/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: commentnode.h,v $
 * Revision 1.1.1.1  2001/01/30 18:36:40  slash
 * Initial release.
 *
 */

#ifndef COMMENTNODE_H
#define COMMENTNODE_H

#include <string>

#include "node.h"

//---------------------------------------------------------------------------
/**
 * This class represents a node, which contains a comment.
 */
class CommentNode : public Node {
  public:
    //-----------------------------------------------------------------------
    /**
     * The constructor initializes the comment-node.
     *
     * @param node The XML-node, which represents the comment-node.
     */
    CommentNode(xmlNodePtr node);

    //-----------------------------------------------------------------------
    /**
     * Destructor.
     */
    ~CommentNode();


    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be HTML.
     * An integer-parameter has to be given because of the derivation,
     * but it won't be used in this class.
     *
     * @param parameter A dummy-parameter
     */
    void writeHTML(int parameter=0) const;

    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be LaTeX.
     */
    void writeLaTeX() const;

    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be XML.
     */
    void writeXML() const;


  private:

    //-----------------------------------------------------------------------
    /**
     * The text of the comment-node.
     */
    string text_;
};

#endif //COMMENTNODE_H
