/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: codenode.cc,v $
 * Revision 1.2  2001/04/27 20:02:50  slash
 * Make use of xmlChildrenNode and xmlRootNode.
 *
 * Revision 1.1.1.1  2001/01/30 18:36:24  slash
 * Initial release.
 *
 */

#include "main.h"
#include "contentnode.h"
#include "codenode.h"


//---------------------------------------------------------------------------
CodeNode::CodeNode(xmlNodePtr node, int with_margin)
        : EnvironmentNode()
{
    with_margin_ = with_margin;

    for (node = node->xmlChildrenNode; node; node = node->next) {
        if (node->type == XML_TEXT_NODE) {
            child_nodes_.push_back(new ContentNode(node, 0));
        } else {
            Number_Of_Errors_++;
        }
    }
}

//---------------------------------------------------------------------------
CodeNode::~CodeNode()
{
}


//---------------------------------------------------------------------------
void CodeNode::writeHTML(int parameter) const
{
    if (with_margin_ == 1) {
        Output_ << "<DIV class=\"code\">" << endl;
    }

    Output_ << "<PRE class=\"code\">" << endl;
    for (unsigned int i=0; i < child_nodes_.size(); i++) {
        child_nodes_[i]->writeHTML();
    }
    Output_ << "</PRE>" << endl;

    if (with_margin_ == 1) {
        Output_ << "</DIV>" << endl;
    }
}

//---------------------------------------------------------------------------
void CodeNode::writeLaTeX() const
{
    Output_ << "\\begin{verbatim}" << endl;
    for (unsigned int i=0; i < child_nodes_.size(); i++) {
        child_nodes_[i]->writeLaTeX();
    }
    Output_ << "\\end{verbatim}" << endl;
}


//---------------------------------------------------------------------------
void CodeNode::writeXML() const
{
    Output_ << "<code>";
    for (unsigned int i=0; i < child_nodes_.size(); i++) {
        child_nodes_[i]->writeXML();
    }
    Output_ << "</code>" << endl;
}


//---------------------------------------------------------------------------
int CodeNode::isHTMLStepped() const
{
    return 0;
}

//---------------------------------------------------------------------------
unsigned int CodeNode::getNumberOfHTMLSteps() const
{
    return 0;
}
