/*****
*
* Copyright (C) 2001 Jeremie Brebec <flagg@ifrance.com>
* All Rights Reserved
*
* This file is part of the Prelude program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
* Written by Jeremie Brebec <flagg@ifrance.com>
*
*****/


#ifndef RULES_PARSING_H
#define RULES_PARSING_H

#include "rules.h"
#include <libprelude/list.h>

/*
 * parameters
 */
typedef struct _parameters_t {
	char *str;
	int not;
	struct _parameters_t *next;
} parameters_t;



parameters_t *signature_parser_make_parameters(char *str);
parameters_t *signature_parser_inverse_parameters(parameters_t *parameters); 
parameters_t *signature_parser_link_parameters(parameters_t *parameters1, parameters_t *parameters2);
void signature_parser_free_parameters(parameters_t *parameters);


/*
 * for new key:value
 */
typedef int (*parse_f_t)(char *str, rules_t **);
typedef int (*parse_set_f_t)(parameters_t *, rules_t **);

int signature_parser_add_one_arg_key(const char *key, parse_f_t parse); 
int signature_parser_add_multiple_args_key(const char *key, parse_set_f_t parse);



/*
 * rule post processing
 */
typedef int (*post_processing_f_t)( rules_t *rules );

int add_post_processing( post_processing_f_t pp_fun );

int signature_parser_add_post_processing(post_processing_f_t pp_fun);

/*
 * parsing
 */
int signature_parser_post_processing(rules_t *rules);
int signature_parser_add_signature(rules_node_t *root, const char *rule, run_f_t run);
int signature_parser_parse_key(const char *key, parameters_t *parameters, rules_t **rule);


/*
 * error
 */
void signature_parser_set_error(const char *format, ...);
const char *signature_parser_get_error_buffer(void);


/*
 * lex
 */
extern rules_t *rule_parsed;
void set_parsing_buffer(const char *buf);
int yyparse(void);


#endif

