/*****
*
* Copyright (C) 1999, 2000, 2002 Yoann Vandoorselaere <yoann@prelude-ids.org>
* All Rights Reserved
*
* This file is part of the Prelude program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/


typedef struct hostdb {
        uint8_t proto;
        uint32_t saddr, daddr;
        
        void **pdata;
        unsigned int refcount;

        struct hostdb *prev;
        struct hostdb *next;
} hostdb_t;



hostdb_t *hostdb_search(const iphdr_t *ip);

hostdb_t *hostdb_new(packet_container_t *pkt, const iphdr_t *ip);

void hostdb_del(hostdb_t *h, const unsigned int pid);

void hostdb_init(void);


/*
 * Get associated data from a plugin hostdb entry.
 */
#define hostdb_get_plugin_data(h, pid) (h)->pdata[(pid)]



/*
 * Associate data to a plugin hostdb entry.
 */
#define hostdb_set_plugin_data(h, pid, data) (h)->pdata[(pid)] = (data); (h)->refcount++
