/* $Cambridge: hermes/src/prayer/cmd/cmd_display.c,v 1.18 2010/07/08 16:55:49 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

void cmd_display(struct session *session)
{
    struct template_vals *tvals = session->template_vals;
    struct options *options = session->options;
    struct prefs *prefs = options->prefs;
    struct request *request = session->request;
    struct msgmap *zm = session->zm;
    unsigned long msgno, msguid;
    char *section;
    struct buffer *b = request->write_buffer;
    MAILSTREAM *stream = session->stream;
    BOOL html_show_images = prefs->html_remote_images;

    if (request->method == POST) {
        char *cmd, *folder;

        request_decode_form(request);

        if (assoc_lookup(request->form, "sub_folder_dialogue") &&
            (folder = assoc_lookup(request->form, "folder")) && folder[0])
        {
            if ((cmd = assoc_lookup(request->form, "command")) &&
                !strcmp(cmd, "copy")) {
                session->aggregate = T;
                session_redirect(session, request,
                                 pool_strcat(request->pool, "copy_msg/",
                                             folder));
            } else
                session_redirect(session, request,
                                 pool_strcat(request->pool, "change/",
                                             folder));
            return;
        }
    }

    if (!msgmap_update(zm)) {
        session_alert(session, "Failed to update msgmap");
        session_redirect(session, request, "restart");
        return;
    }

    if (msgmap_size(zm) == 0) {
        session_message(session, "Folder is empty");
        session_redirect(session, request, "list");
        return;
    }

    /* Save options if anything changed */
    if (options->save)
        session_streams_save_options(session);

    /* Record last command for compose/cancel and friends */
    if (!session->draft->have_draft)
        session->compose_parent_cmd = "display";

    /* Record last command for save/cancel */
    session->copy_parent_cmd = "display";

    /* Record last command for addressbook take */
    session->take_parent_cmd = "display";

    if ((request->argc == 5) && !strcmp(request->argv[4], "show_images"))
        html_show_images = T;

    section = NIL;
    if (request->argc >= 4)
        section = request->argv[3];

    if (request->argc >= 3) {
        msgno = atoi(request->argv[1]);
        msguid = atoi(request->argv[2]);

        if (!(msgno = stream_check_uid(session, stream, msgno, msguid))) {
            session_redirect(session, request, "list");
            return;
        }
    } else {
        msgno = session->last_displayed;

        if ((msgno == 0) || (msgno > msgmap_size(zm)))
            msgno = msgmap_value(zm, msgmap_size(zm));

        msguid = ml_uid(session, stream, msgno);
    }

    session->current = msgno;
    session->last_displayed = msgno;

    if (session->stream == session->draft_stream)
        template_vals_ulong(tvals, "$is_postponed_folder", 1);

    if (prefs->use_mark_persist)
        template_vals_ulong(tvals, "$use_persist", 1);

    if (prefs->use_tail_banner)
        template_vals_ulong(tvals, "$use_tail_banner", 1);

    if (prefs->html_inline)
        template_vals_ulong(tvals, "$html_inline", 1);

    if (prefs->html_remote_images)
        template_vals_ulong(tvals, "$html_remote_images", 1);

    /* Need different name to avoid collision below */
    if (section)
        template_vals_string(tvals, "$section_url", section);

    display_addnav(session, stream, msgno);

    if (session->full_hdrs) {
        char *hdr;
        unsigned long len;

        template_vals_ulong(tvals, "$full_hdrs", 1);
        session_seed_template(session, tvals);
        template_expand("display", tvals, b);
        bprintf(b, "<pre>" CRLF);
        if ((hdr = ml_fetch_header(session, stream, msgno, NIL, NIL, &len, 0)))
            wrap_text_html_quotes(b, hdr, 80, T);
        bprintf(b, "</pre>" CRLF);
    } else {
        display_addhdrs(session, stream, msgno);
        session_seed_template(session, tvals);
        template_expand("display", tvals, b);
    }

    if (!display_body(session, request, stream, msgno, section,
                      "display", html_show_images)) {
        session_redirect(session, request, "restart");
        return;
    }

    template_expand("display_tail", tvals, b);
    /* Send out the response */
    response_html(request, 200);
}
