/*
 *  $Id: gtkgui.c,v 1.36 2001/07/10 18:13:49 davej Exp $
 *	This file is part of Powertweak Linux.
 *	(C) 2000 Dave Jones, Arjan van de Ven.
 *
 * 	Licensed under the terms of the GNU GPL License version 2.
 *
 *  Routines used to create the GTK GUI
 */

#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <powertweak.h>
#include <config.h>
#include <string.h>
#include <unistd.h>

#include "gtkgui.h"
#include "tooltips.h"
#include <client.h>
#include <client-utils.h>

int WindowWidth=640;
int WindowHeight=430;
int LeftWindowHeight=640-100;
int RightWindowHeight=430-70;

int HaveDaemon = 1;

struct tweak *tweaks;



void want_config_saved()
{
	if (HaveDaemon)
		Save_config(); /* client backend */
	else
		save_tree_to_config (tweaks, "/etc/powertweak/tweaks");
}

/* 
 * GuiToDaemon copies all settings in the GUI to the actual
 * values in the backends/daemon.
 * This is useful for Ok / Apply buttons
 */
void GuiToDaemon (struct tweak *T, int immediate)
{

	if (T == NULL)
		return;

	while (T != NULL) {
		if (T->Sub != NULL)
			GuiToDaemon (T->Sub, immediate);

		if ((T->Type != TYPE_NODE_ONLY) && (T->ChangeValue != NULL)) {
			T->ChangeValue (T, T->TempValue, immediate);
		}

		T = T->Next;
	}
}


char *programname;

int main (int argc, char **argv)
{
	struct tweak *localtweaks;
	int error=0;

	gtk_init (&argc, &argv);
	color_init();

	if (getuid()!=0) {
		show_error ("Error!", "gpowertweak only runs as root.");
		exit (-1);
	}

	programname = strdup("Powertweak " VERSION);

	error = InitClientBackend (&localtweaks);
	if (localtweaks == NULL)
		LoadPluginsIfNecessary(&HaveDaemon, &show_error, error, &localtweaks);

	/* If all went ok, do the main stuff. */
	if (localtweaks != NULL) {
		MainWindow (localtweaks);
		gtk_main ();
	}

	/* Shut down gracefully. */
	if (HaveDaemon) {
		CloseClientBackend ();
	} else {
		DestroyAllTweaks (localtweaks);
		ShutdownPlugins();
		DestroyInitFuncList();
	}
	
	free(programname);
	return 0;
}
