/***************************************************************************
 *                                                                         *
 *                         Powersave Daemon                                *
 *                                                                         *
 *          Copyright (C) 2004,2005 SUSE Linux Products GmbH               *
 *                                                                         *
 *               Author(s): Holger Macht <hmacht@suse.de>                  *
 *                                                                         *
 * This program is free software; you can redistribute it and/or modify it *
 * under the terms of the GNU General Public License as published by the   *
 * Free Software Foundation; either version 2 of the License, or (at you   *
 * option) any later version.                                              *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       *
 * General Public License for more details.                                *
 *                                                                         *
 * You should have received a copy of the GNU General Public License along *
 * with this program; if not, write to the Free Software Foundation, Inc., *
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA                  *
 *                                                                         *
 ***************************************************************************/

#include "battery.h"
#include "config_pm.h"
#include "event_management.h"
#include "globals.h"

using namespace Powersave::Globals;

Battery::Battery()
 : _battery_state(BAT_NORM_STATE), _msecs_last_battery_read(0) 
{ 
	_bg.remaining_percent = 0;
	_bg.remaining_minutes = 0;
	_bg.charging_state = CHARG_STATE_UNKNOWN;
}

int Battery::updateBatteryState(int ac_state, EventManagement *eM)
{
	int changed = 0;

	int cur_bat_state = _battery_state;
	int cur_bat_perc = _bg.remaining_percent;
	int cur_bat_mins = _bg.remaining_minutes;
	int cur_charging_state = _bg.charging_state;

	BATTERY_STATES new_bat_state = BAT_NONE_STATE;

	_msecs_last_battery_read = 0;

	if (getBatteriesInfo(&_bg) <= 0) {
		pDebug(DBG_INFO, "Could not get battery info");
		// cannot read out battery

		// if we had a battery and it got unplugged, inform the clients
 		if (_battery_state != BAT_NONE_STATE)
			eM->executeEvent("battery.info");

		_battery_state = BAT_NONE_STATE;

		return -1;
	}

	if (cur_bat_perc != _bg.remaining_percent || cur_bat_mins != _bg.remaining_minutes ||
	    cur_charging_state != _bg.charging_state)
		eM->executeEvent("battery.info");

	if ((ac_state == AC_ONLINE)
	    || ((config_obj->current_scheme->BAT_WARN_LIMIT < _bg.remaining_percent)
		&& (_bg.remaining_percent <= 100)))
		new_bat_state = BAT_NORM_STATE;
	else if (config_obj->current_scheme->BAT_LOW_LIMIT < _bg.remaining_percent
		 && _bg.remaining_percent <= config_obj->current_scheme->BAT_WARN_LIMIT)
		new_bat_state = BAT_WARN_STATE;
	else if (config_obj->current_scheme->BAT_CRIT_LIMIT < _bg.remaining_percent
		 && _bg.remaining_percent <= config_obj->current_scheme->BAT_LOW_LIMIT)
		new_bat_state = BAT_LOW_STATE;
	else if (0 < _bg.remaining_percent && _bg.remaining_percent
		 <= config_obj->current_scheme->BAT_CRIT_LIMIT)
		new_bat_state = BAT_CRIT_STATE;
	else if (_bg.remaining_percent <= 0) {
		/* if we cannot calc remaining percent at least set 
		   warning/low/crit battery state at 8/4/2 minutes of remaining battery */
		//but with this order it could never get in LOW or CRIT state
/*		if (_bg.remaining_minutes <= 8 && _bg.remaining_minutes > 0)
			new_bat_state = BAT_WARN_STATE;
		else if (_bg.remaining_minutes <= 4 && _bg.remaining_minutes > 0)
			new_bat_state = BAT_LOW_STATE;
		else if (_bg.remaining_minutes <= 2 && _bg.remaining_minutes > 0)
			new_bat_state = BAT_CRIT_STATE;
*/
		if (_bg.remaining_minutes <= 2 && _bg.remaining_minutes >= 0)
			new_bat_state = BAT_CRIT_STATE;
		else if (_bg.remaining_minutes <= 4 && _bg.remaining_minutes > 0)
			new_bat_state = BAT_LOW_STATE;
		else if (_bg.remaining_minutes <= 8 && _bg.remaining_minutes > 0)
			new_bat_state = BAT_WARN_STATE;
		else
			new_bat_state = BAT_NORM_STATE;
	} else {
		pDebug(DBG_INFO, "Could not determine battery state, suppose normal");
		new_bat_state = BAT_NORM_STATE;
	}

	pDebug(DBG_INFO, "Get Battery state: %d", new_bat_state);

	if (cur_bat_state == new_bat_state)
		changed = 0;
	else if (new_bat_state > cur_bat_state) {
		changed = 2;
		_battery_state = new_bat_state;
	} else if (new_bat_state < cur_bat_state) {
		changed = 1;
		_battery_state = new_bat_state;
	}
	return changed;
}

BATTERY_STATES Battery::batteryState() const {
	return _battery_state;
}

int Battery::chargingState() const
{
	return _bg.charging_state;
}

int Battery::remainingTime() const
{
	return _bg.remaining_minutes;
}

int Battery::remainingPercent() const
{
	return _bg.remaining_percent;
}

int Battery::remainingChargingTime() const
{
	return _bg.remaining_minutes;
}

void Battery::resetState()
{
	_battery_state = BAT_NORM_STATE;
}

