/*
 * Potamus: an audio player
 * Copyright (C) 2004, 2005, 2006, 2007 Adam Sampson <ats@offog.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>
#include "dnd.h"
#include "main.h"

static GtkTargetEntry targets[] = {
	{ "text/uri-list", 0, 0 }
};

int fromhex(gchar c) {
	const char *hex = "0123456789abcdef";
	const char *p = strchr(hex, tolower(c));
	if (p == NULL)
		return 0;
	else
		return p - hex;
}

void drop_handler(GtkWidget *widget, GdkDragContext *context,
                  gint x, gint y, GtkSelectionData *sdata,
                  guint info, guint t, gpointer data) {
	const gchar *start = (const gchar *) sdata->data;
	if (start == NULL)
		return;

	// The data format is a list of URIs, each terminated by \r\n.
	while (1) {
		const gchar *end = strstr(start, "\r\n");
		if (end == NULL)
			break;

		// Undo URI-encoding.
		GString *url = g_string_new("");
		for (const gchar *p = start; p < end; p++) {
			gchar ch;
			if (*p == '%' && (p + 3) <= end) {
				ch = fromhex(p[1]) * 16 + fromhex(p[2]);
				p += 2;
			} else {
				ch = *p;
			}
			g_string_append_c(url, ch);
		}

		// We can only process file: URIs.
		const gchar *path = url->str;
		if (g_str_has_prefix(path, "file:")) {
			path += 5;

			// Remove //host prefix.
			if (g_str_has_prefix(path, "//")) {
				path += 2;
				while (*path != '\0' && *path != '/')
					++path;
			}

			add_recursively(path);
		}

		g_string_free(url, TRUE);
		start = end + 2;
	}
}

void dnd_init(GtkWidget *dest) {
	gtk_drag_dest_set(dest, GTK_DEST_DEFAULT_ALL,
	                  targets, G_N_ELEMENTS(targets),
	                  GDK_ACTION_COPY | GDK_ACTION_MOVE);
	g_signal_connect(G_OBJECT(dest), "drag_data_received",
	                 G_CALLBACK(drop_handler), NULL);
}

