/*
 * Potamus: an audio player
 * Copyright (C) 2004, 2005, 2006, 2007 Adam Sampson <ats@offog.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef BUFFER_H
#define BUFFER_H

typedef struct buffer {
	unsigned char *data;
	size_t capacity;
	size_t used;
} buffer;

buffer *buffer_new(void);
void buffer_free(buffer *b);
unsigned char *buffer_reserve(buffer *b, size_t size);
void buffer_remove(buffer *b, size_t size);

#endif
