/*                               
Service_Finger.cc
*/

#include "Service_Finger.h"
#include "ClientFinger.h"

extern Language *L;
extern Configuration *Conf;
extern Skin *skin;

class HTMLPages: public HTMLBasic
  {
  private:
    //
  public:
    void PrintFingerDisplayPage (const char *stlang, const char *user, const char *connid, UserOptions *uo, 
                                 const char *fserver, const char *fuser, StringList *SLRes);
  };

//retrieve the url for the Service icon
const char *GetService_Finger_ICO_URL (void)
  {
  return skin->getI(L_FINGER);
  }

//Retrieve the ALT tag for the Service icon
const char *GetService_Finger_ICO_ALT (void)
  {
  return L->get(L_FINGER);
  }

//Retrieve the Service name
const char *GetService_Finger_NAME (void)
  {
  return L->get(L_FINGER);
  }

//Retrieve the Service Description
const char *GetService_Finger_DESCRIPTION (void)
  {
  return L->get(L_FINGER_DESCRIPTION);
  }

//Entry point to service init
bool DoService_Finger_BEGIN (TProgData *pd)
  {
  TBuffer file2show;
  if (CheckServiceDisabled (TranslateServiceR(pd->service), file2show) == true) 
    {pd->html->dumpFile (file2show, "TEXT/HTML"); return false;}        
  LOG ("Initializating Service Finger for user=%s", pd->username);
  return true;
  }

//Entry point to service end
bool DoService_Finger_END (TProgData *pd)
  {
  return true;
  }

//Entry point to execute a service command
bool DoService_Finger_CMD (TProgData *pd)
  {
  HTMLPages *html;
  int cmd;
  StringList *SLFinger;

  html = (HTMLPages *)pd->html;

  TBuffer file2show;
  if (CheckServiceDisabled (TranslateServiceR(pd->service), file2show) == true) 
    {pd->html->dumpFile (file2show, "TEXT/HTML"); return false;}        

  cmd = pd->cmd;
  SLFinger = new StringList;
    
  switch (pd->cmd)
    {
    case (CMD_FINGER_DISPLAYPAGE):
      {
      pd->uo->InitStatusLine ();
      html->PrintFingerDisplayPage (pd->stlang, pd->username, pd->connid, pd->uo, "", "", SLFinger);
      break;   
      }
    case (CMD_FINGER_GO):
      {
      bool b;
      TBuffer ErrMsg, fserver, fuser;
      ClientFinger *CliFi;
      
      cgienv_GetSimpleVar (pd->envfile, "fserver", fserver, true);
      cgienv_GetSimpleVar (pd->envfile, "fuser",   fuser, true);
      CliFi = new ClientFinger (fserver, DEFFINGERPORT, fuser);
      b = CliFi->doFinger (ErrMsg, SLFinger);
      delete CliFi;
      if (b == true) 
        {
        html->PrintFingerDisplayPage (pd->stlang, pd->username, pd->connid, pd->uo, fserver, fuser, SLFinger);
        }
      else 
        {
        LOG ("FINGER: Error: server: %s, user: %s", fserver, fuser);
        html->ErrorPage(ErrMsg);
        }
      break;   
      }      
    default: 
      {    
      LOG ("ERROR: Service_Finger: Here we can not go!! cmd=%s, subcmd=%s", pd->stcmd, pd->stsubcmd);
      pd->html->PrintInvalidCommand (pd->stlang, pd->username, pd->connid, pd->uo);
      break;
      }         
    }
  delete SLFinger;  
  return false;  
  }  

void HTMLPages::PrintFingerDisplayPage 
    (const char *lang, const char *user, const char *connid, UserOptions *uo, 
     const char *fserver, const char *fuser, StringList *SLRes)
  {
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_FINGER_DISPLAYPAGE), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
         skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);  
  
  BotoneraTop (CMD_FINGER_DISPLAYPAGE, lang, user, connid, uo);
  BeginCenter();
  BeginFormPost ("PrintFingerDisplayPage", PATH_CGI);
  FormHidden ("service", SERVICE_FINGER);
  FormHidden ("lang", lang);
  FormHidden ("user", user);
  FormHidden ("connid", connid);
  FormHidden ("validator", uo->getValidator());
  FormHidden ("pageid", uo->getPageId());
  FormHidden ("cmd", "go");      
  FormHidden ("lastcmd", CMD_FINGER_DISPLAYPAGE);    

  Label ("Server:"); FormEdit (50, 20, "fserver", fserver); Label ("User:"); FormEdit (50, 20, "fuser", fuser);
  BR ();
  FormTextArea (uo->getHeightWriteArea(), uo->getWidthWriteArea(), "texttosend", SLRes->toPChar(true), false);  
  BR();
  
  FormButton ("theaction", L->get(L_FINGER));
  EndForm ();
  EndCenter();

  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));            
  }
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
