/*
Skin.h
*/

#ifndef __SKIN_H
#define __SKIN_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "Language.h"
#include "Utils.h"

//***** SKINS ****************************************
#define SKIN_DEFAULT 0
#define SKIN_OLIVE   1
#define SKIN_RED     2
#define SKIN_BLUE    3
#define SKIN_ORANGE  4
#define SKIN_CLASSIC 5

#define DEFOPT_ICON_SET "default"

#define TXTCOLOR "#000000"
#define BGCOLOR  "#FFFFFF"

#define ICONS_SIZE_MEDIUM 0
#define ICONS_SIZE_BIG    1
#define ICONS_SIZE_SMALL  2
#define ST_ICONS_SIZE_MEDIUM "0"
#define ST_ICONS_SIZE_BIG    "1"
#define ST_ICONS_SIZE_SMALL  "2"

#define CSS_SKIN_OLIVE   "/"APPNAME"/style_olive.css"
#define CSS_SKIN_RED     "/"APPNAME"/style_red.css"
#define CSS_SKIN_BLUE    "/"APPNAME"/style_blue.css"
#define CSS_SKIN_ORANGE  "/"APPNAME"/style_orange.css"
#define CSS_SKIN_CLASSIC "/"APPNAME"/style_classic.css"
#define CSS_SKIN_DEFAULT "/"APPNAME"/style_orange.css"

class Skin
  {
  private:    
    char theskin[MAXLENGTHSKIN + 1];
    COLORHTML COLOR_BGTABLE, COLOR_BGTABLECOPYRIGHT, COLOR_BGBOTONERA, COLOR_BGTABLEMSGINDEX, COLOR_BGBODY,
              COLOR_BGTEXTO, COLOR_BGFILASMSGINDEX, COLOR_BGFILASADDBOOK, COLOR_BGFILASREADINGMSG,
              COLOR_FONT_TABLE, COLOR_FONT_MAIN, COLOR_FONT_STATUS, COLOR_FONT_STATUSLINE, COLOR_FONT_TABLECOPYRIGHT;
    FONTNAME FONT_TABLE, FONT_MAIN, FONT_STATUS, FONT_TABLECOPYRIGHT;
    FONTSIZE FONT_TABLE_SIZE, FONT_MAIN_SIZE, FONT_STATUS_SIZE, FONT_BOTONERA_SIZE, FONT_TABLECOPYRIGHT_SIZE;
    bool DISPLAYBUTTONLABELS;
    TSBuffer IMG_BG, theiconset, ICONSIZE, BODYMARGINS;
    int ICONS_SIZE;
    const char *getImageNoLang (int WHAT);
    const char *getImageEnglish (int WHAT);
    const char *getImageSpanish (int WHAT);    
    const char *getImageCatala  (int WHAT);  
    const char *getImageEuskera  (int WHAT);          
  public:
    StringList *beginDecorationTable, *endDecorationTable;
    Skin (void);
    virtual ~Skin (void);         
    void setSkin (const char *askin);
    void setIconsSize (int size);
    const char *getCSSPage (void);
    bool getDisplayButtonLabels (void);
    void setDisplayButtonLabels (bool value);
    const char *getSkin (void);
    void setIconSet (const char *aiconset);        
    char *getSkinAtribProp (const char *propiedad);
    int getSkinAtribPropI (const char *propiedad);
    const char *getI (int WHAT); 
    const char *getISize (void);
  };
  
#endif











