/*                         
InterDaemon.cc
*/

#include "InterDaemon.h"

TProgData pd;
XSocket *serversocket;
Language *L;
Skin *skin;
CCLIENT *cclient;
ClientNNTP *CN;
Configuration *Conf;
TBuffer UserDir, lastconnid, BasePath;
static int ServerCounter = 1;
static long int TotalLogins = 1;
pid_t MainServerPid;
int LockFileDescriptor, lastcmd;
Authentication *auth;
Addressbook *ab;
TBuffer fnsocket, tmp, abuf;  

extern bool Service_FileBrowser_Initialized;
extern bool Service_SecVirtual_Initialized;
extern bool Service_Dotlearn_Initialized;
extern bool Service_Databases_Initialized;
extern bool Service_UserAccounts_Initialized;
extern bool Service_Config_Initialized;
extern bool Service_Sieve_Initialized;
extern bool Service_Calendar_Initialized;
extern bool Service_Cclient_Initialized;

int main  (int argc, char **argv, char **envp)
  {
  TBuffer linea, beginmailbox;
  int cs, validator, pageid;
    
  initServer_beforeFork(argc, argv, envp, &cs);    
      
  //**************************************************
  //********************    FROM HERE THE NEW CHILD! *
  //**************************************************
  
  initServer_afterFork (argc, argv, envp, cs);
  sm_setproctitle (PROGNAME, true, "   (After fork)");

  pd.html = new HTMLBasic (serversocket);   
  pd.utility = NULL;
  serversocket->Gets (linea, CMAXBUFFER);
  ini (pd.connid, pd.stlang, pd.stcmd, pd.stsubcmd, pd.allparms, pd.allparms2, pd.username, pd.password, pd.parm3, pd.parm4);
  initStr (pd.imapserver);
  sscanf (linea, "%s %d %d %d %s %s %d %s %s %s %[^]]s", pd.connid, &pageid, &validator, &lastcmd, pd.stlang, pd.ipclient, &pd.service, pd.stcmd, pd.stsubcmd, pd.envfile, pd.allparms);
  xscanf (linea, pd.connid, &pageid, &validator, &lastcmd, pd.stlang, pd.ipclient, &pd.service, pd.stcmd, pd.stsubcmd, pd.envfile, pd.username, pd.password, pd.imapserver, beginmailbox);
  if (IsEmpty(beginmailbox) == true) {xstrncpy (beginmailbox, CMAXBUFFER, DEFAULTBEGINMAILBOX);}
  
  pd.cmd_counter = 0;
  L = new Language (pd.stlang);
  skin = new Skin ();
  pd.cmd = TranslateCmd (pd.service, pd.stcmd);
             
  if (CONVERTUSERNAMETOLOWERCASE == 1) {xlcase (pd.username);}  
  
  CheckServerCount (pd.stlang);
  CheckParams (pd.cmd, pd.connid, pd.password);
  CheckAllowServeralConns ();      
  
  xstrncpy (lastconnid, CMAXBUFFER, pd.connid);  
  xstrncpy (BasePath, CMAXBUFFER, Conf->getString ("main", "usersbasepath", "/var/"APPNAME"/users", CMAXBUFFER));  
  pd.uo = new UserOptions (BasePath, pd.username, pd.imapserver);
  pd.uo->setPageId (pageid);
  pd.uo->set_use_javascript (Conf->getInt ("main", "use_javascript", 1));
  pd.html->setMAXMSGSFORPAGE (pd.uo->getMsgsPerIndexPage());
  CN = new ClientNNTP (pd.uo->getNNTPServer(), Conf->getString ("main", "defaultipdomain", "", CMAXIPNAME), 
                       pd.username, pd.password);
  cclient = new CCLIENT ();
  cclient->setMAXMSGSFORPAGE (pd.uo->getMsgsPerIndexPage());
  cclient->setTimeout (IMAP_TIMEOUT);
  sm_setproctitle (PROGNAME, true, "%s   (Before login)", pd.username);  
  if (doLogin (&pd) == true) 
    { 
    pd.uo->setImapServer (pd.imapserver);
    cclient->setNetNewsRC();
    sm_setproctitle (PROGNAME, true, "%s   (After login OK)", pd.username);
    doLocking ();
    sm_setproctitle (PROGNAME, true, "%s   (After doLocking)", pd.username);
    pd.uo->InitStatusLine (); 
    if (cclient->getError()==true) {pd.uo->setStatusLine (cclient->getErrorString(), RED);}
    setUserDirs();    
    pd.uo->leeConf();
    sm_setproctitle (PROGNAME, true, "%s   (After leeConf)", pd.username);
    DelAllFilesFromDir ((char *)pd.uo->getAttachDir());
    xstrncpy (lastconnid, CMAXBUFFER, pd.connid);
    xstrncpy (fnsocket, CMAXBUFFER, make_session_socket (pd.username, pd.connid, tmp));
    if (Conf->getInt ("main", "use_cookies", 0) == 1) {pd.html->printCookie(auth->cookie_getSetFullCookieLine());}
    Conf->getSection ("allowed_services", pd.uo->SLAllowedServices);
    pd.uo->setMountPoints (Conf->getString (pd.imapserver, "mount_points", "", CMAXBUFFER));
    if (pd.cmd == CMD_MAIN_RECONNECT)
      {
      sm_setproctitle (PROGNAME, true, "%s   (Before ChildLoop win Reconnect)", pd.username);
      ChildLoop (CMD_MAIN_RECONNECT);      
      }
    else
      {  
      PrintHomePage (&pd);
      serversocket->Close();
      sm_setproctitle (PROGNAME, true, "%s   (Before ChildLoop with Login)", pd.username);
      ChildLoop (CMD_MAIN_LOGIN);
      }
    }
  else 
    {
    sm_setproctitle (PROGNAME, true, "%s   (After login BAD. Exiting.)", pd.username);
    ErrorInLogin ();
    }
  
  ExitServer ();
  }
    
//MAIN LOOP FOR DAEMON CHILD
int ChildLoop (int way)
  {
  int connected_socket = ERROR_SOCKET, listensock = ERROR_SOCKET, validator, pageid;
  TBuffer linea, connid, stlang;
  bool LOOP_FINISHED = false;
  
  AlarmInstall ();
  pd.xs = new XSocket ();
  pd.xs->do_server_unix_only_bind (SOCK_STREAM, &listensock, fnsocket);
  LOG ("Login OK IP=%s, user=%s, servercount=%d, totallogins=%ld", pd.ipclient, pd.username, ServerCounter + 1, TotalLogins);
  UnlockAndCloseFile (LockFileDescriptor);
  
  while (LOOP_FINISHED == false)
    {
    sm_setproctitle (PROGNAME, true, "%s   (idle)", pd.username);
    SwitchOnAlarm (Conf->getInt ("main", "timeout", 1200));
    xstrncpy (BasePath, CMAXBUFFER, Conf->getString ("main", "usersbasepath", "/var/"APPNAME"/users", CMAXBUFFER));
    if (way == CMD_MAIN_RECONNECT)
      {
      TBuffer stservice;
      cgienv_GetSimpleVarDef (pd.envfile, "trueservice", stservice, "");
      pd.service = TranslateService (stservice);
      cgienv_GetSimpleVarDef (pd.envfile, "truecmd", pd.stcmd, "");
      cgienv_GetSimpleVarDef (pd.envfile, "truestsubcmd", pd.stsubcmd, "");
      cgienv_GetSimpleVarDef (pd.envfile, "parm1", pd.parm1, "");
      cgienv_GetSimpleVarDef (pd.envfile, "parm2", pd.parm2, "");
      cgienv_GetSimpleVarDef (pd.envfile, "parm3", pd.parm3, "");
      cgienv_GetSimpleVarDef (pd.envfile, "parm4", pd.parm4, "");                              
      xsnprintf (linea, CMAXBUFFER, "%s -1 -1 -1 _ %s %d %s %s %s \"%s\" \"%s\" \"%s\" \"%s\"", 
                                     pd.connid, pd.ipclient, pd.service, pd.stcmd, pd.stsubcmd, pd.envfile, 
                                     pd.parm1, pd.parm2, pd.parm3, pd.parm4);
      connected_socket = serversocket->getSock();
      pd.xs->SetSock (connected_socket);
      }
    else
      {
      connected_socket = accept(listensock, NULL, NULL);
      if (connected_socket < 0) {if (errno != EINTR) {perror("accept"); close(listensock); return (ERROR_SOCKET);} else {continue;}}
      pd.xs->SetSock (connected_socket);
      pd.xs->Gets (linea, CMAXBUFFER);
      }
    ++(pd.cmd_counter);     
    pd.html = new HTMLBasic (pd.xs);
    pd.html->setMAXMSGSFORPAGE (pd.uo->getMsgsPerIndexPage());    
    cclient->setMAXMSGSFORPAGE (pd.uo->getMsgsPerIndexPage());    
    ini (pd.connid, pd.stlang, pd.stcmd, pd.stsubcmd, pd.allparms, pd.allparms2, pd.parm1, pd.parm2, pd.parm3, pd.parm4);
    sscanf (linea, "%s %d %d %d %s %s %d %s %s %s %[^]]s", pd.connid, &pageid, &validator, &lastcmd, pd.stlang, pd.ipclient, &pd.service, pd.stcmd, pd.stsubcmd, pd.envfile, pd.allparms);
    xscanf (linea, connid, &pageid, &validator, &lastcmd, stlang, pd.ipclient, &pd.service, pd.stcmd, pd.stsubcmd, pd.envfile, pd.parm1, pd.allparms2, NULL, NULL);
    xscanf (linea, connid, &pageid, &validator, &lastcmd, stlang, pd.ipclient, &pd.service, pd.stcmd, pd.stsubcmd, pd.envfile, pd.parm1, pd.parm2, pd.parm3, pd.parm4);
    L->setLang (pd.stlang);
    /*set the defaults for foreign connections*/    
    if (strcmp (connid, TOKEN_JOKER) == 0) {xstrncpy (pd.connid, CMAXBUFFER, lastconnid);} else {xstrncpy (pd.connid, CMAXBUFFER, connid);} 
    if (strcmp (stlang, TOKEN_JOKER) == 0) {xstrncpy (pd.stlang, CMAXBUFFER, L->getStLang());} else {xstrncpy (pd.stlang, CMAXBUFFER, stlang);}     
    if (pageid == -1) {pageid = pd.uo->getPageId();}
    if (validator == -1) {validator = pd.uo->getValidator();}
    if (lastcmd == -1) {lastcmd = pd.uo->getLastCmd();}

    pd.uo->setPageId (pageid);
    pd.uo->setLastCmd(lastcmd);
    pd.cmd = TranslateCmd (pd.service, pd.stcmd);
    xstrncpy (lastconnid, CMAXBUFFER, pd.connid);
    
    //DEBUG ("user=%s,line=%s", pd.username, linea);
    
    sm_setproctitle (PROGNAME, true, "%s   (service '%s', cmd '%s', subcmd '%s')", 
                     pd.username, TranslateServiceR(pd.service), pd.stcmd, pd.stsubcmd);
    if (!IsGoodValidator (pd.cmd,  validator, pd.uo->getValidator(), pd.service, pd.uo->getLastService()))
      {
      pd.service = iSERVICE_MAIN;
      pd.cmd = CMD_SPECIAL_INVALIDPAGE;
      }
    
    pd.uo->addLastStringCmd (pd.cmd, linea);
    if (isAllowedService (pd.uo->SLAllowedServices, pd.uo->getDeniedServices(), pd.service, NULL) == false) 
      {
      pd.service = iSERVICE_NOTALLOWED;
      }
    switch (pd.service)
      {
      case iSERVICE_MAIN:
        {
        LOOP_FINISHED = DoService_Main_CMD (&pd);
        if (pd.cmd == CMD_MAIN_LOGOUT) 
          {
          if (Service_Cclient_Initialized == true) DoService_Cclient_END (&pd);
          if (Service_FileBrowser_Initialized == true) DoService_FileBrowser_END (&pd);          
          if (Service_Databases_Initialized == true) DoService_Databases_END (&pd);
          }
        break; 
        }   
      case iSERVICE_CCLIENT:
        {
        if (Service_Cclient_Initialized == false) 
          {
          if (DoService_Cclient_BEGIN (&pd) == false) {break;}
          }    
        LOOP_FINISHED = DoService_Cclient_CMD (&pd);
        break;
        }
      case iSERVICE_FINGER:
        {
        LOOP_FINISHED = DoService_Finger_CMD (&pd);
        break;                        
        }
      case iSERVICE_FILEBROWSER:
        {
        if (Service_FileBrowser_Initialized == false) 
          {
          if (DoService_FileBrowser_BEGIN (&pd) == false) {break;}
          }    
        LOOP_FINISHED = DoService_FileBrowser_CMD (&pd);
        break;                                
        }
      case iSERVICE_SECVIRTUAL:
        {
        if (Service_SecVirtual_Initialized == false) 
          {
          if (DoService_SecVirtual_BEGIN (&pd) == false) {break;}
          }          
        LOOP_FINISHED = DoService_SecVirtual_CMD (&pd);
        break;                        
        }
      case iSERVICE_DOTLEARN:
        {
        if (Service_Dotlearn_Initialized == false) 
          {
          if (DoService_Dotlearn_BEGIN (&pd) == false) {break;}
          }          
        LOOP_FINISHED = DoService_Dotlearn_CMD (&pd);
        break;                        
        }        
      case iSERVICE_POPPASS:
        {
        LOOP_FINISHED = DoService_PopPass_CMD (&pd);
        break;        
        }
      case iSERVICE_FORWARDMAIL:
        {
        LOOP_FINISHED = DoService_ForwardMail_CMD (&pd);
        break;                
        }
      case iSERVICE_DATABASES:
        {
        if (Service_Databases_Initialized == false) 
          {
          if (DoService_Databases_BEGIN (&pd) == false) {pd.html->ErrorPage (L->get(ERR_SERVICE_INITIALIZING)); break;}
          }    
        LOOP_FINISHED = DoService_Databases_CMD (&pd);
        break;                
        }
      case iSERVICE_USERACCOUNTS:
        {
        if (Service_UserAccounts_Initialized == false) 
          {
          if (DoService_UserAccounts_BEGIN (&pd) == false) {break;}
          }          
        LOOP_FINISHED = DoService_UserAccounts_CMD (&pd);
        break;                        
        }
      case iSERVICE_CONFIG:
        {
        if (Service_Config_Initialized == false) 
          {
          if (DoService_Config_BEGIN (&pd) == false) {break;}
          }          
        LOOP_FINISHED = DoService_Config_CMD (&pd);
        break;                        
        }        
      case iSERVICE_SIEVE:
        {
        if (Service_Sieve_Initialized == false) 
          {
          if (DoService_Sieve_BEGIN (&pd) == false) {break;}
          }          
        LOOP_FINISHED = DoService_Sieve_CMD (&pd);
        break;        
        }
      case iSERVICE_CALENDAR:
        {
        if (Service_Calendar_Initialized == false) 
          {
          if (DoService_Calendar_BEGIN (&pd) == false) {break;}
          }          
        LOOP_FINISHED = DoService_Calendar_CMD (&pd);
        break;        
        }        
      case iSERVICE_NOTALLOWED:
        {
        pd.html->ErrorPage (L->get(ERR_SERVICE_NOTALLOWED));
        break;                              
        }
      default:           
        {
        pd.html->ErrorPage (L->get(ERR_INV_SERVICE));
        break;
        }
      }
    if (((pd.service != iSERVICE_NOTALLOWED) && (pd.service != iSERVICE_INVALID)) &&
        ((pd.cmd != CMD_SPECIAL_CHECK_COOKIE) && (pd.cmd != CMD_MAIN_HELP) && (pd.cmd != CMD_MAIN_CONF_ACT)))
      {
      pd.uo->setLastService(pd.service);
      }
    close (connected_socket);  
    if (way == CMD_MAIN_RECONNECT)
      {
      way = CMD_MAIN_LOGIN;      
      serversocket->Close();
      //DeleteFile (pd.envfile);
      }
    }
    
  ClearConn ();    
  pd.xs->Close ();
  DeleteFile (fnsocket);
  return 0;             
  } 

void procsignals (int signal_type)
  {
  time_t now;
  
  switch (signal_type)
    {
    /* TIMEOUT. Alarm signal. Kill the child server. */     
    case SIGALRM:
         LOG ("Timeout for IP=%s, user=%s", pd.ipclient, pd.username);
         if (Service_FileBrowser_Initialized == true) {DoService_FileBrowser_END (&pd);}
         if (Service_Databases_Initialized == true) {DoService_Databases_END (&pd);}
         if (ALLOW_SEVERAL_CONNS == 0) {DeleteFile (ReturnUserLockFileName (pd.username, tmp));}
         xstrncpy (abuf, CMAXBUFFER, make_session_socket (pd.username, lastconnid, tmp));
         DeleteFile (abuf);
         exit (0);    
         break;              
    /* ZOMBIES. This waits for all children, so that they don't become zombies. */
    case SIGCHLD:    
         int pid, status;
         --ServerCounter;
         while ((pid = wait3(&status, WNOHANG, NULL)) > 0);    
         break;
    /* SIGHUP. Reload configuration. */         
    case SIGHUP:
         {
         bool boo = Conf->Reload();
         if (boo == true) LOG ("Reloading configuration. Successfull.");
         else LOG ("Error reloading configuration.");    
         if (getpid () != MainServerPid)
           {
           Conf->getSection ("allowed_services", pd.uo->SLAllowedServices);
           }
         ServerCounter = getNumChilds ();
         LOG ("    ServerCounter is now=%ld", ServerCounter);
         break;
         }
    /* SIGTERM. Normal kill sent to daemon*/     
    case SIGTERM:
         if (getpid () == MainServerPid)
           {
           LOG ("Main server is down.");
           }
         else
           {
           LOG ("SIGTERM received for IP=%s, user=%s", pd.ipclient, pd.username);
           if (ALLOW_SEVERAL_CONNS == 0) {DeleteFile (ReturnUserLockFileName (pd.username, tmp));}
           xstrncpy (abuf, CMAXBUFFER, make_session_socket (pd.username, lastconnid, tmp));
           DeleteFile (abuf);
           }
         exit (0);      
         break;
    /*SIGSEGV. Invalid memory reference*/     
    case SIGSEGV:
         now = time (NULL);
         fprintf (stderr, "Received signal SIGSEGV for IP=%s, user=%s, service=%d, cmd=%s, subcmd=%s, date=%s", 
                  pd.ipclient, pd.username, pd.service, pd.stcmd, pd.stsubcmd, ctime(&now));
         exit (1);
         break;
    /*SIGBUS. Bus error (bad memory access)*/
    case SIGBUS:
         now = time (NULL);
         fprintf (stderr, "Received signal SIGBUS for IP=%s, user=%s, service=%d, cmd=%s, subcmd=%s, date=%s", 
                  pd.ipclient, pd.username, pd.service, pd.stcmd, pd.stsubcmd, ctime(&now));
         exit (1);
         break;                  
    /* SIGUSR1. Program signal*/     
    case SIGUSR1:
         if (getpid () == MainServerPid)
           {
           LOG ("Main server is down.");
           }
         else
           {
           LOG ("SIGUSR1 received for IP=%s, user=%s", pd.ipclient, pd.username);
           if (Service_FileBrowser_Initialized == true) {DoService_FileBrowser_END (&pd);}
           if (Service_Databases_Initialized == true) {DoService_Databases_END (&pd);}
           xstrncpy (abuf, CMAXBUFFER, make_session_socket (pd.username, lastconnid, tmp));
           DeleteFile (abuf);
           }
         exit (0);  
         break;
    /* SIGUSR2. Program signal*/     
    case SIGUSR2:
         ++ServerCounter;
         ++TotalLogins;  
         break;         
    }    
  }

void SetHandlers (void)
  {
  struct sigaction act1, oldact1, act2, oldact2, act3, oldact3, act4, oldact4, act5, oldact5, act6, oldact6, act7, oldact7;
  sigemptyset(&act1.sa_mask); act1.sa_flags = 0; act1.sa_handler = procsignals; sigaction(SIGCHLD, &act1, &oldact1); 
  sigemptyset(&act2.sa_mask); act2.sa_flags = 0; act2.sa_handler = procsignals; sigaction(SIGHUP,  &act2, &oldact2); 
  sigemptyset(&act3.sa_mask); act3.sa_flags = 0; act3.sa_handler = procsignals; sigaction(SIGTERM, &act3, &oldact3);   
  sigemptyset(&act4.sa_mask); act4.sa_flags = 0; act4.sa_handler = procsignals; sigaction(SIGUSR1, &act4, &oldact4);     
  sigemptyset(&act5.sa_mask); act5.sa_flags = 0; act5.sa_handler = procsignals; sigaction(SIGSEGV, &act5, &oldact5);       
  sigemptyset(&act6.sa_mask); act6.sa_flags = 0; act6.sa_handler = procsignals; sigaction(SIGBUS,  &act6, &oldact6);       
  sigemptyset(&act7.sa_mask); act7.sa_flags = 0; act7.sa_handler = procsignals; sigaction(SIGUSR2, &act7, &oldact7);
  }

void initServer_beforeFork(int argc, char **argv, char **envp, int *cs)
  {    
  int listensock = -1;
  
  MainServerPid = WritePidFile ();  
  if (argc != 2) {printf ("Sintax is: interdaemon fileconfname\n"); exit (1);} 
  xstrncpy (pd.maincfg, CMAXBUFFER, argv[1]);
  Conf = new Configuration (pd.maincfg, true);
  if (!Conf->ConfRead ()) {printf ("Error: %s do not exists.\n", pd.maincfg); exit (1);}      
  umask (UMASK);    
  OPENLOG();
  LOG ("Main server is started.");    
  Randomize ();
  serversocket = new XSocket ();
  serversocket->ignore_pipe();
  SetHandlers(); 
  *cs = serversocket->do_server_unix (SOCK_STREAM, &listensock);
  }

void initServer_afterFork (int argc, char **argv, char **envp, int cs)
  {
  initsetproctitle(argc, argv, envp);
  //Envio una senyal de login al padre para que incremente los contadores necesarios
  kill (MainServerPid, SIGUSR2);  
  Randomize ();
  serversocket->SetSock (cs);
  }

void CheckServerCount (char *astlang)
  {
  if (ServerCounter > Conf->getInt ("main", "maxconnallowed", 50))
    {
    LOG ("Max connections allowed %d reached.", ServerCounter);
    pd.html->MsgPage(L->get (MSG_TOO_MAX_CONN), astlang);
    fflush (stdout); exit (0);
    }  
  }  
                                                                  
void CheckParams (int cmd, char *connid, char *pw)
  {  
  if (((cmd != CMD_MAIN_LOGIN) && (cmd != CMD_MAIN_RECONNECT))
      || (strcmp(connid, "-1") != 0) || (strcmp(pd.username, "") == 0) || (strcmp(pw, "") == 0))
    {
    pd.html->ErrorPage(L->get (ERR_INV_PARMS)); 
    fflush (stdout); 
    exit (0);
    }
  }      

void CheckAllowServeralConns (void)
  {      
  if (ALLOW_SEVERAL_CONNS == 0)  //NO simultaneous connections
    {            
    long LOCKTIME, NOW, INTERVAL;
    LOCKTIME = GetTimeFromLockFileOpening (ReturnUserLockFileName (pd.username, tmp));      
    NOW = time (NULL);
    INTERVAL = NOW - LOCKTIME;
    if ((INTERVAL <= MAX_TIME_BETWEEN_CONNS) && (LOCKTIME != -1))
      {
      --ServerCounter;
      LOG ("Time minimum between connections. User '%s'. Exiting.", pd.username);
      pd.html->ErrorPage (L->get(MSG_MIN_TIMEBETWCONNS)); 
      exit(0);        
      }
    }       
  }
  
void ClearConn (void)
  {
  if (ALLOW_SEVERAL_CONNS == 0) {DeleteFile (ReturnUserLockFileName (pd.username, tmp));}
  }
  
//ALARM INSTALL, FOR TIMEOUT
void AlarmInstall (void)
  {
  struct sigaction actx, oldactx;
  if (USETIMEOUT == 1)
    {
    sigemptyset(&actx.sa_mask); actx.sa_flags = 0; actx.sa_handler = procsignals;
    sigaction(SIGALRM, &actx, &oldactx);      
    }
  }
  
void doLocking (void)
  {
  if (ALLOW_SEVERAL_CONNS == 0) //NO simultaneous connections
    {
    TBuffer lockfile;
    int res;
    xstrncpy (lockfile, CMAXBUFFER, ReturnUserLockFileName (pd.username, tmp));
    res = IsLocked (lockfile, &LockFileDescriptor);
    switch (res)
      {
      case 2: //NO EXISTE EL FICHERO DE LOCK
              LockFileDescriptor = CreateAndLockFile (lockfile);
              break;
      case 1: //SI HAY UN LOCK PA'FUERA
              LOG ("Lock file for user '%s'. Exiting.", pd.username);
              pd.html->ErrorPage (L->get(MSG_TOO_MAX_TRY_CONN)); 
              exit(0);        
              break;
      case 0: //NO HAY LOCK 
              int thepid;
              LOG ("User %s, IP=%s already connected. Killing old connection.", pd.username, pd.ipclient);  
              thepid = GetPIDFromLockFile(LockFileDescriptor);
              if (thepid >0) kill (thepid, SIGUSR1);
              EscribePIDenLockFile (LockFileDescriptor);
              break;
      }
    }
  }   
  
//SWITCH ON THE ALARM
void SwitchOnAlarm (int alarmtime)
  {
  pd.uo->setTimeout (alarmtime);
  if (USETIMEOUT == 1) alarm ((xuint)(alarmtime));
  }

void ExitServer (void)
  {
  serversocket->Close ();
  delete serversocket;
  delete pd.uo;  
  delete cclient;
  delete L;
  delete pd.html;
  if (getpid () == MainServerPid) {LOG ("Main server is down.");}
  CLOSELOG();
  exit (0);
  }

//ERROR: PW invalida, server not ready, port not open, ...
void ErrorInLogin (void)
  {
  TBuffer errmsg;
  xstrncpy (errmsg, CMAXBUFFER, auth->getErrorMsg());
  LOG ("%s (pd.ipclient='%s', user='%s')", errmsg, pd.ipclient, pd.username);
  pd.html->ErrorPage(errmsg);
  }

void setUserDirs (void)
  {
  TBuffer asb;
  char inicials[3];    
  xstrncpy (UserDir, CMAXBUFFER, ReturnUsersDir(Conf->getString ("main", "usersbasepath", "/var/"APPNAME"/users", CMAXBUFFER), pd.username, pd.uo->getImapServer (), tmp));
  inicials [0] = pd.username[0]; inicials [1] = pd.username[1]; inicials [2] = '\0';
  xstrncpy (asb, CMAXBUFFER, Conf->getString ("main", "usersbasepath", "/var/"APPNAME"/users", CMAXBUFFER));
    xstrncat (asb, CMAXBUFFER, "/"); 
    xstrncat (asb, CMAXBUFFER, pd.uo->getImapServer ());
  if (CreateDir (asb, USERDIRMODE) == false) {pd.html->ErrorPage(L->get (ERR_CREAT_USERDIR)); fflush (stdout); exit (0);}
  xstrncat (asb, CMAXBUFFER, "/"); xstrncat (asb, CMAXBUFFER, inicials);
  if (CreateDir (asb, USERDIRMODE) == false) {pd.html->ErrorPage(L->get (ERR_CREAT_USERDIR)); fflush (stdout); exit (0);}
  if (CreateDir (UserDir, USERDIRMODE) == false) {pd.html->ErrorPage(L->get (ERR_CREAT_USERDIR)); fflush (stdout); exit (0);}    
  if (CreateDir ((char *)pd.uo->getAttachDir(), USERATTACHSDIRMODE) == false) {pd.html->ErrorPage(L->get (ERR_CREAT_USERATTACHSDIR)); fflush (stdout); exit (0);} 
  if (CreateDir ((char *)pd.uo->getDatabasesDir(), USERDIRMODE) == false) {pd.html->ErrorPage(L->get (ERR_CREAT_USERDATABASESDIR)); fflush (stdout); exit (0);}    
  }
