/*
 * Decompiled with CFR 0.152.
 */
package org.postgis.pljava;

import java.nio.ByteOrder;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.util.logging.Logger;

public class PLJGeometry
implements SQLData {
    private static char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static Logger s_logger = Logger.getAnonymousLogger();
    public StringBuffer rep = new StringBuffer();
    private String m_typeName;

    public String getSQLTypeName() {
        return this.m_typeName;
    }

    public void readSQL(SQLInput sQLInput, String string) throws SQLException {
        s_logger.info(string + " from SQLInput");
        this.rep.append("'");
        int n = sQLInput.readInt() & 0x3FFFFFFF;
        this.rep.append(n);
        this.rep.append('-');
        byte by = sQLInput.readByte();
        this.rep.append(hex[by >> 4 & 0xF]);
        this.rep.append(hex[by & 0xF]);
        this.rep.append(' ');
        double d = sQLInput.readDouble();
        this.rep.append(d);
        this.rep.append('=');
        this.rep.append(Double.longBitsToDouble(PLJGeometry.swap(Double.doubleToLongBits(d))));
        this.rep.append(' ');
        this.rep.append(sQLInput.readDouble());
        this.rep.append('\'');
        this.m_typeName = string;
        ByteOrder.nativeOrder();
    }

    private static long swap(long l) {
        return (PLJGeometry.b(l, 56) << 0) + (PLJGeometry.b(l, 48) << 8) + (PLJGeometry.b(l, 40) << 16) + (PLJGeometry.b(l, 32) << 24) + (PLJGeometry.b(l, 24) << 32) + (PLJGeometry.b(l, 16) << 40) + (PLJGeometry.b(l, 8) << 48) + (PLJGeometry.b(l, 0) << 56);
    }

    private static long b(long l, int n) {
        return l >> n & 0xFFL;
    }

    public void writeSQL(SQLOutput sQLOutput) throws SQLException {
        s_logger.info(this.m_typeName + " to SQLOutput");
        sQLOutput.writeInt(21);
        sQLOutput.writeByte((byte)1);
        sQLOutput.writeDouble(2.0);
        sQLOutput.writeDouble(3.0);
    }

    public static PLJGeometry logAndReturn(PLJGeometry pLJGeometry) {
        s_logger.info(pLJGeometry.getSQLTypeName() + pLJGeometry);
        return pLJGeometry;
    }
}

