/*
 * This file is part of the xTuple ERP: PostBooks Edition, a free and
 * open source Enterprise Resource Planning software suite,
 * Copyright (c) 1999-2017 by OpenMFG LLC, d/b/a xTuple.
 * It is licensed to you under the Common Public Attribution License
 * version 1.0, the full text of which (including xTuple-specific Exhibits)
 * is available at www.xtuple.com/CPAL.  By using this software, you agree
 * to be bound by its terms.
 */

#include "qtsetup.h"

QScriptValue AlignmentFlagtoScriptValue(QScriptEngine *engine, const enum Qt::AlignmentFlag &p)
{
  return QScriptValue(engine, (int)p);
}

/*QScriptValue AnchorAttributetoScriptValue(QScriptEngine *engine, const enum Qt::AnchorAttribute &p)
{
  return QScriptValue(engine, (int)p);
}*/

QScriptValue ApplicationAttributetoScriptValue(QScriptEngine *engine, const enum Qt::ApplicationAttribute &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue ArrowTypetoScriptValue(QScriptEngine *engine, const enum Qt::ArrowType &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue AspectRatioModetoScriptValue(QScriptEngine *engine, const enum Qt::AspectRatioMode &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue AxistoScriptValue(QScriptEngine *engine, const enum Qt::Axis &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue BGModetoScriptValue(QScriptEngine *engine, const enum Qt::BGMode &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue BrushStyletoScriptValue(QScriptEngine *engine, const enum Qt::BrushStyle &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue CaseSensitivitytoScriptValue(QScriptEngine *engine, const enum Qt::CaseSensitivity &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue CheckStatetoScriptValue(QScriptEngine *engine, const enum Qt::CheckState &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue ClipOperationtoScriptValue(QScriptEngine *engine, const enum Qt::ClipOperation &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue ConnectionTypetoScriptValue(QScriptEngine *engine, const enum Qt::ConnectionType &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue ContextMenuPolicytoScriptValue(QScriptEngine *engine, const enum Qt::ContextMenuPolicy &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue CornertoScriptValue(QScriptEngine *engine, const enum Qt::Corner &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue CursorShapetoScriptValue(QScriptEngine *engine, const enum Qt::CursorShape &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue DateFormattoScriptValue(QScriptEngine *engine, const enum Qt::DateFormat &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue DayOfWeektoScriptValue(QScriptEngine *engine, const enum Qt::DayOfWeek &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue DockWidgetAreatoScriptValue(QScriptEngine *engine, const enum Qt::DockWidgetArea &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue DropActiontoScriptValue(QScriptEngine *engine, const enum Qt::DropAction &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue EventPrioritytoScriptValue(QScriptEngine *engine, const enum Qt::EventPriority &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue FillRuletoScriptValue(QScriptEngine *engine, const enum Qt::FillRule &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue FindChildOptionToScriptValue(QScriptEngine *engine, const enum Qt::FindChildOption &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue FindChildOptionsToScriptValue(QScriptEngine *engine, const Qt::FindChildOptions &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue FocusPolicytoScriptValue(QScriptEngine *engine, const Qt::FocusPolicy &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue FocusReasontoScriptValue(QScriptEngine *engine, const enum Qt::FocusReason &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue GlobalColortoScriptValue(QScriptEngine *engine, const enum Qt::GlobalColor &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue HitTestAccuracytoScriptValue(QScriptEngine *engine, const enum Qt::HitTestAccuracy &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue ImageConversionFlagtoScriptValue(QScriptEngine *engine, const enum Qt::ImageConversionFlag &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue InputMethodQuerytoScriptValue(QScriptEngine *engine, const enum Qt::InputMethodQuery &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue ItemDataRoletoScriptValue(QScriptEngine *engine, const enum Qt::ItemDataRole &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue ItemFlagtoScriptValue(QScriptEngine *engine, const enum Qt::ItemFlag &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue ItemSelectionModetoScriptValue(QScriptEngine *engine, const enum Qt::ItemSelectionMode &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue KeytoScriptValue(QScriptEngine *engine, const enum Qt::Key &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue KeyboardModifiertoScriptValue(QScriptEngine *engine, const enum Qt::KeyboardModifier &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue LayoutDirectiontoScriptValue(QScriptEngine *engine, const enum Qt::LayoutDirection &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue MaskModetoScriptValue(QScriptEngine *engine, const enum Qt::MaskMode &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue MatchFlagtoScriptValue(QScriptEngine *engine, const enum Qt::MatchFlag &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue MatchFlagstoScriptValue(QScriptEngine *engine, const Qt::MatchFlags &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue ModifiertoScriptValue(QScriptEngine *engine, const enum Qt::Modifier &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue MouseButtontoScriptValue(QScriptEngine *engine, const enum Qt::MouseButton &p)
{
  return QScriptValue(engine, (int)p);
}

/*
QScriptValue OrientationtoScriptValue(QScriptEngine *engine, const enum Qt::Orientation &p)
{
  return QScriptValue(engine, (int)p);
}
*/

QScriptValue PenCapStyletoScriptValue(QScriptEngine *engine, const enum Qt::PenCapStyle &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue PenJoinStyletoScriptValue(QScriptEngine *engine, const enum Qt::PenJoinStyle &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue PenStyletoScriptValue(QScriptEngine *engine, const enum Qt::PenStyle &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue ScrollBarPolicytoScriptValue(QScriptEngine *engine, const enum Qt::ScrollBarPolicy &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue ShortcutContexttoScriptValue(QScriptEngine *engine, const enum Qt::ShortcutContext &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue SizeHinttoScriptValue(QScriptEngine *engine, const enum Qt::SizeHint &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue SizeModetoScriptValue(QScriptEngine *engine, const enum Qt::SizeMode &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue SortOrdertoScriptValue(QScriptEngine *engine, const enum Qt::SortOrder &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue TextElideModetoScriptValue(QScriptEngine *engine, const enum Qt::TextElideMode &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue TextFlagtoScriptValue(QScriptEngine *engine, const enum Qt::TextFlag &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue TextFormattoScriptValue(QScriptEngine *engine, const enum Qt::TextFormat &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue TextInteractionFlagtoScriptValue(QScriptEngine *engine, const enum Qt::TextInteractionFlag &p)
{
  return QScriptValue(engine, (int)p);
}

#if QT_VERSION >= 0x050000
QScriptValue TimerTypetoScriptValue(QScriptEngine *engine, const enum Qt::TimerType &p)
{
  return QScriptValue(engine, (int)p);
}
#endif

QScriptValue TimeSpectoScriptValue(QScriptEngine *engine, const enum Qt::TimeSpec &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue ToolBarAreatoScriptValue(QScriptEngine *engine, const enum Qt::ToolBarArea &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue ToolButtonStyletoScriptValue(QScriptEngine *engine, const enum Qt::ToolButtonStyle &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue TransformationModetoScriptValue(QScriptEngine *engine, const enum Qt::TransformationMode &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue UIEffecttoScriptValue(QScriptEngine *engine, const enum Qt::UIEffect &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue WhiteSpaceModetoScriptValue(QScriptEngine *engine, const enum Qt::WhiteSpaceMode &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue WidgetAttributetoScriptValue(QScriptEngine *engine, const enum Qt::WidgetAttribute &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue WindowFrameSectiontoScriptValue(QScriptEngine *engine, const enum Qt::WindowFrameSection &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue WindowModalitytoScriptValue(QScriptEngine *engine, const enum Qt::WindowModality &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue WindowStatetoScriptValue(QScriptEngine *engine, const enum Qt::WindowState &p)
{
  return QScriptValue(engine, (int)p);
}

QScriptValue WindowTypetoScriptValue(QScriptEngine *engine, const enum Qt::WindowType &p)
{
  return QScriptValue(engine, (int)p);
}

void AlignmentFlagfromScriptValue(const QScriptValue &obj, enum Qt::AlignmentFlag &p)
{
  p = (enum Qt::AlignmentFlag)obj.toInt32();
}

/*void AnchorAttributefromScriptValue(const QScriptValue &obj, enum Qt::AnchorAttribute &p)
{
  p = (enum Qt::AnchorAttribute)obj.toInt32();
}*/

void ApplicationAttributefromScriptValue(const QScriptValue &obj, enum Qt::ApplicationAttribute &p)
{
  p = (enum Qt::ApplicationAttribute)obj.toInt32();
}

void ArrowTypefromScriptValue(const QScriptValue &obj, enum Qt::ArrowType &p)
{
  p = (enum Qt::ArrowType)obj.toInt32();
}

void AspectRatioModefromScriptValue(const QScriptValue &obj, enum Qt::AspectRatioMode &p)
{
  p = (enum Qt::AspectRatioMode)obj.toInt32();
}

void AxisfromScriptValue(const QScriptValue &obj, enum Qt::Axis &p)
{
  p = (enum Qt::Axis)obj.toInt32();
}

void BGModefromScriptValue(const QScriptValue &obj, enum Qt::BGMode &p)
{
  p = (enum Qt::BGMode)obj.toInt32();
}

void BrushStylefromScriptValue(const QScriptValue &obj, enum Qt::BrushStyle &p)
{
  p = (enum Qt::BrushStyle)obj.toInt32();
}

void CaseSensitivityfromScriptValue(const QScriptValue &obj, enum Qt::CaseSensitivity &p)
{
  p = (enum Qt::CaseSensitivity)obj.toInt32();
}

void CheckStatefromScriptValue(const QScriptValue &obj, enum Qt::CheckState &p)
{
  p = (enum Qt::CheckState)obj.toInt32();
}

void ClipOperationfromScriptValue(const QScriptValue &obj, enum Qt::ClipOperation &p)
{
  p = (enum Qt::ClipOperation)obj.toInt32();
}

void ConnectionTypefromScriptValue(const QScriptValue &obj, enum Qt::ConnectionType &p)
{
  p = (enum Qt::ConnectionType)obj.toInt32();
}

void ContextMenuPolicyfromScriptValue(const QScriptValue &obj, enum Qt::ContextMenuPolicy &p)
{
  p = (enum Qt::ContextMenuPolicy)obj.toInt32();
}

void CornerfromScriptValue(const QScriptValue &obj, enum Qt::Corner &p)
{
  p = (enum Qt::Corner)obj.toInt32();
}

void CursorShapefromScriptValue(const QScriptValue &obj, enum Qt::CursorShape &p)
{
  p = (enum Qt::CursorShape)obj.toInt32();
}

void DateFormatfromScriptValue(const QScriptValue &obj, enum Qt::DateFormat &p)
{
  p = (enum Qt::DateFormat)obj.toInt32();
}

void DayOfWeekfromScriptValue(const QScriptValue &obj, enum Qt::DayOfWeek &p)
{
  p = (enum Qt::DayOfWeek)obj.toInt32();
}

void DockWidgetAreafromScriptValue(const QScriptValue &obj, enum Qt::DockWidgetArea &p)
{
  p = (enum Qt::DockWidgetArea)obj.toInt32();
}

void DropActionfromScriptValue(const QScriptValue &obj, enum Qt::DropAction &p)
{
  p = (enum Qt::DropAction)obj.toInt32();
}

void EventPriorityfromScriptValue(const QScriptValue &obj, enum Qt::EventPriority &p)
{
  p = (enum Qt::EventPriority)obj.toInt32();
}

void FillRulefromScriptValue(const QScriptValue &obj, enum Qt::FillRule &p)
{
  p = (enum Qt::FillRule)obj.toInt32();
}

void FindChildOptionFromScriptValue(const QScriptValue &obj, enum Qt::FindChildOption &p)
{
  p = (enum Qt::FindChildOption)obj.toInt32();
}

void FindChildOptionsFromScriptValue(const QScriptValue &obj, Qt::FindChildOptions &p)
{
  p = (Qt::FindChildOptions)obj.toInt32();
}

void FocusPolicyfromScriptValue(const QScriptValue &obj, Qt::FocusPolicy &p)
{
  p = (Qt::FocusPolicy)obj.toInt32();
}

void FocusReasonfromScriptValue(const QScriptValue &obj, enum Qt::FocusReason &p)
{
  p = (enum Qt::FocusReason)obj.toInt32();
}

void GlobalColorfromScriptValue(const QScriptValue &obj, enum Qt::GlobalColor &p)
{
  p = (enum Qt::GlobalColor)obj.toInt32();
}

void HitTestAccuracyfromScriptValue(const QScriptValue &obj, enum Qt::HitTestAccuracy &p)
{
  p = (enum Qt::HitTestAccuracy)obj.toInt32();
}

void ImageConversionFlagfromScriptValue(const QScriptValue &obj, enum Qt::ImageConversionFlag &p)
{
  p = (enum Qt::ImageConversionFlag)obj.toInt32();
}

void InputMethodQueryfromScriptValue(const QScriptValue &obj, enum Qt::InputMethodQuery &p)
{
  p = (enum Qt::InputMethodQuery)obj.toInt32();
}

void ItemDataRolefromScriptValue(const QScriptValue &obj, enum Qt::ItemDataRole &p)
{
  p = (enum Qt::ItemDataRole)obj.toInt32();
}

void ItemFlagfromScriptValue(const QScriptValue &obj, enum Qt::ItemFlag &p)
{
  p = (enum Qt::ItemFlag)obj.toInt32();
}

void ItemSelectionModefromScriptValue(const QScriptValue &obj, enum Qt::ItemSelectionMode &p)
{
  p = (enum Qt::ItemSelectionMode)obj.toInt32();
}

void KeyfromScriptValue(const QScriptValue &obj, enum Qt::Key &p)
{
  p = (enum Qt::Key)obj.toInt32();
}

void KeyboardModifierfromScriptValue(const QScriptValue &obj, enum Qt::KeyboardModifier &p)
{
  p = (enum Qt::KeyboardModifier)obj.toInt32();
}

void LayoutDirectionfromScriptValue(const QScriptValue &obj, enum Qt::LayoutDirection &p)
{
  p = (enum Qt::LayoutDirection)obj.toInt32();
}

void MaskModefromScriptValue(const QScriptValue &obj, enum Qt::MaskMode &p)
{
  p = (enum Qt::MaskMode)obj.toInt32();
}

void MatchFlagfromScriptValue(const QScriptValue &obj, enum Qt::MatchFlag &p)
{
  p = (enum Qt::MatchFlag)obj.toInt32();
}

void MatchFlagsfromScriptValue(const QScriptValue &obj, Qt::MatchFlags &p)
{
  p = (Qt::MatchFlags)obj.toInt32();
}

void ModifierfromScriptValue(const QScriptValue &obj, enum Qt::Modifier &p)
{
  p = (enum Qt::Modifier)obj.toInt32();
}

void MouseButtonfromScriptValue(const QScriptValue &obj, enum Qt::MouseButton &p)
{
  p = (enum Qt::MouseButton)obj.toInt32();
}

/*
void OrientationfromScriptValue(const QScriptValue &obj, enum Qt::Orientation &p)
{
  p = (enum Qt::Orientation)obj.toInt32();
}
*/

void PenCapStylefromScriptValue(const QScriptValue &obj, enum Qt::PenCapStyle &p)
{
  p = (enum Qt::PenCapStyle)obj.toInt32();
}

void PenJoinStylefromScriptValue(const QScriptValue &obj, enum Qt::PenJoinStyle &p)
{
  p = (enum Qt::PenJoinStyle)obj.toInt32();
}

void PenStylefromScriptValue(const QScriptValue &obj, enum Qt::PenStyle &p)
{
  p = (enum Qt::PenStyle)obj.toInt32();
}

void ScrollBarPolicyfromScriptValue(const QScriptValue &obj, enum Qt::ScrollBarPolicy &p)
{
  p = (enum Qt::ScrollBarPolicy)obj.toInt32();
}

void ShortcutContextfromScriptValue(const QScriptValue &obj, enum Qt::ShortcutContext &p)
{
  p = (enum Qt::ShortcutContext)obj.toInt32();
}

void SizeHintfromScriptValue(const QScriptValue &obj, enum Qt::SizeHint &p)
{
  p = (enum Qt::SizeHint)obj.toInt32();
}

void SizeModefromScriptValue(const QScriptValue &obj, enum Qt::SizeMode &p)
{
  p = (enum Qt::SizeMode)obj.toInt32();
}

void SortOrderfromScriptValue(const QScriptValue &obj, enum Qt::SortOrder &p)
{
  p = (enum Qt::SortOrder)obj.toInt32();
}

void TextElideModefromScriptValue(const QScriptValue &obj, enum Qt::TextElideMode &p)
{
  p = (enum Qt::TextElideMode)obj.toInt32();
}

void TextFlagfromScriptValue(const QScriptValue &obj, enum Qt::TextFlag &p)
{
  p = (enum Qt::TextFlag)obj.toInt32();
}

void TextFormatfromScriptValue(const QScriptValue &obj, enum Qt::TextFormat &p)
{
  p = (enum Qt::TextFormat)obj.toInt32();
}

void TextInteractionFlagfromScriptValue(const QScriptValue &obj, enum Qt::TextInteractionFlag &p)
{
  p = (enum Qt::TextInteractionFlag)obj.toInt32();
}

#if QT_VERSION >= 0x050000
void TimerTypefromScriptValue(const QScriptValue &obj, enum Qt::TimerType &p)
{
  p = (enum Qt::TimerType)obj.toInt32();
}
#endif

void TimeSpecfromScriptValue(const QScriptValue &obj, enum Qt::TimeSpec &p)
{
  p = (enum Qt::TimeSpec)obj.toInt32();
}

void ToolBarAreafromScriptValue(const QScriptValue &obj, enum Qt::ToolBarArea &p)
{
  p = (enum Qt::ToolBarArea)obj.toInt32();
}

void ToolButtonStylefromScriptValue(const QScriptValue &obj, enum Qt::ToolButtonStyle &p)
{
  p = (enum Qt::ToolButtonStyle)obj.toInt32();
}

void TransformationModefromScriptValue(const QScriptValue &obj, enum Qt::TransformationMode &p)
{
  p = (enum Qt::TransformationMode)obj.toInt32();
}

void UIEffectfromScriptValue(const QScriptValue &obj, enum Qt::UIEffect &p)
{
  p = (enum Qt::UIEffect)obj.toInt32();
}

void WhiteSpaceModefromScriptValue(const QScriptValue &obj, enum Qt::WhiteSpaceMode &p)
{
  p = (enum Qt::WhiteSpaceMode)obj.toInt32();
}

void WidgetAttributefromScriptValue(const QScriptValue &obj, enum Qt::WidgetAttribute &p)
{
  p = (enum Qt::WidgetAttribute)obj.toInt32();
}

void WindowFrameSectionfromScriptValue(const QScriptValue &obj, enum Qt::WindowFrameSection &p)
{
  p = (enum Qt::WindowFrameSection)obj.toInt32();
}

void WindowModalityfromScriptValue(const QScriptValue &obj, enum Qt::WindowModality &p)
{
  p = (enum Qt::WindowModality)obj.toInt32();
}

void WindowStatefromScriptValue(const QScriptValue &obj, enum Qt::WindowState &p)
{
  p = (enum Qt::WindowState)obj.toInt32();
}

void WindowTypefromScriptValue(const QScriptValue &obj, enum Qt::WindowType &p)
{
  p = (enum Qt::WindowType)obj.toInt32();
}

void setupQt(QScriptEngine *engine)
{
  QScriptValue widget = engine->newObject();
  QScriptValue::PropertyFlags ro = QScriptValue::ReadOnly | QScriptValue::Undeletable;

  qScriptRegisterMetaType(engine, AlignmentFlagtoScriptValue, AlignmentFlagfromScriptValue);
  widget.setProperty("AlignLeft",            QScriptValue(engine, Qt::AlignLeft),            ro);
  widget.setProperty("AlignRight",           QScriptValue(engine, Qt::AlignRight),           ro);
  widget.setProperty("AlignHCenter",         QScriptValue(engine, Qt::AlignHCenter),         ro);
  widget.setProperty("AlignJustify",         QScriptValue(engine, Qt::AlignJustify),         ro);
  widget.setProperty("AlignTop",             QScriptValue(engine, Qt::AlignTop),             ro);
  widget.setProperty("AlignBottom",          QScriptValue(engine, Qt::AlignBottom),          ro);
  widget.setProperty("AlignVCenter",         QScriptValue(engine, Qt::AlignVCenter),         ro);
  widget.setProperty("AlignCenter",          QScriptValue(engine, Qt::AlignCenter),          ro);
  widget.setProperty("AlignAbsolute",        QScriptValue(engine, Qt::AlignAbsolute),        ro);
  widget.setProperty("AlignLeading",         QScriptValue(engine, Qt::AlignLeading),         ro);
  widget.setProperty("AlignTrailing",        QScriptValue(engine, Qt::AlignTrailing),        ro);
  widget.setProperty("AlignHorizontal_Mask", QScriptValue(engine, Qt::AlignHorizontal_Mask), ro);
  widget.setProperty("AlignVertical_Mask",   QScriptValue(engine, Qt::AlignVertical_Mask),   ro);

  qScriptRegisterMetaType(engine, ApplicationAttributetoScriptValue, ApplicationAttributefromScriptValue);
  widget.setProperty("AA_ImmediateWidgetCreation",        QScriptValue(engine, Qt::AA_ImmediateWidgetCreation),        ro);
  widget.setProperty("AA_MSWindowsUseDirect3DByDefault",  QScriptValue(engine, Qt::AA_MSWindowsUseDirect3DByDefault),  ro);
  widget.setProperty("AA_DontShowIconsInMenus",           QScriptValue(engine, Qt::AA_DontShowIconsInMenus),           ro);
  widget.setProperty("AA_NativeWindows",                  QScriptValue(engine, Qt::AA_NativeWindows),                  ro);
  widget.setProperty("AA_DontCreateNativeWidgetSiblings", QScriptValue(engine, Qt::AA_DontCreateNativeWidgetSiblings), ro);
  widget.setProperty("AA_MacPluginApplication",           QScriptValue(engine, Qt::AA_MacPluginApplication),           ro);

  qScriptRegisterMetaType(engine, ArrowTypetoScriptValue, ArrowTypefromScriptValue);
  widget.setProperty("NoArrow",                    QScriptValue(engine, Qt::NoArrow),                    ro);
  widget.setProperty("UpArrow",                    QScriptValue(engine, Qt::UpArrow),                    ro);
  widget.setProperty("DownArrow",                  QScriptValue(engine, Qt::DownArrow),                  ro);
  widget.setProperty("LeftArrow",                  QScriptValue(engine, Qt::LeftArrow),                  ro);
  widget.setProperty("RightArrow",                 QScriptValue(engine, Qt::RightArrow),                 ro);

  qScriptRegisterMetaType(engine, AspectRatioModetoScriptValue, AspectRatioModefromScriptValue);
  widget.setProperty("IgnoreAspectRatio",          QScriptValue(engine, Qt::IgnoreAspectRatio),          ro);
  widget.setProperty("KeepAspectRatio",            QScriptValue(engine, Qt::KeepAspectRatio),            ro);
  widget.setProperty("KeepAspectRatioByExpanding", QScriptValue(engine, Qt::KeepAspectRatioByExpanding), ro);

  qScriptRegisterMetaType(engine, AxistoScriptValue,  AxisfromScriptValue);
  widget.setProperty("XAxis",                   QScriptValue(engine, Qt::XAxis),                ro);
  widget.setProperty("YAxis",                   QScriptValue(engine, Qt::YAxis),                ro);
  widget.setProperty("ZAxis",                   QScriptValue(engine, Qt::ZAxis),                ro);

  qScriptRegisterMetaType(engine, BGModetoScriptValue, BGModefromScriptValue);
  widget.setProperty("TransparentMode",         QScriptValue(engine, Qt::TransparentMode),      ro);
  widget.setProperty("OpaqueMode",              QScriptValue(engine, Qt::OpaqueMode),           ro);

  qScriptRegisterMetaType(engine, BrushStyletoScriptValue, BrushStylefromScriptValue);
  widget.setProperty("NoBrush",                 QScriptValue(engine, Qt::NoBrush),              ro);
  widget.setProperty("SolidPattern",            QScriptValue(engine, Qt::SolidPattern),         ro);
  widget.setProperty("Dense1Pattern",           QScriptValue(engine, Qt::Dense1Pattern),        ro);
  widget.setProperty("Dense2Pattern",           QScriptValue(engine, Qt::Dense2Pattern),        ro);
  widget.setProperty("Dense3Pattern",           QScriptValue(engine, Qt::Dense3Pattern),        ro);
  widget.setProperty("Dense4Pattern",           QScriptValue(engine, Qt::Dense4Pattern),        ro);
  widget.setProperty("Dense5Pattern",           QScriptValue(engine, Qt::Dense5Pattern),        ro);
  widget.setProperty("Dense6Pattern",           QScriptValue(engine, Qt::Dense6Pattern),        ro);
  widget.setProperty("Dense7Pattern",           QScriptValue(engine, Qt::Dense7Pattern),        ro);
  widget.setProperty("HorPattern",              QScriptValue(engine, Qt::HorPattern),           ro);
  widget.setProperty("VerPattern",              QScriptValue(engine, Qt::VerPattern),           ro);
  widget.setProperty("CrossPattern",            QScriptValue(engine, Qt::CrossPattern),         ro);
  widget.setProperty("BDiagPattern",            QScriptValue(engine, Qt::BDiagPattern),         ro);
  widget.setProperty("FDiagPattern",            QScriptValue(engine, Qt::FDiagPattern),         ro);
  widget.setProperty("DiagCrossPattern",        QScriptValue(engine, Qt::DiagCrossPattern),     ro);
  widget.setProperty("LinearGradientPattern",   QScriptValue(engine, Qt::LinearGradientPattern),  ro);
  widget.setProperty("ConicalGradientPattern",  QScriptValue(engine, Qt::ConicalGradientPattern), ro);
  widget.setProperty("RadialGradientPattern",   QScriptValue(engine, Qt::RadialGradientPattern),  ro);
  widget.setProperty("TexturePattern",          QScriptValue(engine, Qt::TexturePattern),         ro);

  qScriptRegisterMetaType(engine, CaseSensitivitytoScriptValue, CaseSensitivityfromScriptValue);
  widget.setProperty("CaseInsensitive",         QScriptValue(engine, Qt::CaseInsensitive),      ro);
  widget.setProperty("CaseSensitive",           QScriptValue(engine, Qt::CaseSensitive),        ro);

  qScriptRegisterMetaType(engine, CheckStatetoScriptValue, CheckStatefromScriptValue);
  widget.setProperty("Unchecked",               QScriptValue(engine, Qt::Unchecked),            ro);
  widget.setProperty("PartiallyChecked",        QScriptValue(engine, Qt::PartiallyChecked),     ro);
  widget.setProperty("Checked",                 QScriptValue(engine, Qt::Checked),              ro);

  qScriptRegisterMetaType(engine, ClipOperationtoScriptValue, ClipOperationfromScriptValue);
  widget.setProperty("NoClip",                  QScriptValue(engine, Qt::NoClip),               ro);
  widget.setProperty("ReplaceClip",             QScriptValue(engine, Qt::ReplaceClip),          ro);
  widget.setProperty("IntersectClip",           QScriptValue(engine, Qt::IntersectClip),        ro);

  qScriptRegisterMetaType(engine, ConnectionTypetoScriptValue, ConnectionTypefromScriptValue);
  widget.setProperty("DirectConnection",          QScriptValue(engine, Qt::DirectConnection),       ro);
  widget.setProperty("QueuedConnection",          QScriptValue(engine, Qt::QueuedConnection),       ro);
  widget.setProperty("BlockingQueuedConnection",  QScriptValue(engine, Qt::BlockingQueuedConnection),                        ro);
  widget.setProperty("AutoConnection",            QScriptValue(engine, Qt::AutoConnection),         ro);

  qScriptRegisterMetaType(engine, ContextMenuPolicytoScriptValue, ContextMenuPolicyfromScriptValue);
  widget.setProperty("NoContextMenu",             QScriptValue(engine, Qt::NoContextMenu),          ro);
  widget.setProperty("PreventContextMenu",        QScriptValue(engine, Qt::PreventContextMenu),     ro);
  widget.setProperty("DefaultContextMenu",        QScriptValue(engine, Qt::DefaultContextMenu),     ro);
  widget.setProperty("ActionsContextMenu",        QScriptValue(engine, Qt::ActionsContextMenu),     ro);
  widget.setProperty("CustomContextMenu",         QScriptValue(engine, Qt::CustomContextMenu),      ro);

  qScriptRegisterMetaType(engine, CornertoScriptValue, CornerfromScriptValue);
  widget.setProperty("TopLeftCorner",             QScriptValue(engine, Qt::TopLeftCorner),          ro);
  widget.setProperty("TopRightCorner",            QScriptValue(engine, Qt::TopRightCorner),         ro);
  widget.setProperty("BottomLeftCorner",          QScriptValue(engine, Qt::BottomLeftCorner),       ro);
  widget.setProperty("BottomRightCorner",         QScriptValue(engine, Qt::BottomRightCorner),      ro);

  qScriptRegisterMetaType(engine, CursorShapetoScriptValue, CursorShapefromScriptValue);
  widget.setProperty("ArrowCursor",               QScriptValue(engine, Qt::ArrowCursor),            ro);
  widget.setProperty("UpArrowCursor",             QScriptValue(engine, Qt::UpArrowCursor),          ro);
  widget.setProperty("CrossCursor",               QScriptValue(engine, Qt::CrossCursor),            ro);
  widget.setProperty("WaitCursor",                QScriptValue(engine, Qt::WaitCursor),             ro);
  widget.setProperty("IBeamCursor",               QScriptValue(engine, Qt::IBeamCursor),            ro);
  widget.setProperty("SizeVerCursor",             QScriptValue(engine, Qt::SizeVerCursor),          ro);
  widget.setProperty("SizeHorCursor",             QScriptValue(engine, Qt::SizeHorCursor),          ro);
  widget.setProperty("SizeBDiagCursor",           QScriptValue(engine, Qt::SizeBDiagCursor),        ro);
  widget.setProperty("SizeFDiagCursor",           QScriptValue(engine, Qt::SizeFDiagCursor),        ro);
  widget.setProperty("SizeAllCursor",             QScriptValue(engine, Qt::SizeAllCursor),          ro);
  widget.setProperty("BlankCursor",               QScriptValue(engine, Qt::BlankCursor),            ro);
  widget.setProperty("SplitVCursor",              QScriptValue(engine, Qt::SplitVCursor),           ro);
  widget.setProperty("SplitHCursor",              QScriptValue(engine, Qt::SplitHCursor),           ro);
  widget.setProperty("PointingHandCursor",        QScriptValue(engine, Qt::PointingHandCursor),     ro);
  widget.setProperty("ForbiddenCursor",           QScriptValue(engine, Qt::ForbiddenCursor),        ro);
  widget.setProperty("OpenHandCursor",            QScriptValue(engine, Qt::OpenHandCursor),         ro);
  widget.setProperty("ClosedHandCursor",          QScriptValue(engine, Qt::ClosedHandCursor),       ro);
  widget.setProperty("WhatsThisCursor",           QScriptValue(engine, Qt::WhatsThisCursor),        ro);
  widget.setProperty("BusyCursor",                QScriptValue(engine, Qt::BusyCursor),             ro);
  widget.setProperty("BitmapCursor",              QScriptValue(engine, Qt::BitmapCursor),           ro);

  qScriptRegisterMetaType(engine, DateFormattoScriptValue, DateFormatfromScriptValue);
  widget.setProperty("TextDate",                  QScriptValue(engine, Qt::TextDate),               ro);
  widget.setProperty("ISODate",                   QScriptValue(engine, Qt::ISODate),                ro);
  widget.setProperty("SystemLocaleShortDate",     QScriptValue(engine, Qt::SystemLocaleShortDate),  ro);
  widget.setProperty("SystemLocaleLongDate",      QScriptValue(engine, Qt::SystemLocaleLongDate),   ro);
  widget.setProperty("DefaultLocaleShortDate",    QScriptValue(engine, Qt::DefaultLocaleShortDate), ro);
  widget.setProperty("DefaultLocaleLongDate",     QScriptValue(engine, Qt::DefaultLocaleLongDate),  ro);
  widget.setProperty("SystemLocaleDate",          QScriptValue(engine, Qt::SystemLocaleDate),       ro);
  widget.setProperty("LocaleDate",                QScriptValue(engine, Qt::LocaleDate),             ro);
  widget.setProperty("LocalDate",                 QScriptValue(engine, Qt::LocalDate),              ro);

  qScriptRegisterMetaType(engine, DayOfWeektoScriptValue, DayOfWeekfromScriptValue);
  widget.setProperty("Monday",                    QScriptValue(engine, Qt::Monday),                 ro);
  widget.setProperty("Tuesday",                   QScriptValue(engine, Qt::Tuesday),                ro);
  widget.setProperty("Wednesday",                 QScriptValue(engine, Qt::Wednesday),              ro);
  widget.setProperty("Thursday",                  QScriptValue(engine, Qt::Thursday),               ro);
  widget.setProperty("Friday",                    QScriptValue(engine, Qt::Friday),                 ro);
  widget.setProperty("Saturday",                  QScriptValue(engine, Qt::Saturday),               ro);
  widget.setProperty("Sunday",                    QScriptValue(engine, Qt::Sunday),                 ro);

  qScriptRegisterMetaType(engine, DockWidgetAreatoScriptValue, DockWidgetAreafromScriptValue);
  widget.setProperty("LeftDockWidgetArea",        QScriptValue(engine, Qt::LeftDockWidgetArea),     ro);
  widget.setProperty("RightDockWidgetArea",       QScriptValue(engine, Qt::RightDockWidgetArea),    ro);
  widget.setProperty("TopDockWidgetArea",         QScriptValue(engine, Qt::TopDockWidgetArea),      ro);
  widget.setProperty("BottomDockWidgetArea",      QScriptValue(engine, Qt::BottomDockWidgetArea),   ro);
  widget.setProperty("AllDockWidgetAreas",        QScriptValue(engine, Qt::AllDockWidgetAreas),     ro);
  widget.setProperty("NoDockWidgetArea",          QScriptValue(engine, Qt::NoDockWidgetArea),       ro);

  qScriptRegisterMetaType(engine, DropActiontoScriptValue, DropActionfromScriptValue);
  widget.setProperty("CopyAction",                QScriptValue(engine, Qt::CopyAction),             ro);
  widget.setProperty("MoveAction",                QScriptValue(engine, Qt::MoveAction),             ro);
  widget.setProperty("LinkAction",                QScriptValue(engine, Qt::LinkAction),             ro);
  widget.setProperty("ActionMask",                QScriptValue(engine, Qt::ActionMask),             ro);
  widget.setProperty("IgnoreAction",              QScriptValue(engine, Qt::IgnoreAction),           ro);
  widget.setProperty("TargetMoveAction",          QScriptValue(engine, Qt::TargetMoveAction),       ro);

  qScriptRegisterMetaType(engine, EventPrioritytoScriptValue, EventPriorityfromScriptValue);
  widget.setProperty("HighEventPriority",         QScriptValue(engine, Qt::HighEventPriority),      ro);
  widget.setProperty("NormalEventPriority",       QScriptValue(engine, Qt::NormalEventPriority),    ro);
  widget.setProperty("LowEventPriority",          QScriptValue(engine, Qt::LowEventPriority),       ro);

  qScriptRegisterMetaType(engine, FillRuletoScriptValue, FillRulefromScriptValue);
  widget.setProperty("OddEvenFill",               QScriptValue(engine, Qt::OddEvenFill),            ro);
  widget.setProperty("WindingFill",               QScriptValue(engine, Qt::WindingFill),            ro);

  widget.setProperty("TabFocus",                  QScriptValue(engine, Qt::TabFocus),               ro);
  widget.setProperty("ClickFocus",                QScriptValue(engine, Qt::ClickFocus),             ro);
  widget.setProperty("StrongFocus",               QScriptValue(engine, Qt::StrongFocus),            ro);
  widget.setProperty("WheelFocus",                QScriptValue(engine, Qt::WheelFocus),             ro);
  widget.setProperty("NoFocus",                   QScriptValue(engine, Qt::NoFocus),                ro);

  qScriptRegisterMetaType(engine,  FindChildOptionToScriptValue,  FindChildOptionFromScriptValue);
  qScriptRegisterMetaType(engine,  FindChildOptionsToScriptValue, FindChildOptionsFromScriptValue);
  widget.setProperty("FindDirectChildrenOnly",    QScriptValue(engine, Qt::FindDirectChildrenOnly), ro);
  widget.setProperty("FindChildrenRecursively",   QScriptValue(engine, Qt::FindChildrenRecursively),ro);

  qScriptRegisterMetaType(engine, FocusReasontoScriptValue, FocusReasonfromScriptValue);
  widget.setProperty("MouseFocusReason",          QScriptValue(engine, Qt::MouseFocusReason),       ro);
  widget.setProperty("TabFocusReason",            QScriptValue(engine, Qt::TabFocusReason),         ro);
  widget.setProperty("BacktabFocusReason",        QScriptValue(engine, Qt::BacktabFocusReason),     ro);
  widget.setProperty("ActiveWindowFocusReason",   QScriptValue(engine, Qt::ActiveWindowFocusReason),ro);
  widget.setProperty("PopupFocusReason",          QScriptValue(engine, Qt::PopupFocusReason),       ro);
  widget.setProperty("ShortcutFocusReason",       QScriptValue(engine, Qt::ShortcutFocusReason),    ro);
  widget.setProperty("MenuBarFocusReason",        QScriptValue(engine, Qt::MenuBarFocusReason),     ro);
  widget.setProperty("OtherFocusReason",          QScriptValue(engine, Qt::OtherFocusReason),       ro);

  qScriptRegisterMetaType(engine, GlobalColortoScriptValue, GlobalColorfromScriptValue);
  widget.setProperty("white",                     QScriptValue(engine, Qt::white),                  ro);
  widget.setProperty("black",                     QScriptValue(engine, Qt::black),                  ro);
  widget.setProperty("red",                       QScriptValue(engine, Qt::red),                    ro);
  widget.setProperty("darkRed",                   QScriptValue(engine, Qt::darkRed),                ro);
  widget.setProperty("green",                     QScriptValue(engine, Qt::green),                  ro);
  widget.setProperty("darkGreen",                 QScriptValue(engine, Qt::darkGreen),              ro);
  widget.setProperty("blue",                      QScriptValue(engine, Qt::blue),                   ro);
  widget.setProperty("darkBlue",                  QScriptValue(engine, Qt::darkBlue),               ro);
  widget.setProperty("cyan",                      QScriptValue(engine, Qt::cyan),                   ro);
  widget.setProperty("darkCyan",                  QScriptValue(engine, Qt::darkCyan),               ro);
  widget.setProperty("magenta",                   QScriptValue(engine, Qt::magenta),                ro);
  widget.setProperty("darkMagenta",               QScriptValue(engine, Qt::darkMagenta),            ro);
  widget.setProperty("yellow",                    QScriptValue(engine, Qt::yellow),                 ro);
  widget.setProperty("darkYellow",                QScriptValue(engine, Qt::darkYellow),             ro);
  widget.setProperty("gray",                      QScriptValue(engine, Qt::gray),                   ro);
  widget.setProperty("darkGray",                  QScriptValue(engine, Qt::darkGray),               ro);
  widget.setProperty("lightGray",                 QScriptValue(engine, Qt::lightGray),              ro);
  widget.setProperty("transparent",               QScriptValue(engine, Qt::transparent),            ro);
  widget.setProperty("color0",                    QScriptValue(engine, Qt::color0),                 ro);
  widget.setProperty("color1",                    QScriptValue(engine, Qt::color1),                 ro);

  qScriptRegisterMetaType(engine, HitTestAccuracytoScriptValue, HitTestAccuracyfromScriptValue);
  widget.setProperty("ExactHit",                  QScriptValue(engine, Qt::ExactHit),               ro);
  widget.setProperty("FuzzyHit",                  QScriptValue(engine, Qt::FuzzyHit),               ro);

  qScriptRegisterMetaType(engine, ImageConversionFlagtoScriptValue, ImageConversionFlagfromScriptValue);
  widget.setProperty("AutoColor",                 QScriptValue(engine, Qt::AutoColor),              ro);
  widget.setProperty("ColorOnly",                 QScriptValue(engine, Qt::ColorOnly),              ro);
  widget.setProperty("MonoOnly",                  QScriptValue(engine, Qt::MonoOnly),               ro);
  widget.setProperty("DiffuseDither",             QScriptValue(engine, Qt::DiffuseDither),          ro);
  widget.setProperty("OrderedDither",             QScriptValue(engine, Qt::OrderedDither),          ro);
  widget.setProperty("ThresholdDither",           QScriptValue(engine, Qt::ThresholdDither),        ro);
  widget.setProperty("ThresholdAlphaDither",      QScriptValue(engine, Qt::ThresholdAlphaDither),   ro);
  widget.setProperty("OrderedAlphaDither",        QScriptValue(engine, Qt::OrderedAlphaDither),     ro);
  widget.setProperty("DiffuseAlphaDither",        QScriptValue(engine, Qt::DiffuseAlphaDither),     ro);
  widget.setProperty("PreferDither",              QScriptValue(engine, Qt::PreferDither),           ro);
  widget.setProperty("AvoidDither",               QScriptValue(engine, Qt::AvoidDither),            ro);

  qScriptRegisterMetaType(engine, InputMethodQuerytoScriptValue, InputMethodQueryfromScriptValue);
  widget.setProperty("ImMicroFocus",              QScriptValue(engine, Qt::ImMicroFocus),           ro);
  widget.setProperty("ImFont",                    QScriptValue(engine, Qt::ImFont),                 ro);
  widget.setProperty("ImCursorPosition",          QScriptValue(engine, Qt::ImCursorPosition),       ro);
  widget.setProperty("ImSurroundingText",         QScriptValue(engine, Qt::ImSurroundingText),      ro);
  widget.setProperty("ImCurrentSelection",        QScriptValue(engine, Qt::ImCurrentSelection),     ro);

  qScriptRegisterMetaType(engine, ItemDataRoletoScriptValue, ItemDataRolefromScriptValue);
  widget.setProperty("DisplayRole",               QScriptValue(engine, Qt::DisplayRole),            ro);
  widget.setProperty("DecorationRole",            QScriptValue(engine, Qt::DecorationRole),         ro);
  widget.setProperty("EditRole",                  QScriptValue(engine, Qt::EditRole),               ro);
  widget.setProperty("ToolTipRole",               QScriptValue(engine, Qt::ToolTipRole),            ro);
  widget.setProperty("StatusTipRole",             QScriptValue(engine, Qt::StatusTipRole),          ro);
  widget.setProperty("WhatsThisRole",             QScriptValue(engine, Qt::WhatsThisRole),          ro);
  widget.setProperty("SizeHintRole",              QScriptValue(engine, Qt::SizeHintRole),           ro);
  widget.setProperty("FontRole",                  QScriptValue(engine, Qt::FontRole),               ro);
  widget.setProperty("TextAlignmentRole",         QScriptValue(engine, Qt::TextAlignmentRole),      ro);
  widget.setProperty("BackgroundRole",            QScriptValue(engine, Qt::BackgroundRole),         ro);
  widget.setProperty("BackgroundColorRole",       QScriptValue(engine, Qt::BackgroundColorRole),    ro);
  widget.setProperty("ForegroundRole",            QScriptValue(engine, Qt::ForegroundRole),         ro);
  widget.setProperty("TextColorRole",             QScriptValue(engine, Qt::TextColorRole),          ro);
  widget.setProperty("CheckStateRole",            QScriptValue(engine, Qt::CheckStateRole),         ro);
  widget.setProperty("AccessibleTextRole",        QScriptValue(engine, Qt::AccessibleTextRole),     ro);
  widget.setProperty("AccessibleDescriptionRole", QScriptValue(engine, Qt::AccessibleDescriptionRole), ro);
  widget.setProperty("UserRole",                  QScriptValue(engine, Qt::UserRole),               ro);

  qScriptRegisterMetaType(engine, ItemFlagtoScriptValue, ItemFlagfromScriptValue);
  widget.setProperty("NoItemFlags",               QScriptValue(engine, Qt::NoItemFlags),            ro);
  widget.setProperty("ItemIsSelectable",          QScriptValue(engine, Qt::ItemIsSelectable),       ro);
  widget.setProperty("ItemIsEditable",            QScriptValue(engine, Qt::ItemIsEditable),         ro);
  widget.setProperty("ItemIsDragEnabled",         QScriptValue(engine, Qt::ItemIsDragEnabled),      ro);
  widget.setProperty("ItemIsDropEnabled",         QScriptValue(engine, Qt::ItemIsDropEnabled),      ro);
  widget.setProperty("ItemIsUserCheckable",       QScriptValue(engine, Qt::ItemIsUserCheckable),    ro);
  widget.setProperty("ItemIsEnabled",             QScriptValue(engine, Qt::ItemIsEnabled),          ro);
  widget.setProperty("ItemIsTristate",            QScriptValue(engine, Qt::ItemIsTristate),         ro);

  qScriptRegisterMetaType(engine, ItemSelectionModetoScriptValue, ItemSelectionModefromScriptValue);
  widget.setProperty("ContainsItemShape",          QScriptValue(engine, Qt::ContainsItemShape),          ro);
  widget.setProperty("IntersectsItemShape",        QScriptValue(engine, Qt::IntersectsItemShape),        ro);
  widget.setProperty("ContainsItemBoundingRect",   QScriptValue(engine, Qt::ContainsItemBoundingRect),   ro);
  widget.setProperty("IntersectsItemBoundingRect", QScriptValue(engine, Qt::IntersectsItemBoundingRect), ro);

  qScriptRegisterMetaType(engine, KeytoScriptValue, KeyfromScriptValue);
  widget.setProperty("Key_Escape",                QScriptValue(engine, Qt::Key_Escape),             ro);
  widget.setProperty("Key_Tab",                   QScriptValue(engine, Qt::Key_Tab),                ro);
  widget.setProperty("Key_Backtab",               QScriptValue(engine, Qt::Key_Backtab),            ro);
  widget.setProperty("Key_Backspace",             QScriptValue(engine, Qt::Key_Backspace),          ro);
  widget.setProperty("Key_Return",                QScriptValue(engine, Qt::Key_Return),             ro);
  widget.setProperty("Key_Enter",                 QScriptValue(engine, Qt::Key_Enter),              ro);
  widget.setProperty("Key_Insert",                QScriptValue(engine, Qt::Key_Insert),             ro);
  widget.setProperty("Key_Delete",                QScriptValue(engine, Qt::Key_Delete),             ro);
  widget.setProperty("Key_Pause",                 QScriptValue(engine, Qt::Key_Pause),              ro);
  widget.setProperty("Key_Print",                 QScriptValue(engine, Qt::Key_Print),              ro);
  widget.setProperty("Key_SysReq",                QScriptValue(engine, Qt::Key_SysReq),             ro);
  widget.setProperty("Key_Clear",                 QScriptValue(engine, Qt::Key_Clear),              ro);
  widget.setProperty("Key_Home",                  QScriptValue(engine, Qt::Key_Home),               ro);
  widget.setProperty("Key_End",                   QScriptValue(engine, Qt::Key_End),                ro);
  widget.setProperty("Key_Left",                  QScriptValue(engine, Qt::Key_Left),               ro);
  widget.setProperty("Key_Up",                    QScriptValue(engine, Qt::Key_Up),                 ro);
  widget.setProperty("Key_Right",                 QScriptValue(engine, Qt::Key_Right),              ro);
  widget.setProperty("Key_Down",                  QScriptValue(engine, Qt::Key_Down),               ro);
  widget.setProperty("Key_PageUp",                QScriptValue(engine, Qt::Key_PageUp),             ro);
  widget.setProperty("Key_PageDown",              QScriptValue(engine, Qt::Key_PageDown),           ro);
  widget.setProperty("Key_Shift",                 QScriptValue(engine, Qt::Key_Shift),              ro);
  widget.setProperty("Key_Control",               QScriptValue(engine, Qt::Key_Control),            ro);
  widget.setProperty("Key_Meta",                  QScriptValue(engine, Qt::Key_Meta),               ro);
  widget.setProperty("Key_Alt",                   QScriptValue(engine, Qt::Key_Alt),                ro);
  widget.setProperty("Key_AltGr",                 QScriptValue(engine, Qt::Key_AltGr),              ro);
  widget.setProperty("Key_CapsLock",              QScriptValue(engine, Qt::Key_CapsLock),           ro);
  widget.setProperty("Key_NumLock",               QScriptValue(engine, Qt::Key_NumLock),            ro);
  widget.setProperty("Key_ScrollLock",            QScriptValue(engine, Qt::Key_ScrollLock),         ro);
  widget.setProperty("Key_F1",                    QScriptValue(engine, Qt::Key_F1),                 ro);
  widget.setProperty("Key_F2",                    QScriptValue(engine, Qt::Key_F2),                 ro);
  widget.setProperty("Key_F3",                    QScriptValue(engine, Qt::Key_F3),                 ro);
  widget.setProperty("Key_F4",                    QScriptValue(engine, Qt::Key_F4),                 ro);
  widget.setProperty("Key_F5",                    QScriptValue(engine, Qt::Key_F5),                 ro);
  widget.setProperty("Key_F6",                    QScriptValue(engine, Qt::Key_F6),                 ro);
  widget.setProperty("Key_F7",                    QScriptValue(engine, Qt::Key_F7),                 ro);
  widget.setProperty("Key_F8",                    QScriptValue(engine, Qt::Key_F8),                 ro);
  widget.setProperty("Key_F9",                    QScriptValue(engine, Qt::Key_F9),                 ro);
  widget.setProperty("Key_F10",                   QScriptValue(engine, Qt::Key_F10),                ro);
  widget.setProperty("Key_F11",                   QScriptValue(engine, Qt::Key_F11),                ro);
  widget.setProperty("Key_F12",                   QScriptValue(engine, Qt::Key_F12),                ro);
  widget.setProperty("Key_F13",                   QScriptValue(engine, Qt::Key_F13),                ro);
  widget.setProperty("Key_F14",                   QScriptValue(engine, Qt::Key_F14),                ro);
  widget.setProperty("Key_F15",                   QScriptValue(engine, Qt::Key_F15),                ro);
  widget.setProperty("Key_F16",                   QScriptValue(engine, Qt::Key_F16),                ro);
  widget.setProperty("Key_F17",                   QScriptValue(engine, Qt::Key_F17),                ro);
  widget.setProperty("Key_F18",                   QScriptValue(engine, Qt::Key_F18),                ro);
  widget.setProperty("Key_F19",                   QScriptValue(engine, Qt::Key_F19),                ro);
  widget.setProperty("Key_F20",                   QScriptValue(engine, Qt::Key_F20),                ro);
  widget.setProperty("Key_F21",                   QScriptValue(engine, Qt::Key_F21),                ro);
  widget.setProperty("Key_F22",                   QScriptValue(engine, Qt::Key_F22),                ro);
  widget.setProperty("Key_F23",                   QScriptValue(engine, Qt::Key_F23),                ro);
  widget.setProperty("Key_F24",                   QScriptValue(engine, Qt::Key_F24),                ro);
  widget.setProperty("Key_F25",                   QScriptValue(engine, Qt::Key_F25),                ro);
  widget.setProperty("Key_F26",                   QScriptValue(engine, Qt::Key_F26),                ro);
  widget.setProperty("Key_F27",                   QScriptValue(engine, Qt::Key_F27),                ro);
  widget.setProperty("Key_F28",                   QScriptValue(engine, Qt::Key_F28),                ro);
  widget.setProperty("Key_F29",                   QScriptValue(engine, Qt::Key_F29),                ro);
  widget.setProperty("Key_F30",                   QScriptValue(engine, Qt::Key_F30),                ro);
  widget.setProperty("Key_F31",                   QScriptValue(engine, Qt::Key_F31),                ro);
  widget.setProperty("Key_F32",                   QScriptValue(engine, Qt::Key_F32),                ro);
  widget.setProperty("Key_F33",                   QScriptValue(engine, Qt::Key_F33),                ro);
  widget.setProperty("Key_F34",                   QScriptValue(engine, Qt::Key_F34),                ro);
  widget.setProperty("Key_F35",                   QScriptValue(engine, Qt::Key_F35),                ro);
  widget.setProperty("Key_Super_L",               QScriptValue(engine, Qt::Key_Super_L),            ro);
  widget.setProperty("Key_Super_R",               QScriptValue(engine, Qt::Key_Super_R),            ro);
  widget.setProperty("Key_Menu",                  QScriptValue(engine, Qt::Key_Menu),               ro);
  widget.setProperty("Key_Hyper_L",               QScriptValue(engine, Qt::Key_Hyper_L),            ro);
  widget.setProperty("Key_Hyper_R",               QScriptValue(engine, Qt::Key_Hyper_R),            ro);
  widget.setProperty("Key_Help",                  QScriptValue(engine, Qt::Key_Help),               ro);
  widget.setProperty("Key_Direction_L",           QScriptValue(engine, Qt::Key_Direction_L),        ro);
  widget.setProperty("Key_Direction_R",           QScriptValue(engine, Qt::Key_Direction_R),        ro);
  widget.setProperty("Key_Space",                 QScriptValue(engine, Qt::Key_Space),              ro);
  widget.setProperty("Key_Any",                   QScriptValue(engine, Qt::Key_Any),                ro);
  widget.setProperty("Key_Exclam",                QScriptValue(engine, Qt::Key_Exclam),             ro);
  widget.setProperty("Key_QuoteDbl",              QScriptValue(engine, Qt::Key_QuoteDbl),           ro);
  widget.setProperty("Key_NumberSign",            QScriptValue(engine, Qt::Key_NumberSign),         ro);
  widget.setProperty("Key_Dollar",                QScriptValue(engine, Qt::Key_Dollar),             ro);
  widget.setProperty("Key_Percent",               QScriptValue(engine, Qt::Key_Percent),            ro);
  widget.setProperty("Key_Ampersand",             QScriptValue(engine, Qt::Key_Ampersand),          ro);
  widget.setProperty("Key_Apostrophe",            QScriptValue(engine, Qt::Key_Apostrophe),         ro);
  widget.setProperty("Key_ParenLeft",             QScriptValue(engine, Qt::Key_ParenLeft),          ro);
  widget.setProperty("Key_ParenRight",            QScriptValue(engine, Qt::Key_ParenRight),         ro);
  widget.setProperty("Key_Asterisk",              QScriptValue(engine, Qt::Key_Asterisk),           ro);
  widget.setProperty("Key_Plus",                  QScriptValue(engine, Qt::Key_Plus),               ro);
  widget.setProperty("Key_Comma",                 QScriptValue(engine, Qt::Key_Comma),              ro);
  widget.setProperty("Key_Minus",                 QScriptValue(engine, Qt::Key_Minus),              ro);
  widget.setProperty("Key_Period",                QScriptValue(engine, Qt::Key_Period),             ro);
  widget.setProperty("Key_Slash",                 QScriptValue(engine, Qt::Key_Slash),              ro);
  widget.setProperty("Key_0",                     QScriptValue(engine, Qt::Key_0),                  ro);
  widget.setProperty("Key_1",                     QScriptValue(engine, Qt::Key_1),                  ro);
  widget.setProperty("Key_2",                     QScriptValue(engine, Qt::Key_2),                  ro);
  widget.setProperty("Key_3",                     QScriptValue(engine, Qt::Key_3),                  ro);
  widget.setProperty("Key_4",                     QScriptValue(engine, Qt::Key_4),                  ro);
  widget.setProperty("Key_5",                     QScriptValue(engine, Qt::Key_5),                  ro);
  widget.setProperty("Key_6",                     QScriptValue(engine, Qt::Key_6),                  ro);
  widget.setProperty("Key_7",                     QScriptValue(engine, Qt::Key_7),                  ro);
  widget.setProperty("Key_8",                     QScriptValue(engine, Qt::Key_8),                  ro);
  widget.setProperty("Key_9",                     QScriptValue(engine, Qt::Key_9),                  ro);
  widget.setProperty("Key_Colon",                 QScriptValue(engine, Qt::Key_Colon),              ro);
  widget.setProperty("Key_Semicolon",             QScriptValue(engine, Qt::Key_Semicolon),          ro);
  widget.setProperty("Key_Less",                  QScriptValue(engine, Qt::Key_Less),               ro);
  widget.setProperty("Key_Equal",                 QScriptValue(engine, Qt::Key_Equal),              ro);
  widget.setProperty("Key_Greater",               QScriptValue(engine, Qt::Key_Greater),            ro);
  widget.setProperty("Key_Question",              QScriptValue(engine, Qt::Key_Question),           ro);
  widget.setProperty("Key_At",                    QScriptValue(engine, Qt::Key_At),                 ro);
  widget.setProperty("Key_A",                     QScriptValue(engine, Qt::Key_A),                  ro);
  widget.setProperty("Key_B",                     QScriptValue(engine, Qt::Key_B),                  ro);
  widget.setProperty("Key_C",                     QScriptValue(engine, Qt::Key_C),                  ro);
  widget.setProperty("Key_D",                     QScriptValue(engine, Qt::Key_D),                  ro);
  widget.setProperty("Key_E",                     QScriptValue(engine, Qt::Key_E),                  ro);
  widget.setProperty("Key_F",                     QScriptValue(engine, Qt::Key_F),                  ro);
  widget.setProperty("Key_G",                     QScriptValue(engine, Qt::Key_G),                  ro);
  widget.setProperty("Key_H",                     QScriptValue(engine, Qt::Key_H),                  ro);
  widget.setProperty("Key_I",                     QScriptValue(engine, Qt::Key_I),                  ro);
  widget.setProperty("Key_J",                     QScriptValue(engine, Qt::Key_J),                  ro);
  widget.setProperty("Key_K",                     QScriptValue(engine, Qt::Key_K),                  ro);
  widget.setProperty("Key_L",                     QScriptValue(engine, Qt::Key_L),                  ro);
  widget.setProperty("Key_M",                     QScriptValue(engine, Qt::Key_M),                  ro);
  widget.setProperty("Key_N",                     QScriptValue(engine, Qt::Key_N),                  ro);
  widget.setProperty("Key_O",                     QScriptValue(engine, Qt::Key_O),                  ro);
  widget.setProperty("Key_P",                     QScriptValue(engine, Qt::Key_P),                  ro);
  widget.setProperty("Key_Q",                     QScriptValue(engine, Qt::Key_Q),                  ro);
  widget.setProperty("Key_R",                     QScriptValue(engine, Qt::Key_R),                  ro);
  widget.setProperty("Key_S",                     QScriptValue(engine, Qt::Key_S),                  ro);
  widget.setProperty("Key_T",                     QScriptValue(engine, Qt::Key_T),                  ro);
  widget.setProperty("Key_U",                     QScriptValue(engine, Qt::Key_U),                  ro);
  widget.setProperty("Key_V",                     QScriptValue(engine, Qt::Key_V),                  ro);
  widget.setProperty("Key_W",                     QScriptValue(engine, Qt::Key_W),                  ro);
  widget.setProperty("Key_X",                     QScriptValue(engine, Qt::Key_X),                  ro);
  widget.setProperty("Key_Y",                     QScriptValue(engine, Qt::Key_Y),                  ro);
  widget.setProperty("Key_Z",                     QScriptValue(engine, Qt::Key_Z),                  ro);
  widget.setProperty("Key_BracketLeft",           QScriptValue(engine, Qt::Key_BracketLeft),        ro);
  widget.setProperty("Key_Backslash",             QScriptValue(engine, Qt::Key_Backslash),          ro);
  widget.setProperty("Key_BracketRight",          QScriptValue(engine, Qt::Key_BracketRight),       ro);
  widget.setProperty("Key_AsciiCircum",           QScriptValue(engine, Qt::Key_AsciiCircum),        ro);
  widget.setProperty("Key_Underscore",            QScriptValue(engine, Qt::Key_Underscore),         ro);
  widget.setProperty("Key_QuoteLeft",             QScriptValue(engine, Qt::Key_QuoteLeft),          ro);
  widget.setProperty("Key_BraceLeft",             QScriptValue(engine, Qt::Key_BraceLeft),          ro);
  widget.setProperty("Key_Bar",                   QScriptValue(engine, Qt::Key_Bar),                ro);
  widget.setProperty("Key_BraceRight",            QScriptValue(engine, Qt::Key_BraceRight),         ro);
  widget.setProperty("Key_AsciiTilde",            QScriptValue(engine, Qt::Key_AsciiTilde),         ro);
  widget.setProperty("Key_nobreakspace",          QScriptValue(engine, Qt::Key_nobreakspace),       ro);
  widget.setProperty("Key_exclamdown",            QScriptValue(engine, Qt::Key_exclamdown),         ro);
  widget.setProperty("Key_cent",                  QScriptValue(engine, Qt::Key_cent),               ro);
  widget.setProperty("Key_sterling",              QScriptValue(engine, Qt::Key_sterling),           ro);
  widget.setProperty("Key_currency",              QScriptValue(engine, Qt::Key_currency),           ro);
  widget.setProperty("Key_yen",                   QScriptValue(engine, Qt::Key_yen),                ro);
  widget.setProperty("Key_brokenbar",             QScriptValue(engine, Qt::Key_brokenbar),          ro);
  widget.setProperty("Key_section",               QScriptValue(engine, Qt::Key_section),            ro);
  widget.setProperty("Key_diaeresis",             QScriptValue(engine, Qt::Key_diaeresis),          ro);
  widget.setProperty("Key_copyright",             QScriptValue(engine, Qt::Key_copyright),          ro);
  widget.setProperty("Key_ordfeminine",           QScriptValue(engine, Qt::Key_ordfeminine),        ro);
  widget.setProperty("Key_guillemotleft",         QScriptValue(engine, Qt::Key_guillemotleft),      ro);
  widget.setProperty("Key_notsign",               QScriptValue(engine, Qt::Key_notsign),            ro);
  widget.setProperty("Key_hyphen",                QScriptValue(engine, Qt::Key_hyphen),             ro);
  widget.setProperty("Key_registered",            QScriptValue(engine, Qt::Key_registered),         ro);
  widget.setProperty("Key_macron",                QScriptValue(engine, Qt::Key_macron),             ro);
  widget.setProperty("Key_degree",                QScriptValue(engine, Qt::Key_degree),             ro);
  widget.setProperty("Key_plusminus",             QScriptValue(engine, Qt::Key_plusminus),          ro);
  widget.setProperty("Key_twosuperior",           QScriptValue(engine, Qt::Key_twosuperior),        ro);
  widget.setProperty("Key_threesuperior",         QScriptValue(engine, Qt::Key_threesuperior),      ro);
  widget.setProperty("Key_acute",                 QScriptValue(engine, Qt::Key_acute),              ro);
  widget.setProperty("Key_mu",                    QScriptValue(engine, Qt::Key_mu),                 ro);
  widget.setProperty("Key_paragraph",             QScriptValue(engine, Qt::Key_paragraph),          ro);
  widget.setProperty("Key_periodcentered",        QScriptValue(engine, Qt::Key_periodcentered),     ro);
  widget.setProperty("Key_cedilla",               QScriptValue(engine, Qt::Key_cedilla),            ro);
  widget.setProperty("Key_onesuperior",           QScriptValue(engine, Qt::Key_onesuperior),        ro);
  widget.setProperty("Key_masculine",             QScriptValue(engine, Qt::Key_masculine),          ro);
  widget.setProperty("Key_guillemotright",        QScriptValue(engine, Qt::Key_guillemotright),     ro);
  widget.setProperty("Key_onequarter",            QScriptValue(engine, Qt::Key_onequarter),         ro);
  widget.setProperty("Key_onehalf",               QScriptValue(engine, Qt::Key_onehalf),            ro);
  widget.setProperty("Key_threequarters",         QScriptValue(engine, Qt::Key_threequarters),      ro);
  widget.setProperty("Key_questiondown",          QScriptValue(engine, Qt::Key_questiondown),       ro);
  widget.setProperty("Key_Agrave",                QScriptValue(engine, Qt::Key_Agrave),             ro);
  widget.setProperty("Key_Aacute",                QScriptValue(engine, Qt::Key_Aacute),             ro);
  widget.setProperty("Key_Acircumflex",           QScriptValue(engine, Qt::Key_Acircumflex),        ro);
  widget.setProperty("Key_Atilde",                QScriptValue(engine, Qt::Key_Atilde),             ro);
  widget.setProperty("Key_Adiaeresis",            QScriptValue(engine, Qt::Key_Adiaeresis),         ro);
  widget.setProperty("Key_Aring",                 QScriptValue(engine, Qt::Key_Aring),              ro);
  widget.setProperty("Key_AE",                    QScriptValue(engine, Qt::Key_AE),                 ro);
  widget.setProperty("Key_Ccedilla",              QScriptValue(engine, Qt::Key_Ccedilla),           ro);
  widget.setProperty("Key_Egrave",                QScriptValue(engine, Qt::Key_Egrave),             ro);
  widget.setProperty("Key_Eacute",                QScriptValue(engine, Qt::Key_Eacute),             ro);
  widget.setProperty("Key_Ecircumflex",           QScriptValue(engine, Qt::Key_Ecircumflex),        ro);
  widget.setProperty("Key_Ediaeresis",            QScriptValue(engine, Qt::Key_Ediaeresis),         ro);
  widget.setProperty("Key_Igrave",                QScriptValue(engine, Qt::Key_Igrave),             ro);
  widget.setProperty("Key_Iacute",                QScriptValue(engine, Qt::Key_Iacute),             ro);
  widget.setProperty("Key_Icircumflex",           QScriptValue(engine, Qt::Key_Icircumflex),        ro);
  widget.setProperty("Key_Idiaeresis",            QScriptValue(engine, Qt::Key_Idiaeresis),         ro);
  widget.setProperty("Key_ETH",                   QScriptValue(engine, Qt::Key_ETH),                ro);
  widget.setProperty("Key_Ntilde",                QScriptValue(engine, Qt::Key_Ntilde),             ro);
  widget.setProperty("Key_Ograve",                QScriptValue(engine, Qt::Key_Ograve),             ro);
  widget.setProperty("Key_Oacute",                QScriptValue(engine, Qt::Key_Oacute),             ro);
  widget.setProperty("Key_Ocircumflex",           QScriptValue(engine, Qt::Key_Ocircumflex),        ro);
  widget.setProperty("Key_Otilde",                QScriptValue(engine, Qt::Key_Otilde),             ro);
  widget.setProperty("Key_Odiaeresis",            QScriptValue(engine, Qt::Key_Odiaeresis),         ro);
  widget.setProperty("Key_multiply",              QScriptValue(engine, Qt::Key_multiply),           ro);
  widget.setProperty("Key_Ooblique",              QScriptValue(engine, Qt::Key_Ooblique),           ro);
  widget.setProperty("Key_Ugrave",                QScriptValue(engine, Qt::Key_Ugrave),             ro);
  widget.setProperty("Key_Uacute",                QScriptValue(engine, Qt::Key_Uacute),             ro);
  widget.setProperty("Key_Ucircumflex",           QScriptValue(engine, Qt::Key_Ucircumflex),        ro);
  widget.setProperty("Key_Udiaeresis",            QScriptValue(engine, Qt::Key_Udiaeresis),         ro);
  widget.setProperty("Key_Yacute",                QScriptValue(engine, Qt::Key_Yacute),             ro);
  widget.setProperty("Key_THORN",                 QScriptValue(engine, Qt::Key_THORN),              ro);
  widget.setProperty("Key_ssharp",                QScriptValue(engine, Qt::Key_ssharp),             ro);
  widget.setProperty("Key_division",              QScriptValue(engine, Qt::Key_division),           ro);
  widget.setProperty("Key_ydiaeresis",            QScriptValue(engine, Qt::Key_ydiaeresis),         ro);
  widget.setProperty("Key_Multi_key",             QScriptValue(engine, Qt::Key_Multi_key),          ro);
  widget.setProperty("Key_Codeinput",             QScriptValue(engine, Qt::Key_Codeinput),          ro);
  widget.setProperty("Key_SingleCandidate",       QScriptValue(engine, Qt::Key_SingleCandidate),    ro);
  widget.setProperty("Key_MultipleCandidate",     QScriptValue(engine, Qt::Key_MultipleCandidate),  ro);
  widget.setProperty("Key_PreviousCandidate",     QScriptValue(engine, Qt::Key_PreviousCandidate),  ro);
  widget.setProperty("Key_Mode_switch",           QScriptValue(engine, Qt::Key_Mode_switch),        ro);
  widget.setProperty("Key_Kanji",                 QScriptValue(engine, Qt::Key_Kanji),              ro);
  widget.setProperty("Key_Muhenkan",              QScriptValue(engine, Qt::Key_Muhenkan),           ro);
  widget.setProperty("Key_Henkan",                QScriptValue(engine, Qt::Key_Henkan),             ro);
  widget.setProperty("Key_Romaji",                QScriptValue(engine, Qt::Key_Romaji),             ro);
  widget.setProperty("Key_Hiragana",              QScriptValue(engine, Qt::Key_Hiragana),           ro);
  widget.setProperty("Key_Katakana",              QScriptValue(engine, Qt::Key_Katakana),           ro);
  widget.setProperty("Key_Hiragana_Katakana",     QScriptValue(engine, Qt::Key_Hiragana_Katakana),  ro);
  widget.setProperty("Key_Zenkaku",               QScriptValue(engine, Qt::Key_Zenkaku),            ro);
  widget.setProperty("Key_Hankaku",               QScriptValue(engine, Qt::Key_Hankaku),            ro);
  widget.setProperty("Key_Zenkaku_Hankaku",       QScriptValue(engine, Qt::Key_Zenkaku_Hankaku),    ro);
  widget.setProperty("Key_Touroku",               QScriptValue(engine, Qt::Key_Touroku),            ro);
  widget.setProperty("Key_Massyo",                QScriptValue(engine, Qt::Key_Massyo),             ro);
  widget.setProperty("Key_Kana_Lock",             QScriptValue(engine, Qt::Key_Kana_Lock),          ro);
  widget.setProperty("Key_Kana_Shift",            QScriptValue(engine, Qt::Key_Kana_Shift),         ro);
  widget.setProperty("Key_Eisu_Shift",            QScriptValue(engine, Qt::Key_Eisu_Shift),         ro);
  widget.setProperty("Key_Eisu_toggle",           QScriptValue(engine, Qt::Key_Eisu_toggle),        ro);
  widget.setProperty("Key_Hangul",                QScriptValue(engine, Qt::Key_Hangul),             ro);
  widget.setProperty("Key_Hangul_Start",          QScriptValue(engine, Qt::Key_Hangul_Start),       ro);
  widget.setProperty("Key_Hangul_End",            QScriptValue(engine, Qt::Key_Hangul_End),         ro);
  widget.setProperty("Key_Hangul_Hanja",          QScriptValue(engine, Qt::Key_Hangul_Hanja),       ro);
  widget.setProperty("Key_Hangul_Jamo",           QScriptValue(engine, Qt::Key_Hangul_Jamo),        ro);
  widget.setProperty("Key_Hangul_Romaja",         QScriptValue(engine, Qt::Key_Hangul_Romaja),      ro);
  widget.setProperty("Key_Hangul_Jeonja",         QScriptValue(engine, Qt::Key_Hangul_Jeonja),      ro);
  widget.setProperty("Key_Hangul_Banja",          QScriptValue(engine, Qt::Key_Hangul_Banja),       ro);
  widget.setProperty("Key_Hangul_PreHanja",       QScriptValue(engine, Qt::Key_Hangul_PreHanja),    ro);
  widget.setProperty("Key_Hangul_PostHanja",      QScriptValue(engine, Qt::Key_Hangul_PostHanja),   ro);
  widget.setProperty("Key_Hangul_Special",        QScriptValue(engine, Qt::Key_Hangul_Special),     ro);
  widget.setProperty("Key_Dead_Grave",            QScriptValue(engine, Qt::Key_Dead_Grave),         ro);
  widget.setProperty("Key_Dead_Acute",            QScriptValue(engine, Qt::Key_Dead_Acute),         ro);
  widget.setProperty("Key_Dead_Circumflex",       QScriptValue(engine, Qt::Key_Dead_Circumflex),    ro);
  widget.setProperty("Key_Dead_Tilde",            QScriptValue(engine, Qt::Key_Dead_Tilde),         ro);
  widget.setProperty("Key_Dead_Macron",           QScriptValue(engine, Qt::Key_Dead_Macron),        ro);
  widget.setProperty("Key_Dead_Breve",            QScriptValue(engine, Qt::Key_Dead_Breve),         ro);
  widget.setProperty("Key_Dead_Abovedot",         QScriptValue(engine, Qt::Key_Dead_Abovedot),      ro);
  widget.setProperty("Key_Dead_Diaeresis",        QScriptValue(engine, Qt::Key_Dead_Diaeresis),     ro);
  widget.setProperty("Key_Dead_Abovering",        QScriptValue(engine, Qt::Key_Dead_Abovering),     ro);
  widget.setProperty("Key_Dead_Doubleacute",      QScriptValue(engine, Qt::Key_Dead_Doubleacute),   ro);
  widget.setProperty("Key_Dead_Caron",            QScriptValue(engine, Qt::Key_Dead_Caron),         ro);
  widget.setProperty("Key_Dead_Cedilla",          QScriptValue(engine, Qt::Key_Dead_Cedilla),       ro);
  widget.setProperty("Key_Dead_Ogonek",           QScriptValue(engine, Qt::Key_Dead_Ogonek),        ro);
  widget.setProperty("Key_Dead_Iota",             QScriptValue(engine, Qt::Key_Dead_Iota),          ro);
  widget.setProperty("Key_Dead_Voiced_Sound",     QScriptValue(engine, Qt::Key_Dead_Voiced_Sound),  ro);
  widget.setProperty("Key_Dead_Semivoiced_Sound", QScriptValue(engine, Qt::Key_Dead_Semivoiced_Sound),                                                ro);
  widget.setProperty("Key_Dead_Belowdot",         QScriptValue(engine, Qt::Key_Dead_Belowdot),      ro);
  widget.setProperty("Key_Dead_Hook",             QScriptValue(engine, Qt::Key_Dead_Hook),          ro);
  widget.setProperty("Key_Dead_Horn",             QScriptValue(engine, Qt::Key_Dead_Horn),          ro);
  widget.setProperty("Key_Back",                  QScriptValue(engine, Qt::Key_Back),               ro);
  widget.setProperty("Key_Forward",               QScriptValue(engine, Qt::Key_Forward),            ro);
  widget.setProperty("Key_Stop",                  QScriptValue(engine, Qt::Key_Stop),               ro);
  widget.setProperty("Key_Refresh",               QScriptValue(engine, Qt::Key_Refresh),            ro);
  widget.setProperty("Key_VolumeDown",            QScriptValue(engine, Qt::Key_VolumeDown),         ro);
  widget.setProperty("Key_VolumeMute",            QScriptValue(engine, Qt::Key_VolumeMute),         ro);
  widget.setProperty("Key_VolumeUp",              QScriptValue(engine, Qt::Key_VolumeUp),           ro);
  widget.setProperty("Key_BassBoost",             QScriptValue(engine, Qt::Key_BassBoost),          ro);
  widget.setProperty("Key_BassUp",                QScriptValue(engine, Qt::Key_BassUp),             ro);
  widget.setProperty("Key_BassDown",              QScriptValue(engine, Qt::Key_BassDown),           ro);
  widget.setProperty("Key_TrebleUp",              QScriptValue(engine, Qt::Key_TrebleUp),           ro);
  widget.setProperty("Key_TrebleDown",            QScriptValue(engine, Qt::Key_TrebleDown),         ro);
  widget.setProperty("Key_MediaPlay",             QScriptValue(engine, Qt::Key_MediaPlay),          ro);
  widget.setProperty("Key_MediaStop",             QScriptValue(engine, Qt::Key_MediaStop),          ro);
  widget.setProperty("Key_MediaPrevious",         QScriptValue(engine, Qt::Key_MediaPrevious),      ro);
  widget.setProperty("Key_MediaNext",             QScriptValue(engine, Qt::Key_MediaNext),          ro);
  widget.setProperty("Key_MediaRecord",           QScriptValue(engine, Qt::Key_MediaRecord),        ro);
  widget.setProperty("Key_HomePage",              QScriptValue(engine, Qt::Key_HomePage),           ro);
  widget.setProperty("Key_Favorites",             QScriptValue(engine, Qt::Key_Favorites),          ro);
  widget.setProperty("Key_Search",                QScriptValue(engine, Qt::Key_Search),             ro);
  widget.setProperty("Key_Standby",               QScriptValue(engine, Qt::Key_Standby),            ro);
  widget.setProperty("Key_OpenUrl",               QScriptValue(engine, Qt::Key_OpenUrl),            ro);
  widget.setProperty("Key_LaunchMail",            QScriptValue(engine, Qt::Key_LaunchMail),         ro);
  widget.setProperty("Key_LaunchMedia",           QScriptValue(engine, Qt::Key_LaunchMedia),        ro);
  widget.setProperty("Key_Launch0",               QScriptValue(engine, Qt::Key_Launch0),            ro);
  widget.setProperty("Key_Launch1",               QScriptValue(engine, Qt::Key_Launch1),            ro);
  widget.setProperty("Key_Launch2",               QScriptValue(engine, Qt::Key_Launch2),            ro);
  widget.setProperty("Key_Launch3",               QScriptValue(engine, Qt::Key_Launch3),            ro);
  widget.setProperty("Key_Launch4",               QScriptValue(engine, Qt::Key_Launch4),            ro);
  widget.setProperty("Key_Launch5",               QScriptValue(engine, Qt::Key_Launch5),            ro);
  widget.setProperty("Key_Launch6",               QScriptValue(engine, Qt::Key_Launch6),            ro);
  widget.setProperty("Key_Launch7",               QScriptValue(engine, Qt::Key_Launch7),            ro);
  widget.setProperty("Key_Launch8",               QScriptValue(engine, Qt::Key_Launch8),            ro);
  widget.setProperty("Key_Launch9",               QScriptValue(engine, Qt::Key_Launch9),            ro);
  widget.setProperty("Key_LaunchA",               QScriptValue(engine, Qt::Key_LaunchA),            ro);
  widget.setProperty("Key_LaunchB",               QScriptValue(engine, Qt::Key_LaunchB),            ro);
  widget.setProperty("Key_LaunchC",               QScriptValue(engine, Qt::Key_LaunchC),            ro);
  widget.setProperty("Key_LaunchD",               QScriptValue(engine, Qt::Key_LaunchD),            ro);
  widget.setProperty("Key_LaunchE",               QScriptValue(engine, Qt::Key_LaunchE),            ro);
  widget.setProperty("Key_LaunchF",               QScriptValue(engine, Qt::Key_LaunchF),            ro);
  widget.setProperty("Key_MediaLast",             QScriptValue(engine, Qt::Key_MediaLast),          ro);
  widget.setProperty("Key_unknown",               QScriptValue(engine, Qt::Key_unknown),            ro);
  widget.setProperty("Key_Call",                  QScriptValue(engine, Qt::Key_Call),               ro);
  widget.setProperty("Key_Context1",              QScriptValue(engine, Qt::Key_Context1),           ro);
  widget.setProperty("Key_Context2",              QScriptValue(engine, Qt::Key_Context2),           ro);
  widget.setProperty("Key_Context3",              QScriptValue(engine, Qt::Key_Context3),           ro);
  widget.setProperty("Key_Context4",              QScriptValue(engine, Qt::Key_Context4),           ro);
  widget.setProperty("Key_Flip",                  QScriptValue(engine, Qt::Key_Flip),               ro);
  widget.setProperty("Key_Hangup",                QScriptValue(engine, Qt::Key_Hangup),             ro);
  widget.setProperty("Key_No",                    QScriptValue(engine, Qt::Key_No),                 ro);
  widget.setProperty("Key_Select",                QScriptValue(engine, Qt::Key_Select),             ro);
  widget.setProperty("Key_Yes",                   QScriptValue(engine, Qt::Key_Yes),                ro);
  widget.setProperty("Key_Execute",               QScriptValue(engine, Qt::Key_Execute),            ro);
  widget.setProperty("Key_Printer",               QScriptValue(engine, Qt::Key_Printer),            ro);
  widget.setProperty("Key_Play",                  QScriptValue(engine, Qt::Key_Play),               ro);
  widget.setProperty("Key_Sleep",                 QScriptValue(engine, Qt::Key_Sleep),              ro);
  widget.setProperty("Key_Zoom",                  QScriptValue(engine, Qt::Key_Zoom),               ro);
  widget.setProperty("Key_Cancel",                QScriptValue(engine, Qt::Key_Cancel),             ro);

  qScriptRegisterMetaType(engine, KeyboardModifiertoScriptValue, KeyboardModifierfromScriptValue);
  widget.setProperty("NoModifier",                QScriptValue(engine, Qt::NoModifier),             ro);
  widget.setProperty("ShiftModifier",             QScriptValue(engine, Qt::ShiftModifier),          ro);
  widget.setProperty("ControlModifier",           QScriptValue(engine, Qt::ControlModifier),        ro);
  widget.setProperty("AltModifier",               QScriptValue(engine, Qt::AltModifier),            ro);
  widget.setProperty("MetaModifier",              QScriptValue(engine, Qt::MetaModifier),           ro);
  widget.setProperty("KeypadModifier",            QScriptValue(engine, Qt::KeypadModifier),         ro);
  widget.setProperty("GroupSwitchModifier",       QScriptValue(engine, Qt::GroupSwitchModifier),    ro);

  qScriptRegisterMetaType(engine, LayoutDirectiontoScriptValue, LayoutDirectionfromScriptValue);
  widget.setProperty("LeftToRight",               QScriptValue(engine, Qt::LeftToRight),            ro);
  widget.setProperty("RightToLeft",               QScriptValue(engine, Qt::RightToLeft),            ro);

  qScriptRegisterMetaType(engine, MaskModetoScriptValue, MaskModefromScriptValue);
  widget.setProperty("MaskInColor",               QScriptValue(engine, Qt::MaskInColor),            ro);
  widget.setProperty("MaskOutColor",              QScriptValue(engine, Qt::MaskOutColor),           ro);

  qScriptRegisterMetaType(engine, MatchFlagtoScriptValue,  MatchFlagfromScriptValue);
  qScriptRegisterMetaType(engine, MatchFlagstoScriptValue, MatchFlagsfromScriptValue);
  widget.setProperty("MatchExactly",              QScriptValue(engine, Qt::MatchExactly),           ro);
  widget.setProperty("MatchFixedString",          QScriptValue(engine, Qt::MatchFixedString),       ro);
  widget.setProperty("MatchContains",             QScriptValue(engine, Qt::MatchContains),          ro);
  widget.setProperty("MatchStartsWith",           QScriptValue(engine, Qt::MatchStartsWith),        ro);
  widget.setProperty("MatchEndsWith",             QScriptValue(engine, Qt::MatchEndsWith),          ro);
  widget.setProperty("MatchCaseSensitive",        QScriptValue(engine, Qt::MatchCaseSensitive),     ro);
  widget.setProperty("MatchRegExp",               QScriptValue(engine, Qt::MatchRegExp),            ro);
  widget.setProperty("MatchWildcard",             QScriptValue(engine, Qt::MatchWildcard),          ro);
  widget.setProperty("MatchWrap",                 QScriptValue(engine, Qt::MatchWrap),              ro);
  widget.setProperty("MatchRecursive",            QScriptValue(engine, Qt::MatchRecursive),         ro);

  qScriptRegisterMetaType(engine, ModifiertoScriptValue, ModifierfromScriptValue);
  widget.setProperty("SHIFT",                     QScriptValue(engine, Qt::SHIFT),                  ro);
  widget.setProperty("META",                      QScriptValue(engine, Qt::META),                   ro);
  widget.setProperty("CTRL",                      QScriptValue(engine, Qt::CTRL),                   ro);
  widget.setProperty("ALT",                       QScriptValue(engine, Qt::ALT),                    ro);
  widget.setProperty("UNICODE_ACCEL",             QScriptValue(engine, Qt::UNICODE_ACCEL),          ro);

  qScriptRegisterMetaType(engine, MouseButtontoScriptValue, MouseButtonfromScriptValue);
  widget.setProperty("NoButton",                  QScriptValue(engine, Qt::NoButton),               ro);
  widget.setProperty("LeftButton",                QScriptValue(engine, Qt::LeftButton),             ro);
  widget.setProperty("RightButton",               QScriptValue(engine, Qt::RightButton),            ro);
  widget.setProperty("MidButton",                 QScriptValue(engine, Qt::MidButton),              ro);
  widget.setProperty("XButton1",                  QScriptValue(engine, Qt::XButton1),               ro);
  widget.setProperty("XButton2",                  QScriptValue(engine, Qt::XButton2),               ro);

/* this line causes problems with the embedded designer.
   the conversion appears to work correctly without it.
  qScriptRegisterMetaType(engine, OrientationtoScriptValue,	OrientationfromScriptValue);
*/
  widget.setProperty("Horizontal",                QScriptValue(engine, Qt::Horizontal),             ro);
  widget.setProperty("Vertical",                  QScriptValue(engine, Qt::Vertical),               ro);

  qScriptRegisterMetaType(engine, PenCapStyletoScriptValue, PenCapStylefromScriptValue);
  widget.setProperty("SquareCap",                 QScriptValue(engine, Qt::SquareCap),              ro);
  widget.setProperty("FlatCap",                   QScriptValue(engine, Qt::FlatCap),                ro);
  widget.setProperty("SquareCap",                 QScriptValue(engine, Qt::SquareCap),              ro);
  widget.setProperty("RoundCap",                  QScriptValue(engine, Qt::RoundCap),               ro);

  qScriptRegisterMetaType(engine, PenJoinStyletoScriptValue, PenJoinStylefromScriptValue);
  widget.setProperty("BevelJoin",                 QScriptValue(engine, Qt::BevelJoin),              ro);
  widget.setProperty("MiterJoin",                 QScriptValue(engine, Qt::MiterJoin),              ro);
  widget.setProperty("BevelJoin",                 QScriptValue(engine, Qt::BevelJoin),              ro);
  widget.setProperty("RoundJoin",                 QScriptValue(engine, Qt::RoundJoin),              ro);
  widget.setProperty("SvgMiterJoin",              QScriptValue(engine, Qt::SvgMiterJoin),           ro);

  qScriptRegisterMetaType(engine, PenStyletoScriptValue, PenStylefromScriptValue);
  widget.setProperty("SolidLine",                 QScriptValue(engine, Qt::SolidLine),              ro);
  widget.setProperty("DashDotLine",               QScriptValue(engine, Qt::DashDotLine),            ro);
  widget.setProperty("NoPen",                     QScriptValue(engine, Qt::NoPen),                  ro);
  widget.setProperty("SolidLine",                 QScriptValue(engine, Qt::SolidLine),              ro);
  widget.setProperty("DashLine",                  QScriptValue(engine, Qt::DashLine),               ro);
  widget.setProperty("DotLine",                   QScriptValue(engine, Qt::DotLine),                ro);
  widget.setProperty("DashDotLine",               QScriptValue(engine, Qt::DashDotLine),            ro);
  widget.setProperty("DashDotDotLine",            QScriptValue(engine, Qt::DashDotDotLine),         ro);
  widget.setProperty("CustomDashLine",            QScriptValue(engine, Qt::CustomDashLine),         ro);

  qScriptRegisterMetaType(engine, ScrollBarPolicytoScriptValue, ScrollBarPolicyfromScriptValue);
  widget.setProperty("ScrollBarAsNeeded",         QScriptValue(engine, Qt::ScrollBarAsNeeded),      ro);
  widget.setProperty("ScrollBarAlwaysOff",        QScriptValue(engine, Qt::ScrollBarAlwaysOff),     ro);
  widget.setProperty("ScrollBarAlwaysOn",         QScriptValue(engine, Qt::ScrollBarAlwaysOn),      ro);

  qScriptRegisterMetaType(engine, ShortcutContexttoScriptValue, ShortcutContextfromScriptValue);
  widget.setProperty("WidgetShortcut",             QScriptValue(engine, Qt::WidgetShortcut),          ro);
  widget.setProperty("WidgetWithChildrenShortcut", QScriptValue(engine, Qt::WidgetWithChildrenShortcut),                                                 ro);
  widget.setProperty("WindowShortcut",             QScriptValue(engine, Qt::WindowShortcut),          ro);
  widget.setProperty("ApplicationShortcut",        QScriptValue(engine, Qt::ApplicationShortcut),     ro);

  qScriptRegisterMetaType(engine, SizeHinttoScriptValue, SizeHintfromScriptValue);
  widget.setProperty("MinimumSize",                QScriptValue(engine, Qt::MinimumSize),             ro);
  widget.setProperty("PreferredSize",              QScriptValue(engine, Qt::PreferredSize),           ro);
  widget.setProperty("MaximumSize",                QScriptValue(engine, Qt::MaximumSize),             ro);
  widget.setProperty("MinimumDescent",             QScriptValue(engine, Qt::MinimumDescent),          ro);

  qScriptRegisterMetaType(engine, SizeModetoScriptValue, SizeModefromScriptValue);
  widget.setProperty("AbsoluteSize",               QScriptValue(engine, Qt::AbsoluteSize),            ro);
  widget.setProperty("RelativeSize",               QScriptValue(engine, Qt::RelativeSize),            ro);

  qScriptRegisterMetaType(engine, SortOrdertoScriptValue, SortOrderfromScriptValue);
  widget.setProperty("AscendingOrder",             QScriptValue(engine, Qt::AscendingOrder),          ro);
  widget.setProperty("DescendingOrder",            QScriptValue(engine, Qt::DescendingOrder),         ro);

  qScriptRegisterMetaType(engine, TextElideModetoScriptValue, TextElideModefromScriptValue);
  widget.setProperty("ElideLeft",                  QScriptValue(engine, Qt::ElideLeft),               ro);
  widget.setProperty("ElideRight",                 QScriptValue(engine, Qt::ElideRight),              ro);
  widget.setProperty("ElideMiddle",                QScriptValue(engine, Qt::ElideMiddle),             ro);
  widget.setProperty("ElideNone",                  QScriptValue(engine, Qt::ElideNone),               ro);
  widget.setProperty("ElideMiddle",                QScriptValue(engine, Qt::ElideMiddle),             ro);

  qScriptRegisterMetaType(engine, TextFlagtoScriptValue, TextFlagfromScriptValue);
  widget.setProperty("TextSingleLine",             QScriptValue(engine, Qt::TextSingleLine),          ro);
  widget.setProperty("TextDontClip",               QScriptValue(engine, Qt::TextDontClip),            ro);
  widget.setProperty("TextExpandTabs",             QScriptValue(engine, Qt::TextExpandTabs),          ro);
  widget.setProperty("TextShowMnemonic",           QScriptValue(engine, Qt::TextShowMnemonic),        ro);
  widget.setProperty("TextWordWrap",               QScriptValue(engine, Qt::TextWordWrap),            ro);
  widget.setProperty("TextWrapAnywhere",           QScriptValue(engine, Qt::TextWrapAnywhere),        ro);
  widget.setProperty("TextHideMnemonic",           QScriptValue(engine, Qt::TextHideMnemonic),        ro);
  widget.setProperty("TextDontPrint",              QScriptValue(engine, Qt::TextDontPrint),           ro);
  widget.setProperty("TextIncludeTrailingSpaces",  QScriptValue(engine, Qt::TextIncludeTrailingSpaces),                                                  ro);
  widget.setProperty("TextJustificationForced",    QScriptValue(engine, Qt::TextJustificationForced), ro);

  qScriptRegisterMetaType(engine, TextFormattoScriptValue, TextFormatfromScriptValue);
  widget.setProperty("PlainText",                  QScriptValue(engine, Qt::PlainText),               ro);
  widget.setProperty("RichText",                   QScriptValue(engine, Qt::RichText),                ro);
  widget.setProperty("AutoText",                   QScriptValue(engine, Qt::AutoText),                ro);

  qScriptRegisterMetaType(engine, TextInteractionFlagtoScriptValue, TextInteractionFlagfromScriptValue);
  widget.setProperty("NoTextInteraction",          QScriptValue(engine, Qt::NoTextInteraction),       ro);
  widget.setProperty("TextSelectableByMouse",      QScriptValue(engine, Qt::TextSelectableByMouse),   ro);
  widget.setProperty("TextSelectableByKeyboard",   QScriptValue(engine, Qt::TextSelectableByKeyboard),                                                   ro);
  widget.setProperty("LinksAccessibleByMouse",     QScriptValue(engine, Qt::LinksAccessibleByMouse),  ro);
  widget.setProperty("LinksAccessibleByKeyboard",  QScriptValue(engine, Qt::LinksAccessibleByKeyboard),                                                  ro);
  widget.setProperty("TextEditable",               QScriptValue(engine, Qt::TextEditable),            ro);
  widget.setProperty("TextEditorInteraction",      QScriptValue(engine, Qt::TextEditorInteraction),   ro);
  widget.setProperty("TextBrowserInteraction",     QScriptValue(engine, Qt::TextBrowserInteraction),  ro);

#if QT_VERSION >= 0x050000
  qScriptRegisterMetaType(engine, TimerTypetoScriptValue, TimerTypefromScriptValue);
  widget.setProperty("PreciseTimer",               QScriptValue(engine, Qt::PreciseTimer),            ro);
  widget.setProperty("CoarseTimer",                QScriptValue(engine, Qt::CoarseTimer),             ro);
  widget.setProperty("VeryCoarseTimer",            QScriptValue(engine, Qt::VeryCoarseTimer),         ro);
#endif

  qScriptRegisterMetaType(engine, TimeSpectoScriptValue, TimeSpecfromScriptValue);
  widget.setProperty("LocalTime",                  QScriptValue(engine, Qt::LocalTime),               ro);
  widget.setProperty("UTC",                        QScriptValue(engine, Qt::UTC),                     ro);
  widget.setProperty("OffsetFromUTC",              QScriptValue(engine, Qt::OffsetFromUTC),           ro);

  qScriptRegisterMetaType(engine, ToolBarAreatoScriptValue, ToolBarAreafromScriptValue);
  widget.setProperty("LeftToolBarArea",            QScriptValue(engine, Qt::LeftToolBarArea),         ro);
  widget.setProperty("RightToolBarArea",           QScriptValue(engine, Qt::RightToolBarArea),        ro);
  widget.setProperty("TopToolBarArea",             QScriptValue(engine, Qt::TopToolBarArea),          ro);
  widget.setProperty("BottomToolBarArea",          QScriptValue(engine, Qt::BottomToolBarArea),       ro);
  widget.setProperty("AllToolBarAreas",            QScriptValue(engine, Qt::AllToolBarAreas),         ro);
  widget.setProperty("NoToolBarArea",              QScriptValue(engine, Qt::NoToolBarArea),           ro);

  qScriptRegisterMetaType(engine, ToolButtonStyletoScriptValue, ToolButtonStylefromScriptValue);
  widget.setProperty("ToolButtonIconOnly",         QScriptValue(engine, Qt::ToolButtonIconOnly),      ro);
  widget.setProperty("ToolButtonTextOnly",         QScriptValue(engine, Qt::ToolButtonTextOnly),      ro);
  widget.setProperty("ToolButtonTextBesideIcon",   QScriptValue(engine, Qt::ToolButtonTextBesideIcon),ro);
  widget.setProperty("ToolButtonTextUnderIcon",    QScriptValue(engine, Qt::ToolButtonTextUnderIcon), ro);

  qScriptRegisterMetaType(engine, TransformationModetoScriptValue, TransformationModefromScriptValue);
  widget.setProperty("FastTransformation",         QScriptValue(engine, Qt::FastTransformation),      ro);
  widget.setProperty("SmoothTransformation",       QScriptValue(engine, Qt::SmoothTransformation),    ro);

  qScriptRegisterMetaType(engine, UIEffecttoScriptValue, UIEffectfromScriptValue);
  widget.setProperty("UI_AnimateMenu",             QScriptValue(engine, Qt::UI_AnimateMenu),          ro);
  widget.setProperty("UI_FadeMenu",                QScriptValue(engine, Qt::UI_FadeMenu),             ro);
  widget.setProperty("UI_AnimateCombo",            QScriptValue(engine, Qt::UI_AnimateCombo),         ro);
  widget.setProperty("UI_AnimateTooltip",          QScriptValue(engine, Qt::UI_AnimateTooltip),       ro);
  widget.setProperty("UI_FadeTooltip",             QScriptValue(engine, Qt::UI_FadeTooltip),          ro);
  widget.setProperty("UI_AnimateToolBox",          QScriptValue(engine, Qt::UI_AnimateToolBox),       ro);

  qScriptRegisterMetaType(engine, WhiteSpaceModetoScriptValue, WhiteSpaceModefromScriptValue);
  widget.setProperty("WhiteSpaceNormal",           QScriptValue(engine, Qt::WhiteSpaceNormal),        ro);
  widget.setProperty("WhiteSpacePre",              QScriptValue(engine, Qt::WhiteSpacePre),           ro);
  widget.setProperty("WhiteSpaceNoWrap",           QScriptValue(engine, Qt::WhiteSpaceNoWrap),        ro);

  qScriptRegisterMetaType(engine, WidgetAttributetoScriptValue, WidgetAttributefromScriptValue);
  widget.setProperty("WA_AcceptDrops",                    QScriptValue(engine, Qt::WA_AcceptDrops),                 ro);
  widget.setProperty("WA_AlwaysShowToolTips",             QScriptValue(engine, Qt::WA_AlwaysShowToolTips),          ro);
  widget.setProperty("WA_ContentsPropagated",             QScriptValue(engine, Qt::WA_ContentsPropagated),          ro);
  widget.setProperty("WA_CustomWhatsThis",                QScriptValue(engine, Qt::WA_CustomWhatsThis),             ro);
  widget.setProperty("WA_DeleteOnClose",                  QScriptValue(engine, Qt::WA_DeleteOnClose),               ro);
  widget.setProperty("WA_Disabled",                       QScriptValue(engine, Qt::WA_Disabled),                    ro);
  widget.setProperty("WA_ForceDisabled",                  QScriptValue(engine, Qt::WA_ForceDisabled),               ro);
  widget.setProperty("WA_ForceUpdatesDisabled",           QScriptValue(engine, Qt::WA_ForceUpdatesDisabled),        ro);
  widget.setProperty("WA_GroupLeader",                    QScriptValue(engine, Qt::WA_GroupLeader),                 ro);
  widget.setProperty("WA_Hover",                          QScriptValue(engine, Qt::WA_Hover),                       ro);
  widget.setProperty("WA_InputMethodEnabled",             QScriptValue(engine, Qt::WA_InputMethodEnabled),          ro);
  widget.setProperty("WA_KeyboardFocusChange",            QScriptValue(engine, Qt::WA_KeyboardFocusChange),         ro);
  widget.setProperty("WA_KeyCompression",                 QScriptValue(engine, Qt::WA_KeyCompression),              ro);
  widget.setProperty("WA_LayoutOnEntireRect",             QScriptValue(engine, Qt::WA_LayoutOnEntireRect),          ro);
  widget.setProperty("WA_LayoutUsesWidgetRect",           QScriptValue(engine, Qt::WA_LayoutUsesWidgetRect),        ro);
  widget.setProperty("WA_MacNoClickThrough",              QScriptValue(engine, Qt::WA_MacNoClickThrough),           ro);
  widget.setProperty("WA_MacOpaqueSizeGrip",              QScriptValue(engine, Qt::WA_MacOpaqueSizeGrip),           ro);
  widget.setProperty("WA_MacShowFocusRect",               QScriptValue(engine, Qt::WA_MacShowFocusRect),            ro);
  widget.setProperty("WA_MacNormalSize",                  QScriptValue(engine, Qt::WA_MacNormalSize),               ro);
  widget.setProperty("WA_MacSmallSize",                   QScriptValue(engine, Qt::WA_MacSmallSize),                ro);
  widget.setProperty("WA_MacMiniSize",                    QScriptValue(engine, Qt::WA_MacMiniSize),                 ro);
  widget.setProperty("WA_MacVariableSize",                QScriptValue(engine, Qt::WA_MacVariableSize),             ro);
  widget.setProperty("WA_MacBrushedMetal",                QScriptValue(engine, Qt::WA_MacBrushedMetal),             ro);
  widget.setProperty("WA_Mapped",                         QScriptValue(engine, Qt::WA_Mapped),                      ro);
  widget.setProperty("WA_MouseNoMask",                    QScriptValue(engine, Qt::WA_MouseNoMask),                 ro);
  widget.setProperty("WA_MouseTracking",                  QScriptValue(engine, Qt::WA_MouseTracking),               ro);
  widget.setProperty("WA_Moved",                          QScriptValue(engine, Qt::WA_Moved),                       ro);
  widget.setProperty("WA_MSWindowsUseDirect3D",           QScriptValue(engine, Qt::WA_MSWindowsUseDirect3D),        ro);
  widget.setProperty("WA_NoBackground",                   QScriptValue(engine, Qt::WA_NoBackground),                ro);
  widget.setProperty("WA_NoChildEventsForParent",         QScriptValue(engine, Qt::WA_NoChildEventsForParent),      ro);
  widget.setProperty("WA_NoChildEventsFromChildren",      QScriptValue(engine, Qt::WA_NoChildEventsFromChildren),   ro);
  widget.setProperty("WA_NoMouseReplay",                  QScriptValue(engine, Qt::WA_NoMouseReplay),               ro);
  widget.setProperty("WA_NoMousePropagation",             QScriptValue(engine, Qt::WA_NoMousePropagation),          ro);
  widget.setProperty("WA_TransparentForMouseEvents",      QScriptValue(engine, Qt::WA_TransparentForMouseEvents),   ro);
  widget.setProperty("WA_NoSystemBackground",             QScriptValue(engine, Qt::WA_NoSystemBackground),          ro);
  widget.setProperty("WA_OpaquePaintEvent",               QScriptValue(engine, Qt::WA_OpaquePaintEvent),            ro);
  widget.setProperty("WA_OutsideWSRange",                 QScriptValue(engine, Qt::WA_OutsideWSRange),              ro);
  widget.setProperty("WA_PaintOnScreen",                  QScriptValue(engine, Qt::WA_PaintOnScreen),               ro);
  widget.setProperty("WA_PaintUnclipped",                 QScriptValue(engine, Qt::WA_PaintUnclipped),              ro);
  widget.setProperty("WA_PendingMoveEvent",               QScriptValue(engine, Qt::WA_PendingMoveEvent),            ro);
  widget.setProperty("WA_PendingResizeEvent",             QScriptValue(engine, Qt::WA_PendingResizeEvent),          ro);
  widget.setProperty("WA_QuitOnClose",                    QScriptValue(engine, Qt::WA_QuitOnClose),                 ro);
  widget.setProperty("WA_Resized",                        QScriptValue(engine, Qt::WA_Resized),                     ro);
  widget.setProperty("WA_RightToLeft",                    QScriptValue(engine, Qt::WA_RightToLeft),                 ro);
  widget.setProperty("WA_SetCursor",                      QScriptValue(engine, Qt::WA_SetCursor),                   ro);
  widget.setProperty("WA_SetFont",                        QScriptValue(engine, Qt::WA_SetFont),                     ro);
  widget.setProperty("WA_SetPalette",                     QScriptValue(engine, Qt::WA_SetPalette),                  ro);
  widget.setProperty("WA_SetStyle",                       QScriptValue(engine, Qt::WA_SetStyle),                    ro);
  widget.setProperty("WA_ShowModal",                      QScriptValue(engine, Qt::WA_ShowModal),                   ro);
  widget.setProperty("WA_StaticContents",                 QScriptValue(engine, Qt::WA_StaticContents),              ro);
  widget.setProperty("WA_StyleSheet",                     QScriptValue(engine, Qt::WA_StyleSheet),                  ro);
  widget.setProperty("WA_TranslucentBackground",          QScriptValue(engine, Qt::WA_TranslucentBackground),       ro);
  widget.setProperty("WA_UnderMouse",                     QScriptValue(engine, Qt::WA_UnderMouse),                  ro);
  widget.setProperty("WA_UpdatesDisabled",                QScriptValue(engine, Qt::WA_UpdatesDisabled),             ro);
  widget.setProperty("WA_WindowModified",                 QScriptValue(engine, Qt::WA_WindowModified),              ro);
  widget.setProperty("WA_WindowPropagation",              QScriptValue(engine, Qt::WA_WindowPropagation),           ro);
  widget.setProperty("WA_MacAlwaysShowToolWindow",        QScriptValue(engine, Qt::WA_MacAlwaysShowToolWindow),     ro);
  widget.setProperty("WA_SetLocale",                      QScriptValue(engine, Qt::WA_SetLocale),                   ro);
  widget.setProperty("WA_StyledBackground",               QScriptValue(engine, Qt::WA_StyledBackground),            ro);
  widget.setProperty("WA_ShowWithoutActivating",          QScriptValue(engine, Qt::WA_ShowWithoutActivating),       ro);
  widget.setProperty("WA_NativeWindow",                   QScriptValue(engine, Qt::WA_NativeWindow),                ro);
  widget.setProperty("WA_DontCreateNativeAncestors",      QScriptValue(engine, Qt::WA_DontCreateNativeAncestors),   ro);
  widget.setProperty("WA_X11NetWmWindowTypeDesktop",      QScriptValue(engine, Qt::WA_X11NetWmWindowTypeDesktop),   ro);
  widget.setProperty("WA_X11NetWmWindowTypeDock",         QScriptValue(engine, Qt::WA_X11NetWmWindowTypeDock),      ro);
  widget.setProperty("WA_X11NetWmWindowTypeToolBar",      QScriptValue(engine, Qt::WA_X11NetWmWindowTypeToolBar),   ro);
  widget.setProperty("WA_X11NetWmWindowTypeMenu",         QScriptValue(engine, Qt::WA_X11NetWmWindowTypeMenu),      ro);
  widget.setProperty("WA_X11NetWmWindowTypeUtility",      QScriptValue(engine, Qt::WA_X11NetWmWindowTypeUtility),   ro);
  widget.setProperty("WA_X11NetWmWindowTypeSplash",       QScriptValue(engine, Qt::WA_X11NetWmWindowTypeSplash),    ro);
  widget.setProperty("WA_X11NetWmWindowTypeDialog",       QScriptValue(engine, Qt::WA_X11NetWmWindowTypeDialog),    ro);
  widget.setProperty("WA_X11NetWmWindowTypeDropDownMenu", QScriptValue(engine, Qt::WA_X11NetWmWindowTypeDropDownMenu), ro);
  widget.setProperty("WA_X11NetWmWindowTypePopupMenu",    QScriptValue(engine, Qt::WA_X11NetWmWindowTypePopupMenu), ro);
  widget.setProperty("WA_X11NetWmWindowTypeToolTip",      QScriptValue(engine, Qt::WA_X11NetWmWindowTypeToolTip),   ro);
  widget.setProperty("WA_X11NetWmWindowTypeNotification", QScriptValue(engine, Qt::WA_X11NetWmWindowTypeNotification), ro);
  widget.setProperty("WA_X11NetWmWindowTypeCombo",        QScriptValue(engine, Qt::WA_X11NetWmWindowTypeCombo),     ro);
  widget.setProperty("WA_X11NetWmWindowTypeDND",          QScriptValue(engine, Qt::WA_X11NetWmWindowTypeDND),       ro);
  widget.setProperty("WA_MacFrameworkScaled",             QScriptValue(engine, Qt::WA_MacFrameworkScaled),          ro);

  qScriptRegisterMetaType(engine, WindowFrameSectiontoScriptValue, WindowFrameSectionfromScriptValue);
  widget.setProperty("NoSection",                 QScriptValue(engine, Qt::NoSection),              ro);
  widget.setProperty("LeftSection",               QScriptValue(engine, Qt::LeftSection),            ro);
  widget.setProperty("TopLeftSection",            QScriptValue(engine, Qt::TopLeftSection),         ro);
  widget.setProperty("TopSection",                QScriptValue(engine, Qt::TopSection),             ro);
  widget.setProperty("TopRightSection",           QScriptValue(engine, Qt::TopRightSection),        ro);
  widget.setProperty("RightSection",              QScriptValue(engine, Qt::RightSection),           ro);
  widget.setProperty("BottomRightSection",        QScriptValue(engine, Qt::BottomRightSection),     ro);
  widget.setProperty("BottomSection",             QScriptValue(engine, Qt::BottomSection),          ro);
  widget.setProperty("BottomLeftSection",         QScriptValue(engine, Qt::BottomLeftSection),      ro);
  widget.setProperty("TitleBarArea",              QScriptValue(engine, Qt::TitleBarArea),           ro);

  qScriptRegisterMetaType(engine, WindowModalitytoScriptValue, WindowModalityfromScriptValue);
  widget.setProperty("NonModal",                  QScriptValue(engine, Qt::NonModal),               ro);
  widget.setProperty("WindowModal",               QScriptValue(engine, Qt::WindowModal),            ro);
  widget.setProperty("ApplicationModal",          QScriptValue(engine, Qt::ApplicationModal),       ro);

  qScriptRegisterMetaType(engine, WindowStatetoScriptValue, WindowStatefromScriptValue);
  widget.setProperty("WindowNoState",             QScriptValue(engine, Qt::WindowNoState),          ro);
  widget.setProperty("WindowMinimized",           QScriptValue(engine, Qt::WindowMinimized),        ro);
  widget.setProperty("WindowMaximized",           QScriptValue(engine, Qt::WindowMaximized),        ro);
  widget.setProperty("WindowFullScreen",          QScriptValue(engine, Qt::WindowFullScreen),       ro);
  widget.setProperty("WindowActive",              QScriptValue(engine, Qt::WindowActive),           ro);

  qScriptRegisterMetaType(engine, WindowTypetoScriptValue, WindowTypefromScriptValue);
  widget.setProperty("Widget",                         QScriptValue(engine, Qt::Widget),                       ro);
  widget.setProperty("Window",                         QScriptValue(engine, Qt::Window),                       ro);
  widget.setProperty("Dialog",                         QScriptValue(engine, Qt::Dialog),                       ro);
  widget.setProperty("Sheet",                          QScriptValue(engine, Qt::Sheet),                        ro);
  widget.setProperty("Drawer",                         QScriptValue(engine, Qt::Drawer),                       ro);
  widget.setProperty("Popup",                          QScriptValue(engine, Qt::Popup),                        ro);
  widget.setProperty("Tool",                           QScriptValue(engine, Qt::Tool),                         ro);
  widget.setProperty("ToolTip",                        QScriptValue(engine, Qt::ToolTip),                      ro);
  widget.setProperty("SplashScreen",                   QScriptValue(engine, Qt::SplashScreen),                 ro);
  widget.setProperty("Desktop",                        QScriptValue(engine, Qt::Desktop),                      ro);
  widget.setProperty("SubWindow",                      QScriptValue(engine, Qt::SubWindow),                    ro);
  widget.setProperty("MSWindowsFixedSizeDialogHint",   QScriptValue(engine, Qt::MSWindowsFixedSizeDialogHint), ro);
  widget.setProperty("MSWindowsOwnDC",                 QScriptValue(engine, Qt::MSWindowsOwnDC),               ro);
  widget.setProperty("X11BypassWindowManagerHint",     QScriptValue(engine, Qt::X11BypassWindowManagerHint),   ro);
  widget.setProperty("FramelessWindowHint",            QScriptValue(engine, Qt::FramelessWindowHint),          ro);
  widget.setProperty("CustomizeWindowHint",            QScriptValue(engine, Qt::CustomizeWindowHint),          ro);
  widget.setProperty("WindowTitleHint",                QScriptValue(engine, Qt::WindowTitleHint),              ro);
  widget.setProperty("WindowSystemMenuHint",           QScriptValue(engine, Qt::WindowSystemMenuHint),         ro);
  widget.setProperty("WindowMinimizeButtonHint",       QScriptValue(engine, Qt::WindowMinimizeButtonHint),     ro);
  widget.setProperty("WindowMaximizeButtonHint",       QScriptValue(engine, Qt::WindowMaximizeButtonHint),     ro);
  widget.setProperty("WindowMinMaxButtonsHint",        QScriptValue(engine, Qt::WindowMinMaxButtonsHint),      ro);
  widget.setProperty("WindowCloseButtonHint",          QScriptValue(engine, Qt::WindowCloseButtonHint),        ro);
  widget.setProperty("WindowContextHelpButtonHint",    QScriptValue(engine, Qt::WindowContextHelpButtonHint),  ro);
  widget.setProperty("MacWindowToolBarButtonHint",     QScriptValue(engine, Qt::MacWindowToolBarButtonHint),   ro);
  widget.setProperty("BypassGraphicsProxyWidget",      QScriptValue(engine, Qt::BypassGraphicsProxyWidget),    ro);
  widget.setProperty("WindowShadeButtonHint",          QScriptValue(engine, Qt::WindowShadeButtonHint),        ro);
  widget.setProperty("WindowStaysOnTopHint",           QScriptValue(engine, Qt::WindowStaysOnTopHint),         ro);
  widget.setProperty("WindowStaysOnBottomHint",        QScriptValue(engine, Qt::WindowStaysOnBottomHint),      ro);
#if QT_VERSION < 0x050800
  widget.setProperty("WindowOkButtonHint",             QScriptValue(engine, Qt::WindowOkButtonHint),           ro);
  widget.setProperty("WindowCancelButtonHint",         QScriptValue(engine, Qt::WindowCancelButtonHint),       ro);
#endif
  widget.setProperty("WindowType_Mask",                QScriptValue(engine, Qt::WindowType_Mask),              ro);

  engine->globalObject().setProperty("Qt", widget, ro);
}
