/*
 * rwconf.h	Definitions for the configuration stuff in conf.c.
 *		You cannot set any compile-time directives here.
 *
 * Version:	@(#)rwconf.h  1.10  14-Oct-1996  miquels@cistron.nl
 *
 */

#ifndef __rwconf_h
#define __rwconf_h

/*
 *	Realm structure.
 */
struct realm_def {
	char *name;
	struct sockaddr *authhost1;
	struct sockaddr *authhost2;
	struct sockaddr *accthost1;
	struct sockaddr *accthost2;
	struct realm_def *next;
	bool prefix;
	bool strip;
};

/*
 *	Configuration, per line.
 */
struct line_cfg {
	char *hostname;
	unsigned int loc_host;
#ifdef HAVE_IPV6
	struct in6_addr loc_host6;
	bool use_v6;
#endif
	char *lockdir;
	char *rlogin;
	char *telnet;
	char *ssh;
	char *pppd;
	unsigned int syslog;
	int facility;
	char *filterdir;
	/* Networking options */
	int authtype;
	struct sockaddr *authhost1;
	struct sockaddr *authhost2;
#ifdef PORTSLAVE_TACACS
	struct sockaddr *tacauthhost1;
	struct sockaddr *tacauthhost2;
#endif
	struct sockaddr *accthost1;
	struct sockaddr *accthost2;
	unsigned int radtimeout;
	unsigned int radretries;
	char *utmpfrom;
	char *secret;
	int protocol;
	int host;
	unsigned int rem_host;
	unsigned int netmask;
	int mtu, mru;
	char *autoppp;
	char *pppopt;
	char *tty;
	/* Other options */
	char *issue;
	char *prompt;
	char *term;
	struct realm_def *realm;
	/* Modem options */
	int flow;
	bool dcd;
	int speed;
	int socket_port;
	int parity;
	int stopbits;
	int datasize;
	int debug;
	int porttype;
	char *initchat;
#ifdef PORTSLAVE_CLIENT_IP_RULES
	char *valid_ip;
#endif
	char *fixedlogin;

	char *lockfile; /* Internal use only */
	bool emumodem;
	bool logpassword;
	bool locallogins;
	bool stripnames;
	bool radnullpass;
	bool sysutmp;
	bool syswtmp;
	bool do_acct;
} lineconf;

/*
 *	Flow control definitions.
 */
#define FLOW_NONE	0
#define FLOW_HARD	1
#define FLOW_SOFT	2

/*
 *	Functions.
 */
void initcfg(void);
int readcfg(const char *config_file, const char *tty);
int writecfg(void);

#endif	/* __rwconf_h */
