/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#ifndef POLYXMASS_UI_SEQED_WIDGET_CONTEXT_MENU_H
#define POLYXMASS_UI_SEQED_WIDGET_CONTEXT_MENU_H

#include "polyxmass-globals.h"
#include "polyxmass-ui-seqed-widget.h"


GtkWidget *
polyxmass_seqed_widget_context_menu_setup (GtkWidget *seqed_widget) ;


/************* EDIT ---> COPY *************
 */
void
polyxmass_seqed_widget_context_menu_edit_copy (GtkMenuItem *menuitem,
					       gpointer data);

/************* EDIT ---> CUT *************
 */
void
polyxmass_seqed_widget_context_menu_edit_cut (GtkMenuItem *menuitem,
					      gpointer data);

/************* EDIT ---> PASTE *************
 */
void
polyxmass_seqed_widget_context_menu_edit_paste (GtkMenuItem *menuitem,
						gpointer data);

/************* EDIT ---> IMPORT RAW TEXT *************
 */
void
polyxmass_seqed_widget_context_menu_edit_import_raw_text (GtkMenuItem *menuitem,
						gpointer data);


/************* EDIT ---> FIND_REPLACE *************
 */
void
polyxmass_seqed_widget_context_menu_edit_find_replace (GtkMenuItem *menuitem,
						       gpointer data);

/************* EDIT ---> ANNOTATIONS -> MONOMER -> SINGLE *************
 */
void
polyxmass_seqed_widget_context_menu_edit_annotations_monomer_single (GtkMenuItem *menuitem,
								     gpointer data);

/************* EDIT ---> ANNOTATIONS -> MONOMER -> RANGE *************
 */
void
polyxmass_seqed_widget_context_menu_edit_annotations_monomer_range (GtkMenuItem *menuitem,
								    gpointer data);

/************* EDIT ---> ANNOTATIONS -> POLYMER *************
 */
void
polyxmass_seqed_widget_context_menu_edit_annotations_polymer (GtkMenuItem *menuitem,
							      gpointer data);

/************* EDIT ---> LIST COMPLETIONS *************
 */
void
polyxmass_seqed_widget_context_menu_edit_list_completions (GtkMenuItem *menuitem,
							   gpointer data);

/************* EDIT ---> SELECT ALL *************
 */
void
polyxmass_seqed_widget_context_menu_edit_select_all (GtkMenuItem *menuitem,
						     gpointer data);

/************* CHEMISTRY ---> MODIFICATIONS (MONOMER) *************
 */
void
polyxmass_seqed_widget_context_menu_chemistry_monomer_modif (GtkMenuItem *menuitem,
						   gpointer data);

/************* CHEMISTRY ---> MODIFICATIONS (POLYMER) *************
 */
void
polyxmass_seqed_widget_context_menu_chemistry_polymer_modif (GtkMenuItem *menuitem,
						   gpointer data);

/************* SELF READ SEQUENCE TO FILE *************
 */
void
polyxmass_seqed_widget_context_menu_self_read_sequence_to_file (GtkMenuItem *menuitem,
								gpointer data);







#endif /* POLYXMASS_UI_SEQED_WIDGET_CONTEXT_MENU_H */
