/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "libpolyxmass-masspair.h"



/* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
 */

PxmMasspair *
libpolyxmass_masspair_new (void)
{
  PxmMasspair *mp = NULL;
  
  mp = g_malloc0 (sizeof (PxmMasspair));

  mp->ionizerule = pxmchem_ionizerule_new ();
    
  return mp;
}


PxmMasspair *
libpolyxmass_masspair_dup (PxmMasspair *mp)
{
  PxmMasspair *mp_new = NULL;

  g_assert (mp != NULL);
  
  mp_new = g_malloc0 (sizeof (PxmMasspair));

  mp_new->mono = mp->mono;
  mp_new->avg = mp->avg;

  mp_new->ionizerule = pxmchem_ionizerule_dup (mp->ionizerule);
    
  return mp_new;
}


PxmProp *
libpolyxmass_masspair_prop_dup (PxmProp * prop)
{
  PxmProp *prop_new = NULL;
  
  g_assert (prop != NULL);
  g_assert (prop->name != NULL);
  g_assert (prop->data != NULL);
  
  prop_new = libpolyxmass_prop_new ();
  
  libpolyxmass_prop_set_name (prop_new, prop->name);
  
  prop_new->data = 
    (gpointer) libpolyxmass_masspair_dup ((PxmMasspair *) prop->data);
  
  return prop_new;
}


gboolean
libpolyxmass_masspair_set_mono (PxmMasspair *mp, gdouble mono)
{
  g_assert (mp != NULL);

  mp->mono = mono;
  
  return TRUE;
}


gboolean
libpolyxmass_masspair_set_avg (PxmMasspair *mp, gdouble avg)
{
  g_assert (mp != NULL);

  mp->avg = avg;
  
  return TRUE;
}


gboolean
libpolyxmass_masspair_set_both (PxmMasspair *mp, gdouble mono, gdouble avg)
{
  g_assert (mp != NULL);
   
  mp->mono = mono;
  mp->avg = avg;
  
  return TRUE;
}


gdouble
libpolyxmass_masspair_get_mono (PxmMasspair *mp)
{
  g_assert (mp != NULL);

  return mp->mono;
}


gdouble
libpolyxmass_masspair_get_avg (PxmMasspair *mp)
{
  g_assert (mp != NULL);

  return mp->avg;
}





/*  LOCATING FUNCTIONS
 */




/* UTILITY FUNCTIONS
 */
gboolean
libpolyxmass_masspair_reset (PxmMasspair *mp)
{
  g_assert (mp != NULL);
  
  mp->mono = 0;
  mp->avg = 0;
  
  return TRUE;
}




/* FREE'ING FUNCTIONS
 */
gboolean
libpolyxmass_masspair_free (PxmMasspair *mp)
{
  g_assert (mp != NULL);
  
  pxmchem_ionizerule_free (mp->ionizerule);
  
  g_free (mp);
  
  return 1;
}


gint 
libpolyxmass_masspair_prop_free (PxmProp *prop)
{
  g_assert (prop != NULL);
  
  if (prop->name != NULL)
    g_free (prop->name);
  
  if (prop->data == NULL)
    return TRUE;
  
  /* Now free the masspair data.
   */
  return libpolyxmass_masspair_free ((PxmMasspair *) prop->data);
}



/* GPtrArray-RELATED FUNCTIONS
 */
gint
libpolyxmass_masspair_GPA_empty (GPtrArray *GPA)
{
  gint count = 0;
  
  PxmMasspair *mp = NULL;
  

  g_assert (GPA != NULL);
  
  while (GPA->len > 0)
    {
      mp = g_ptr_array_remove_index (GPA, 0);
      g_assert (mp != NULL);
      libpolyxmass_masspair_free (mp);
      count++;
    }

  return count;
}

gint
libpolyxmass_masspair_GPA_free (GPtrArray *GPA)
{
  gint count = 0;


  g_assert (GPA != NULL);

  count = libpolyxmass_masspair_GPA_empty (GPA);
    
  g_ptr_array_free (GPA, TRUE);

  return count;
}
