/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#include "polyxedit-monicon.h"




/* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
 */
PxmMonicon *
polyxedit_monicon_new (void)
{
  PxmMonicon *monicon = NULL;
  
  monicon = g_malloc0 (sizeof (PxmMonicon));
  
  return monicon;
}



/* FREE'ING FUNCTIONS
 */
gboolean
polyxedit_monicon_free (PxmMonicon *monicon)
{
  g_assert (monicon != NULL);
  
  /* It is important to remember here, that the pixbuf that is used to
     make the canvas_item ( with a call to gnome_canvas_item_new ())
     is automatically refcounted. So we can gtk_object_destroy () the
     non-NULL canvas_item and the pixbuf will be unreffed.
   */

  if (monicon->canvas_item != NULL)
    gtk_object_destroy (GTK_OBJECT (monicon->canvas_item));
  
  /*
    debug_printf (("freeing monicon %p\n", monicon));
  */

  g_free (monicon);
  
  return TRUE;
}



/* GPtrArray-RELATED FUNCTIONS
 */
gint
polyxedit_monicon_GPA_empty (GPtrArray *GPA)
{
  gint count = 0;
  
  PxmMonicon *monicon = NULL;
  

  g_assert (GPA != NULL);
  
  while (GPA->len > 0)
    {
      monicon = g_ptr_array_remove_index (GPA, 0);
      polyxedit_monicon_free (monicon);
      count++;
    }
  
  /* Attention, here we do not free the GPA, we are only emptying it !
   */

  return count;
}


gint
polyxedit_monicon_GPA_free (GPtrArray *GPA)
{
  gint count = 0;
  
  PxmMonicon *monicon = NULL;
  

  g_assert (GPA != NULL);
  
  while (GPA->len > 0)
    {
      monicon = g_ptr_array_remove_index (GPA, 0);
      polyxedit_monicon_free (monicon);
      count++;
    }
  
  g_ptr_array_free (GPA, TRUE);

  return count;
}
