/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#include "polyxedit-ui-masses-display-wnd.h"
#include "polyxedit-ui-seqed-wnd.h"



GtkWidget *
polyxedit_ui_masses_display_wnd_setup_window (void)
{
  GtkWidget *widget = NULL;
  GladeXML *xml = NULL;

  gchar *gui_file = NULL;
  

  /* We are setting up the window into which masses for the currently
     focused sequence are computed. This window displays avg and
     monoisotopic masses both for the whole polymer sequence and for
     the selected portion of that sequence.
  */

  gui_file = 
    g_strdup_printf ("%s/polyxmass-masses-display.glade", 
		     userspec->gladedir);

  g_assert (gui_file != NULL);
    
  xml = glade_xml_new (gui_file, "masses_display_wnd", 
		       PACKAGE);
  g_free (gui_file);

  if (xml == NULL)
    {
      g_error (_("%s@%d: failed loading the interface\n"),
	     __FILE__, __LINE__);
    }
  
  polyxedit_masses_display_wnd = glade_xml_get_widget (xml, 
						       "masses_display_wnd");
  
  if (polyxedit_masses_display_wnd == NULL)
    {
      g_error (_("%s@%d: failed creating the masses display window\n"),
	     __FILE__, __LINE__);
    }
  

  widget = glade_xml_get_widget (xml, "polseq_name_entry");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (polyxedit_masses_display_wnd),
		     "polseq_name_entry", widget);

  widget = glade_xml_get_widget (xml, "polseq_id_entry");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (polyxedit_masses_display_wnd),
		     "polseq_id_entry", widget);

  widget = glade_xml_get_widget (xml, "sequence_mono_entry");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (polyxedit_masses_display_wnd),
		     "sequence_mono_entry", widget);

  widget = glade_xml_get_widget (xml, "sequence_avg_entry");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (polyxedit_masses_display_wnd),
		     "sequence_avg_entry", widget);

  widget = glade_xml_get_widget (xml, "selection_mono_entry");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (polyxedit_masses_display_wnd),
		     "selection_mono_entry", widget);

  widget = glade_xml_get_widget (xml, "selection_avg_entry");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (polyxedit_masses_display_wnd),
		     "selection_avg_entry", widget);

 
  widget = glade_xml_get_widget (xml, "recalculate_button");
  g_assert (widget != NULL);
    g_object_set_data (G_OBJECT (polyxedit_masses_display_wnd),
		     "recalculate_button", widget);
  g_signal_connect 
    (G_OBJECT (widget),
     "clicked",
     G_CALLBACK (polyxedit_ui_masses_display_wnd_recalculate_masses),
     polyxedit_masses_display_wnd);
  
  /* We don't need the GladeXML object any more, so unref it
   * to save some memory 
   */
  g_object_unref (G_OBJECT (xml));

  
  /* Connect some important signals for the window proper.
   */
  g_signal_connect (G_OBJECT (polyxedit_masses_display_wnd),
		    "delete_event",
		    G_CALLBACK 
		    (polyxedit_ui_masses_display_wnd_delete_event),
		    polyxedit_masses_display_wnd);
  
  g_signal_connect (G_OBJECT (polyxedit_masses_display_wnd),
		    "destroy_event",
		    G_CALLBACK 
		    (polyxedit_ui_masses_display_wnd_destroy_event),
		    polyxedit_masses_display_wnd);
  
  gtk_widget_show_all (polyxedit_masses_display_wnd);
  
  
  return polyxedit_masses_display_wnd;
}


gboolean
polyxedit_ui_masses_display_wnd_update_sequence_data (PxmEditCtxt *editctxt)
{
  GtkWidget *widget = NULL;
  
  gchar *help = NULL;

  if (polyxedit_masses_display_wnd == NULL)
    return TRUE;


  g_assert (editctxt != NULL);
  g_assert (editctxt->polymer != NULL);


  widget = g_object_get_data (G_OBJECT (polyxedit_masses_display_wnd), 
			      "polseq_name_entry");
  g_assert (widget != NULL);

  if (editctxt != NULL)
    {
      if (editctxt->polymer->plminfo->name != NULL)
	gtk_entry_set_text (GTK_ENTRY (widget), 
			    editctxt->polymer->plminfo->name);
      else
	gtk_entry_set_text (GTK_ENTRY (widget), 
			    _("Name not set"));
    }

  widget = g_object_get_data (G_OBJECT (polyxedit_masses_display_wnd), 
			      "polseq_id_entry");
  g_assert (widget != NULL);

  if (editctxt != NULL)
    {
      help = g_strdup_printf ("%p", editctxt);
      gtk_entry_set_text (GTK_ENTRY (widget), help);
      g_free (help);
    }

  /* Set a datum to the window that points to the present editctxt. 
     Each time a polseq editor window gets the focus this datum is
     reset to the new value here.
  */
  g_object_set_data (G_OBJECT (polyxedit_masses_display_wnd), 
		     "editctxt", editctxt);
    
  return TRUE;
}


gboolean
polyxedit_ui_masses_display_wnd_update_sequence_masses (PxmEditCtxt *editctxt)
{
  PxmMasspair *masspair = NULL;
  
  GtkWidget *widget = NULL;
  
  gchar *help = NULL;
  

  if (polyxedit_masses_display_wnd == NULL)
    return TRUE;


  g_assert (editctxt != NULL);

  /* Make sure the editctxt is still present in the memory context.
   */
  if (-1 == polyxedit_editctxt_get_index (editctxt, 
					  polyxedit_editctxtGPA))
    {
      polyxedit_ui_masses_display_wnd_reset_all ();
  
      return TRUE;
    }
  
  /* At this point we know that the editctxt is still live in the
     program's memory.
  */
  g_assert (editctxt->polymer != NULL);
  
  /* Remember that the polymer's masspair_seq member is not allocated
     automatically, so it may be NULL. In which case we simply allocate
     it once for all.
  */
  if (editctxt->polymer->masspair_seq == NULL)
    editctxt->polymer->masspair_seq = libpolyxmass_masspair_new ();
  
  masspair = editctxt->polymer->masspair_seq;
  
  /* Reset the masspair object to 0.0 and 0.0 because otherwise
     we would increment the masses at each recalculation!
  */
  libpolyxmass_masspair_reset (masspair);
  
  /* Effectively compute the masses using the editctxt->calcopt and
     editctxt->ionizerule members to drive the calculations.
  */

  /* Note that we are calculating the mass of the whole polymer sequence
     so we have to make sure that editctxt->calcopt hold the proper
     start_idx and end_idx values.
  */
  editctxt->calcopt->start_idx = -1;
  editctxt->calcopt->end_idx = -1;
  
  pxmchem_masscalc_polymer (editctxt->polymer,
			    editctxt->polchemdefctxt->polchemdef,
			    editctxt->calcopt,
			    editctxt->ionizerule,
			    masspair);
  
  /* At this point we should have the masses into the masspair object.
   */

  widget = g_object_get_data (G_OBJECT (polyxedit_masses_display_wnd),
			      "sequence_mono_entry");
  g_assert (widget != NULL);
  
  help = g_strdup_printf ("%.5f", masspair->mono);
  gtk_entry_set_text (GTK_ENTRY (widget), help);
  g_free (help);
  
  widget = g_object_get_data (G_OBJECT (polyxedit_masses_display_wnd),
			      "sequence_avg_entry");
  g_assert (widget != NULL);
  
  help = g_strdup_printf ("%.5f", masspair->avg);
  gtk_entry_set_text (GTK_ENTRY (widget), help);
  g_free (help);
  
  return TRUE;
}


gboolean
polyxedit_ui_masses_display_wnd_update_selection_masses (PxmEditCtxt *editctxt)
{
  PxmMasspair *masspair = NULL;
  
  GtkWidget *widget = NULL;

  gchar *help = NULL;


  if (polyxedit_masses_display_wnd == NULL)
    return TRUE;


  g_assert (editctxt != NULL);

  /* Make sure the editctxt is still present in the memory context.
   */
  if (-1 == polyxedit_editctxt_get_index (editctxt, polyxedit_editctxtGPA))
    {
      polyxedit_ui_masses_display_wnd_reset_all ();
  
      return TRUE;
    }
  
  /* At this point we know that the editctxt is still live in the
     program's memory.
  */
  g_assert (editctxt->polymer != NULL);
  
  /* Remember that the polymer's masspair_sel member is not allocated
     automatically, so it may be NULL. In which case we simply allocate
     it once for all.
  */
  if (editctxt->polymer->masspair_sel == NULL)
    editctxt->polymer->masspair_sel = libpolyxmass_masspair_new ();
  
  masspair = editctxt->polymer->masspair_sel;
  
  /* Reset the masspair object to 0.0 and 0.0 because otherwise
     we would increment the masses at each recalculation!
  */
  libpolyxmass_masspair_reset (masspair);
  
  /* Effectively compute the masses using the editctxt->calcopt and
     editctxt->ionizerule members to drive the calculations.
  */

  /* Note that we are calculating the mass of the polymer sequence's
     selection so we have to make sure that editctxt->calcopt hold
     the proper start_idx and end_idx values.
  */
  if (FALSE == polyxedit_seqed_wnd_get_selection_indices (editctxt,
							  &editctxt->
							  calcopt->start_idx,
							  &editctxt->
							  calcopt->end_idx))
    {
      /* There is no actual selection, so we consider like selected
	 the region of the sequence that goes from 0 to the location
	 of the cursor.
      */
      editctxt->calcopt->start_idx = 0;
      editctxt->calcopt->end_idx = 
	editctxt->seqeditorctxt->last_point_1_idx;
    }

  pxmchem_masscalc_polymer (editctxt->polymer,
			    editctxt->polchemdefctxt->polchemdef,
			    editctxt->calcopt,
			    editctxt->ionizerule,
			    masspair);
  
  /* At this point we should have the masses into the masspair object.
   */
  widget = g_object_get_data (G_OBJECT (polyxedit_masses_display_wnd),
			      "selection_mono_entry");
  g_assert (widget != NULL);
  
  help = g_strdup_printf ("%.5f", masspair->mono);
  gtk_entry_set_text (GTK_ENTRY (widget), help);
  g_free (help);
  
  widget = g_object_get_data (G_OBJECT (polyxedit_masses_display_wnd),
			      "selection_avg_entry");
  g_assert (widget != NULL);
  
  help = g_strdup_printf ("%.5f", masspair->avg);
  gtk_entry_set_text (GTK_ENTRY (widget), help);
  g_free (help);
  
  return TRUE;
}


void
polyxedit_ui_masses_display_wnd_recalculate_masses (GtkWidget *widget,
						    gpointer data)
{
  PxmEditCtxt *editctxt = NULL;
  

  if (polyxedit_masses_display_wnd == NULL)
    return;
  
  /* Get the editctxt from the window data.
   */
  editctxt = g_object_get_data (G_OBJECT (polyxedit_masses_display_wnd), 
				  "editctxt");
  
  if (editctxt == NULL)
    {
      polyxedit_ui_masses_display_wnd_reset_all ();
  
      return;
    }
  
  polyxedit_ui_masses_display_wnd_update_sequence_masses (editctxt);
  polyxedit_ui_masses_display_wnd_update_selection_masses (editctxt);

  return;
}


gboolean
polyxedit_ui_masses_display_wnd_reset_all (void)
{
  GtkWidget *widget = NULL;
  

  if (polyxedit_masses_display_wnd == NULL)
    return TRUE;


  widget = g_object_get_data (G_OBJECT (polyxedit_masses_display_wnd), 
			      "polseq_name_entry");
  g_assert (widget != NULL);
  gtk_entry_set_text (GTK_ENTRY (widget), "");

  widget = g_object_get_data (G_OBJECT (polyxedit_masses_display_wnd), 
			      "polseq_id_entry");
  g_assert (widget != NULL);

  gtk_entry_set_text (GTK_ENTRY (widget), "");
  
  widget = g_object_get_data (G_OBJECT (polyxedit_masses_display_wnd),
			      "sequence_mono_entry");
  g_assert (widget != NULL);
  gtk_entry_set_text (GTK_ENTRY (widget), "");
  
  widget = g_object_get_data (G_OBJECT (polyxedit_masses_display_wnd),
			      "sequence_avg_entry");
  g_assert (widget != NULL);
  gtk_entry_set_text (GTK_ENTRY (widget), "");
  
  widget = g_object_get_data (G_OBJECT (polyxedit_masses_display_wnd),
			      "selection_mono_entry");
  g_assert (widget != NULL);
  gtk_entry_set_text (GTK_ENTRY (widget), "");
  
  widget = g_object_get_data (G_OBJECT (polyxedit_masses_display_wnd),
			      "selection_avg_entry");
  g_assert (widget != NULL);
  gtk_entry_set_text (GTK_ENTRY (widget), "");
  

  /* Set a datum to the window that points to the present editctxt. 
     Each time a polseq editor window gets the focus this datum is
     reset to the new value here.
  */
  g_object_set_data (G_OBJECT (polyxedit_masses_display_wnd), 
		     "editctxt", NULL);
    
  return TRUE;
}


void
polyxedit_ui_masses_display_wnd_make_visible (gboolean visible)
{
  g_assert (polyxedit_masses_display_wnd != NULL);
  
  if (TRUE == visible)
    gtk_widget_show (GTK_WIDGET (polyxedit_masses_display_wnd)); 
  else
    gtk_widget_hide (GTK_WIDGET (polyxedit_masses_display_wnd)); 
  
}


  
	

gboolean
polyxedit_ui_masses_display_wnd_delete_event (GtkWidget *widget,
					      GdkEvent *event,
					      gpointer data)
{
  GtkWidget *check_menu = NULL;
  

  /* We actually never close this window, it is closed only when the
     polyxmass program is exited.
  */
  gtk_widget_hide (GTK_WIDGET (polyxedit_masses_display_wnd));
  
  /* We want to maintain the consistency between the main program
     window's menu checkbutton and the visibility of the window.
   */
  check_menu = g_object_get_data (G_OBJECT (polyxmass_main_wnd),
				  "polyxedit_display_masses_window");
  g_assert (check_menu != NULL);
  
  gtk_check_menu_item_set_active ((GtkCheckMenuItem *) check_menu,
				  FALSE);
    
  return TRUE;
}


gboolean
polyxedit_ui_masses_display_wnd_destroy_event (GtkWidget *widget,
				  GdkEvent *event,
				  gpointer data)
{
  return FALSE;
}

