/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#ifndef POLYXEDIT_UI_CLEAVE_H
#define POLYXEDIT_UI_CLEAVE_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "polyxedit-globals.h"
#include "polyxedit-editctxt.h"

/* columns */

enum
{
  COLUMN_CLS_NAME = 0,
  COLUMN_CLS_PATTERN,
  
  COLUMN_LRR_LEFT_CODE,
  COLUMN_LRR_LEFT_ACTFORM,

  COLUMN_LRR_RIGHT_CODE,
  COLUMN_LRR_RIGHT_ACTFORM,

  COLUMN_CLS_VISIBLE,
  COLUMN_CLS_EDITABLE,
  COLUMN_CLS_COL_COUNT
};

enum
{
  COLUMN_OLIG_PARTIAL = 0,
  COLUMN_OLIG_NUMBER,
  
  COLUMN_OLIG_COORDINATES,

  COLUMN_OLIG_MONO,
  COLUMN_OLIG_AVG,

  COLUMN_OLIG_MODIFIED,

  COLUMN_OLIG_VISIBLE,
  COLUMN_OLIG_EDITABLE,
  COLUMN_OLIG_COL_COUNT
};



GtkWidget *
polyxedit_cleave_options_wnd_setup (PxmEditCtxt *editctxt);


gboolean
polyxedit_cleave_setup_cleavespecs_treeview (GtkWidget *window, 
					    GtkWidget *vbox);


GtkTreeModel *
polyxedit_cleave_create_cleavespecs_treeview_model (GPtrArray *GPA);


void
polyxdef_cleave_options_wnd_cleave_button (GtkWidget *widget, gpointer data);


GtkWidget *
polyxedit_cleave_results_wnd_setup (PxmEditCtxt *editctxt,
				    GPtrArray *partialsGPA);
gboolean
polyxedit_cleave_results_wnd_show_oligomers (GtkWidget *window,
					     GPtrArray *partialsGPA);
gboolean
polyxedit_cleave_setup_oligomers_treeview (GtkWidget *window, 
					   GtkWidget *vbox);

GtkTreeModel *
polyxedit_cleave_create_oligomers_treeview_model (GPtrArray *GPA);

void
polyxdef_cleave_results_wnd_ok_button (GtkWidget *widget, gpointer data);



gboolean
polyxedit_cleave_options_wnd_delete_event (GtkWidget *widget,
				  GdkEvent *event,
					   gpointer data);

gboolean
polyxedit_cleave_options_wnd_destroy_event (GtkWidget *widget,
					   GdkEvent *event,
					    gpointer data);

gboolean
polyxedit_cleave_results_wnd_delete_event (GtkWidget *widget,
					   GdkEvent *event,
					   gpointer data);

gboolean
polyxedit_cleave_results_wnd_destroy_event (GtkWidget *widget,
					   GdkEvent *event,
					    gpointer data);









#endif /*POLYXEDIT_UI_CLEAVE_H */
