.\" Automatically generated by Pod::Man 2.1801 (Pod::Simple 3.05)
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  \*(C+ will
.\" give a nicer C++.  Capital omega is used to do unbreakable dashes and
.\" therefore won't be available.  \*(C` and \*(C' expand to `' in nroff,
.\" nothing in troff, for use with C<>.
.tr \(*W-
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" Escape single quotes in literal strings from groff's Unicode transform.
.ie \n(.g .ds Aq \(aq
.el       .ds Aq '
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.SS), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.ie \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.el \{\
.    de IX
..
.\}
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "POLYGLOT 6"
.TH POLYGLOT 6 "2010-04-25" "" ""
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.if n .ad l
.nh
.SH "NAME"
PolyGlot \-  Winboard protocol to UCI protocol adapter
         \-  book engine for Polyglot books 
         \-  a collection of utilities for creating and analyzing opening books
         \-  a utility for analyzing epd files
         \-  a perft counter
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
polyglot [configfile] [\-noini] [\-ec engine] [\-ed enginedirectory] [\-en enginename] [\-log true/false] [\-lf logfile] [\-pg <name>=<value>]* [\-uci <name>=<value>]*
.PP
polyglot make-book [\-pgn inputfile] [\-bin outputfile] [\-max\-ply ply] [\-min\-game games] [\-min\-score score] [\-only\-white] [\-only\-black] [\-uniform]
.PP
polyglot merge-book \-in1 inputfile1 \-in2 inputfile2 [\-out outputfile]
.PP
polyglot info-book [\-bin inputfile] [\-exact]
.PP
polyglot dump-book [\-bin inputfile] \-color color [\-out outputfile]
.PP
polyglot [configfile] epd-test [engineoptions] [\-epd inputfile] [\-min\-depth depth] [\-max\-depth depth] [\-max\-time time] [\-depth\-delta delta]
.PP
polyglot perft [\-fen fen] [\-max\-depth depth]
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
.SS "PolyGlot as adapter and book engine"
.IX Subsection "PolyGlot as adapter and book engine"
PolyGlot is a \*(L"\s-1UCI\s0 adapter\*(R".  It connects a \s-1GUI\s0 interface (such as
XBoard, Winboard, Arena or Chessbase) to a \s-1UCI\s0 chess engine.
.PP
By specifying an opening book (in PolyGlot book format) chess engines can
transparently use such books.
.PP
PolyGlot understands the two main \s-1GUI\s0 protocols: \s-1UCI\s0 and
xboard. Normally the protocol will be auto detected but this can be
overridden in the configuration file.
.PP
In xboard mode PolyGlot fully translates between the xboard and \s-1UCI\s0 protocols.
In addition it tries to solve known problems with other adapters.
For instance, it detects and reports draws by fifty-move rule,
repetition, etc ... It also supports Chess960.
.PP
When in \s-1UCI\s0 mode PolyGlot mostly passes commands from the \s-1GUI\s0
to the engine and vice versa, except that it will play book moves on
behalf of the engine when the occasion arises.
.PP
The engine options are exported as \s-1UCI\s0 options in \s-1UCI\s0
mode and as \*(L"feature option=\*(R" commands in xboard mode. The latter form
an extension of the xboard protocol as defined by H.G. Muller.
.PP
Options which normally appear in the [PolyGlot] section of the
config file (see below) are exported as options with their name prefixed
by \*(L"Polyglot\*(R". This makes it easy to filter them in the \s-1GUI\s0.
.PP
\&\s-1NOTE:\s0 Not all options are exported, only those that make sense in the
given mode.
.SS "Book making utilities"
.IX Subsection "Book making utilities"
PolyGlot supports the \*(L"PolyGlot opening book format\*(R". This is the
defacto standard non-proprietary opening book format. It is fully documented
here
.PP
http://alpha.uhasselt.be/Research/Algebra/Toga/book_format.html
.PP
Roughly speaking a PolyGlot opening book is a collection of triples
(position, move, weight). A \*(L"position\*(R" is represented by a 64\-bit
Zobrist hash key. The weight is proportional to the probability the move should
be played.
.PP
Other opening book formats such as ChessBase's .ctg format and Arena's
\&.abk format are undocumented and proprietary. They can only be used 
by their own GUIs.
.PP
PolyGlot can compile a pgn file into a binary PolyGlot book and furthermore
it can merge two such binary books into a third one.
.PP
PolyGlot can also extract some useful information from PolyGlot books. The utility
\&\*(L"dump-book\*(R" dumps the \*(L"lines\*(R" in a book for a given color. By definition
a line is a sequence of moves (from the starting position) in which
the given color makes only book moves and the other color makes 
arbitrary moves (i.e. not necessarily book moves).
.PP
Since a PolyGlot book is built up from positions and not lines there
may be (and there usually are) many positions in the book that are not
on a \*(L"line\*(R" as defined in the previous paragraph. It is convenient
to call such positions \*(L"isolated\*(R" positions. The utility \*(L"info-book\*(R"
counts such isolated positions.
.PP
Some of the isolated positions are provably unreachable and they
could in principle be deleted from the book. For example if a book
contains only the move \*(L"e4\*(R" in the starting position but also the
position after \*(L"d4 d5\*(R" then this last position is provably unreachable
since it requires white to make a non-book move when a book move is
available. Such situations arise frequently from the priority rules
in merging books.
.PP
Unfortunately not all isolated positions are provably unreachable and
it is difficult to identify the latter. If invoked with \*(L"\-exact\*(R" the
utility info-book will attempt to count the isolated positions which
require a player to make a non-book move when a book move is available.
Due to the possibility of transpositions this is not a fool proof method.
.SS "Epd test mode"
.IX Subsection "Epd test mode"
In epd test mode, PolyGlot will search positions in an epd file and
record the number of times the right best move was found.  The
arguments specify when to stop the search in any given position.
.SS "Perft counts"
.IX Subsection "Perft counts"
A perft count is the number of legal move sequence in a given position
up to a given depth. PolyGlot can perform such perft counts. It
is however much slower than other more dedicated programs.
.SH "OPTIONS"
.IX Header "OPTIONS"
When PolyGlot is invoked as an adapter of in epd-test mode it gets its
options from a config file and then from the command line.  The
default config file is \*(L"polyglot.ini\*(R" but an alternative one may be
optionally included as first argument. The config file format is
described below.
.PP
The following engine options may be specified on the command line.
.IP "\fB\-noini\fR" 4
.IX Item "-noini"
Do not use a config file, even if one was specified on the command line.
.IP "\fB\-pg\fR" 4
.IX Item "-pg"
The argument is a string of the form <name>=<value>. This option will
set the Polyglot option <name> to <value>.
.IP "\fB\-uci\fR" 4
.IX Item "-uci"
The argument is a string of the form <name>=<value>. This option will
set the engine option <name> to <value>.
.IP "\fB\-ec\fR" 4
.IX Item "-ec"
This is an alias for \-pg \*(L"EngineCommand=<value>\*(R"
.IP "\fB\-ed\fR" 4
.IX Item "-ed"
This is an alias for \-pg \*(L"EngineDir=<value>\*(R"
.IP "\fB\-en\fR" 4
.IX Item "-en"
This is an alias for \-pg \*(L"EngineName=<value>\*(R"
.IP "\fB\-log\fR (default: false)" 4
.IX Item "-log (default: false)"
This is an alias for \-pg \*(L"Log=<value>\*(R"
.ie n .IP "\fB\-lf\fR (default: ""polyglot.log"")" 4
.el .IP "\fB\-lf\fR (default: ``polyglot.log'')" 4
.IX Item "-lf (default: polyglot.log)"
This is an alias for \-pg \*(L"LogFile=<value>\*(R".
.ie n .IP "\fB\-wb\fR (default: ""true"")" 4
.el .IP "\fB\-wb\fR (default: ``true'')" 4
.IX Item "-wb (default: true)"
This is an alias for \-pg \*(L"OnlyWbOptions=<value>\*(R".
.PP
When invoked as
.SS "polyglot make-book"
.IX Subsection "polyglot make-book"
PolyGlot supports the following options
.ie n .IP "\fB\-pgn\fR (default: ""book.pgn"")" 4
.el .IP "\fB\-pgn\fR (default: ``book.pgn'')" 4
.IX Item "-pgn (default: book.pgn)"
Input file in pgn format.
.ie n .IP "\fB\-bin\fR (default: ""book.bin"")" 4
.el .IP "\fB\-bin\fR (default: ``book.bin'')" 4
.IX Item "-bin (default: book.bin)"
Output file in PolyGlot format.
.IP "\fB\-max\-ply\fR (default: 1024)" 4
.IX Item "-max-ply (default: 1024)"
Specifies the maximum ply-depth of lines included in the book.
.IP "\fB\-min\-game\fR (default: 3)" 4
.IX Item "-min-game (default: 3)"
Specifies the minimum number of games that have to contain this move for it to be included in the book.
.IP "\fB\-min\-score\fR (default: 0.0)" 4
.IX Item "-min-score (default: 0.0)"
Specifies the minimum score (or weight) this move should have received for 
it to  be included in the book. The score is 2*(wins)+(draws), globally scaled
to fit into 16 bits.
.IP "\fB\-only\-white\fR" 4
.IX Item "-only-white"
Include only moves for white in the book.
.IP "\fB\-only\-black\fR" 4
.IX Item "-only-black"
Include only moves for black in the book.
.IP "\fB\-uniform\fR" 4
.IX Item "-uniform"
Set all weights to 1. In other words, all moves will be selected with 
equal probability.
.PP
When invoked
as
.SS "polyglot merge-book"
.IX Subsection "polyglot merge-book"
PolyGlot supports the following options
.IP "\fB\-in1\fR" 4
.IX Item "-in1"
First input file (in PolyGlot book format).
.IP "\fB\-in2\fR" 4
.IX Item "-in2"
Second input file (in PolyGlot book format).
.IP "\fB\-out\fR (default: out.bin)" 4
.IX Item "-out (default: out.bin)"
Output file (in PolyGlot book format).
.PP
Input files are not symmetrical, \*(L"in1\*(R" has priority over \*(L"in2\*(R". In other
words when a position occurs both in \*(L"in1\*(R" and \*(L"in2\*(R" only the
moves and weights from \*(L"in1\*(R" will be retained in \*(L"out\*(R".
.PP
When invoked
as
.SS "polyglot dump-book"
.IX Subsection "polyglot dump-book"
PolyGlot supports the following options
.IP "\fB\-bin\fR (default: book.bin)" 4
.IX Item "-bin (default: book.bin)"
Input file in PolyGlot book format.
.IP "\fB\-color\fR" 4
.IX Item "-color"
The color for whom to generate the lines.
.IP "\fB\-out\fR (default: book_<color>.txt)" 4
.IX Item "-out (default: book_<color>.txt)"
The name of the output file.
.PP
When invoked
as
.SS "polyglot info-book"
.IX Subsection "polyglot info-book"
PolyGlot supports the following options
.IP "\fB\-bin\fR (default: book.bin)" 4
.IX Item "-bin (default: book.bin)"
Input file in PolyGlot book format.
.IP "\fB\-exact\fR" 4
.IX Item "-exact"
Attempt to count the provably unreachable positions among the isolated ones.
Note that this takes a very long time.
.PP
When invoked as
.SS "polyglot epd-test"
.IX Subsection "polyglot epd-test"
(possibly with a config file as first argument) PolyGlot supports
besides the generic options described above the following additional
options.
.IP "\fB\-max\-depth\fR (default: 63)" 4
.IX Item "-max-depth (default: 63)"
Unconditionally stop the search when this depth has
been reached.
.IP "\fB\-max\-time\fR (default: 5.0)" 4
.IX Item "-max-time (default: 5.0)"
Unconditionally stop the seach after this amount of time.
.IP "\fB\-depth\-delta\fR (default: 3)" 4
.IX Item "-depth-delta (default: 3)"
Stop the search if the solution as been found and the best move has
been constant for this many depths, on condition that the mininal
depth and minimal time have been reached.
.IP "\fB\-min\-depth\fR (default: 8)" 4
.IX Item "-min-depth (default: 8)"
Minimal search depth when the search is stopped using \*(L"\-depth\-delta\*(R".
.IP "\fB\-min\-time\fR (default: 1.0)" 4
.IX Item "-min-time (default: 1.0)"
Minimal search time when the search is stopped using \*(L"\-depth\-delta\*(R".
.PP
When invoked as
.SS "polyglot perft"
.IX Subsection "polyglot perft"
PolyGlot supports the following
options
.IP "\fB\-fen\fR (default: starting position)" 4
.IX Item "-fen (default: starting position)"
Fen at which to start searching.
.IP "\fB\-max\-depth\fR (default: 1)" 4
.IX Item "-max-depth (default: 1)"
Maximum depth to search.
.SH "CONFIG FILE FORMAT"
.IX Header "CONFIG FILE FORMAT"
There should be a different config file for each engine.
.PP
The config file is in the traditional \s-1INI\s0 format.
.PP
.Vb 6
\&    [PolyGLot]
\&    option = value
\&    ...
\&    [Engine]
\&    option = value
\&    ...
.Ve
.PP
The characters \*(L"#\*(R" and \*(L";\*(R" serve as comment characters.
.PP
Initial and final white space is stripped from option names and
values. If you need to use characters which have a special meaning to
PolyGlot (these are ';#[]=\e') you should quote them by preceding them
with '\e'. \*(L"Quoting\*(R" other characters in this way has no effect. In
particular the use of '\e' as a path separator in windows should
normally not affected.
.SS "[PolyGlot] section"
.IX Subsection "[PolyGlot] section"
This section is used by PolyGlot only.  The engine is unaware of these
options.  The list of available options is detailed below.
.IP "\fBEngineName\fR (default: \s-1UCI\s0 name)" 4
.IX Item "EngineName (default: UCI name)"
This is the name that will appear in the \s-1GUI\s0.  It is
cosmetic only.  You can use different names for tweaked versions of
the same engine.
.ie n .IP "\fBEngineDir\fR (default: ""."")" 4
.el .IP "\fBEngineDir\fR (default: ``.'')" 4
.IX Item "EngineDir (default: .)"
Full path of the directory where the engine is installed.  You can use
\&\*(L".\*(R" (without the quotes) if you know that PolyGlot will be launched in
the engine directory or the engine is in the \*(L"path\*(R" and does not need
any data file.
.IP "\fBEngineCommand\fR" 4
.IX Item "EngineCommand"
Put here the name of the engine executable file.  You can also add
command-line arguments.  Path searching is used and the current
directory will be \*(L"EngineDir\*(R". On Linux the EngineCommand is passed
to wordexp so that shell quoting rules and expansions are applied.
On Windows the EngineCommand is simply passed to CreateProcess which
does its own shell like processing.
.ie n .IP "\fBSettingsDir\fR (default: $HOME/.polyglot on Linux; "".\e_PG"" on Windows)" 4
.el .IP "\fBSettingsDir\fR (default: \f(CW$HOME\fR/.polyglot on Linux; ``.\e_PG'' on Windows)" 4
.IX Item "SettingsDir (default: $HOME/.polyglot on Linux; ._PG on Windows)"
The directory where ini files are stored for engines that are started with
\&\-noini. Such ini files may be created by pushing the \*(L"Save\*(R" button in the
Engine settings dialog in \s-1WB/XB\s0 4.4.0 and higher. As a special exception
(for \s-1WB/XB\s0 4.4.0 compatibility) this directory is also used in case
PolyGlot is started with config files named \*(L"polyglot_1st.ini\*(R" or
\&\*(L"polyglot_2nd.ini\*(R".
.IP "\fBLog\fR (default: false)" 4
.IX Item "Log (default: false)"
Whether PolyGlot should log all transactions with the interface and
the engine.  This should be necessary only to locate problems.
.IP "\fBLogFile\fR (default: polyglot.log)" 4
.IX Item "LogFile (default: polyglot.log)"
The name of the log file.  Note that it is put where PolyGlot was
launched from, not into the engine directory.
.Sp
\&\s-1WARNING:\s0 Log files are not cleared between sessions, and can become
very large.  It is safe to remove them though.
.IP "\fBResign\fR (default: false)" 4
.IX Item "Resign (default: false)"
Set this to \*(L"true\*(R" if you want PolyGlot to resign on behalf of the
engine.
.Sp
\&\s-1NOTE:\s0 Some engines display buggy scores from time to time although the
best move is correct.  Use this option only if you know what you are
doing (e.g. you always check the final position of games).
.IP "\fBResignMoves\fR (default: 3)" 4
.IX Item "ResignMoves (default: 3)"
Number of consecutive moves with \*(L"resign\*(R" score (see below) before
PolyGlot resigns for the engine.  Positions with only one legal move
are ignored.
.IP "\fBResignScore\fR (default: 600)" 4
.IX Item "ResignScore (default: 600)"
This is the score in centipawns that will trigger resign \*(L"counting\*(R".
.IP "\fBShowPonder\fR (default: true)" 4
.IX Item "ShowPonder (default: true)"
Show search information during engine pondering.  Turning this off
might be better for interactive use in some interfaces.
.IP "\fBScoreWhite\fR (default: true)" 4
.IX Item "ScoreWhite (default: true)"
Report score from white's point of view in xboard mode.
.IP "\fBKibitzMove\fR (default: false)" 4
.IX Item "KibitzMove (default: false)"
Whether to kibitz when playing a move.
.IP "\fBKibitzPV\fR (default: false)" 4
.IX Item "KibitzPV (default: false)"
Whether to kibitz when the \s-1PV\s0 is changed (new iteration or new best move).
.ie n .IP "\fBKibitzCommand\fR (default: ""tellall"")" 4
.el .IP "\fBKibitzCommand\fR (default: ``tellall'')" 4
.IX Item "KibitzCommand (default: tellall)"
xboard command to use for kibitzing, normally \*(L"tellall\*(R" for kibitzing
or \*(L"tellothers\*(R" for whispering.
.IP "\fBKibitzDelay\fR (default: 5)" 4
.IX Item "KibitzDelay (default: 5)"
How many seconds to wait before starting kibitzing.  This has an
effect only if \*(L"KibitzPV\*(R" is selected, move kibitzes are always sent
regardless of the delay.
.IP "\fBKibitzInterval\fR (default: 0)" 4
.IX Item "KibitzInterval (default: 0)"
This is another form of throttling. PolyGlot will usually wait this
many seconds before doing the next kibitz.
.IP "\fB\s-1UCI\s0\fR (default: false)" 4
.IX Item "UCI (default: false)"
If true PolyGlot will not understand xboard commands.
.IP "\fBMateScore\fR (default: 10000)" 4
.IX Item "MateScore (default: 10000)"
Mate score reported to \s-1GUI\s0 when in xboard mode.
.IP "\fBBook\fR (default: false)" 4
.IX Item "Book (default: false)"
Indicates whether a PolyGlot book should be used.  This has no effect
on the engine own book (which can be controlled with the \s-1UCI\s0 option
\&\*(L"OwnBook\*(R" in the [Engine] section).  In particular, it is possible to
use both a PolyGlot book and an engine book.  In that case, the engine
book will be used whenever PolyGlot is out of book.  Remember that
PolyGlot is unaware of whether the engine is itself using a book or
not.
.IP "\fBBookFile\fR (default: book.bin)" 4
.IX Item "BookFile (default: book.bin)"
The name of the (binary) book file.  Note that PolyGlot will look for
it in the directory it was launched from, not in the engine directory.
Of course, full path can be used in which case the current directory
does not matter.
.IP "\fBBookRandom\fR (default: true)" 4
.IX Item "BookRandom (default: true)"
Select moves according to their weights in the book. If false the move
with the highest weight is selected.
.IP "\fBBookLearn\fR (default: false)" 4
.IX Item "BookLearn (default: false)"
Store learning information in the book (which must be writable). Currently
no engine actually uses this information.
.IP "\fBBookDepth\fR (default: 256)" 4
.IX Item "BookDepth (default: 256)"
Stop using the book after this number of moves.
.IP "\fBBookTreshold\fR (default: 5)" 4
.IX Item "BookTreshold (default: 5)"
Do not play moves with a weight (probability) lower than this (in per mil).
.IP "\fBUseNice\fR (default: false)" 4
.IX Item "UseNice (default: false)"
Run the engine at nice level 5, or \*(L"NiceValue\*(R" if it set.  On some
operating systems it may be necessary to run the engine at lower
priority for it to be responsive to commands from PolyGlot while
searching.
.IP "\fBNiceValue\fR (default: 5)" 4
.IX Item "NiceValue (default: 5)"
Nice levels go from \-20 to 20 with 20 being the lowest priority.
On Unix only root can set negative nice levels. On Windows the standard
Win32 priority levels are mapped in a sensible way to Unix nice levels.
.IP "\fBAffinity\fR (default: \-1)" 4
.IX Item "Affinity (default: -1)"
This a bit vector in which each bit represents the processors that a
process is allowed to run on. This option works only on Windows.
.IP "\fBOnlyWbOptions\fR (default: true)" 4
.IX Item "OnlyWbOptions (default: true)"
If true then PolyGlot restricts the options it sends to those that
are potentially useful for WinBoard.
.SS "Work arounds"
.IX Subsection "Work arounds"
Work arounds are identical to options except that they should be used
only when necessary.  Their purpose is to try to hide problems with
various software (not just engines).
.PP
\&\s-1IMPORTANT:\s0 Any of these work arounds might be removed in future
versions of PolyGlot.  You are strongly recommended to contact the
author of faulty software and truly fix the problem.
.PP
PolyGlot supports the following work arounds:
.IP "\fBUCIVersion\fR (default: 2)" 4
.IX Item "UCIVersion (default: 2)"
The default value of 2 corresponds to \s-1UCI+\s0.  Use 1 to select plain
\&\s-1UCI\s0 for engines that have problems with \s-1UCI+\s0.
.IP "\fBCanPonder\fR (default: false)" 4
.IX Item "CanPonder (default: false)"
PolyGlot now conforms to the documented \s-1UCI\s0 behaviour: the engine will
be allowed to ponder only if it (the engine) declares the \*(L"Ponder\*(R" \s-1UCI\s0
option.  However some engines which can actually ponder do not declare
the option.  This work around lets PolyGlot know that they can ponder.
.IP "\fBSyncStop\fR (default: false)" 4
.IX Item "SyncStop (default: false)"
When a ponder miss occurs, Polyglot interrupts the engine and
\&\s-1IMMEDIATELY\s0 launches a new search.  While there should be no problem
with this, some engines seem confused and corrupt their search board.
\&\*(L"SyncStop\*(R" forces PolyGlot to wait for the (now useless) ponder search
to finish before launching the new search.
.IP "\fBPromoteWorkAround\fR (default: false)" 4
.IX Item "PromoteWorkAround (default: false)"
Some engines do not specify a promotion piece, e.g. they send \*(L"e7e8\*(R"
instead of the correct \*(L"e7e8q\*(R".  This work around enables the
incorrect form (and of course promotes into a queen).
.IP "\fBRepeatPV\fR (default: true)" 4
.IX Item "RepeatPV (default: true)"
When true, PolyGlot repeats the last pv string (which also contains
score,depth and time usage) it got from the engine. Some engines
however do not send a new pv string just before sending the move.
In that case the output of PolyGlot would be inconsistent. 
When RepeatPV is false PolyGlot does not repeat the last pv string.
Due to the way kibitzing is implemented, KibitzMove is disabled in that case.
.SS "[Engine] section"
.IX Subsection "[Engine] section"
This section contains engine \s-1UCI\s0 options.  PolyGlot does not
understand them, but sends the information to the engine at startup
(converted to \s-1UCI\s0 form).  You can add any \s-1UCI\s0 option that makes sense
to the engine (not just the common options about hash-table size and
tablebases).
.PP
\&\s-1NOTE:\s0 use \s-1INI\s0 syntax, not \s-1UCI\s0.  For example \*(L"OwnBook = true\*(R" is
correct.  It will be replaced by PolyGlot with \*(L"setoption name OwnBook
value true\*(R" at engine startup.
.PP
Standard \s-1UCI\s0 options are
.PP
.Vb 4
\&    Hash 
\&    NalimovPath
\&    NalimovCache
\&    OwnBook
.Ve
.PP
Hidden options like \*(L"Ponder\*(R" or \*(L"UCI_xxx\*(R" are automatic
and should not be put in an \s-1INI\s0 file.
.PP
The other options are engine-specific.  Check their name using a \s-1UCI\s0
\&\s-1GUI\s0 or launch the engine in a console and type \*(L"uci\*(R".
.SH "EXAMPLES"
.IX Header "EXAMPLES"
Running the \s-1UCI\s0 engine \*(L"fruit\*(R" under xboard 4.3.15 and later (this invokes PolyGlot internally).
.PP
.Vb 1
\&    xboard \-fcp fruit \-fUCI
.Ve
.PP
An explicit command line for using the \s-1UCI\s0 engine \*(L"fruit\*(R" with logging enabled (this works also with older versions of xboard).
.PP
.Vb 1
\&    xboard \-fcp "polyglot \-noini \-log true \-ec fruit"
.Ve
.PP
The equivalent config file would be:
.PP
.Vb 4
\&    [PolyGlot]
\&    EngineCommand = fruit
\&    Log = true
\&    [Engine]
.Ve
.PP
Compile \*(L"games.pgn\*(R" into a book \*(L"book.bin\*(R" retaining all lines of at
most 30 plies.
.PP
.Vb 1
\&    polyglot make\-book \-pgn games.pgn \-bin book.bin \-max\-ply 30
.Ve
.PP
Merge books \*(L"w1.bin\*(R" and \*(L"w2.bin\*(R" into a book \*(L"w.bin\*(R".
.PP
.Vb 1
\&    polyglot merge\-book \-in1 w1.bin \-in2 w2.bin \-out w.bin
.Ve
.PP
Inspect lines for white in \*(L"w.bin\*(R"
.PP
.Vb 1
\&    polyglot dump\-book \-bin w.bin \-color white \-out w_white.txt
.Ve
.PP
Test epd file \*(L"test.epd\*(R" with a (maximum) search time of 7 minutes per position
.PP
.Vb 1
\&    polyglot epd\-test \-epd test.epd \-max\-time 420
.Ve
.SH "EXIT STATUS"
.IX Header "EXIT STATUS"
PolyGlot always returns 0 on exit.
.SH "AUTHORS"
.IX Header "AUTHORS"
Main author: Fabien Letouzey<fabien_letouzey(at)hotmail.com>
.PP
Native Windows port:  Huang Chen<webmaster@elephantbase.net> (\*(L"Morning Yellow\*(R")
.PP
Various enhancements: Fonzy Bleumers<match(at)geenvis.net>
.PP
\&\s-1UCI\s0 port and implementation of new \s-1WB\s0 protocol: Michel Van den Bergh
<michel.vandenbergh(at)uhasselt.be>
.SH "SEE ALSO"
.IX Header "SEE ALSO"
\&\fIxboard\fR\|(6)
