""" /** Functions and Classes used in detecting instances of patterns

     */"""

from util import *
from gen import Player
from walk import instance2individuals
from specs import SPECIFIERS



############################### Classes and Instances #####################################


class Aggr:
    """ /** Aggr instances hold data on a set of classes that plays a role in a
         *  pattern's implementation
         *
         *   Parameters required for construction:
         *   @param label - role label used as index to aggregate of elements
         *   @param pattern - pattern recognizer
         *   @param elements - elements being gathered
         *   @author
         */
    """
    def __init__(self, label, pattern, elements):
        self.label = label
        self.elements = [Player(s, label, -1, pattern, elements[s], {}) \
                         for s in elements.keys()]

def make_aggr(label, pattern, lst):
    """ /**    An Aggr 'factory' """
    return Aggr(label, pattern, lst)

################ Internals to finder generation #########################

""" Next set of functions are used to create dictionaries whose keys
are classes and entries are sets of classes, methods, or locations"""

def collect_by_second (lst):
    """ /** a special utility that converts lists such as  [[a, x], [b, y], [c, y], [c, x]] to
                dictionary format with the second items as keys - {x : [a, c]],, y : [b,c]]]
         *   @author
         *
         *   @param lst - a list in the form shown above
         *
         *   @return dictionary format of list
         *
         */
    """
    ans = {}
    keys = seq2set([s[1] for s in lst])
    for s in lst:
        dict_put(ans, s[1], s[0])
    return ans

def next_classes_with_justifications (accessor_func, lstObj):
    """ Applies func to objs; returns a dictionary
    computed from a set of justifications (e.g., classes, methods, or locations) finds associated classes"""
    #return apply(accessor_func,[lstObj])
    return nodes_in(lstObj)


def nodes_in (lstClasses):
    """ /** dictionary where keys and values are the same class
         *   @author
         *
         *   @param lstClasses - a list  of ClassObjects
         *
         *   @return dictionary of Classes (same class as key and value)
         *
         */
    """
    # degenerate structure created to match returns of other accessors
    #key is item itself
    dict = {}
    for s in lstClasses:
        dict[s] = s
    return dict

#################### For spec composition operations ##############

def get_fillers(recogStr, roleStr):
    toreturn = []
    there = [x for x in SPECIFIERS if x.__name__ == recogStr]
    if len(there) == 0:
        print recogStr + " is not the name of a recognizer"
        return []
    else:
        s = there[0]
        pat = s.pattern
        roles = pat.participants
        if roleStr not in roles:
            print rolestr + " is not the name of a pattern participant"
            return []
        else:
            pos = roles.index(roleStr)
            individuals = []
            for x in PRGM.pattern_instances[recogStr]:
                toreturn  = toreturn + [y[pos] for y in instance2individuals(x)]
    return seq2set(toreturn)

######################### Utilities  #######################

def how_related (p1, p2):
    t1_out = [x.range for x in p1.out_edges]
    t2_in = [x.domain for x in p2.in_edges]
    return [y for y in t1_out if y in t2_in]



def neither_local (obj1, obj2):
    ans = not (obj1.is_local() or obj2.is_local())
    return ans

def reads_from (process):
    toreturn = []
    for item in process.in_edges:
        target = item.domain
        if the_type(target) == 'File':
            toreturn.append(target)
    return toreturn

def writes_to (process):
    toreturn = []
    for item in process.out_edges:
        target = item.range
        if the_type(target) == 'File' and item.action == 'write':
            toreturn.append(target)
    return toreturn

def execs (process):
    #processes executed by  any of its clones
    start = []
    clonings = [x.range for x in process.out_edges if x.action in ['activate', 'clone']]
    clones = setdiff([y.range for y in flatten([x.out_edges for x in clonings])], [process])
    for item in clones:
        start = start + item.executing
    return start
    
def dir2sc ():
    seen = {}
    for f in [x for x in resources_dict.values() if x.__class__.__name__ == 'File']:
        n = f.name
        st = f.security_context.split(':')[-1]
        path = n.split('/')[:-1]
        dir = ''
        for p in path:
            dir = dir + p + '/'
        if dir in seen.keys():
            seen[dir].append(st)
        else: seen[dir] = [st]
    for dir in seen.keys():
        seen[dir] = seq2set(seen[dir])
    return seen

def print_it (obj):
    """for debugging"""
    print obj
    return True

def processes_out (obj, action):
    toreturn = []
    for x in [y for y in obj.out_edges if y.action == action]: # x is a transition
        connector = x.range # connector is a Spawn or File
        
