#! /usr/bin/env python
import sys, os, os.path, re

env = {}
configFiles = ['config', 'spar']

def fetchSub(matchObject):
    global env
    var = matchObject.group(1)
    return env[var]

def configSubstitute(file):
    subPattern = re.compile("@(\w+)@")
    infile = file + ".py.in"
    outfile = file + ".py"
#    if file = 'spar':
#        outfile = 'spar'

    if (os.path.exists(outfile)):
        os.remove(outfile)

    f_in = open(infile, "r")
    f_out = open(outfile, "w")

    linesIn = f_in.readlines()

    linesOut = [re.sub(subPattern, fetchSub, line) for line in linesIn]

    f_out.writelines(linesOut)
    return

configDir = os.getcwd()
env['libdir'] = configDir

for file in configFiles:
    configSubstitute(file)
