/*
    Controller.h - Application controller header for Poe.app
    Copyright (C) 2003 Rob Burns

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02111, USA.
*/

#ifndef _CONTROLLER_H_
#define _CONTROLLER_H_

#include <Foundation/Foundation.h>
#include "OGGEditor.h"
#include "EditorWindowController.h"
#include "PreferencesWindowController.h"

@interface Controller : NSObject
{

}

- (void) openFile: (id) sender;
- (void) saveFile: (id) sender;
- (void) showInfo: (id) sender;
- (void) showPrefs: (id) sender;

- (void) addComment: (id) sender;
- (void) deleteComment: (id) sender;


// NSApplication delegate methods
//********************************

- (void) applicationWillFinishLaunching: (NSNotification *)not;
- (BOOL)application:(NSApplication*)application openFile:(NSString *)fileName;

@end

#endif // _CONTROLLER_H_

