# This file is released to the Public Domain by Moshe Zadka
# Author: Moshe Zadka <pms@zadka.site.co.il>
import Configuration, Server, Folder, MailMessage, Log
import os, string, re, poplib
from cStringIO import StringIO

def _parse_lines(lines):
	fp = StringIO()
	for line in lines:
		fp.write(line+'\n')
	fp.seek(0)
	return MailMessage.parse(fp)

class POP3Server(Server.Server):

	def __init__(self, name, host, port, user, pass_):
		Log.log("initializing pop server", host, port, user, '*')
		self.pop = poplib.POP3(host, port)
		Log.log("issuing user command", user)
		self.pop.user(user)
		Log.log("issuing pass command", '*')
		self.pop.pass_(pass_)
		Log.log("logged in")

	def __getattr__(self, name):
		if name != "indices":
			raise AttributeError(name)
		Log.log("getting indices")
		self.indices = {}
		response, list, octets = self.pop.uidl()
		Log.log("got indices")
		for (index, uid) in map(string.split, list):
			Log.log(uid, "->", index)
			self.indices[uid] = index
		return self.indices
	
        def get_message(self, folder, uid):
		Log.log("get message", uid, "from", folder)
		return _parse_lines(self.pop.retr(self.indices[uid])[1])

	def get_header(self, folder, uid):
		Log.log("get headers of", uid, "from", folder)
		return _parse_lines(self.pop.top(self.indices[uid], 0)[1])
		
        def remove_message(self, folder, uid):
		Log.log("remove", uid, "from", folder)
		self.pop.dele(self.indices[uid])

        def get_list(self, folder):
		Log.log("get list of messages from", folder)
		return self.indices.keys()

        def get_subfolders(self, folder):
		Log.log("get list of subfolders")
		return []
