# This file is released to the Public Domain by Moshe Zadka
# Author: Moshe Zadka <pms@zadka.site.co.il>
import syslog, string


class FileLogger:

	def __init__(self, file):
		self.file = file

	def log(self, *args):
		self.file.write(string.join(map(str, args))+'\n')

def log_syslog(self, *args):
	syslog.syslog(syslog.LOG_INFO, string.join(map(str, args)))

def log(*args):
	pass

def log_to_file(name):
	global log
	fp = open(name, 'a')
	log = FileLogger(fp).log

def log_to_stdout():
	global log
	import sys
	log = FileLogger(sys.stdout).log
	
def log_to_stderr():
	global log
	import sys
	log = FileLogger(sys.stderr).log

def log_to_syslog():
	global log
	syslog.openlog("pms")
	log = log_syslog

def stop_log():
	global log
	log = lambda *args: None
