# This file is released to the Public Domain by Moshe Zadka
# Author: Moshe Zadka <pms@zadka.site.co.il>
import Log

class NoSuchMessageError(Exception):
	pass

class AbstractFolder:

	def __init__(self):
		Log.log("initializing AbstractFolder")
		self.index = 0
		self._uid = None

	def _set_uid(self):
		Log.log("setting uid")
		try:
			self._uid = self.messages[self.index]
			Log.log("set uid to", self._uid)
		except IndexError:
			Log.log(self.index, "invalid, setting uid to None")
			self._uid = None

	def resync(self):
		Log.log("resyncing")
		Log.log("deleting .messages attribute")
		try:
			del self.messages
		except AttributeError:
			Log.log("no .messages attribute")
			pass
		Log.log("deleting .messages attribute")
		try:
			del self.folders
		except AttributeError:
			Log.log("no .messages attribute")
			pass
		Log.log("trying to resync index of", self._uid)
		try:
			self.index = self.messages.index(self._uid)
		except ValueError:
			Log.log("uid does not appear, resetting uid")
			self._set_uid()

	def __getattr__(self, name):
		if name == 'messages':
			Log.log("getting messages")
			self.messages = self._get_messages()
			return self.messages
		if name == 'folders':
			Log.log("getting folders")
			self.folders = self._get_folders()
			return self.folders
		raise AttributeError(name)

	def get_uid(self, index=None):
		Log.log("getting uid corresponding to", index)
		if index is not None:
			Log.log(index, "is not None, returning it")
			return index
		try:
			Log.log("returning", self.index, "message")
			return self.messages[self.index]
		except IndexError:
			Log.log("current message invalid -- raising error")
			raise NoSuchMessageError, "no messages in folder"

	def remove_message(self, message):
		Log.log("removing", message)
		old_uid = self.get_uid()
		Log.log("saving old uid", old_uid)
		self._remove_message(message)
		Log.log("removed", message, "from storage")
		self.messages.remove(message)
		Log.log("removed", message, "from list of messages")
		if message == old_uid:
			Log.log("removed current message. reseting uid")
			self._set_uid()
		try:
			uid = self.get_uid()
			Log.log("got current uid", uid)
		except NoSuchMessageError:
			uid = None
		if uid is None:
			Log.log("no current message")
			if self.messages:
				Log.log(len(self.messages), "messages exist")
				self.index = len(self.messages) - 1
				Log.log("picked message", self.index)
				self._set_uid()
			else:
				Log.log("no messages, placing pointer at 0")
				self.index = 0
		
	def next(self):
		Log.log("moving to next message")
		if self.index+1 >= len(self.messages):
			Log.log("was at last message, raising error")
			raise NoSuchMessageError, "not that many messages"
		self.index = self.index+1
		Log.log("index is now", self.index)
		self._set_uid()

	def prev(self):
		Log.log("moving to previous message")
		if self.index-1 < 0:
			Log.log("was at first message, raising error")
			raise NoSuchMessageError, \
			      "no message before first message"
		self.index = self.index-1
		Log.log("index is now", self.index)
		self._set_uid()

	def set_index(self, i):
		Log.log("setting index to", i)
		if not 0 <= i < len(self.messages):
			Log.log(i, "invalid, raising error")
			raise NoSuchMessageError, "index out of bounds"
		self.index = i
		Log.log("index is now", self.index)
		self._set_uid()
