/*
 * $Id: uncompress.h,v 1.12 2001/07/18 20:01:37 nordstrom Exp $
 *
 * Viewer - a part of Plucker, the free off-line HTML viewer for PalmOS
 * Copyright (c) 1998-2001, Mark Ian Lillywhite and Michael Nordstrm
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __PLUCKER_UNCOMPRESS_H
#define __PLUCKER_UNCOMPRESS_H

#include "viewer.h"
#include "document.h"


/* Local record IDs in UncompressDB */
#define UNCOMPRESS_TEXT_ID       0
#define UNCOMPRESS_IMAGE_ID     1
#define UNCOMPRESS_SPECIAL_ID   2


Err CreateUncompressBuffer( void ) PLKRDB_SECTION;
void CloseUncompressBuffer( void ) PLKRDB_SECTION;
MemHandle GetUncompressTextHandle( void ) PLKRDB_SECTION;
MemHandle GetUncompressImageHandle( void ) PLKRDB_SECTION;
MemHandle UnDoc( Header* record ) PLKRDB_SECTION;
MemHandle UnZip( Header* record ) PLKRDB_SECTION;

MemHandle (*uncompressFunc) ( Header* );


#define Uncompress( record )  (*uncompressFunc)( record )

#endif
