/* 
 * $Id: session.c,v 1.25 2001/09/16 15:07:38 nordstrom Exp $
 *
 * Viewer - a part of Plucker, the free off-line HTML viewer for PalmOS
 * Copyright (c) 1998-2001, Mark Ian Lillywhite and Michael Nordstrm
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "const.h"
#include "debug.h"
#include "documentdata.h"
#include "history.h"
#include "session.h"


void InitSessionData( void ) PLKRDB_SECTION;
void SaveSessionData( void ) PLKRDB_SECTION;

static void HandleSessionData( Boolean init ) PLKRDB_SECTION;



/* Handle the session data */
static void HandleSessionData
    (
    Boolean init    /* if true initialize session data, otherwise
                       store session data */
    )
{
    MemHandle   handle;
    History*    sessionPtr;

    handle = NULL;
    if ( ReturnMetaHandle( SESSION_DATA_ID, 0, false, &handle ) != errNone ) {
        if ( init )
            InitHistory();
        return;
    }
    sessionPtr = (History*) MemHandleLock( handle );
    ErrFatalDisplayIf( sessionPtr == NULL, "InitSessionData: MemHandleLock failed" );

    if ( init )
        ReadHistory( sessionPtr );
    else
        SaveHistory( sessionPtr );

    MemHandleUnlock( handle );
}



/* Initialize the session data */
void InitSessionData( void )
{
    HandleSessionData( true );
}



/* Save the session data */
void SaveSessionData( void )
{
    HandleSessionData( false );
}
