#!/bin/bash

# ***********************************
# * Plex86 Empty Disk Image Utility *
# *                                 *
# *               by                *
# *                                 *
# *          Eric Laberge           *
# *                                 *
# *          v. 20011123            *
# ***********************************

MBR_DATA="`dirname $0`/mbrdata"

# *** Standard CHS, limit 504MB ***

MAX_C=1024
MAX_H=16
MAX_S=63

B_PER_S=512
MAX_SIZE=$(($MAX_C * $MAX_H * $MAX_S * $B_PER_S))

SPARSE=no
if [ "$1" = "-s" ]
then
    SPARSE=yes
    shift
fi

# $1 : File, $2 : Size

if [ -z $1 ] || [ -z $2 ] || [ `echo $2 | grep "[^0-9]" | wc -l` -gt 0 ]
then
  echo "Usage:"
  echo "$0 [-s] file size"
  echo "  -s   : Create sparse image"
  echo "  file : File name"
  echo "  size : Requested size (MB)"
  exit 1
fi

REQ_SIZE=$(($2 * 1024 * 1024))

if [ $REQ_SIZE -gt $MAX_SIZE ]
then
  echo "Warning: exceding 1024 cylinders barrier!"
fi

SIZE=$(($REQ_SIZE / $B_PER_S))
C=$(($SIZE / ($MAX_H * $MAX_S)))
H=$MAX_H
S=$MAX_S
BLOCKS=$(($C * $H * $S))
SIZE=$(($BLOCKS * $B_PER_S))

echo "Disk Geometry:"
echo "C: $C"
echo "H: $H"
echo "S: $S"
echo "Total size: $SIZE bytes"

if [ "$SPARSE" = "yes" ]
then
    dd if=/dev/zero of=$1 bs=$B_PER_S seek=$(($BLOCKS-1)) count=1 2> /dev/null
else
    dd if=/dev/zero of=$1 bs=$B_PER_S count=$BLOCKS 2> /dev/null
fi

if [ -e $MBR_DATA ]
then
  dd if=$MBR_DATA of=$1 bs=$B_PER_S count=1 conv=notrunc 2> /dev/null
  echo "Wrote master boot record from file $MBR_DATA"
fi

exit 0


