/*
 *  Copyright 2000 - Martin Garton
 *  SDL display handling for Bochs (and plex86 with the bochs plugin.)
 */

extern "C"
{
#include "SDL/SDL.h"
}
#include "bochs.h"
#include "font/vga.bitmap.h"

SDL_Surface *screen;
static unsigned mouse_button_state = 0;

Bit32u sdlkeyevent_to_bx_key(SDL_Event *ev)
{
switch(ev->key.keysym.sym)
  {
  case SDLK_LCTRL: return BX_KEY_CTRL_L; break; 
  case SDLK_LSHIFT: return BX_KEY_SHIFT_L; break; 
    
  case SDLK_F1: return BX_KEY_F1; break; 
  case SDLK_F2: return BX_KEY_F2; break; 
  case SDLK_F3: return BX_KEY_F3; break; 
  case SDLK_F4: return BX_KEY_F4; break; 
  case SDLK_F5: return BX_KEY_F5; break; 
  case SDLK_F6: return BX_KEY_F6; break; 
  case SDLK_F7: return BX_KEY_F7; break; 
  case SDLK_F8: return BX_KEY_F8; break; 
  case SDLK_F9: return BX_KEY_F9; break; 
  case SDLK_F10: return BX_KEY_F10; break; 
  case SDLK_F11: return BX_KEY_F11; break; 
  case SDLK_F12: return BX_KEY_F12; break; 
      
  case SDLK_RCTRL: return BX_KEY_CTRL_R; break; 
  case SDLK_RSHIFT: return BX_KEY_SHIFT_R; break; 
  case SDLK_CAPSLOCK: return BX_KEY_CAPS_LOCK; break; 
  case SDLK_NUMLOCK: return BX_KEY_NUM_LOCK; break;
  case SDLK_LALT: return BX_KEY_ALT_L; break; 
  case SDLK_RALT: return BX_KEY_ALT_R; break;  

  case SDLK_a: return BX_KEY_A; break; 
  case SDLK_b: return BX_KEY_B; break; 
  case SDLK_c: return BX_KEY_C; break; 
  case SDLK_d: return BX_KEY_D; break; 
  case SDLK_e: return BX_KEY_E; break;
  case SDLK_f: return BX_KEY_F; break;
  case SDLK_g: return BX_KEY_G; break;
  case SDLK_h: return BX_KEY_H; break;
  case SDLK_i: return BX_KEY_I; break;
  case SDLK_j: return BX_KEY_J; break;
  case SDLK_k: return BX_KEY_K; break; 
  case SDLK_l: return BX_KEY_L; break; 
  case SDLK_m: return BX_KEY_M; break; 
  case SDLK_n: return BX_KEY_N; break;
  case SDLK_o: return BX_KEY_O; break;
  case SDLK_p: return BX_KEY_P; break;
  case SDLK_q: return BX_KEY_Q; break;
  case SDLK_r: return BX_KEY_R; break;
  case SDLK_s: return BX_KEY_S; break;
  case SDLK_t: return BX_KEY_T; break;
  case SDLK_u: return BX_KEY_U; break;
  case SDLK_v: return BX_KEY_V; break;
  case SDLK_w: return BX_KEY_W; break;
  case SDLK_x: return BX_KEY_X; break;
  case SDLK_y: return BX_KEY_Y; break;
  case SDLK_z: return BX_KEY_Z; break;

  case SDLK_0: return BX_KEY_0; break;
  case SDLK_1: return BX_KEY_1; break;
  case SDLK_2: return BX_KEY_2; break;
  case SDLK_3: return BX_KEY_3; break;
  case SDLK_4: return BX_KEY_4; break;
  case SDLK_5: return BX_KEY_5; break;
  case SDLK_6: return BX_KEY_6; break;
  case SDLK_7: return BX_KEY_7; break;
  case SDLK_8: return BX_KEY_8; break;
  case SDLK_9: return BX_KEY_9; break;

  case SDLK_ESCAPE: return BX_KEY_ESC; break;
  case SDLK_SPACE: return BX_KEY_SPACE; break;
  case SDLK_QUOTE: return BX_KEY_SINGLE_QUOTE; break;
  case SDLK_COMMA: return BX_KEY_COMMA; break;
  case SDLK_PERIOD: return BX_KEY_PERIOD; break;
  case SDLK_SLASH: return BX_KEY_SLASH; break;
  case SDLK_SEMICOLON: return BX_KEY_SEMICOLON; break;
  case SDLK_EQUALS: return BX_KEY_EQUALS; break;
  case SDLK_LEFTBRACKET: return BX_KEY_LEFT_BRACKET; break; 
  case SDLK_BACKSLASH: return BX_KEY_BACKSLASH; break; 
  case SDLK_RIGHTBRACKET: return BX_KEY_RIGHT_BRACKET; break; 
  case SDLK_MINUS: return BX_KEY_MINUS; break;
  case SDLK_BACKQUOTE: return BX_KEY_GRAVE; break; // FIXME: is this right?
  case SDLK_BACKSPACE: return BX_KEY_BACKSPACE; break;
  case SDLK_RETURN: return BX_KEY_ENTER; break; 
  case SDLK_TAB: return BX_KEY_TAB; break;
  case SDLK_INSERT: return BX_KEY_INSERT; break;
  case SDLK_DELETE: return BX_KEY_DELETE; break;
  case SDLK_HOME: return BX_KEY_HOME; break;
  case SDLK_END: return BX_KEY_END; break;
  case SDLK_PAGEUP: return BX_KEY_PAGE_UP; break;
  case SDLK_PAGEDOWN: return BX_KEY_PAGE_DOWN; break;
  case SDLK_KP_PLUS: return BX_KEY_KP_ADD; break;
  case SDLK_KP_MINUS: return BX_KEY_KP_SUBTRACT; break;
  case SDLK_KP1: return BX_KEY_KP_END; break;
  case SDLK_KP2: return BX_KEY_KP_DOWN; break;
  case SDLK_KP3: return BX_KEY_KP_PAGE_DOWN; break;
  case SDLK_KP4: return BX_KEY_KP_LEFT; break;
  case SDLK_KP6: return BX_KEY_KP_RIGHT; break;
  case SDLK_KP7: return BX_KEY_KP_HOME; break;
  case SDLK_KP8: return BX_KEY_KP_UP; break;
  case SDLK_KP9: return BX_KEY_KP_PAGE_UP; break;
    //case FIXME: return BX_KEY_KP_INSERT; break;
    //case FIXME: return BX_KEY_KP_DELETE; break;
  case SDLK_KP5: return BX_KEY_KP_5; break;
  case SDLK_UP: return BX_KEY_UP; break;
  case SDLK_DOWN: return BX_KEY_DOWN; break;
  case SDLK_RIGHT: return BX_KEY_RIGHT; break;
  case SDLK_LEFT: return BX_KEY_LEFT; break;
  case SDLK_KP_ENTER: return BX_KEY_KP_ENTER; break;
  case SDLK_KP_MULTIPLY: return BX_KEY_KP_MULTIPLY; break;
  case SDLK_KP_DIVIDE: return BX_KEY_KP_DIVIDE; break;
    
  default:
    bx_printf("Unknown key pressed: %d %c\n",
	      ev->key.keysym.sym, ev->key.keysym.sym);
    return 0;
    break; 
  }
}

extern Bit8u graphics_snapshot[32 * 1024];

#define ROUNDUP(nbytes, pad) ((((nbytes) + ((pad)-1)) / (pad)) * ((pad)>>3))

SDL_Color colors[256]; // SDL colors
int ncolors=256;

unsigned curr_foreground, curr_background;

static unsigned x_tilesize, y_tilesize;

void bx_gui_c::specific_init (bx_gui_c * th, int argc, char **argv, unsigned tilewidth, unsigned tileheight,
	       unsigned headerbar_y)
{
  unsigned i;

  x_tilesize = tilewidth;
  y_tilesize = tileheight;

  /* Initialize the SDL library */                                  
  if ( SDL_Init(SDL_INIT_VIDEO) < 0 )
    {                             
      bx_panic ("Couldn't initialize SDL: %s\n", SDL_GetError());
    }                                                                  
  atexit(SDL_Quit);

  // Open the window.
  screen = SDL_SetVideoMode(640, 480, 8, 
			    SDL_SWSURFACE|SDL_ANYFORMAT);
  if ( screen == NULL ) 
    {                                             
      bx_panic("Couldn't set 640x480x8 video mode: %s\n", SDL_GetError());
    }

  // Set the window title.
  SDL_WM_SetCaption(argv[0], argv[0]);  
  //  SDL_GrabMode(SDL_GRAB_ON);
  SDL_ShowCursor(0);

  // set up SDL color palette 
  // Set a 3,3,2 color cube

  for (int r=0; r<8; ++r ) 
    {                                        
      for (int g=0; g<8; ++g ) 
	{
	  for (int b=0; b<4; ++b )
	    {                 
	      i = ((r<<5)|(g<<2)|b);          
	      colors[i].r = r<<5;               
	      colors[i].g = g<<5;         
	      colors[i].b = b<<6;           
	    }                                      
	}                                     
    } 
  SDL_SetColors(screen, colors, 0, 256);
}

//****************************************************************************
void bx_gui_c::handle_events (void)
{
  static int lsdown,lcdown;
  SDL_Event theevent;
  Bit32u key_event;
  
  if(SDL_PollEvent(&theevent))
    {
      
      switch(theevent.type)
	{
	case SDL_QUIT:
	  bx_printf("SDL quit event\n");
	  break;
	case SDL_MOUSEMOTION:
	  {
	    int dx;
	    int dy;
	    bx_printf("SDL mouse motion event\n");
	    dx = theevent.motion.xrel;
	    dy = -theevent.motion.yrel;
	    bx_devices.keyboard->mouse_motion(dx, dy, mouse_button_state);
	  }
	  break;
	case SDL_MOUSEBUTTONUP:
	  bx_printf("SDL mouse button up event\n");
	  switch(theevent.button.button)
	    {
	    case 1:
	      mouse_button_state &= ~0x01;
	    case 2:
	      mouse_button_state &= ~0x02;
	    case 3:
	      mouse_button_state &= ~0x03;
	    default:
	      bx_printf("Unknown SDL mouse button pressed\n");
	    }
	  bx_devices.keyboard->mouse_motion(0, 0, mouse_button_state);
	  break;
	case SDL_MOUSEBUTTONDOWN:
	  bx_printf("SDL mouse button down event\n");
	  
	  switch(theevent.button.button)
	    {
	    case 1:
	      mouse_button_state |= 0x01;
	    case 2:
	      mouse_button_state |= 0x02;
	    case 3:
	      mouse_button_state |= 0x03;
	    default:
	      bx_printf("Unknown SDL mouse button pressed");
	    }
	  bx_devices.keyboard->mouse_motion(0, 0, mouse_button_state);
	  break;
	
	case SDL_KEYDOWN:
	  key_event=sdlkeyevent_to_bx_key(&theevent);
	  
	  // if lctrl && lshift are pressed, do special things for
	  // certain keys.
	  
	  Uint8 *keys;          
	  keys = SDL_GetKeyState(NULL);
	  
	  if(keys[SDLK_LCTRL] && keys[SDLK_LSHIFT])
	    switch(key_event)
	      {
	      case BX_KEY_ENTER:
		SDL_WM_ToggleFullScreen(screen);
	      default:
		bx_devices.keyboard->gen_scancode (key_event);
	      }
	  else
	    bx_devices.keyboard->gen_scancode (key_event);
	  break;
	case SDL_KEYUP:
	  bx_printf("SDL keyup event\n");
	  key_event=sdlkeyevent_to_bx_key(&theevent);

	  bx_devices.keyboard->gen_scancode (key_event | BX_KEY_RELEASED);
	  
	  break;
	default:
	  bx_printf("some other SDL event happenned\n");
	}
    }
}

//****************************************************************************
void bx_gui_c::flush (void)
{
  // FIXME: write me. do we do anything here with SDL?
}

//****************************************************************************
void bx_gui_c::clear_screen (void)
{
  // FIXME: write me.
}

//****************************************************************************
void char_to_surface(SDL_Surface *screen,unsigned charnum, unsigned col,
		  unsigned row, Uint32 bg, Uint32 fg)
{
#define FONTX 8
#define FONTY 16
  
  unsigned y0,x0;
  unsigned pixel;
  Uint8 bpp, *bits;
  
  y0 = FONTY * row;
  x0 = FONTX * col; 	
  
  for (int y = 0; y < FONTY; y++)
    {
      for (int x = 0; x < FONTX; x++)
	{
	  //	  if(( fontdata_8x16[charnum*FONTY + y] << x ) & 128)
	  if(( bx_vgafont[charnum].data[y] >> x ) & 1)
	    pixel = fg;
	  else
	    pixel = bg;
	  
	  bpp = screen->format->BytesPerPixel;                   
	  bits = ((Uint8 *)screen->pixels)+(y+y0)*screen->pitch+(x+x0)*bpp;
	  
	  /* Set the pixel */                                
	  switch(bpp) {                                      
	  case 1:          
	    *((Uint8 *)(bits)) = (Uint8)pixel;
	    break;  
	  case 2:                                                 
	    *((Uint16 *)(bits)) = (Uint16)pixel;              
	    break;                                          
	  case 3: 
	    { /* Format/endian independent */
	      Uint8 r, g, b;
	      
	      r = (pixel>>screen->format->Rshift)&0xFF;       
	      g = (pixel>>screen->format->Gshift)&0xFF;              
	      b = (pixel>>screen->format->Bshift)&0xFF;      
	      *((bits)+screen->format->Rshift/8) = r;        
	      *((bits)+screen->format->Gshift/8) = g;
	      *((bits)+screen->format->Bshift/8) = b;            
	    }            
	    break;
	  case 4:
	    *((Uint32 *)(bits)) = (Uint32)pixel;
	    break;
	  }
	}
      
      
    }
  return;
} 

//****************************************************************************
void bx_gui_c::text_update (Bit8u * old_text, Bit8u * new_text,
			    unsigned long cursor_x, unsigned long cursor_y,
			    unsigned nrows)
{  
  Uint32   SDL_fg, SDL_bg, SDL_temp;
  unsigned y,x,charnum;
  unsigned new_fg, new_bg;
  
  if ( SDL_MUSTLOCK(screen) )
    {                                   
      if ( SDL_LockSurface(screen) < 0 )                       
	{
	  bx_printf("couldn't lock SDL screen\n");
	  return;
	}
    }      
  
  // Loop around all characters on the screen and draw them on our SDL
  // surface. FIXME: performance - don't do chars that haven't changed.
  
  for(x=0 ; x<80 ; x++)
    {
      for(y=0 ; y<nrows ; y++)
	{
	  
	  charnum = new_text[(y*80 + x) * 2];
	  new_fg = new_text[((y*80 + x) * 2) + 1] & 0x0f;
	  new_bg = (new_text[((y*80 + x) * 2)  + 1] & 0xf0) >> 4;
	  SDL_fg = SDL_MapRGB(screen->format, colors[new_fg].r,
			      colors[new_fg].g, colors[new_fg].b); 	  
	  SDL_bg = SDL_MapRGB(screen->format, colors[new_bg].r,
			      colors[new_bg].g, colors[new_bg].b); 	  
	  if(y==cursor_y && x==cursor_x)
	    { SDL_temp=SDL_bg ; SDL_bg=SDL_fg ; SDL_fg=SDL_temp; }
	  char_to_surface(screen,charnum,x,y,SDL_bg,SDL_fg);
	}
    }
  
  
  /* Update the display */
  if ( SDL_MUSTLOCK(screen) ) {
    SDL_UnlockSurface(screen);
  }
  SDL_UpdateRect(screen,0, 0, FONTX*80, FONTY*nrows);  
}

//****************************************************************************
void bx_gui_c::graphics_tile_update (Bit8u * tile, unsigned x0, unsigned y0)
{  
  
  // SDL stuff
  Uint32   pixel;
  Uint8   *bits, bpp;
  unsigned colornum; 
  Sint32 x ,y;
  
  if ( SDL_MUSTLOCK(screen) )
    {                                   
      if ( SDL_LockSurface(screen) < 0 )                       
	{
	  bx_printf("couldn't lock SDL screen\n");
	  return;
	}
    }      
  
  for (y = 0; y < y_tilesize; y++)
    {
      for (x = 0; x < x_tilesize; x++)
	{
	  colornum = tile[y * x_tilesize + x];
	  //	  color = col_vals[tile[y * x_tilesize + x]];
	  pixel = SDL_MapRGB(screen->format, colors[colornum].r, colors[colornum].g, colors[colornum].b); 	  
	  bpp = screen->format->BytesPerPixel;                   
	  bits = ((Uint8 *)screen->pixels)+(y+y0)*screen->pitch+(x+x0)*bpp;
	  
	  /* Set the pixel */                                
	  switch(bpp) {                                      
	  case 1:          
	    *((Uint8 *)(bits)) = (Uint8)pixel;
	    break;  
	  case 2:                                                 
	    *((Uint16 *)(bits)) = (Uint16)pixel;              
	    break;                                          
	  case 3: 
	    { /* Format/endian independent */
	      Uint8 r, g, b;
	      
	      r = (pixel>>screen->format->Rshift)&0xFF;       
	      g = (pixel>>screen->format->Gshift)&0xFF;              
	      b = (pixel>>screen->format->Bshift)&0xFF;      
	      *((bits)+screen->format->Rshift/8) = r;        
	      *((bits)+screen->format->Gshift/8) = g;
	      *((bits)+screen->format->Bshift/8) = b;            
	    }            
	    break;
	  case 4:
	    *((Uint32 *)(bits)) = (Uint32)pixel;
	    break;
	  }
	}
    }
  /* Update the display */
  if ( SDL_MUSTLOCK(screen) ) {
    SDL_UnlockSurface(screen);
  }
  SDL_UpdateRect(screen,x0, y0, x_tilesize, y_tilesize);
  
  return;  
}
  
//****************************************************************************
Boolean bx_gui_c::palette_change (unsigned index, unsigned red,
				  unsigned green, unsigned blue)
{
  bx_printf("REACHED: bx_gui_c::palette_change \n");
  
  colors[index].r=red;
  colors[index].g=green;
  colors[index].b=blue;
  SDL_SetColors(screen, colors, 0, ncolors);
  
  return(0); // 0 means no screen update needed. 1 means update reqd.
}

//****************************************************************************
void bx_gui_c::dimension_update (unsigned x, unsigned y)
{
  // FIXME: write me!

}
//****************************************************************************
void bx_gui_c::show_headerbar (void)
{

}
//****************************************************************************
unsigned bx_gui_c::create_bitmap (const unsigned char *bmap, unsigned xdim, unsigned ydim)
{
  return(0); 
}
//****************************************************************************
unsigned bx_gui_c::headerbar_bitmap (unsigned bmap_id, unsigned alignment, void (*f) (void))
{
return(0);
}
//****************************************************************************
void  bx_gui_c::replace_bitmap (unsigned hbar_id, unsigned bmap_id)
{

}
//****************************************************************************
void
  bx_gui_c::exit (void)
{
  SDL_Quit();
  // FIXME: is this enough/required?
}
//****************************************************************************


