/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.resource;


/**
 * 翻訳辞書クラスのヘルプ・テスト・クラスです。
 * <p>
 * @author cypher256
 */
public class TranslationDictionaryHelpTestX extends TranslationDictionaryTest {

	/** assertLookupHelp */
	protected void assertLookupHelp(String input, String expected) {

		TranslationResult result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals(expected, result.getValue());
		assertEquals(true, result.isFound());
	}

	//-------------------------------------------------------------------------

	/** テスト */
	public void testHelp() {

		// 句点分割 ()
		assertLookupHelp(
			"When active, completion doesn't show that you can not see (e.g. you can not see private methods of a super class).",
			"アクティブ時に、完了は不可視であるものを表示しません (例えば、スーパー・クラスの private メソッドを見ることはできません)。");

		// ヘルプ・ロード後
		super.testLookup();
		super.testLookupIgnoreMnemonic();
	}
}
