/*
  Plee the Bear

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file action_file_player.hpp
 * \brief An item that send actions to a player.
 * \author Sbastien Angibaud
 */
#ifndef __PTB_ACTION_FILE_PLAYER_HPP__
#define __PTB_ACTION_FILE_PLAYER_HPP__

#include "ptb/player_action.hpp"
#include "universe/derived_item_handle.hpp"
#include "ptb/item/plee/plee.hpp"
#include "engine/resource_pool.hpp"

#include <map>
#include <list>
#include <set>
#include <fstream>

namespace ptb
{
  /**
   * \brief An item that send actions to a player.
   *
   * This item send the actions of a file.
   *
   * The valid fields for this item are
   *  - \a file_path: (string) [required] The path to the file in which the
   *    actions are saved,
   *  - any field supported by the parent classes.
   *
   * \author Sbastien Angibaud
   */
  class action_file_player 
  {
  private:
    /** \brief The current actions of a given player. */
    typedef std::map<player_action::value_type, bear::universe::time_type>
    current_actions_map;

  private:
    /** \brief A class to store action informations. */
    struct action_information
    {
      /** \brief The date of the action. */
      bear::universe::time_type date;

      /** \brief The name of the action. */
      player_action::value_type action;

      /** \brief The duration of the action. */
      bear::universe::time_type duration;

      /** \brief The speech that Plee says. */
      std::string speech;

    }; // struct action_information 

    /** \brief All actions of a given player. */
    typedef std::list<action_information> actions_list;
        
  public:
    action_file_player();
    action_file_player( const action_file_player& that );

    void build();
       
    void set_action_file
    (bear::engine::resource_pool& resources, const std::string& filename);
    void set_player_index(unsigned int index);
    unsigned int get_player_index() const;

    bool is_valid() const;
    void progress_action_file
    ( bear::engine::level_globals& glob, 
      bear::universe::time_type elapsed_time );
    bear::universe::derived_item_handle_maker<plee>::handle_type& get_player();

  private:
    void search_player(bear::engine::level_globals& glob);
    void start_actions(std::set<player_action::value_type>& new_actions);

  protected:
    virtual void set_marionette(bool b);
    virtual void finish();

  private:
    /** \brief The current date. */
    bear::universe::time_type m_date;

    /** \brief The current actions to do. */
    current_actions_map m_current_actions;

    /** \brief All actions of a given player. */
    actions_list m_actions;

    /** \brief The index of the player to control. */
    unsigned int m_player_index;

    /** \brief The player to control. */
    bear::universe::derived_item_handle_maker<plee>::handle_type m_player;

  }; // class action_file_player
} // namespace ptb

#endif // __PTB_ACTION_FILE_PLAYER_HPP__
