/*
    Bear Engine - Model editor

    Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file bf/model_editor.hpp
 * \brief The class representing the application.
 * \author Julien Jorge
 */
#ifndef __BF_MODEL_EDITOR_HPP__
#define __BF_MODEL_EDITOR_HPP__

#include <wx/app.h>

namespace bf
{
  class main_frame;
  class model;

  /**
   * \brief The class representing the application.
   * \author Julien Jorge
   */
  class model_editor:
    public wxApp
  {
  public:
    model_editor();
    ~model_editor();

    virtual bool OnInit();

  private:
    void init_app();
    bool compile_arguments();
    bool check_model( const model& mdl );
    bool compile_model( const model& mdl, const wxString& path );
    bool show_help();
    bool show_version();
    bool find_and_erase_option
    ( const wxString& long_name, const wxString& short_name );

  private:
    /** \brief The locale, for internationalization. */
    wxLocale m_locale;

    /** \brief The main window of our program. */
    main_frame* m_main_frame;

  }; // class model_editor
} // namespace bf

#endif // __BF_MODEL_EDITOR_HPP__
