/*
  Bear Engine

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file item_handle.hpp
 * \brief Safe way to point an item that could die between two uses.
 * \author Julien Jorge
 */
#ifndef __UNIVERSE_ITEM_HANDLE_HPP__
#define __UNIVERSE_ITEM_HANDLE_HPP__

namespace bear
{
  namespace universe
  {
    /**
     * \brief Safe way to point an item that could die between two uses.
     * \author Julien Jorge
     */
    template<typename ItemType>
    class base_item_handle
    {
    public:
      typedef base_item_handle<ItemType> self_type;

    public:
      base_item_handle();
      base_item_handle( ItemType* item );
      base_item_handle( ItemType& item );
      base_item_handle( const self_type& that );
      ~base_item_handle();

      ItemType* get() const;

      ItemType& operator*() const;
      ItemType* operator->() const;

      self_type& operator=( ItemType* item );
      self_type& operator=( const self_type& that );

      bool operator==( const ItemType* item ) const;
      bool operator==( const self_type& that ) const;
      bool operator!=( const ItemType* item ) const;
      bool operator!=( const self_type& that ) const;
      bool operator<( const self_type& that ) const;

    private:
      /** \brief The critical item. */
      ItemType* m_item;

    }; // class base_item_handle

    class physical_item;

    typedef base_item_handle<physical_item> item_handle;
    typedef base_item_handle<const physical_item> const_item_handle;

  } // namespace universe
} // namespace bear

#include "universe/impl/item_handle.tpp"

#endif // __UNIVERSE_ITEM_HANDLE_HPP__
