#! /usr/bin/perl -w

use strict;
use warnings;

use CGI;

use DBI;

use Classes::User;

package main;

require 'Functions/config.pl';
require 'Functions/db.pl';
require 'Functions/parser.pl';
require 'Functions/web.pl';
require 'Functions/encode.pl';

require 'Functions/_AlertDetails.pl';
require 'Functions/Filtered_Links.pl';

require 'Functions/packet.pl';
require 'Functions/Name_Resolution.pl';
require 'Functions/FakeFunctions.pl';

our $CurUser = User->new()->auth();

our %conf = ();	# configuration directives
our $cgi = '';	# CGI data

LoadConfig();

print "Pragma: no-cache\n";
print "Expires: -1\n";
print "Cache-Control: no-cache\n";
print "Content-Type: text/html\n\n";

  # Open the DB connection :
our $dbh = DB_Open();

  # Import CGI parameters :
$cgi = CGI->new();

our $PageTitle = " - Alert's Details (Standard)";
ParseComponent( 'CommonHeader' );
ParseComponent( 'Links' );

our $AlertId = int( $cgi->param( 'id' ) );

ParseComponent( 'AlertDetails' );
ParseComponent( 'CommonFooter' );
