/* Generated from "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod" by precompile.pike running Pike v7.8 release 866
 *
 * Do NOT edit this file.
 */

#undef PRECOMPILE_API_VERSION
#define PRECOMPILE_API_VERSION 3

#undef PRECOMPILE_SUB_PIKEVARS
#define PRECOMPILE_SUB_PIKEVARS 1

#undef PRECOMPILE_DYNAMIC_TYPES
#define PRECOMPILE_DYNAMIC_TYPES 1


#line 1 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
/* vim:syntax=c
 */
/* -*- c -*-
|| This file is part of Pike. For copyright information see COPYRIGHT.
|| Pike is distributed under GPL, LGPL and MPL. See the file COPYING
|| for more information.
*/

/* Module for the linux inotify api.
 *
 * Ref: inotify(7)
 *
 */

#include "inotify_config.h"

#include "global.h"
#include "interpret.h"
#include "module.h"
#include "program.h"
#include "stralloc.h"
#include "svalue.h"
#include "object.h"
#include "pike_types.h"
#include "builtin_functions.h"
#include "fdlib.h"
#include "fd_control.h"
#include "pike_threadlib.h"

#ifdef HAVE_SYS_INOTIFY_H

#include <sys/inotify.h>
#include <errno.h>
#include <unistd.h>

/* Autoconf helpfully litters generated files with colliding defines. */
#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_URL
#undef PACKAGE_VERSION

#include "modules/_Stdio/file_machine.h"
#include "modules/_Stdio/file.h"



#ifndef PIKE_UNUSED_ATTRIBUTE
#define PIKE_UNUSED_ATTRIBUTE
#endif
#define CMOD_MAP_PROGRAM_IDS_DEFINED 1
static int ___cmod_map_program_ids(int id) PIKE_UNUSED_ATTRIBUTE;
#ifndef TYPEOF
/* Compat with older Pikes. */
#define TYPEOF(SVAL)	((SVAL).type)
#define SUBTYPEOF(SVAL)	((SVAL).subtype)
#define SET_SVAL_TYPE(SVAL, TYPE)	(TYPEOF(SVAL) = TYPE)
#define SET_SVAL_SUBTYPE(SVAL, TYPE)	(SUBTYPEOF(SVAL) = TYPE)
#define SET_SVAL(SVAL, TYPE, SUBTYPE, FIELD, EXPR) do {	\
    /* Set the type afterwards to avoid a clobbered	\
     * svalue in case EXPR throws. */			\
    (SVAL).u.FIELD = (EXPR);				\
    SET_SVAL_TYPE((SVAL), (TYPE));			\
    SET_SVAL_SUBTYPE((SVAL), (SUBTYPE));		\
  } while(0)
#endif /* !TYPEOF */
#ifndef PIKE_UNUSED
/* Compat with Pike 7.8 and earlier. */
/* NB: Not strictly correct; PIKE_UNUSED was added the
 *     day after set_program_id_to_id(), but good enough.
 */
#ifndef UNUSED
#define UNUSED(X)	X
#endif
#ifndef set_program_id_to_id
/* NB: Recent Pike 7.8 has a #define that conflicts with
 *     the following declaration.
 */
static void set_program_id_to_id(void*UNUSED(id)){}
#endif
#else /* */
PMOD_EXPORT void set_program_id_to_id( int (*to)(int) );
#endif /* !PIKE_UNUSED */


#ifndef DEFAULT_CMOD_STORAGE
#define CMOD_COND_USED
#define DEFAULT_CMOD_STORAGE static
#endif
#define module_strings_declared
static struct pike_string *module_strings[1] = {
  NULL,
};
#ifndef CMOD_COND_USED
# define f_Inotify_cq__Instance_poll_fun_num_used 1
#else
#define f_Inotify_cq__Instance_poll_fun_num_used 1
#endif
#ifndef CMOD_COND_USED
# define f_Inotify_cq__Instance_get_event_callback_fun_num_used 1
#else
#undef f_Inotify_cq__Instance_get_event_callback_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Inotify_cq__Instance_set_event_callback_fun_num_used 1
#else
#undef f_Inotify_cq__Instance_set_event_callback_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Inotify_cq__Instance_query_fd_fun_num_used 1
#else
#undef f_Inotify_cq__Instance_query_fd_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Inotify_cq__Instance_rm_watch_fun_num_used 1
#else
#undef f_Inotify_cq__Instance_rm_watch_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Inotify_cq__Instance_set_nonblocking_fun_num_used 1
#else
#undef f_Inotify_cq__Instance_set_nonblocking_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Inotify_cq__Instance_set_blocking_fun_num_used 1
#else
#undef f_Inotify_cq__Instance_set_blocking_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Inotify_cq__Instance_add_watch_fun_num_used 1
#else
#undef f_Inotify_cq__Instance_add_watch_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Inotify_cq__Instance_set_backend_fun_num_used 1
#else
#undef f_Inotify_cq__Instance_set_backend_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Inotify_parse_event_fun_num_used 1
#else
#undef f_Inotify_parse_event_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define Inotify_cq__Instance_program_fun_num_used 1
#else
#undef Inotify_cq__Instance_program_fun_num_used
#endif
/*! @module System */

/*! @module Inotify
 *! This module implements an API to linux inotify. It is available on all
 *! kernels from version 2.6.13 onwards. Inotify offers fast and scalable file
 *! notifications.
 */

/*! @decl constant IN_ALL_EVENTS
 *! This is a derived constant that is not part of the standard inotify API. It
 *! is the union of all other constants.
 *!
 *! @decl constant IN_ACCESS
 *! @decl constant IN_ATTRIB
 *! @decl constant IN_CLOSE
 *! @decl constant IN_CLOSE_WRITE
 *! @decl constant IN_CLOSE_NOWRITE
 *! @decl constant IN_CREATE
 *! @decl constant IN_DELETE
 *! @decl constant IN_DELETE_SELF
 *! @decl constant IN_MODIFY
 *! @decl constant IN_MOVE_SELF
 *! @decl constant IN_MOVED_FROM
 *! @decl constant IN_MOVED_TO
 *! @decl constant IN_OPEN
 *! @decl constant IN_MOVE
 *! @decl constant IN_CLOSE
 *! @decl constant IN_DONT_FOLLOW
 *! @decl constant IN_MASK_ADD
 *! @decl constant IN_ONESHOT
 *! @decl constant IN_ONLYDIR
 *! @decl constant IN_IGNORED
 *! @decl constant IN_ISDIR
 *! @decl constant IN_Q_OVERFLOW
 *! @decl constant IN_UNMOUNT
 *! 	Please have a look at the inotify(7) manpage for information about
 *!	these constants.
 *! @note
 *! 	Some constants may not be available when the module has been
 *!	compiled on a machine with linux kernel before 2.6.15. See the
 *!	manpage for more details.
 */

/*! @decl array(string|int) parse_event(string data)
 *! Parses one inotify_event struct from @expr{data@}.
 *! @returns
 *! 	Returns an array consisting of
 *! 	@array
 *!	    @elem int 0
 *! 		The watch descriptor returned by @[_Instance()->add_watch()]
 *!		when the watch for this file was added.
 *!	    @elem int 1
 *! 		An integer that describes the event that occured. See
 *!		the inotify manpage for a list of possible events and
 *!		their numerical identifiers.
 *!	    @elem int 2
 *! 		An integer cookie that can be used to group together
 *!		different events that were triggered by moving a file
 *!		from one location to another.
 *! 	    @elem string 3
 *! 		The name of the file. This will only be present if the
 *!		event happened to a file in a directory that was
 *!		watched, e.g. with @[System.Inotify.IN_CREATE].
 *! 		Otherwise this will be 0.
 *!	    @elem int 4
 *! 		The length of the data that has been parsed. If the @[data]
 *!		string contains more than one inotify event, this parse
 *!		function needs to be called again with the remainder as
 *!		an argument.
 *! 	@endarray
 */
#define f_Inotify_parse_event_defined

#ifdef f_Inotify_parse_event_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Inotify_parse_event_fun_num = 0;

#endif /* f_Inotify_parse_event_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Inotify_parse_event(INT32 args) {
#line 120 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
struct pike_string * data;
#line 120 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
if(args != 1) wrong_number_of_args_error("parse_event",args,1);
#line 120 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("parse_event",1,"string");
#line 120 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
debug_malloc_pass(data=Pike_sp[0-1].u.string);
#line 120 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
{
    struct inotify_event event;
    size_t len;
    const char * d;

    if (data->size_shift)
	Pike_error("Inotify events should not be wide.\n");

    if ((size_t)data->len < sizeof(struct inotify_event))
	Pike_error("Malformed data.\n");

    d = data->str;

    memcpy(&event, d, sizeof(struct inotify_event));

    push_int(event.wd);
    push_int((int)event.mask);
    push_int((int)event.cookie);

    if (event.len) {
        if (event.len > data->len - sizeof(struct inotify_event))
            Pike_error("Data missing. Got %u expected %u bytes.\n", (unsigned)(data->len - sizeof(struct inotify_event)), event.len);
        d += sizeof(struct inotify_event);
	push_string(make_shared_binary_string(d, strnlen(d, event.len)));
    } else {
        push_int(0);
    }

    push_int((int)(event.len + sizeof(struct inotify_event)));

    f_aggregate(5);
    stack_swap();
    pop_stack();
}

}
/*! @class _Instance
 *! 	Simple wrapper class that gives direct access to the @tt{inotify(7)@}
 *!	interface. On create an inotify instance is initiated by calling
 *!	@tt{inotify_init(2)@}. Every object of this class has its own inotify
 *!	file descriptor. Use this class only if you want direct access to
 *!	the file descriptor to read from it manually. For a more user
 *!	friendly inferface use @[System.Inotify.Instance].
 *!
 *! @seealso
 *!     @[System.Inotify.Instance]
 */

#undef class_Inotify_cq__Instance_defined
#define class_Inotify_cq__Instance_defined
DEFAULT_CMOD_STORAGE struct program *Inotify_cq__Instance_program=NULL;

#ifdef Inotify_cq__Instance_program_fun_num_used
DEFAULT_CMOD_STORAGE int Inotify_cq__Instance_program_fun_num=-1;
#endif /* Inotify_cq__Instance_program_fun_num_used */

#undef var_box_Inotify_cq__Instance_defined
#define var_box_Inotify_cq__Instance_defined

#undef var_buf_Inotify_cq__Instance_defined
#define var_buf_Inotify_cq__Instance_defined
/*! @decl private function(int, int, int, string:void) event_callback
     *!
     *! Callback function that is called when an event is triggered.
     *!
     *! @seealso
     *!   @[set_event_callback()], @[query_event_callback()]
     */
    
#undef var_event_callback_Inotify_cq__Instance_defined
#define var_event_callback_Inotify_cq__Instance_defined

#undef THIS
#define THIS ((struct Inotify_cq__Instance_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_INOTIFY_CQ__INSTANCE
#define THIS_INOTIFY_CQ__INSTANCE ((struct Inotify_cq__Instance_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_INOTIFY_CQ__INSTANCE
#define OBJ2_INOTIFY_CQ__INSTANCE(o) ((struct Inotify_cq__Instance_struct *)(o->storage+Inotify_cq__Instance_storage_offset))

#undef GET_INOTIFY_CQ__INSTANCE_STORAGE
#define GET_INOTIFY_CQ__INSTANCE_STORAGE(o) ((struct Inotify_cq__Instance_struct *)(o->storage+Inotify_cq__Instance_storage_offset)
static ptrdiff_t Inotify_cq__Instance_storage_offset;
struct Inotify_cq__Instance_struct {

#ifdef var_box_Inotify_cq__Instance_defined
#line 167 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
struct fd_callback_box box;
#endif /* var_box_Inotify_cq__Instance_defined */

#ifdef var_buf_Inotify_cq__Instance_defined
#line 168 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
struct string_builder buf;
#endif /* var_buf_Inotify_cq__Instance_defined */

#ifdef var_event_callback_Inotify_cq__Instance_defined
  struct svalue event_callback;

#endif /* var_event_callback_Inotify_cq__Instance_defined */
};
#ifdef PIKE_DEBUG
/* Ensure the struct is used in a variable declaration, or else gdb might not see it. */
static struct Inotify_cq__Instance_struct *Inotify_cq__Instance_gdb_dummy_ptr;
#endif
#line 179 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
static int event_callback_fun_num;

    
#undef extra_Inotify_cq__Instance_defined
#define extra_Inotify_cq__Instance_defined
#line 196 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
static void check_schedule_poll(void);

    /*! @decl int add_watch(string file, int mask)
     *! Add a watch for a certain file or directory and specific events.
     *! Adding more than one watch for one file will overwrite the
     *! previous watch unless @[System.Inotify.IN_MASK_ADD] is contained
     *! in the mask.
     *! @param path
     *!	    Path of the file or directory.
     *! @param mask
     *!	    Integer mask specifying the event type. This can be a
     *!	    combination of different event types using bitwise OR.
     *!	    See the inotify manpage for possible values and their
     *!	    description. The values defined by the inotify header
     *!	    file are exported by @[System.Inotify] as constants
     *!	    using the same names (e.g. @[System.Inotify.IN_CREATE]).
     *! @returns
     *!     Returns a watch descriptor.
     *! @note
     *!	    Subdirectories are not watched. If you want to watch
     *!	    subdirectories as well, you need to add watches for
     *!	    them individually.
     *! @note
     *!     At creation of a watch for a directory simulated
     *!     @[IN_CREATE]-events with cookie @expr{0x7fffffff@} will
     *!     be added for the initial contents of the directory.
     *!     This is to reduce the risk of losing state changes
     *!     due to races. Note that is is not known whether these
     *!     paths are in flux or not. Note also that there may
     *!     be multiple notifications for content that is created
     *!     at the moment the watch is created.
     *!
     *! @seealso
     *!     @[rm_watch()], @[parse_event()]
     */
    #define f_Inotify_cq__Instance_add_watch_defined

#ifdef f_Inotify_cq__Instance_add_watch_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Inotify_cq__Instance_add_watch_fun_num = 0;

#endif /* f_Inotify_cq__Instance_add_watch_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Inotify_cq__Instance_add_watch(INT32 args) {
#line 231 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
struct pike_string * file;
#line 231 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
INT_TYPE mask;
#line 231 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
if(args != 2) wrong_number_of_args_error("add_watch",args,2);
#line 231 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
if(TYPEOF(Pike_sp[0-2]) != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("add_watch",1,"string");
#line 231 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
debug_malloc_pass(file=Pike_sp[0-2].u.string);
#line 231 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
if(TYPEOF(Pike_sp[1-2]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("add_watch",2,"int");
#line 231 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
mask=Pike_sp[1-2].u.integer;
#line 231 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
{
	INT32 wd;

	if (file->size_shift)
	    Pike_error("Widestring filenames are not allowed.\n");

	wd = inotify_add_watch(THIS->box.fd, file->str, mask);

	if (wd == -1)
	    Pike_error("inotify_add_watch failed: %s\n",
		       strerror(errno));

	if (mask & IN_CREATE) {
	  DIR *dir = opendir(file->str);
	  if (dir) {
	    struct dirent *dirent;
	    /* Add any paths already present to the input buffer. */
	    while ((dirent = readdir(dir))) {
	      struct inotify_event ev;
	      int pad = 0;

	      if ((dirent->d_name[0] == '.') &&
		  (!dirent->d_name[1] ||
		   ((dirent->d_name[1] == '.') && !dirent->d_name[2]))) {
		/* Filter "." and ".." */
		continue;
	      }
	      ev.wd = wd;
	      ev.mask = IN_CREATE;	/* FIXME: Use custom code? */
	      ev.cookie = (uint32_t)0x7fffffff;	/* Special marker. */
	      ev.len = strlen(dirent->d_name) + 1;
	      if (ev.len & 0x07) {
		pad = 0x08 - (ev.len & 0x07);
		ev.len += pad;
	      }
#ifdef HAVE_DIRENT_D_TYPE
	      if (dirent->d_type == DT_DIR) {
		ev.mask |= IN_ISDIR;
	      }
	      /* FIXME: Handle DT_UNKNOWN. */
#endif /* HAVE_DIRENT_T_TYPE */

	      string_build_mkspace(&THIS->buf, sizeof(ev) + ev.len, 0);
	      string_builder_binary_strcat0(&THIS->buf,
					    (p_wchar0 *)&ev,
					    sizeof(ev));
	      string_builder_strcat(&THIS->buf, dirent->d_name);
	      string_builder_fill(&THIS->buf, pad+1,
				  MKPCHARP("\0\0\0\0\0\0\0\0", 0), 8, 0);
	    }
	    closedir(dir);

	    /* Wake up the backend if we've added stuff to the buffer. */
	    check_schedule_poll();
	  }
	}
	do { INT_TYPE ret_=(wd); pop_n_elems(2); push_int(ret_); return; }while(0);
#line 288 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
}


    }
/*! @decl int query_fd()
     *! @returns
     *!	    Returns the file descriptor associated with this inotify instance.
     */
    #define f_Inotify_cq__Instance_query_fd_defined

#ifdef f_Inotify_cq__Instance_query_fd_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Inotify_cq__Instance_query_fd_fun_num = 0;

#endif /* f_Inotify_cq__Instance_query_fd_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Inotify_cq__Instance_query_fd(INT32 args) {
#line 295 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
if(args != 0) wrong_number_of_args_error("query_fd",args,0);
#line 295 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
{
	push_int(THIS->box.fd);
    }

    }
/*! @decl int rm_watch(int wd)
     *! Remove a watch.
     *! @param wd
     *!	    The watch descriptor that was returned by @[add_watch()].
     */
    #define f_Inotify_cq__Instance_rm_watch_defined

#ifdef f_Inotify_cq__Instance_rm_watch_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Inotify_cq__Instance_rm_watch_fun_num = 0;

#endif /* f_Inotify_cq__Instance_rm_watch_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Inotify_cq__Instance_rm_watch(INT32 args) {
#line 304 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
INT_TYPE wd;
#line 304 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
if(args != 1) wrong_number_of_args_error("rm_watch",args,1);
#line 304 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("rm_watch",1,"int");
#line 304 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
wd=Pike_sp[0-1].u.integer;
#line 304 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
{
	INT32 err;

	err = inotify_rm_watch(THIS->box.fd, wd);

	if (!err || (errno == EINVAL)) {
	    /* NB: EINVAL typically means that the watch descriptor is
	     *     invalid, and is often triggered by the descriptor
	     *     having been automatically removed.
	     */
	    return;
	}

	if (errno == EBADF) {
	    Pike_error("Oups. I feel funny inside.\n");
	}
	Pike_error("Unexpected error: %d.\n", errno);
    }

    }
/*! @decl void set_event_callback(function(int, int, int, string:void) cb)
     *!
     *! Set the @[event_callback].
     *!
     *! @seealso
     *!   @[get_event_callback()], @[event_callback], @[poll()]
     */
    #define f_Inotify_cq__Instance_set_event_callback_defined

#ifdef f_Inotify_cq__Instance_set_event_callback_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Inotify_cq__Instance_set_event_callback_fun_num = 0;

#endif /* f_Inotify_cq__Instance_set_event_callback_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Inotify_cq__Instance_set_event_callback(INT32 args) {
#line 330 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
struct svalue * cb;
#line 330 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
if(args != 1) wrong_number_of_args_error("set_event_callback",args,1);
#line 330 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_FUNCTION) SIMPLE_ARG_TYPE_ERROR("set_event_callback",1,"function(int,int,int,string:void)");
#line 330 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
cb=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
{
      /* Use object indexing to handle circular reference counting correctly. */
      object_low_set_index(Pike_fp->current_object,
			   Pike_fp->context->identifier_level +
			   event_callback_fun_num,
			   cb);
    }

    }
/*! @decl function(int, int, int, string:void) get_event_callback()
     *!
     *! Get the current @[event_callback].
     *!
     *! @seealso
     *!   @[set_event_callback()], @[event_callback], @[poll()]
     */
    #define f_Inotify_cq__Instance_get_event_callback_defined

#ifdef f_Inotify_cq__Instance_get_event_callback_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Inotify_cq__Instance_get_event_callback_fun_num = 0;

#endif /* f_Inotify_cq__Instance_get_event_callback_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Inotify_cq__Instance_get_event_callback(INT32 args) {
#line 346 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
if(args != 0) wrong_number_of_args_error("get_event_callback",args,0);
{
      push_svalue(&THIS->event_callback);
    }

    }
/*! @decl void set_backend(Pike.Backend backend)
     *!
     *! Set the backend used for callbacks.
     *!
     *! @seealso
     *!   @[set_event_callback()], @[set_nonblocking()], @[poll()]
     */
    #define f_Inotify_cq__Instance_set_backend_defined

#ifdef f_Inotify_cq__Instance_set_backend_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Inotify_cq__Instance_set_backend_fun_num = 0;

#endif /* f_Inotify_cq__Instance_set_backend_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Inotify_cq__Instance_set_backend(INT32 args) {
#line 358 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
struct object * backend_object;
#line 358 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
if(args != 1) wrong_number_of_args_error("set_backend",args,1);
#line 358 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_OBJECT) SIMPLE_ARG_TYPE_ERROR("set_backend",1,"object");
#line 358 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
debug_malloc_pass(backend_object=Pike_sp[0-1].u.object);
{
	struct Backend_struct *backend =
	    get_storage(backend_object, Backend_program);
	if (!backend)
	    SIMPLE_BAD_ARG_ERROR("set_backend", 1, "Pike.Backend");
	change_backend_for_box(&THIS->box, backend);
    }

    }
/*! @decl void set_nonblocking()
     *!
     *! Enable backend callback mode.
     *!
     *! The configured backend will call @[poll()] automatically
     *! as soon as there are events pending.
     *!
     *! @seealso
     *!   @[set_blocking()], @[poll()]
     */
    #define f_Inotify_cq__Instance_set_nonblocking_defined

#ifdef f_Inotify_cq__Instance_set_nonblocking_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Inotify_cq__Instance_set_nonblocking_fun_num = 0;

#endif /* f_Inotify_cq__Instance_set_nonblocking_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Inotify_cq__Instance_set_nonblocking(INT32 args) {
#line 377 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
if(args != 0) wrong_number_of_args_error("set_nonblocking",args,0);
{
      set_fd_callback_events(&THIS->box, PIKE_BIT_FD_READ, 0);
    }

    }
/*! @decl void set_blocking()
     *!
     *! Disable backend callback mode.
     *!
     *! The configured backend will stop calling @[poll()], so
     *! @[poll()] will need to be called by hand.
     *!
     *! @seealso
     *!   @[set_blocking()], @[poll()]
     */
    #define f_Inotify_cq__Instance_set_blocking_defined

#ifdef f_Inotify_cq__Instance_set_blocking_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Inotify_cq__Instance_set_blocking_fun_num = 0;

#endif /* f_Inotify_cq__Instance_set_blocking_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Inotify_cq__Instance_set_blocking(INT32 args) {
#line 392 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
if(args != 0) wrong_number_of_args_error("set_blocking",args,0);
{
      set_fd_callback_events(&THIS->box, 0, 0);
    }

    }
/*! @decl void poll()
     *!
     *! Check for any pending events.
     *!
     *! Any pending events will be read and parsed, and @[event_callback] will
     *! be called once for each event. The arguments to the @[event_callback]
     *! will be:
     *! @array
     *!   @elem int 1
     *!     The watch descriptor that was triggered.
     *!   @elem int 2
     *!     The event that was triggerend (one of @tt{IN_*@}).
     *!   @elem int 3
     *!     An integer cookie used to identify grouped events.
     *!   @elem string 4
     *!     The name of the path segment (if any).
     *! @endarray
     *!
     *! @note
     *!   This function is called by the backend when there are events
     *!   pending.
     *!
     *! @seealso
     *!   @[set_event_callback()]
     */
    #define f_Inotify_cq__Instance_poll_defined

#ifdef f_Inotify_cq__Instance_poll_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Inotify_cq__Instance_poll_fun_num = 0;

#endif /* f_Inotify_cq__Instance_poll_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Inotify_cq__Instance_poll(INT32 args) {
#line 422 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
if(args != 0) wrong_number_of_args_error("poll",args,0);
{
	ptrdiff_t off = 0;
	ptrdiff_t bytes;
	do {
	    string_build_mkspace(&THIS->buf, 1024, 0);
	    do {
		bytes = read(THIS->box.fd,
			     THIS->buf.s->str + THIS->buf.s->len,
			     1024);
	    } while ((bytes == -1) && (errno == EINTR));
	    if (bytes > 0) {
	      THIS->buf.s->len += bytes;
	    }
	    while (THIS->buf.s->len >=
		   (off + (ptrdiff_t)sizeof(struct inotify_event))) {
	        /* NB: Assumes that e->len has a valid alignment
		 *     for the struct. This could cause problems
		 *     on non-x86 systems and injected data.
		 */
		struct inotify_event *e = (void *)(THIS->buf.s->str + off);
		const char *path = (char *)(e + 1);
		ptrdiff_t new_off = off + sizeof(struct inotify_event) + e->len;
		if (new_off > THIS->buf.s->len) {
		    /* Not enough data for the filename yet. */
		    break;
		}
		off = new_off;

		push_int(e->wd);
		push_int(e->mask);
		push_int(e->cookie);
		push_string(make_shared_binary_string(path,
						      strnlen(path, e->len)));
		safe_apply_svalue(&THIS->event_callback, 4, 1);
		pop_stack();
	    }
	    if (off == THIS->buf.s->len) {
		/* End of data reached. Restart at beginning of buffer. */
		off = THIS->buf.s->len = 0;
	    }
	} while (bytes > 0);
	if (off) {
	    /* Unlikely, but... */
	    THIS->buf.s->len -= off;
	    memmove(THIS->buf.s->str, THIS->buf.s->str + off,
		    THIS->buf.s->len);
	}
    }

    }
#line 472 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
static void check_schedule_poll(void)
    {
      if (THIS->box.events & PIKE_BIT_FD_READ) {
	/* Nonblocking mode. */
	if (THIS->buf.s->len >= (ptrdiff_t)sizeof(struct inotify_event)) {
	  /* There's stuff waiting in the buffer, so schedule
	   * an immediate call_out of poll() to handle the data.
	   */
	  ref_push_function(Pike_fp->current_object,
			    f_Inotify_cq__Instance_poll_fun_num +
			    Pike_fp->context->identifier_level);
	  push_int(0);
	  safe_apply(get_backend_obj(THIS->box.backend), "call_out", 2);
	  pop_stack();
	}
      }
    }

    static int got_inotify_event(struct fd_callback_box *box, int UNUSED(event))
    {
	apply(box->ref_obj, "poll", 0);
	pop_stack();
	return 0;
    }

    
#undef internal_init_Inotify_cq__Instance_defined
#define internal_init_Inotify_cq__Instance_defined

#undef Inotify_cq__Instance_event_handler_defined
#define Inotify_cq__Instance_event_handler_defined
static void init_Inotify_cq__Instance_struct(void)
#line 497 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
{
	THIS->box.fd = -1;
	init_string_builder_alloc(&THIS->buf, 1024, 0);
	INIT_FD_CALLBACK_BOX(&THIS->box, default_backend,
			     Pike_fp->current_object,
			     inotify_init(), 0, got_inotify_event, 0);

	if (THIS->box.fd == -1) {
	  switch (errno) {
	  case EMFILE:
	    Pike_error("User limit on inotify instances reached.\n");
	    break;
	  case ENFILE:
	    Pike_error("User limit on file descriptors reached.\n");
	    break;
	  case ENOMEM:
	    Pike_error("No free kernel memory available.\n");
	    break;
	  default:
	    Pike_error("Failed to initialize.\n");
	    break;
	  }
	}
	set_nonblocking(THIS->box.fd, 1);
    }

    
#undef Inotify_cq__Instance_gc_live_obj
#define Inotify_cq__Instance_gc_live_obj

#undef internal_exit_Inotify_cq__Instance_defined
#define internal_exit_Inotify_cq__Instance_defined

#undef Inotify_cq__Instance_event_handler_defined
#define Inotify_cq__Instance_event_handler_defined
static void exit_Inotify_cq__Instance_struct(void)
#line 523 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
{
	if (THIS->box.fd != -1) {
	    int fd = THIS->box.fd;
	    set_fd_callback_events(&THIS->box, 0, 0);
	    change_fd_for_box(&THIS->box, -1);
	    unhook_fd_callback_box(&THIS->box);
	    /*
	     * Currently (linux 3.4.9) closing an inotify fd takes
	     * on the order of 100 ms
	     */
	    THREADS_ALLOW();
	    while ((close(fd) == -1) && (errno == EINTR))
	      ;
	    THREADS_DISALLOW();
	}
	free_string_builder(&THIS->buf);
    }

#ifdef Inotify_cq__Instance_event_handler_defined
static void Inotify_cq__Instance_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_Inotify_cq__Instance_defined
  case PROG_EVENT_INIT: init_Inotify_cq__Instance_struct(); break;

#endif /* internal_init_Inotify_cq__Instance_defined */

#ifdef internal_exit_Inotify_cq__Instance_defined
  case PROG_EVENT_EXIT: exit_Inotify_cq__Instance_struct(); break;

#endif /* internal_exit_Inotify_cq__Instance_defined */
  default: break; 
  }
}

#endif /* Inotify_cq__Instance_event_handler_defined */
/*! @endclass
 */

#line 545 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
#define ADD_ICONST(name) do {			\
    add_integer_constant(#name, name, 0);	\
} while(0);

#else /* !HAVE_SYS_INOTIFY_H */

#define ADD_ICONST(name)

#endif /* HAVE_SYS_INOTIFY_H */

PIKE_MODULE_INIT {
    ADD_ICONST(IN_ACCESS);
    ADD_ICONST(IN_ALL_EVENTS);
    ADD_ICONST(IN_ATTRIB);
    ADD_ICONST(IN_CLOSE_WRITE);
    ADD_ICONST(IN_CLOSE_NOWRITE);
    ADD_ICONST(IN_CREATE);
    ADD_ICONST(IN_DELETE);
    ADD_ICONST(IN_DELETE_SELF);
    ADD_ICONST(IN_MODIFY);
    ADD_ICONST(IN_MOVE_SELF);
    ADD_ICONST(IN_MOVED_FROM);
    ADD_ICONST(IN_MOVED_TO);
    ADD_ICONST(IN_OPEN);

    ADD_ICONST(IN_MOVE);
    ADD_ICONST(IN_CLOSE);

/* some of these came with 2.6.15 linux and 2.5 glibc */
#ifdef IN_DONT_FOLLOW
    ADD_ICONST(IN_DONT_FOLLOW);
#endif
#ifdef IN_MASK_ADD
    ADD_ICONST(IN_MASK_ADD);
#endif
    ADD_ICONST(IN_ONESHOT);
#ifdef IN_ONLYDIR
    ADD_ICONST(IN_ONLYDIR);
#endif

    ADD_ICONST(IN_IGNORED);
    ADD_ICONST(IN_ISDIR);
    ADD_ICONST(IN_Q_OVERFLOW);
    ADD_ICONST(IN_UNMOUNT);

    
#ifdef module_strings_declared
module_strings[0] = 
  make_shared_binary_string("event_callback",
                            CONSTANT_STRLEN("event_callback"));
#endif

#ifdef CMOD_MAP_PROGRAM_IDS_DEFINED
set_program_id_to_id( ___cmod_map_program_ids );

#endif /* CMOD_MAP_PROGRAM_IDS_DEFINED */

#ifdef class_Inotify_cq__Instance_defined

#ifdef PROG_INOTIFY_CQ__INSTANCE_ID
#line 166 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
  START_NEW_PROGRAM_ID(INOTIFY_CQ__INSTANCE);
#else
#line 166 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
  start_new_program();

#endif /* PROG_INOTIFY_CQ__INSTANCE_ID */
#line 166 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
  Inotify_cq__Instance_program = Pike_compiler->new_program;

#ifndef tObjImpl_INOTIFY_CQ__INSTANCE

#undef tObjIs_INOTIFY_CQ__INSTANCE
#define tObjIs_INOTIFY_CQ__INSTANCE "\3\1\177\0\0\2"

#undef tObjImpl_INOTIFY_CQ__INSTANCE
#define tObjImpl_INOTIFY_CQ__INSTANCE "\3\0\177\0\0\2"

#endif /* tObjImpl_INOTIFY_CQ__INSTANCE */

#ifdef THIS_INOTIFY_CQ__INSTANCE
  Inotify_cq__Instance_storage_offset = ADD_STORAGE(struct Inotify_cq__Instance_struct);
#endif /* THIS_INOTIFY_CQ__INSTANCE */

#ifdef var_event_callback_Inotify_cq__Instance_defined
  PIKE_MAP_VARIABLE("event_callback", Inotify_cq__Instance_storage_offset + OFFSETOF(Inotify_cq__Instance_struct, event_callback),
                    tFunc("\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" tStr,tVoid), PIKE_T_MIXED, ID_PRIVATE);
#endif /* var_event_callback_Inotify_cq__Instance_defined */

#ifdef extra_Inotify_cq__Instance_defined
#line 182 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
{
      /* NB: Inlined isidentifier() due to it not being exported. */
      event_callback_fun_num =
	really_low_find_shared_string_identifier(module_strings[0] /* "event_callback" */,
						 Pike_compiler->new_program,
						 SEE_PROTECTED|SEE_PRIVATE);
      if (event_callback_fun_num == -1) {
	Pike_fatal("Inotify: Event callback variable not mapped!\n");
      }
      /* We don't want to count references to ourselves. */
      ID_FROM_INT(Pike_compiler->new_program, event_callback_fun_num)->
	identifier_flags |= IDENTIFIER_NO_THIS_REF;
    }

    
#endif /* extra_Inotify_cq__Instance_defined */

#ifdef Inotify_cq__Instance_event_handler_defined
  pike_set_prog_event_callback(Inotify_cq__Instance_event_handler);

#ifndef Inotify_cq__Instance_gc_live_obj
  Pike_compiler->new_program->flags &= ~PROGRAM_LIVE_OBJ;

#endif /* Inotify_cq__Instance_gc_live_obj */

#endif /* Inotify_cq__Instance_event_handler_defined */

#ifdef f_Inotify_cq__Instance_add_watch_defined

#ifdef f_Inotify_cq__Instance_add_watch_fun_num_used
  f_Inotify_cq__Instance_add_watch_fun_num =
#endif /* f_Inotify_cq__Instance_add_watch_fun_num_used */
#line 231 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
    ADD_FUNCTION2("add_watch", f_Inotify_cq__Instance_add_watch, tFunc(tStr "\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Inotify_cq__Instance_add_watch_defined */

#ifdef f_Inotify_cq__Instance_query_fd_defined

#ifdef f_Inotify_cq__Instance_query_fd_fun_num_used
  f_Inotify_cq__Instance_query_fd_fun_num =
#endif /* f_Inotify_cq__Instance_query_fd_fun_num_used */
#line 295 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
    ADD_FUNCTION2("query_fd", f_Inotify_cq__Instance_query_fd, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Inotify_cq__Instance_query_fd_defined */

#ifdef f_Inotify_cq__Instance_rm_watch_defined

#ifdef f_Inotify_cq__Instance_rm_watch_fun_num_used
  f_Inotify_cq__Instance_rm_watch_fun_num =
#endif /* f_Inotify_cq__Instance_rm_watch_fun_num_used */
    ADD_FUNCTION2("rm_watch", f_Inotify_cq__Instance_rm_watch, tFunc("\10\200\0\0\0\177\377\377\377",tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Inotify_cq__Instance_rm_watch_defined */

#ifdef f_Inotify_cq__Instance_set_event_callback_defined

#ifdef f_Inotify_cq__Instance_set_event_callback_fun_num_used
  f_Inotify_cq__Instance_set_event_callback_fun_num =
#endif /* f_Inotify_cq__Instance_set_event_callback_fun_num_used */
#line 330 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
    ADD_FUNCTION2("set_event_callback", f_Inotify_cq__Instance_set_event_callback, tFunc(tFunc("\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" tStr,tVoid),tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Inotify_cq__Instance_set_event_callback_defined */

#ifdef f_Inotify_cq__Instance_get_event_callback_defined

#ifdef f_Inotify_cq__Instance_get_event_callback_fun_num_used
  f_Inotify_cq__Instance_get_event_callback_fun_num =
#endif /* f_Inotify_cq__Instance_get_event_callback_fun_num_used */
#line 346 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
    ADD_FUNCTION2("get_event_callback", f_Inotify_cq__Instance_get_event_callback, tFunc(tNone,tFunc("\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" tStr,tVoid)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Inotify_cq__Instance_get_event_callback_defined */

#ifdef f_Inotify_cq__Instance_set_backend_defined

#ifdef f_Inotify_cq__Instance_set_backend_fun_num_used
  f_Inotify_cq__Instance_set_backend_fun_num =
#endif /* f_Inotify_cq__Instance_set_backend_fun_num_used */
#line 358 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
    ADD_FUNCTION2("set_backend", f_Inotify_cq__Instance_set_backend, tFunc(tObj,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Inotify_cq__Instance_set_backend_defined */

#ifdef f_Inotify_cq__Instance_set_nonblocking_defined

#ifdef f_Inotify_cq__Instance_set_nonblocking_fun_num_used
  f_Inotify_cq__Instance_set_nonblocking_fun_num =
#endif /* f_Inotify_cq__Instance_set_nonblocking_fun_num_used */
#line 377 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
    ADD_FUNCTION2("set_nonblocking", f_Inotify_cq__Instance_set_nonblocking, tFunc(tNone,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Inotify_cq__Instance_set_nonblocking_defined */

#ifdef f_Inotify_cq__Instance_set_blocking_defined

#ifdef f_Inotify_cq__Instance_set_blocking_fun_num_used
  f_Inotify_cq__Instance_set_blocking_fun_num =
#endif /* f_Inotify_cq__Instance_set_blocking_fun_num_used */
#line 392 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
    ADD_FUNCTION2("set_blocking", f_Inotify_cq__Instance_set_blocking, tFunc(tNone,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Inotify_cq__Instance_set_blocking_defined */

#ifdef f_Inotify_cq__Instance_poll_defined

#ifdef f_Inotify_cq__Instance_poll_fun_num_used
  f_Inotify_cq__Instance_poll_fun_num =
#endif /* f_Inotify_cq__Instance_poll_fun_num_used */
#line 422 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
    ADD_FUNCTION2("poll", f_Inotify_cq__Instance_poll, tFunc(tNone,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Inotify_cq__Instance_poll_defined */
#line 166 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
  Inotify_cq__Instance_program=end_program();
#line 166 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
#ifdef Inotify_cq__Instance_program_fun_num_used
Inotify_cq__Instance_program_fun_num=
#endif
 add_program_constant("_Instance",Inotify_cq__Instance_program,0);

#endif /* class_Inotify_cq__Instance_defined */

#ifdef f_Inotify_parse_event_defined

#ifdef f_Inotify_parse_event_fun_num_used
  f_Inotify_parse_event_fun_num =
#endif /* f_Inotify_parse_event_fun_num_used */
#line 120 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
    ADD_FUNCTION2("parse_event", f_Inotify_parse_event, tFunc(tStr,tArr(tOr(tStr,"\10\200\0\0\0\177\377\377\377"))), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Inotify_parse_event_defined */

#ifdef CMOD_MAP_PROGRAM_IDS_DEFINED
set_program_id_to_id( 0 );
#endif /* CMOD_MAP_PROGRAM_IDS_DEFINED */
#line 591 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
}

PIKE_MODULE_EXIT {
    
#ifdef class_Inotify_cq__Instance_defined
  if(Inotify_cq__Instance_program) {
#line 166 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
    free_program(Inotify_cq__Instance_program);
    Inotify_cq__Instance_program=0;
  }

#endif /* class_Inotify_cq__Instance_defined */

#ifdef module_strings_declared
{
  int i;
  for(i=0; i < 1; i++) {
    if (module_strings[i]) free_string(module_strings[i]);
    module_strings[i] = NULL;
  }
}
#endif
#line 595 "/home/zino/hack/pike8-rel/pike/src/modules/Inotify/inotify.cmod"
}

/*! @endmodule
 */
/*! @endmodule
 */


#ifdef CMOD_MAP_PROGRAM_IDS_DEFINED
static int ___cmod_map_program_ids(int id)
{
  int i = 0;
  if( (id&0x7f000000) != 0x7f000000 ) return id;
  id = id&0x00ffffff;
#ifdef class_Inotify_cq__Instance_defined
if(id==2) return Inotify_cq__Instance_program->id;
#endif
  return 0;
}
#endif /* CMOD_MAP_PROGRAM_IDS_DEFINED */
