<?php
  /**************************************************************************\
  * phpGroupWare - Polls                                                     *
  * http://www.phpgroupware.org                                              *
  *  The file is based on phpPolls                                           *
  *  Copyright (c) 1999 Till Gerken (tig@skv.org)                            *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: functions.inc.php,v 1.11.2.1.2.5 2004/07/15 02:07:00 skwashd Exp $ */

	$GLOBALS['phpgw']->db->query("select * from phpgw_polls_settings");
	while ($GLOBALS['phpgw']->db->next_record())
	{
		$GLOBALS['poll_settings'][$GLOBALS['phpgw']->db->f('setting_name')] = $GLOBALS['phpgw']->db->f('setting_value');
	}

	function add_template_row(&$tpl,$label,$value)
	{
		$GLOBALS['phpgw']->nextmatchs->template_alternate_row_color($tpl);
		$tpl->set_var('td_1',$label);
		$tpl->set_var('td_2',$value);
		$tpl->parse('rows','row',True);
	}

	function verify_uservote($poll_id)
	{
		$poll_id = intval($poll_id);
		if ($GLOBALS['poll_settings']['allow_multiable_votes'])
		{
			return True;
		}

		$GLOBALS['phpgw']->db->query('SELECT COUNT(*) as cnt FROM phpgw_polls_user ' 
			. 'WHERE user_id=' . intval($GLOBALS['phpgw_info']['user']['account_id'])
				. " AND poll_id = $poll_id",__LINE__,__FILE__);
		$GLOBALS['phpgw']->db->next_record();

		return ($GLOBALS['phpgw']->db->f(cnt) == 0) ? True : False;
	}

	function poll_viewResults($poll_id)
	{
		$poll_id = intval($poll_id);
		$GLOBALS['phpgw']->db->query("SELECT SUM(option_count) AS cnt FROM phpgw_polls_data WHERE poll_id = $poll_id",__LINE__,__FILE__);
		$GLOBALS['phpgw']->db->next_record();
		$poll_sum = intval($GLOBALS['phpgw']->db->f(cnt));

		$GLOBALS['phpgw']->db->query("select poll_title from phpgw_polls_desc where poll_id=$poll_id",__LINE__,__FILE__);
		$GLOBALS['phpgw']->db->next_record();

		echo '<p><table border="0" align="center" width="50%">';
		echo ' <tr>' . "\n"
			. '  <td colspan="3" bgcolor="' . $GLOBALS['phpgw_info']['theme']['th_bg'] . '" align="center">'
			. $GLOBALS['phpgw']->db->f('poll_title', True) . '</td>' . "\n"
			. '</tr>' . "\n";

		$GLOBALS['phpgw']->db->query("SELECT * FROM phpgw_polls_data WHERE poll_id = $poll_id",__LINE__,__FILE__);
		while ($GLOBALS['phpgw']->db->next_record())
		{
			$poll_optionText  = $GLOBALS['phpgw']->db->f('option_text', True);
			$poll_optionCount = $GLOBALS['phpgw']->db->f('option_count');

			$tr_color = $GLOBALS['phpgw']->nextmatchs->alternate_row_color($tr_color);
			echo ' <tr bgcolor="' . $tr_color . '">' . "\n";

			if ($poll_optionText != '')
			{
				echo "  <td>$poll_optionText</td>\n";

				if ($poll_sum)
				{
					$poll_percent = 100 * $poll_optionCount / $poll_sum;
				}
				else
				{
					$poll_percent = 0;
				}

				if ($poll_percent > 0)
				{
					$poll_percentScale = intval($poll_percent * 1);
					echo '  <td><img src="' . $GLOBALS['phpgw_info']['server']['webserver_url']
						. '/polls/images/pollbar.gif" height="12" width="' . $poll_percentScale
						. '"></td>' . "\n";
				}
				else
				{
					echo '  <td>&nbsp;</td>' . "\n";
				}

				printf('  <td> %.2f %% (%d)</td>' . "\n" . ' </tr>' . "\n", $poll_percent, $poll_optionCount);

				echo ' </tr>' . "\n";
			}
		}

		echo ' <tr bgcolor="' . $GLOBALS['phpgw_info']['theme']['bgcolor'] . '">' . "\n"
			. '  <td>' . lang('Total votes') . ': ' . $poll_sum . '</td>' . "\n"
			. ' </tr>' . "\n"
			. '</table>' . "\n";
	}

	function poll_getResults($poll_id)
	{
		$ret = array();
		$poll_id = intval($poll_id);
		$GLOBALS['phpgw']->db->query("SELECT SUM(option_count) AS cnt FROM phpgw_polls_data WHERE poll_id = $poll_id",__LINE__,__FILE__);
		$GLOBALS['phpgw']->db->next_record();
		$poll_sum = $GLOBALS['phpgw']->db->f('cnt');

		$GLOBALS['phpgw']->db->query("SELECT poll_title FROM phpgw_polls_desc WHERE poll_id = $poll_id",__LINE__,__FILE__);
		$GLOBALS['phpgw']->db->next_record();

		$poll_title = $GLOBALS['phpgw']->db->f('poll_title', True);

		$ret[0] = array(
			'title' => $poll_title,
			'votes' => $poll_sum
		);

		// select next vote option
		$GLOBALS['phpgw']->db->query("SELECT * FROM phpgw_polls_data WHERE poll_id = $poll_id",__LINE__,__FILE__);
		while ($GLOBALS['phpgw']->db->next_record())
		{
			$ret[] = array(
				'text' => $GLOBALS['phpgw']->db->f('option_text', True),
				'votes' => $GLOBALS['phpgw']->db->f('option_count')
			);
		}

		return $ret;
	}

	function poll_generateUI($poll_id = '')
	{
		if (! $poll_id)
		{
			$GLOBALS['phpgw']->db->query('SELECT MAX(poll_id) FROM phpgw_polls_desc',__LINE__,__FILE__);
			$GLOBALS['phpgw']->db->next_record();
			$poll_id = $GLOBALS['phpgw']->db->f(0);
		}

		if (! verify_uservote($poll_id))
		{
			return False;
		}

		$GLOBALS['phpgw']->db->query('SELECT poll_title FROM phpgw_polls_desc WHERE poll_id = ' . intval($poll_id),__LINE__,__FILE__);
		$GLOBALS['phpgw']->db->next_record();

		echo "\n";
		echo '<form action="' . $GLOBALS['phpgw']->link('/polls/vote.php') . '" method="post">' . "\n";
		echo '<input type="hidden" name="poll_id" value="' . $poll_id . '">' . "\n";
//		echo '<input type="hidden" name="poll_forwarder" value="' . $poll_forwarder . '">';
		echo '<table border="0" align="center" width="50%">' . "\n"
			. ' <tr>' . "\n"
			. '  <td colspan="2" bgcolor="' . $GLOBALS['phpgw_info']['theme']['th_bg'] . '" align="center">&nbsp;'
			. $GLOBALS['phpgw']->db->f('poll_title', True) . '&nbsp;</td>' . "\n"
			. ' </tr>' . "\n";

		$GLOBALS['phpgw']->db->query('SELECT * FROM phpgw_polls_data WHERE poll_id = ' . intval($poll_id),__LINE__,__FILE__);
		while ($GLOBALS['phpgw']->db->next_record())
		{
			$tr_color = $GLOBALS['phpgw']->nextmatchs->alternate_row_color($tr_color);
			echo ' <tr bgcolor="' . $tr_color . '">' . "\n"
				. '  <td align="center"><input type="radio" name="poll_voteNr" value="'
				. $GLOBALS['phpgw']->db->f('vote_id') . '"></td>' . "\n"
				. '  <td>&nbsp;' . $GLOBALS['phpgw']->db->f('option_text', True) . '</td>' . "\n"
				. ' </tr>' . "\n";
		}

		echo ' <tr bgcolor="' . $GLOBALS['phpgw_info']['theme']['bgcolor'] . '">' . "\n"
			. '  <td colspan="2">&nbsp;</td>' . "\n"
			. ' </tr>' . "\n"
			. ' <tr bgcolor="' . $GLOBALS['phpgw_info']['theme']['bgcolor'] . '">' . "\n"
			. '  <td colspan="2" align="center">'
			. '   <input name="submit" type="submit" value="' . lang('Vote') . '"></td>' . "\n"
			. ' </tr>' . "\n"
			. '</table>' . "\n" . '</form>' . "\n";
	}

	function display_poll()
	{
		if (! verify_uservote($GLOBALS['poll_settings']['currentpoll']))
		{
			poll_viewResults($GLOBALS['poll_settings']['currentpoll']);
		}
		else
		{
			poll_generateUI($GLOBALS['poll_settings']['currentpoll']);
		}
	}
?>
