<?php
  /**************************************************************************\
  * phpGroupWare - Human Resources                                           *
  * http://www.phpgroupware.org                                              *
  * Written by Joseph Engo <jengo@phpgroupware.org>                          *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: index.php,v 1.12.2.1.2.3 2004/02/02 23:44:16 alexbsa Exp $ */

	if(@isset($GLOBALS['phpgw_info']))
	{
		settype($GLOBALS['phpgw_info'],'array');
	}

	$GLOBALS['phpgw_info']['flags'] = Array(
		'currentapp'	=> 'hr',
		'enable_nextmatchs_class'	=> True
	);
	include('../header.inc.php');
?>
<p>
<table border="0" width="100%">
 <tr>
  <td align="left" width="50%" valign="top">
   <table border="0" width="80%">
    <tr>
	  <td bgcolor="<?php echo $GLOBALS['phpgw_info']['theme']['th_bg'] ?>" align="center">
	     <b><?php echo lang('users'); ?></b>
	  </td>
    </tr>
<?php
	$account_info = $GLOBALS['phpgw']->accounts->get_list('accounts');
	while (list($null,$account) = each($account_info))
	{
		$GLOBALS['tr_color'] = $GLOBALS['phpgw']->nextmatchs->alternate_row_color($GLOBALS['tr_color']);
?>
    <tr>
     <td bgcolor="<?php echo $GLOBALS['tr_color']; ?>">&nbsp;<a href="<?php echo $GLOBALS['phpgw']->link('/hr/index.php','userid='.$account['account_id']); ?>"><?php echo $account['account_firstname'].' '.$account['account_lastname']; ?></a></td>
    </tr>
<?php
	}
?>
   </table>
   <p>
   <table border="0" width="80%">
    <tr>
     <td bgcolor="<?php echo $GLOBALS['phpgw_info']['theme']['th_bg']; ?>" align="center">
     	<b><?php echo lang('groups'); ?></b>
     </td>
    </tr>
<?php
	$group_info = $GLOBALS['phpgw']->accounts->get_list('groups');
	while (list($null,$group) = each($group_info))
	{
		$GLOBALS['tr_color'] = $GLOBALS['phpgw']->nextmatchs->alternate_row_color($GLOBALS['tr_color']);
?>
    <tr>
     <td bgcolor="<?php echo $GLOBALS['tr_color']; ?>">&nbsp;<a href="<?php echo $GLOBALS['phpgw']->link('/hr/index.php','groupid='.$group['account_id']); ?>"><?php echo $group['account_lid']; ?></a></td>
    </tr>
<?php
	}
?>
   </table>
  </td>
  <td align="right" width="50%" valign="top">
<?php

	function display_line($label,$data,$link='',$valign='')
	{
		$GLOBALS['tr_color'] = $GLOBALS['phpgw']->nextmatchs->alternate_row_color($GLOBALS['tr_color']);
		echo '<tr>'."\n"
			. ' <td align="right" bgcolor="' . $GLOBALS['tr_color'] . '" width="50%">' 
			. "\t<b>$label<b>\n"
			. '</td>'."\n"
			. ' <td align="left" width="50%" bgcolor="' . $GLOBALS['tr_color'] . '"'.$valign.'>';
			
		if($link)
		{
			echo '<a href="'.$link.'">';
		}
		
		echo $data;
		
		if($link)
		{
			echo '</a>';
		}
		
		echo '</td>'."\n".'</tr>'."\n";
	}

	//Quick fix for globals - skwashd
	$groupid = intval($_GET['groupid']);
	$userid  = intval($_GET['userid']);

	if ($groupid && !$userid)
	{
		$account = CreateObject('phpgwapi.accounts',$groupid,'g');
		$groupdata = $account->read();

		echo '<table border="0" width="80%">';
		echo '<tr><td colspan="2" bgcolor="' . $phpgw_info['theme']['th_bg']	. '">&nbsp;</td></tr>';

		
		if(!$groupdata['account_id'])
		{
			display_line(lang('error') . ':', lang('group not found'));
		}
		else
		{
			$membership = $account->member($groupid);
			$firstname = $groupdata['firstname'];
			$lastname  = $groupdata['lastname'];

			if($GLOBALS['phpgw_info']['user']['apps']['admin'])
			{
				$link = $GLOBALS['phpgw']->link('/index.php',
					Array(
						'menuaction'	=> 'admin.uiaccounts.edit_group',
						'account_id'	=> $groupdata['account_id']
					)
				);
			}
			else
			{
				$link = '';
			}
			display_line(lang('group login') . ':',$groupdata['account_lid'],$link);
			display_line(lang('first name') . ':',$firstname);
			display_line(lang('last name') . ':',$lastname);

			
			echo '<tr><td colspan="2">&nbsp;</td></tr>';
			echo '<tr><td colspan="2" align="left" bgcolor="' . $phpgw_info['theme']['th_bg']
			. '"><b>' . lang('members of the group') . ':</b></td></tr>';
			
			for ($i=0;$i<count($membership); $i++) 
			{
				$GLOBALS['tr_color'] = $GLOBALS['phpgw']->nextmatchs->alternate_row_color($GLOBALS['tr_color']);
				echo '<tr bgcolor="'.$GLOBALS['tr_color'].'"><td colspan="2"><a href="'
					. $GLOBALS['phpgw']->link('/hr/index.php','userid='.$membership[$i]['account_id']) . '">'
					. $membership[$i]['account_name'] . '</a></td></tr>';
			}
			echo '</table>';
		}
	}
	elseif (!$groupid && $userid)
	{
		$account = CreateObject('phpgwapi.accounts',$userid,'u');
		$account_info = $account->read_repository();
		$membership = $account->membership($userid);
		$contacts = CreateObject('phpgwapi.contacts');
		$contact_id = $contacts->is_contact($userid);

		$qcols = array(
			'n_given'    => 'n_given',
			'n_family'   => 'n_family',
			'tel_work'   => 'tel_work',
			'tel_home'   => 'tel_home',
			'tel_cell'   => 'tel_cell',
			'title'      => 'title',
			'email'      => 'email',
			'email_home' => 'email_home',
		);

		$fields = $contacts->are_users($account_info['person_id'], $qcols);
		
		if(!$account_info['person_id'] && $GLOBALS['phpgw_info']['user']['apps']['admin'])
		{
			$sfields = rawurlencode(serialize($fields[0]));
			$contact_link   = $GLOBALS['phpgw']->link('/index.php',
				array
				(
					'menuaction'	=> 'addressbook.uiaddressbook.add_person',
					'entry'		=> $fields,
				)
			);
			$contact_text = lang('add');
		}
		else
		{
			$contact_link   = $GLOBALS['phpgw']->link('/index.php',
				array
				(
					'menuaction'	=> 'addressbook.uiaddressbook.view_person',
					'ab_id'		=> $fields[0]['person_id']
				)
			);
			$contact_text = lang('view');
		}

		$firstname = $account_info['firstname'];
		$lastname  = $account_info['lastname'];

		if ($GLOBALS['phpgw_info']['user']['apps']['email'])
		{
			if ($fields[0]['email'])
			{
				$profile_work_email = '<a href="'.$GLOBALS['phpgw']->link('/email/compose.php','to='.urlencode($fields[0]['email'])).'" target="_new">'.$fields[0]['email'].'</a>';
			}
			if ($fields[0]['email_home'])
			{
				$profile_home_email = '<a href="'.$GLOBALS['phpgw']->link('/email/compose.php','to='.urlencode($fields[0]['email_home'])).'" target="_new">'.$fields[0]['email_home'].'</a>';
			}
		}
		else
		{
			if ($fields[0]['email']) 
			{
				$profile_work_email='<a href="mailto:'. $fields[0]['email'] .'">'.$fields[0]['email'].'</a>';
			}
			if ($fields[0]['email_home']) 
			{
				$profile_home_email='<a href="mailto:'. $fields[0]['email_home'] .'">'.$fields[0]['email_home'].'</a>';
			}
		}

		$profile_work_phone = $GLOBALS['phpgw']->strip_html($fields[0]['tel_work']);
		if (!$profile_work_phone)
		{
			$profile_work_phone = '&nbsp;';
		}

		$profile_home_phone = $GLOBALS['phpgw']->strip_html($fields[0]['tel_home']);
		if (!$profile_home_phone)
		{
			$profile_home_phone = '&nbsp;';
		}

		$profile_title = $GLOBALS['phpgw']->strip_html($fields[0]['title']);

		echo '<table border="0" width="80%">';
		echo '<tr><td colspan="2" bgcolor="' . $GLOBALS['phpgw_info']['theme']['th_bg']
			. '">&nbsp;</td></tr>';

		if($GLOBALS['phpgw_info']['user']['apps']['admin'])
		{
			$link = $GLOBALS['phpgw']->link('/index.php',
				array(
					'menuaction'	=> 'admin.uiaccounts.edit_user',
					'account_id'	=> $account_info['account_id']
				)
			);
		}
		else
		{
			$link = '';
		}
		display_line(lang('account login') . ':', $account_info['account_lid'], $link);
		display_line(lang('profile') . ':',$contact_text,$contact_link);
		display_line(lang('first name') . ':',$firstname);
		display_line(lang('last name') .':',$lastname);
		display_line(lang('title') . ':',$profile_title);
		display_line(lang('work phone') . ':',$profile_work_phone);
		display_line(lang('home phone') .':',$profile_home_phone);
		display_line(lang('work email') . ':',$profile_work_email);
		display_line(lang('home email') . ':',$profile_home_email);
		display_line('&nbsp;','<img src="' . $GLOBALS['phpgw']->link('/hr/view_image.php','con='.$account_info['account_id']).'" width="100" height="120">');

		echo '<tr><td colspan="2">&nbsp;</td></tr>';
		echo '<tr><td colspan="2" align="left" bgcolor="' . $GLOBALS['phpgw_info']['theme']['th_bg']
			. '"><b>' . lang('member of the following groups') . ':<b></td></tr>';

		for ($i=0;$i<count($membership); $i++)
		{
			$GLOBALS['tr_color'] = $GLOBALS['phpgw']->nextmatchs->alternate_row_color($GLOBALS['tr_color']);
			echo '<tr bgcolor="'.$GLOBALS['tr_color'].'"><td colspan="2">'
				. '<a href="'.$GLOBALS['phpgw']->link('/hr/index.php','groupid='.$membership[$i]['account_id']).'">'
				. $membership[$i]['account_name'] . '</a></td></tr>';
		}
		echo '</table>';
	}
?>
  </td>
 </tr>
</table>
<?php
	$GLOBALS['phpgw']->common->phpgw_footer();
?>
