<?php
  /**************************************************************************\
  * phpGroupWare - DJ mp3 directories                                        *
  * http://www.phpgroupware.org                                              *
  * Written by Bettina Gille [ceb@phpgroupware.org]                          *
  * -----------------------------------------------                          *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/
  /* $Id: directories.php,v 1.5.2.1 2003/02/27 21:48:38 gugux Exp $ */

	$GLOBALS['phpgw_info']['flags'] = array(
		'currentapp' => 'dj',
		'enable_nextmatchs_class' => True
	);

	include('../header.inc.php');

	$GLOBALS['phpgw']->template->set_file(array('dir_list_t'   => 'listdirectories.tpl'));
	$GLOBALS['phpgw']->template->set_block('dir_list_t','dir_list','list');

	$common_hidden_vars = "<input type=\"hidden\" name=\"sort\" value=\"$sort\">\n"
		. "<input type=\"hidden\" name=\"order\" value=\"$order\">\n"
		. "<input type=\"hidden\" name=\"query\" value=\"$query\">\n"
		. "<input type=\"hidden\" name=\"start\" value=\"$start\">\n"
		. "<input type=\"hidden\" name=\"filter\" value=\"$filter\">\n";

	$GLOBALS['phpgw']->template->set_var('lang_action',lang('Directory List'));
	$GLOBALS['phpgw']->template->set_var('add_action',$GLOBALS['phpgw']->link('/dj/adddirectory.php'));
	$GLOBALS['phpgw']->template->set_var('lang_add',lang('Add'));
	$GLOBALS['phpgw']->template->set_var('title_directories',lang('Directories'));
	$GLOBALS['phpgw']->template->set_var('lang_search',lang('Search'));
	$GLOBALS['phpgw']->template->set_var('actionurl',$GLOBALS['phpgw']->link('/dj/directories.php'));
	$GLOBALS['phpgw']->template->set_var('lang_done',lang('Done'));
	$GLOBALS['phpgw']->template->set_var('doneurl',$GLOBALS['phpgw']->link('/preferences/index.php'));

	if (!$start)
	{
		$start = 0;
	}

	if ($GLOBALS['phpgw_info']['user']['preferences']['common']['maxmatchs'] &&
		$GLOBALS['phpgw_info']['user']['preferences']['common']['maxmatchs'] > 0)
	{
		$limit = $GLOBALS['phpgw_info']['user']['preferences']['common']['maxmatchs'];
	}
	else
	{
		$limit = 15;
	}

	if (!$sort)
	{
		$sort = 'ASC';
	}

	if ($query)
	{
		$querymethod = " WHERE dir_name like '%$query%'";
	}

	$db2 = $GLOBALS['phpgw']->db;

	$sql = "SELECT * FROM phpgw_dj_directories $querymethod  order by dir_name $sort";
	$db2->query($sql,__LINE__,__FILE__);
	$total_records = $db2->num_rows();
	$GLOBALS['phpgw']->db->limit_query($sql . " ",$start,__LINE__,__FILE__);
	while ($GLOBALS['phpgw']->db->next_record())
	{
		$directory[] = array(
			'dir_id'   => $GLOBALS['phpgw']->db->f('dir_id'),
			'dir_name' => $GLOBALS['phpgw']->db->f('dir_name')
		);
	}

	//--------------------------------- nextmatch --------------------------------------------
	$left = $GLOBALS['phpgw']->nextmatchs->left('/dj/directories.php',$start,$total_records);
	$right = $GLOBALS['phpgw']->nextmatchs->right('/dj/directories.php',$start,$total_records);
	$GLOBALS['phpgw']->template->set_var('left',$left);
	$GLOBALS['phpgw']->template->set_var('right',$right);

	if ($total_records > $limit)
	{
		$GLOBALS['phpgw']->template->set_var('lang_showing',lang("showing %1 - %2 of %3",($start + 1),($start + $limit),$total_records));
	}
	else
	{
		$GLOBALS['phpgw']->template->set_var('lang_showing',lang("showing %1",$total_records));
	}

	//------------------------------ end nextmatch ------------------------------------------

	//------------------- list header variable template-declarations ------------------------- 
	$GLOBALS['phpgw']->template->set_var('th_bg',$GLOBALS['phpgw_info']["theme"][th_bg]);
	$GLOBALS['phpgw']->template->set_var('name',lang('Directory Name'));
	$GLOBALS['phpgw']->template->set_var('lang_edit',lang('Edit'));
	$GLOBALS['phpgw']->template->set_var('lang_delete',lang('Delete'));

	//-------------------------- end header declaration --------------------------------------
	@reset($directory);
	while (list($key,$dirinfo) = @each($directory))
	{
		$tr_color = $GLOBALS['phpgw']->nextmatchs->alternate_row_color($tr_color);
		$GLOBALS['phpgw']->template->set_var(tr_color,$tr_color);
		$dir_id = $dirinfo['dir_id'];
		$dir_name = $GLOBALS['phpgw']->strip_html($dirinfo['dir_name']);
		//-------------------------- template declaration for list records ---------------------------
		$GLOBALS['phpgw']->template->set_var('dir_name',$dir_name);

		$GLOBALS['phpgw']->template->set_var('edit',$GLOBALS['phpgw']->link('/dj/editdirectory.php',"dir_id=$dir_id&start=$start&query=$query&sort=$sort&order=$order&filter=$filter"));
		$GLOBALS['phpgw']->template->set_var('lang_edit_entry',lang('Edit'));

		$GLOBALS['phpgw']->template->set_var('delete',$GLOBALS['phpgw']->link('/dj/deletedirectory.php',"dir_id=$dir_id&start=$start&query=$query&sort=$sort&order=$order&filter=$filter"));
		$GLOBALS['phpgw']->template->set_var('lang_delete_entry',lang('Delete'));
		$GLOBALS['phpgw']->template->parse('list','dir_list',True);
	}
	// ---------------------------- end record declaration -----------------------------------------

	$GLOBALS['phpgw']->template->parse('out','dir_list_t',True);
	$GLOBALS['phpgw']->template->p('out');

	$GLOBALS['phpgw']->common->phpgw_footer();
?>
