/*
 * lcmswrapper.cpp - encapsulates typical "user" functions of LittleCMS,
 * providing a Profile and Transform class
 *
 * Copyright (c) 2004 by Alastair M. Robinson
 * Distributed under the terms of the GNU General Public License -
 * see the file named "COPYING" for more details.
 *
 * TODO: Report pixel type, support Lab, XYZ, etc.
 *
 */

#ifndef LCMSWRAPPER_H
#define LCMSWRAPPER_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <lcms.h>
#include "md5.h"
#include "../imagesource/imagesource_types.h"

class CMSWhitePoint;
class CMSRGBPrimaries;
class CMSRGBGamma;
class CMSGamma;

class CMSProfile
{
	public:
	CMSProfile(const char *filename);
	CMSProfile(char *buffer,int length);
	CMSProfile(CMSRGBPrimaries &primaries,CMSRGBGamma &gamma,CMSWhitePoint &whitepoint);
	~CMSProfile();
	enum IS_TYPE GetColourSpace();
	enum IS_TYPE GetDeviceLinkOutputSpace();
	bool IsDeviceLink();
	const char *GetName();
	const char *GetManufacturer();
	const char *GetModel();
	const char *GetDescription();
	const char *GetInfo();
	const char *GetCopyright();
	const char *GetFilename();
	MD5Digest *GetMD5();
	bool operator==(const CMSProfile &other);
	protected:
	MD5Digest *md5;
	cmsHPROFILE prof;
	char *filename;
	friend class CMSTransform;
};


class CMSTransform
{
	public:
	CMSTransform(CMSProfile *in,CMSProfile *out,int intent=INTENT_PERCEPTUAL);
	CMSTransform(CMSProfile *devicelink,int intent=INTENT_PERCEPTUAL);
	CMSTransform(CMSProfile *profiles[],int profilecount,int intent=INTENT_PERCEPTUAL);
	~CMSTransform();
	void Transform(unsigned short *src,unsigned short *dst,int pixels);
	enum IS_TYPE GetInputColourSpace();
	enum IS_TYPE GetOutputColourSpace();
	private:
	void MakeTransform(CMSProfile *in,CMSProfile *out,int intent);
	enum IS_TYPE inputtype;
	enum IS_TYPE outputtype;
	cmsHTRANSFORM transform;
};


class CMSWhitePoint
{
	public:
	CMSWhitePoint(int degk)
	{
		cmsWhitePointFromTemp(degk,&whitepoint);
	}
	protected:
	cmsCIExyY whitepoint;
	friend class CMSProfile;
};


class CMSRGBPrimaries
{
	CMSRGBPrimaries(float rx,float ry,float gx,float gy,float bx,float by)
	{
		primaries.Red.x=rx;
		primaries.Red.y=ry;
		primaries.Red.Y=1.0;
		primaries.Green.x=gx;
		primaries.Green.y=gy;
		primaries.Green.Y=1.0;
		primaries.Blue.x=bx;
		primaries.Blue.y=by;
		primaries.Blue.Y=1.0;	
	}
	protected:
	cmsCIExyYTRIPLE primaries;
	friend class CMSProfile;
};


class CMSGamma
{
	public:
	CMSGamma(float gamma)
	{
		gammatable=cmsBuildGamma(256,gamma);
	}
	~CMSGamma()
	{
		cmsFreeGamma(gammatable);
	}
	protected:
	LPGAMMATABLE gammatable;
	friend class CMSProfile;
	friend class CMSRGBGamma;
};

class CMSRGBGamma
{
	public:
	CMSRGBGamma(float rgamma,float ggamma,float bgamma)
		: redgamma(rgamma),greengamma(ggamma),bluegamma(bgamma)
	{
		gammatables[0]=redgamma.gammatable;
		gammatables[1]=greengamma.gammatable;
		gammatables[2]=bluegamma.gammatable;
	}
	protected:
	CMSGamma redgamma,greengamma,bluegamma;
	LPGAMMATABLE gammatables[3];
	friend class CMSProfile;
};

int CMS_GetIntentCount();
const char *CMS_GetIntentName(int intent);
const char *CMS_GetIntentDescription(int intent);

#endif
