include(CheckCXXCompilerFlag)

if(NOT BINARY_PACKAGE_BUILD)
  message(STATUS "Checking for -march=native support")
  CHECK_CXX_COMPILER_FLAG("-march=native" MARCHNATIVE)
  if(MARCHNATIVE)
    message(STATUS "Checking for -march=native support - works")
    set(MARCH "-march=native")
  else()
    message(STATUS "Checking for -mtune=native support")
    CHECK_CXX_COMPILER_FLAG("-mtune=native" MTUNENATIVE)
    if(MTUNENATIVE)
      message(STATUS "Checking for -mtune=native support - works")
      set(MARCH "-mtune=native")
    else()
      message(STATUS "Checking for -mtune=generic support")
      CHECK_CXX_COMPILER_FLAG("-mtune=generic" MTUNEGENERIC)
      if(MTUNEGENERIC)
        message(STATUS "Checking for -mtune=generic support - works")
        set(MARCH "-mtune=generic")
      else()
        message(WARNING "Do not know which -march/-mtune to pass! Resulting binaries may be broken!")
      endif()
    endif()
  endif()
else()
  message(STATUS "Checking for -mtune=generic support")
  CHECK_CXX_COMPILER_FLAG("-mtune=generic" MTUNEGENERIC)
  if(MTUNEGENERIC)
    message(STATUS "Checking for -mtune=generic support - works")
    set(MARCH "-mtune=generic")
  else()
    message(WARNING "Do not know which -march/-mtune to pass! Resulting binaries may be broken!")
  endif()
endif()

ADD_DEFINITIONS(${MARCH})
