#include "phluid.h"
#include "debug.h"

void
button_press(XEvent ev)
{
  Client *c;
  int mouse_x, mouse_y;
  DEBUG_PRINT("got ButtonPress\n");
  get_mouse_x_y(&mouse_x, &mouse_y);
  if(ev.xbutton.window == root) {
    switch(ev.xbutton.button) {
      case Button2:
        system("gtk-switch &");
        break;
      default:
        system("gtk-panel &");
        break;
    }
  }
  c = find_client_by_frame(ev.xbutton.window);
  if (c) {
    Decal *decal;
    XEvent peek;

    decal = decal_at(c, ev.xbutton.x, ev.xbutton.y);
    XPeekEvent(disp, &peek);

    if (decal) {
      Decal *tmp_decal;
      XEvent tmp_ev;
      XMaskEvent(disp, ButtonReleaseMask, &tmp_ev);
      tmp_decal = decal_at(c, tmp_ev.xbutton.x, tmp_ev.xbutton.y);
      if(tmp_decal == decal)
        do_decal_fn(c, decal, ev.xbutton.button);
      return;
    }

    if (ev.xbutton.button == Button2) {
      shade_client(c);
      XSync(disp, False);
      icccm_send_configure_event(c);
      return;
    }

    if (ev.xbutton.button == Button3) {
      return;
    }

    /* the user let go immediately, so treat as click not drag */
    if (peek.type == ButtonRelease) {
      Window top;
      Client *tmp;
      char *name;

      top = x_get_top_window();
      XFetchName(disp, top, &name);
      DEBUG_VAR("top window: %s\n", name);
      XFree(name);

      tmp = find_client_by_frame(top);
      if (!tmp)
        DEBUG_PRINT("top window not found as frame\n");

      if (c->frame == top) {
        DEBUG_PRINT("client is on top\n");
        XLowerWindow(disp, c->frame);
      } else {
        DEBUG_PRINT("client is NOT on top\n");
        XRaiseWindow(disp, c->frame);
      }
    }

    if (peek.type == MotionNotify &&
        ev.xbutton.x > (c->width + EDGE_THICKNESS - 5) &&
        ev.xbutton.y > (c->height + TITLEBAR_HEIGHT - 5)) {
      resize_client(c, mouse_x, mouse_y);
      XSync(disp,False);
    } else if (peek.type == MotionNotify) {
      drag_client(c, mouse_x, mouse_y);
      if (MOVE_AFTER_DRAG) {
        XMoveWindow(disp, c->frame, c->x, c->y);
      }
      XSync(disp,False);
      if (SEND_CONFIGURE_AFTER_DRAG) {
        icccm_send_configure_event(c);
      }
    }
  }
}

void
motion_notify(XEvent ev)
{
  Client *c = find_client_by_frame(ev.xbutton.window);
  DEBUG_PRINT("got MotionNotify\n");
  if (c) {
    Decal *decal;
    decal = decal_at(c, ev.xbutton.x, ev.xbutton.y);

    if (ev.xbutton.x > (c->width + EDGE_THICKNESS - 5) &&
        ev.xbutton.y > (c->height + TITLEBAR_HEIGHT - 5)) {
      XDefineCursor(disp, c->frame, resize_curs);
    } else if (!decal &&
               (ev.xbutton.x > (c->width + EDGE_THICKNESS) ||
                ev.xbutton.x < EDGE_THICKNESS ||
                ev.xbutton.y > (c->height + TITLEBAR_HEIGHT) ||
                ev.xbutton.y < TITLEBAR_HEIGHT)) {
      XDefineCursor(disp, c->frame, move_curs);
    } else {
      XUndefineCursor(disp, c->frame);
    }
  }
}

void
map_request(XEvent ev)
{
  char *name, *dummy;
  Client *c;
  int x, y;

  /* check that the program isn't gkrellm / xmms */
  XFetchName(disp, ev.xmaprequest.window, &name);
  DEBUG_VAR("name: %s\n", name);
  if (name && strcmp(name, "gkrellm") == 0) {
    XFree(name);
    XMapWindow(disp, ev.xmaprequest.window);
    return;
  }
  dummy = malloc(sizeof(char) * 5);
  dummy[0] = '\0';
  if (name && strcmp(strncat(dummy, name, 4), "XMMS") == 0) {
    XFree(name);
    XMapWindow(disp, ev.xmaprequest.window);
    return;
  }
  
  c = find_client_by_child(ev.xmap.window);
  if (c)
    return; /* we already have a client for this window */

  /* otherwise, make a new client */
  get_mouse_x_y(&x, &y);
  XMoveWindow(disp, ev.xmap.window, x-30, y-8);
  XMapWindow(disp, ev.xmaprequest.window);
  XSync(disp, False);
  make_client(&ev.xmap.window);
}

void
unmap_notify(XEvent ev)
{
  Client *c;
  c = find_client_by_child(ev.xunmap.window);
  
  if (c) {
    if (c->ignore_unmap > 0)
      c->ignore_unmap--;
    else
      delete_client(c);
  }
}

void
expose (XEvent ev)
{
  Client *exposed;
  /* was the exposed window a frame? */
  exposed = find_client_by_frame(ev.xexpose.window);
 
  if (exposed) {
    /* yes, so ask imlib to update the exposed portion */
    exposed->updates =
      imlib_update_append_rect(exposed->updates, ev.xexpose.x,
                               ev.xexpose.y, ev.xexpose.width,
                               ev.xexpose.height);
  }
}

void
enter_notify (XEvent ev)
{
  Client *c;
  c = find_client_by_frame(ev.xcrossing.window);
  if (c) {
    if(!c->shaded)
      XSetInputFocus(disp, c->window, RevertToPointerRoot, CurrentTime);
  }
}

void
property_notify (XEvent ev)
{
  Client *c;
  
  c = find_client_by_child(ev.xproperty.window);
  
  /* name change? */
  if (c && ev.xproperty.atom == XA_WM_NAME) {
    DEBUG_PRINT("PropertyNotify is a name change\n");
    DEBUG_VAR("old name was: %s\n", c->name);
    if (c->name)
      XFree(c->name);
    XFetchName(disp, c->window, &c->name);
    DEBUG_VAR("new name is: %s\n", c->name);
    c->name_change++;
    redraw_client(c);
  }
}


void
configure_request (XEvent ev)
{
  Client *c;
  XWindowChanges changes;
  int mask, width, height;

  mask = ev.xconfigurerequest.value_mask;
  width = ev.xconfigurerequest.width;
  height = ev.xconfigurerequest.height;
  c = find_client_by_child(ev.xconfigurerequest.window);

  if (c) {
    if (mask & (CWWidth|CWHeight)) {
      c->width = width;
      c->height = height;
      icccm_send_configure_event(c);
      XResizeWindow(disp, c->frame, width+2*EDGE_THICKNESS, height+TITLEBAR_HEIGHT);
    }
    if(mask & CWWidth) {
      /* width changed redraw titlebar */
      render_title_bar(c);
    }
    changes.x = EDGE_THICKNESS;
    changes.y = TITLEBAR_HEIGHT;
  } else {
    changes.x = ev.xconfigurerequest.x;
    changes.y = ev.xconfigurerequest.y;
  }

  changes.width = width;
  changes.height = height;
  changes.sibling = ev.xconfigurerequest.above;
  changes.stack_mode = ev.xconfigurerequest.detail;
  XConfigureWindow(disp, ev.xconfigurerequest.window, mask, &changes);
}
