#!/usr/bin/python

# $Progeny: main.py,v 1.31 2002/01/18 06:20:02 dsp Exp $

# Copyright (C) 2001  Progeny Linux Systems, Inc.
# AUTHORS: Jeff Licquia <jlicquia@progeny.com>
#          Branden Robinson <branden@progeny.com>
#          Eric Gillespie, Jr. <epg@progeny.com>

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License, version 2,  as
# published by the Free Software Foundation.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import configlet
import sys
import os
import string
import re
import whrandom
import crypt

user_attributes = {
    "name":          "user",
    "display_title": "Configure User Accounts",
    "description":   "This option sets the login and password information " +\
                     "for the administrator account (root) and user " +\
                     "accounts.",
    "packages":      ["passwd"],
    "priority":      45
    }

def _get_shells():
    shells = []

    file = open("/etc/shells", "r")
    line = file.readline()
    while line:
        s = string.split(line, "#")
        s = string.rstrip(s[0])
        if s and os.path.exists(s):
            shells.append(s)
        line = file.readline()

    file.close()

    shells.sort()
    return shells

def encrypt_password(plaintext, strong):
    global wtree

    saltchars = "./" + string.letters + string.digits

    if strong:
        # Hash with MD5.
        salt = "$1$"
        for count in range(0, 8):
            salt = salt + saltchars[whrandom.randint(0, len(saltchars) - 1)]
    else:
        # Hash with crypt.
        salt = ""
        for count in range(0, 2):
            salt = salt + saltchars[whrandom.randint(0, len(saltchars) - 1)]

    hash = crypt.crypt(plaintext, salt)
    return hash

def change_password(user, hash):
    passwd_pipe = os.popen("/usr/sbin/chpasswd -e", "w")
    passwd_pipe.write("%s:%s\n" % (user, hash))
    retval = passwd_pipe.close()

def toggle_user(button):
    global wtree

    wtree.get_widget("userframe").set_sensitive(button.get_active())

class User(configlet.Configlet):
    def gnome_setup(self):
        configlet.Configlet.gnome_setup(self)
        global gnome_ui
        import gnome.ui
        gnome_ui = gnome.ui

        global wtree

        wtree = self.wtree

        wtree.signal_autoconnect({
            "on_createuser_toggled": toggle_user
            })

        combo = self.wtree.get_widget("shell_combo")
        combo_entry = self.wtree.get_widget("shell_combo_entry")
        combo.set_popdown_strings(_get_shells())
        combo_entry.set_text("/bin/bash")

    def validate_page(self, pagename):
        result = 1

        username = self.wtree.get_widget("username")
        userpwd1 = self.wtree.get_widget("userpwd1")
        userpwd2 = self.wtree.get_widget("userpwd2")
        rootpwd1 = self.wtree.get_widget("rootpwd1")
        rootpwd2 = self.wtree.get_widget("rootpwd2")

        if rootpwd1.get_text() == "":
            gnome_ui.GnomeMessageBox("You must enter a root password.\n"
                            "Please try again.",
                            "error", gnome_ui.STOCK_BUTTON_OK).run_and_close()
            result = 0

        if rootpwd1.get_text() != rootpwd2.get_text():
            gnome_ui.GnomeMessageBox("The root passwords you entered did not match.\n"
                            "Please try again.",
                            "error", gnome_ui.STOCK_BUTTON_OK).run_and_close()
            rootpwd1.set_text("")
            rootpwd2.set_text("")
            result = 0

        if self.wtree.get_widget("createuser").get_active():
            if username.get_text() == "":
                gnome_ui.GnomeMessageBox("You must enter a user name.\n"
                                "Please try again.",
                                "error",
                                gnome_ui.STOCK_BUTTON_OK).run_and_close()
                result = 0
            else:
                for char in username.get_text():
                    if char not in string.digits and \
                       char not in string.lowercase:
                        gnome_ui.GnomeMessageBox("User names can only contain lowercase letters and numbers.\n"
                                        "Please try again.",
                                        "error",
                                        gnome_ui.STOCK_BUTTON_OK).run_and_close()
                        result = 0
                        break

            if userpwd1.get_text() == "":
                gnome_ui.GnomeMessageBox("You must enter a user password.\n"
                                "Please try again.",
                                "error",
                                gnome_ui.STOCK_BUTTON_OK).run_and_close()
                result = 0

            if (self.wtree.get_widget("strength-compat").get_active()
                and len(userpwd1.get_text()) > 8):
                gnome_ui.GnomeMessageBox("DES passwords may not be more than eight characters in length.\n"
                                         "Please try again.",
                                         "error",
                                         gnome_ui.STOCK_BUTTON_OK).run_and_close()

            if userpwd1.get_text() != userpwd2.get_text():
                gnome_ui.GnomeMessageBox("The user passwords you entered did not "
                                "match.\n"
                                "Please try again.",
                                "error",
                                gnome_ui.STOCK_BUTTON_OK).run_and_close()
                userpwd1.set_text("")
                userpwd2.set_text("")
                result = 0

            fullname = self.wtree.get_widget("fullname").get_chars(0, -1)
            if re.search("[:,]", fullname):
                gnome_ui.GnomeMessageBox("User fullname may not contain commas or colons.",
                                         "error",
                                         gnome_ui.STOCK_BUTTON_OK).run_and_close()

            shell = self.wtree.get_widget("shell_combo_entry").get_chars(0, -1)
            if not os.path.exists(shell):
                gnome_ui.GnomeMessageBox("User shell is not installed.  Please choose from the available list.",
                                         "error",
                                         gnome_ui.STOCK_BUTTON_OK).run_and_close()

        return result

    def on_gnome_close(self):
        use_md5 = self.wtree.get_widget("strength-max").get_active()
        use_shadow = self.wtree.get_widget("shadow").get_active()

        if use_shadow:
            os.system("/usr/sbin/shadowconfig on")

        for pamfn in ("/etc/pam.d/passwd", "/etc/pam.d/login"):
            newfn = pamfn + ".new"
            pamfile = open(pamfn, "r")
            newfile = open(newfn, "w")
            for line in pamfile.readlines():
                newline = line
                if newline[-1] == "\n":
                    newline = newline[:-1]
                if re.match(r'password.*required.*pam_(unix|ldap|pwdb)\.so.*',
                            line):
                    if use_md5 and not re.search("md5", line):
                        newline = newline + " md5"
                    elif not use_md5 and re.search("md5", line):
                        newline = re.sub(" md5", "", newline)
                newfile.write(newline + "\n")
            pamfile.close()
            newfile.close()
            os.unlink(pamfn)
            os.rename(newfn, pamfn)

        roothash = encrypt_password(
            self.wtree.get_widget("rootpwd1").get_text(), use_md5)
        self.wtree.get_widget("rootpwd1").set_text("")
        self.wtree.get_widget("rootpwd2").set_text("")
        change_password("root", roothash)

        if wtree.get_widget("createuser").get_active():
            username = self.wtree.get_widget("username").get_text()
            fullname = self.wtree.get_widget("fullname").get_text()
            uid = self.wtree.get_widget("uid_spinbutton").get_value_as_int()
            shell = self.wtree.get_widget("shell_combo_entry").get_chars(0, -1)

            userhash = encrypt_password(
                self.wtree.get_widget("userpwd1").get_text(), use_md5)
            self.wtree.get_widget("userpwd1").set_text("")
            self.wtree.get_widget("userpwd2").set_text("")

            if not fullname:
                fullname = username
            os.system("/usr/sbin/adduser --disabled-password "
                      "--gecos \"%s\" --uid \"%s\" "
                      "--shell \"%s\" \"%s\""
                      % (fullname, uid, shell, username))
            change_password(username, userhash)

configlet.register_configlet(User, user_attributes)

# vim:ai:et:sts=4:sw=4:tw=0:
