#! /usr/bin/python

# $Progeny: setup-base-text.py,v 1.14 2002/04/23 23:44:05 branden Exp $

import re
import sys

import pgi.base
import pgi.common

from getopt import getopt, GetoptError
from pgi.common import TRUE, FALSE, EX_USAGE, _, warn

###############################################################################
# getopt

extra_packages = None
mirror = "http://archive.progeny.com/debian"
suite = "stable"
swaps = []
target = "/target"

try:
    (opts, args) = getopt(sys.argv[1:], "",
                          ["extra-packages=",
                           "mirror=",
                           "suite=",
                           "swaps=",
                           "target="])
except GetoptError:
    sys.exit(EX_USAGE)

for (o, a) in opts:
    if o == "--extra-packages":
        extra_packages = a
        pgi.common.msg("Got extra packages file: %s\n" % (extra_packages,))
    elif o == "--mirror":
        mirror = a
    elif o == "--suite":
        suite = a
    elif "--swaps":
        for i in re.split(r"\s+", a):
            swaps.append(i)
    elif o == "--target":
        target = a

argc = len(args)
if argc == 0 or (argc % 3 != 0):
    sys.exit(EX_USAGE)

mounts = {}
i = 0
while i < argc:
    mounts[args[i]] = [args[i + 1], args[i + 2]]
    i = i + 3

###############################################################################
# Main

pgi.base.mount(mounts, target)
pgi.base.install_packages(suite, mirror, target, extra_packages)
pgi.base.mkfstab(mounts, swaps, target)
pgi.base.install_kernel(target)
