#!/bin/sh

# $Progeny: stage0.sh,v 1.141 2002/04/23 23:48:30 branden Exp $

pgilog () {
	if [ "$1" = "-n" ]
	then
		no_newline="$1"
		shift
	else
		no_newline=
	fi
	if [ -n "$PGIDEBUG" ]
	then
		echo $no_newline "$*"
	fi
	echo $no_newline "$*" >> $LOGFILE;
}

bring_up_network () {
	echo
	echo
	echo "Configuring the network..."

	ifconfig eth0 up
	ifconfig lo inet 127.0.0.1

	if [ -n "$ip" ]
	then
		PGI_STATIC=YES interface=eth0 configure-network bound
	else
		udhcpc -s /sbin/configure-network
	fi;
}

# load_from_modules_archive tarball [short_module_name
#   full_path_of_desired_module ... ]
load_from_modules_archive () {
	devices=$(discover --disable-all --enable=pci,ide,scsi,pcmcia --device cdrom)
	archive=$1
	shift
	if [ -n "$1" ]
	then
		module=$1
		shift
		# remaining arguments are filenames to extract
	fi
	status=1
	for device in $devices
	do
		if mount -t iso9660 -o ro $device /mnt 2> /dev/null
		then
			if [ -f "/mnt/$archive" ]
			then
				if [ -n "$module" ]
				then
					echo -n "Copying $module module from modules archive..."
					if (cd / && gzip -dc "/mnt/$archive" | tar xf - $@)
					then
						echo "done."
						status=0
					fi
				else
					echo -n "Copying $archive archive..."
					if (cd / && gzip -dc "/mnt/$archive" | tar xf -)
					then
						echo "done."
						status=0
					fi
				fi
			fi
			umount /mnt
		fi
	done

	return $status;
}

export ARCH DISPLAY DMESGLOG IDENTLOG KERNEL_VERSION LD_LIBRARY_PATH LIVE \
	LIVE_DEVICE LOGFILE MIRROR PATH PGIDEBUG PROMPTING RESCUE SUITE \
	SYSLOG TEXTMODE ip subnet router broadcast dns pgilog

# Get configuration information about this initrd.  Also find out whether we
# should assume we're doing a network-based install (auto_dhcp).  We permit the
# user to override the mirror and suite at the boot prompt.
ARCH=$(cat /etc/arch)
KERNEL_VERSION=$(cat /etc/kernel_version)
if [ -e /etc/http_proxy ]
then
	export http_proxy
	http_proxy=$(cat /etc/http_proxy)
fi
: ${auto_dhcp:=$(cat /etc/auto_dhcp 2> /dev/null)}
: ${MIRROR:=$(cat /etc/mirror)}
: ${SUITE:=$(cat /etc/suite)}
: ${EXPERIMENTAL:=$(cat /etc/experimental 2> /dev/null)}

PATH="/sbin:/bin"
LD_LIBRARY_PATH="/lib"
LIVE=/live
STAGE1=$LIVE/share/installer/stage1.sh

# amount of prompting to do; either "less" or "more"
PROMPTING=less

# installer log files
LOGFILE=/var/log/installer.log
SYSLOG=/var/log/installer.syslog
IDENTLOG=/var/log/installer.ident
DMESGLOG=/var/log/installer.dmesg

# sleep for a moment to give the kernel time to spew to the console
sleep 1

# small banner so people know what the heck is booting
echo
echo "PGI $(cat /etc/pgi_version); Copyright (C) 2001,2002 Progeny Linux Systems, Inc."
cat << EOF

PGI is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation;
either version 2, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU General Public License for more details.

EOF

# start the logfile with information about this PGI initrd
pgilog "PGI $(cat /etc/pgi_version)"
pgilog "Architecture: $(cat /etc/arch)"
pgilog "Vendor: $(cat /etc/vendor)"
pgilog "Product: $(cat /etc/product)"
pgilog "Verson: $(cat /etc/product_version)"
pgilog "Based on Debian release: $(cat /etc/debian_version)"
pgilog "Built by: $(cat /etc/builder)"
pgilog "Command line: $(cat /etc/pgi_cmdline)"

syslogd -O $SYSLOG

# link /usr to the initrd /
rm -f /usr
ln -s / /usr

# mount the /proc file system
mount -t proc proc /proc

# parse the command line options
for option in $(cat /proc/cmdline)
do
	label=$(echo $option | cut -d'=' -f1)
	value=$(echo $option | cut -d'=' -f2)

	case "$label" in
	ip|ipaddr)
		ip="$value"
		;;
	subnet|netmask)
		subnet="$value"
		;;
	router*|gateway)
		router="$value"
		;;
	broadcast)
		broadcast="$value"
		;;
	dns|nameserver)
		dns="$value"
		;;
	dhcp)
		dhcp=true
		;;
	display)
		DISPLAY="$value"
		;;
	nfs*)
		nfs="$value"
		;;
	pgidebug|debug)
		if [ "$value" = "noisy" ]
		then
			NOISY=true
			set -x
		fi
		PGIDEBUG=true
		;;
	rescue)
		RESCUE=true
		;;
	text*)
		TEXTMODE=true
		;;
	prompt*)
		if [ -n "$value" ]
		then
			PROMPTING=$value
		fi
		;;
	*)
		if [ -n "$value" ]
		then
			if sh -c "eval $label=$value"
			then
				eval $label=$value
			fi
		fi
		if sh -c "export $label"
		then
			export $label
		fi
		;;
	esac
done

# if any of these variables are set, turn off auto_dhcp
if [ -n "$ip$subnet$router$broadcast$dns" ]
then
	auto_dhcp=
fi

# if auto_dhcp is still relevant, turn on dhcp
if [ -n "$auto_dhcp" ]
then
	dhcp=true
fi

# if any of these variables are set, load ethernet module(s)
if [ -n "$ip$subnet$router$broadcast$dns$dhcp$DISPLAY$nfs" ]
then
	ethdetect="ethernet"
fi

if [ -n "$EXPERIMENTAL" ]
then
	pgilog "THIS IS AN EXPERIMENTAL VERSION OF PGI."
	cat << EOF
This version of the PGI installer is *EXPERIMENTAL*.  It is not
supported in any way, and may do horrible things to your machine.  If
you are not prepared for this possibility, you have this opportunity to
reboot.
EOF
	echo -n "Cancel installation and reboot? (yes/no) [yes is default] "
	read input
	case "$input" in
	*)
		initrd-reboot
		;;
	n*)
		;;
	esac
fi

if [ -n "$PGIDEBUG" ]
then
	pgilog "Preparing to detect hardware; launching shell."
	envsh
fi

echo
echo
echo "Detecting hardware..."

# manually load modules to enable things we can't detect
# XXX: discover 2.0 should enable us to detect IDE devices properly
manual_load="ide-probe-mod ide-scsi usb-storage"
for module in $manual_load
do
	modprobe $module 2> /dev/null
done

IFS_SAVE=$IFS
IFS="
"

for device in $(discover --disable-all --enable=pci,ide,scsi,pcmcia \
			 --format="%m\t%V\t%M\n" \
			 bridge usb scsi cdrom $ethdetect)
do
	module=$(echo $device | cut -f1)
	vendor=$(echo $device | cut -f2)
	model=$(echo $device | cut -f3)

	if [ "$vendor" != "Unknown" ]
	then
		name="$vendor $model"
	else
		name="$model"
	fi

	echo
	echo $name

	if [ -n "$module" -a "$module" != "ignore" ]
	then
		if ! modprobe $module 2> /dev/null
		then
			if [ -z "$(modprobe -l $module.o)" ]
			then
				# get absolute path of desired module, minus
				# leading slash; there may be multiple matches
				module_copied=0
				module_found=$(grep /$module\.o: /lib/modules/$KERNEL_VERSION/modules.dep)
				if [ $? -eq 0 ]
				then
					module_filenames=$(echo "$module_found" | cut -d: -f1 | cut -d/ -f2-)
					if load_from_modules_archive modules.tgz $module $module_filenames
					then
						module_copied=1
					fi
				fi
				if [ $module_copied -eq 0 ]
				then
					echo "The driver for this device is not included on the installation disk."
					echo "It is either unavailable, or already compiled into the kernel."
					# skip to the next module
					continue
				fi
			fi
		fi

		if ! modprobe $module
		then
			echo "Error loading $module module for $vendor $model!" >&2
		fi
		for f in $module_filenames
		do
			rm -f /$f
		done
	fi
done
IFS=$IFS_SAVE

# if PCMCIA was detected, load the PCMCIA drivers and start cardmgr
if [ -e /proc/bus/pccard ]
then
	echo "PCMCIA bus detected."
	if load_from_modules_archive pcmcia.tgz
	then
		echo "PCMCIA modules extracted."
	else
		echo "Failed to load extra PCMCIA modules; PCMCIA support may not work properly."
	fi

	modprobe ds 2> /dev/null
	gunzip /etc/pcmcia/config.gz
	echo "Starting PCMCIA card services manager."
	cardmgr
	# Give cardmgr time to find, oh, say, network cards.
	sleep 5
else
	echo "PCMCIA bus not detected."
fi

# bring up the network if it is needed
if [ -n "$ip$dhcp$nfs" ]
then
	echo -n "Configuring network interface..."
	bring_up_network
	echo "done."
fi

# XXX: kludge to work around delays in detecting USB mice
sleep 2
modprobe mousedev 2> /dev/null

echo
echo
echo "Searching for Debian installation media..."

# Also used during stage1 finalization
CDROMS=$(discover --disable-all --enable=pci,ide,scsi --device cdrom)
export CDROMS

# attempt to mount the live filesystem
while [ ! -f $STAGE1 ]
do
	if [ -n "$nfs" ]
	then
		if mount -t nfs -o nolock,ro,exec $nfs $LIVE 2>/dev/null
		then
			continue
		fi
	fi

	for cdrom in $CDROMS
	do
		if mount -t iso9660 -o ro,exec $cdrom $LIVE 2> /dev/null
		then
			# get out to enclosing while loop
			continue 2
		fi
	done

	cat << EOF
The PGI Debian Installer live filesystem was not found.

If you are installing from an optical disk (CD or DVD), please make sure that a
PGI installer disk is in the CD/DVD drive.  Also, please look at the messages
above to ensure that the driver for your CD/DVD drive was loaded properly.

If you are installing from the network, please make sure that the NFS host you
are using is reachable and configured appropriately.  Also, please look at the
messages above to ensure that the driver for your network device was loaded
properly, and that the network settings (IP address, etc.) have been reported
and are correct.

Would you like to retry the search?  If not, you will be given a shell prompt
so that you may attempt to diagnose and fix the problem, if you wish.
EOF

	echo -n "Retry search? (yes/no) [yes is default] "
	read input
	case "$input" in
	n*)
		cat << EOF
When this shell exits, the PGI Debian installer will search for the live
filesystem again.  You can use the "initrd-reboot" command to reboot the
system.
EOF
		envsh
		;;
	*)
		;;
	esac
done

# store location of live filesystem
LIVE_DEVICE=$(grep $LIVE /proc/mounts | cut -d\  -f1)
pgilog "Live filesystem at $LIVE_DEVICE mounted on $LIVE."

# link /usr to the live filesystem
rm -f /usr
ln -s $LIVE /usr

# symlink bash so "which" will work
ln -s $LIVE/bin/bash /bin/bash

if [ "$RESCUE" = "true" ]
then
	echo
	if [ -e /etc/rescue.txt ]
	then
		cat /etc/rescue.txt
	fi
	echo

	# spawn a rescue shell
	echo "When this shell exits, the system will restart."
	envsh

	# the user is done fixing her system; reboot
	PATH="/sbin:/bin" LD_LIBRARY_PATH="/lib" initrd-reboot
	exit 0
fi

if [ -n "$PGIDEBUG" ]
then
	pgilog "Preparing to run \"$STAGE1\"; launching shell."
	envsh
fi

. $STAGE1

if [ -n "$CANCEL" ]
then
	echo "Installation cancelled."
	if [ -n "$PGIDEBUG" ]
	then
		envsh
	else
		echo -n "Press Enter to reboot the system. "
		read input
	fi
	initrd-reboot
	exit
else
	echo "Preparing to boot into installed system.  Just a moment..."
	# copy logfiles to target system
	pgilog "Copying installer logfiles to $TARGET/var/log."
	cp /var/log/installer.* $TARGET/var/log

	mount -o remount,ro $TARGET
fi

# WARNING: Be *VERY* careful when making changes after this point; any little
# thing can cause the live filesystem to be opened, and cause failure to
# unmount it.

# link /usr back to the initrd /
rm -f /usr
ln -s / /usr

PATH="/usr/sbin:/usr/bin:/sbin:/bin"
LD_LIBRARY_PATH=
unset PYTHONHOME

if [ -n "$PGIDEBUG" ]
then
	echo "PATH is \"$PATH\"."
	echo "LD_LIBRARY_PATH is \"$LD_LIBRARY_PATH\"."
	echo "PYTHONHOME is \"$PYTHONHOME\"."
	LD_LIBRARY_PATH=$TARGET/lib $TARGET/bin/fuser -v -m $LIVE
	pgilog "Preparing to unmount live filesystem; launching shell."
	envsh
fi

# attempt to unmount the live filesystem
while ! umount -f $LIVE
do
	procs=$(LD_LIBRARY_PATH=$TARGET/lib $TARGET/bin/fuser -v -m $LIVE)
	echo "Processes with $LIVE wedged open:" >> $LOGFILE
	echo "$procs" >> $LOGFILE
	cat << EOF
Unable to unmount the live filesystem.  If you have any processes running on
other virtual consoles, make sure you have exited them.

Here is a list of processes that appear to be using the live filesystem:
$procs

Would you like to retry the unmount?  If not, you will be given a shell prompt
so that you may attempt to diagnose and fix the problem, if you wish.
Alternatively, you can force the system to reboot.
EOF
	echo -n "Retry unmount? (yes/no/reboot) [yes is default] "
	read input
	case "$input" in
	n*)
		cat << EOF
When this shell exits, the PGI Debian installer will try to unmount the live
filesystem again.
EOF
		sh
		;;
	reboot)
		initrd-reboot
		;;
	*)
		;;
	esac
done

pgilog "Live filesystem on $LIVE unmounted."

# remove the bash symlink
rm /bin/bash

# enter the installed system
cd $TARGET

# shut down everything still using the initrd filesystem
tries="1 2 3"
for cmd in syslogd udhcpc
do
	for n in $tries
	do
		pgilog "Terminating $cmd process (attempt $n)..."
		LD_LIBRARY_PATH=$TARGET/lib $TARGET/usr/bin/killall $cmd 2>> $LOGFILE && break
		sleep 1
	done
done

# unmount /proc
for n in $tries
do
	pgilog "Unmounting /proc (attempt $n)..."
	LD_LIBRARY_PATH=$TARGET/lib $TARGET/bin/umount /proc 2>> $LOGFILE && break
	sleep 1
done

pgilog "Processes using initrd filesystem:"
pgilog $(LD_LIBRARY_PATH=$TARGET/lib $TARGET/bin/fuser -v -m /)

pgilog "Downing the interface."
if [ -n "$ethdetect" ]
then
	interface=eth0 configure-network deconfig 2>> $LOGFILE
	ifconfig eth0 down 2>> $LOGFILE
fi

unset ARCH CDROMS DISPLAY DMESGLOG IDENTLOG KERNEL_VERSION LIVE \
	LIVE_DEVICE MIRROR PROMPTING RESCUE SUITE SYSLOG TARGET \
	TEXTMODE ip subnet router broadcast dns http_proxy

if [ -n "$PGIDEBUG" ]
then
	pgilog "Preparing to pivot into installed system; launching shell."
	sh
fi

unset PGIDEBUG LOGFILE pgilog

if [ -d oldroot ]
then
	pivot_root . oldroot
	exec chroot . sh -c 'exec init' \
		< dev/console > dev/console 2>&1
else
	pivot_root . mnt
	exec chroot . sh -c 'umount mnt; exec init' \
		< dev/console > dev/console 2>&1
fi

# vim:ai:noet:sts=8:sw=8:tw=0:
