-- ########## ID PARENT / ID SUBPARENT / ID SUB-SUB-PARENT ##########
-- May have to increase max_locks_per_transaction above the default 64 for this test to run properly
-- Additional tests: Cluster index
\set ON_ERROR_ROLLBACK 1
\set ON_ERROR_STOP true

BEGIN;
SELECT set_config('search_path','partman, public',false);

SELECT plan(3096);
CREATE SCHEMA partman_test;

CREATE TABLE partman_test.id_taptest_table (col1 int primary key, col2 text default 'stuff', col3 timestamptz NOT NULL DEFAULT now());
ALTER TABLE partman_test.id_taptest_table CLUSTER ON id_taptest_table_pkey;
INSERT INTO partman_test.id_taptest_table (col1) VALUES (generate_series(1,100000));
-- larger insert for testing partition/undo scripts
--INSERT INTO partman_test.id_taptest_table (col1) VALUES (generate_series(100001,2000000));
SELECT create_parent('partman_test.id_taptest_table', 'col1', 'id', '10000', p_use_run_maintenance := true, p_jobmon := false, p_premake := 2);

SELECT has_table('partman_test', 'id_taptest_table_p100000', 'Check id_taptest_table_p100000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p110000', 'Check id_taptest_table_p110000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p120000', 'Check id_taptest_table_p120000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p90000', 'Check id_taptest_table_p90000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p80000', 'Check id_taptest_table_p80000 exists');

SELECT results_eq('SELECT i.indisclustered::text FROM pg_class c JOIN pg_index i ON c.oid = i.indexrelid WHERE c.relname = ''id_taptest_table_p100000_pkey''', ARRAY['true'],
    'Check that id_taptest_table_p100000_pkey is clustered');
SELECT results_eq('SELECT i.indisclustered::text FROM pg_class c JOIN pg_index i ON c.oid = i.indexrelid WHERE c.relname = ''id_taptest_table_p110000_pkey''', ARRAY['true'],
    'Check that id_taptest_table_p110000_pkey is clustered');
SELECT results_eq('SELECT i.indisclustered::text FROM pg_class c JOIN pg_index i ON c.oid = i.indexrelid WHERE c.relname = ''id_taptest_table_p120000_pkey''', ARRAY['true'],
    'Check that id_taptest_table_p120000_pkey is clustered');
SELECT results_eq('SELECT i.indisclustered::text FROM pg_class c JOIN pg_index i ON c.oid = i.indexrelid WHERE c.relname = ''id_taptest_table_p90000_pkey''', ARRAY['true'],
    'Check that id_taptest_table_p90000_pkey is clustered');
SELECT results_eq('SELECT i.indisclustered::text FROM pg_class c JOIN pg_index i ON c.oid = i.indexrelid WHERE c.relname = ''id_taptest_table_p80000_pkey''', ARRAY['true'],
    'Check that id_taptest_table_p80000_pkey is clustered');

SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table'', p_batch_count := 20)::int', ARRAY[100000], 'Check that partitioning function returns correct count of rows moved');

SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table', 'Check that parent table has had data moved to partition');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table', ARRAY[100000], 'Check count from parent table');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0', ARRAY[9999], 'Check count from id_taptest_table_p0');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000', ARRAY[10000], 'Check count from id_taptest_table_p10000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000', ARRAY[10000], 'Check count from id_taptest_table_p20000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000', ARRAY[10000], 'Check count from id_taptest_table_p30000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000', ARRAY[10000], 'Check count from id_taptest_table_p40000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000', ARRAY[10000], 'Check count from id_taptest_table_p50000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000', ARRAY[10000], 'Check count from id_taptest_table_p60000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000', ARRAY[10000], 'Check count from id_taptest_table_p70000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000', ARRAY[10000], 'Check count from id_taptest_table_p80000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000', ARRAY[10000], 'Check count from id_taptest_table_p90000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000', ARRAY[1], 'Check count from id_taptest_table_p100000');

SELECT create_sub_parent('partman_test.id_taptest_table', 'col1', 'id', '1000', p_jobmon := false, p_premake := 2);
SELECT results_eq('SELECT sub_parent FROM part_config_sub ORDER BY sub_parent',
    ARRAY['partman_test.id_taptest_table'],
    'Check that part_config_sub has all tables configured as needed');

-- Test for normal partitions that should be made based on current max value of 100,000
SELECT has_table('partman_test', 'id_taptest_table_p90000_p98000', 'Check id_taptest_table_p90000_p98000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p90000_p99000', 'Check id_taptest_table_p90000_p99000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p100000_p100000', 'Check id_taptest_table_p100000_p100000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p100000_p101000', 'Check id_taptest_table_p100000_p101000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p100000_p102000', 'Check id_taptest_table_p100000_p102000 exists');

-- This should be enough cluster testing. If it worked above and here, should work for remaining subpartitioning
SELECT results_eq('SELECT i.indisclustered::text FROM pg_class c JOIN pg_index i ON c.oid = i.indexrelid WHERE c.relname = ''id_taptest_table_p90000_p98000_pkey''', ARRAY['true'],
    'Check that id_taptest_table_p90000_p98000_pkey is clustered');
SELECT results_eq('SELECT i.indisclustered::text FROM pg_class c JOIN pg_index i ON c.oid = i.indexrelid WHERE c.relname = ''id_taptest_table_p90000_p99000_pkey''', ARRAY['true'],
    'Check that id_taptest_table_p90000_p99000_pkey is clustered');
SELECT results_eq('SELECT i.indisclustered::text FROM pg_class c JOIN pg_index i ON c.oid = i.indexrelid WHERE c.relname = ''id_taptest_table_p100000_p100000_pkey''', ARRAY['true'],
    'Check that id_taptest_table_p100000_p100000_pkey is clustered');
SELECT results_eq('SELECT i.indisclustered::text FROM pg_class c JOIN pg_index i ON c.oid = i.indexrelid WHERE c.relname = ''id_taptest_table_p100000_p101000_pkey''', ARRAY['true'],
    'Check that id_taptest_table_p100000_p101000_pkey is clustered');
SELECT results_eq('SELECT i.indisclustered::text FROM pg_class c JOIN pg_index i ON c.oid = i.indexrelid WHERE c.relname = ''id_taptest_table_p100000_p102000_pkey''', ARRAY['true'],
    'Check that id_taptest_table_p100000_p102000_pkey is clustered');

-- Tests that ensure minimal partition was made in all sets
SELECT has_table('partman_test', 'id_taptest_table_p0_p0', 'Check id_taptest_table_p0_p0 exists');
SELECT has_table('partman_test', 'id_taptest_table_p10000_p10000', 'Check id_taptest_table_p10000_p10000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p20000_p20000', 'Check id_taptest_table_p20000_p20000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p30000_p30000', 'Check id_taptest_table_p30000_p30000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p40000_p40000', 'Check id_taptest_table_p40000_p40000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p50000_p50000', 'Check id_taptest_table_p50000_p50000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p60000_p60000', 'Check id_taptest_table_p60000_p60000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p70000_p70000', 'Check id_taptest_table_p70000_p70000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p80000_p80000', 'Check id_taptest_table_p80000_p80000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p110000_p110000', 'Check id_taptest_table_p110000_p110000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p120000_p120000', 'Check id_taptest_table_p120000_p120000 exists');

-- Partition all data again
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p0'', p_batch_count := 20)::int', ARRAY[9999], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p0');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p10000'', p_batch_count := 20)::int', ARRAY[10000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p10000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p20000'', p_batch_count := 20)::int', ARRAY[10000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p20000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p30000'', p_batch_count := 20)::int', ARRAY[10000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p30000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p40000'', p_batch_count := 20)::int', ARRAY[10000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p40000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p50000'', p_batch_count := 20)::int', ARRAY[10000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p50000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p60000'', p_batch_count := 20)::int', ARRAY[10000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p60000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p70000'', p_batch_count := 20)::int', ARRAY[10000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p70000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p80000'', p_batch_count := 20)::int', ARRAY[10000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p80000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p90000'', p_batch_count := 20)::int', ARRAY[10000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p90000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p100000'', p_batch_count := 20)::int', ARRAY[1], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p100000');
-- Test that all partitions have their data/exist
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table', 'Check that parent table has had data moved to partition');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table', ARRAY[100000], 'Check count from parent table');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p0', 'Check that parent table id_taptest_table_p0 has had data moved to partition ');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p0', ARRAY[999], 'Check count from id_taptest_table_p0_p0');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p1000', ARRAY[1000], 'Check count from id_taptest_table_p0_p1000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p2000', ARRAY[1000], 'Check count from id_taptest_table_p0_p2000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p3000', ARRAY[1000], 'Check count from id_taptest_table_p0_p3000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p4000', ARRAY[1000], 'Check count from id_taptest_table_p0_p4000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p5000', ARRAY[1000], 'Check count from id_taptest_table_p0_p5000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p6000', ARRAY[1000], 'Check count from id_taptest_table_p0_p6000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p7000', ARRAY[1000], 'Check count from id_taptest_table_p0_p7000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p8000', ARRAY[1000], 'Check count from id_taptest_table_p0_p8000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p9000', ARRAY[1000], 'Check count from id_taptest_table_p0_p9000');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p10000', 'Check that parent table id_taptest_table_p10000 has had data moved to partition ');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p10000', ARRAY[1000], 'Check count from id_taptest_table_p10000_p10000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p11000', ARRAY[1000], 'Check count from id_taptest_table_p10000_p11000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p12000', ARRAY[1000], 'Check count from id_taptest_table_p10000_p12000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p13000', ARRAY[1000], 'Check count from id_taptest_table_p10000_p13000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p14000', ARRAY[1000], 'Check count from id_taptest_table_p10000_p14000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p15000', ARRAY[1000], 'Check count from id_taptest_table_p10000_p15000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p16000', ARRAY[1000], 'Check count from id_taptest_table_p10000_p16000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p17000', ARRAY[1000], 'Check count from id_taptest_table_p10000_p17000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p18000', ARRAY[1000], 'Check count from id_taptest_table_p10000_p18000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p19000', ARRAY[1000], 'Check count from id_taptest_table_p10000_p19000');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p20000', 'Check that parent table id_taptest_table_p20000 has had data moved to partition ');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p20000', ARRAY[1000], 'Check count from id_taptest_table_p20000_p20000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p21000', ARRAY[1000], 'Check count from id_taptest_table_p20000_p21000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p22000', ARRAY[1000], 'Check count from id_taptest_table_p20000_p22000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p23000', ARRAY[1000], 'Check count from id_taptest_table_p20000_p23000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p24000', ARRAY[1000], 'Check count from id_taptest_table_p20000_p24000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p25000', ARRAY[1000], 'Check count from id_taptest_table_p20000_p25000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p26000', ARRAY[1000], 'Check count from id_taptest_table_p20000_p26000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p27000', ARRAY[1000], 'Check count from id_taptest_table_p20000_p27000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p28000', ARRAY[1000], 'Check count from id_taptest_table_p20000_p28000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p29000', ARRAY[1000], 'Check count from id_taptest_table_p20000_p29000');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p30000', 'Check that parent table id_taptest_table_p30000 has had data moved to partition ');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p30000', ARRAY[1000], 'Check count from id_taptest_table_p30000_p30000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p31000', ARRAY[1000], 'Check count from id_taptest_table_p30000_p31000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p32000', ARRAY[1000], 'Check count from id_taptest_table_p30000_p32000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p33000', ARRAY[1000], 'Check count from id_taptest_table_p30000_p33000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p34000', ARRAY[1000], 'Check count from id_taptest_table_p30000_p34000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p35000', ARRAY[1000], 'Check count from id_taptest_table_p30000_p35000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p36000', ARRAY[1000], 'Check count from id_taptest_table_p30000_p36000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p37000', ARRAY[1000], 'Check count from id_taptest_table_p30000_p37000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p38000', ARRAY[1000], 'Check count from id_taptest_table_p30000_p38000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p39000', ARRAY[1000], 'Check count from id_taptest_table_p30000_p39000');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p40000', 'Check that parent table id_taptest_table_p40000 has had data moved to partition ');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p40000', ARRAY[1000], 'Check count from id_taptest_table_p40000_p40000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p41000', ARRAY[1000], 'Check count from id_taptest_table_p40000_p41000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p42000', ARRAY[1000], 'Check count from id_taptest_table_p40000_p42000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p43000', ARRAY[1000], 'Check count from id_taptest_table_p40000_p43000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p44000', ARRAY[1000], 'Check count from id_taptest_table_p40000_p44000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p45000', ARRAY[1000], 'Check count from id_taptest_table_p40000_p45000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p46000', ARRAY[1000], 'Check count from id_taptest_table_p40000_p46000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p47000', ARRAY[1000], 'Check count from id_taptest_table_p40000_p47000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p48000', ARRAY[1000], 'Check count from id_taptest_table_p40000_p48000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p49000', ARRAY[1000], 'Check count from id_taptest_table_p40000_p49000');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p50000', 'Check that parent table id_taptest_table_p50000 has had data moved to partition ');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p50000', ARRAY[1000], 'Check count from id_taptest_table_p50000_p50000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p51000', ARRAY[1000], 'Check count from id_taptest_table_p50000_p51000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p52000', ARRAY[1000], 'Check count from id_taptest_table_p50000_p52000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p53000', ARRAY[1000], 'Check count from id_taptest_table_p50000_p53000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p54000', ARRAY[1000], 'Check count from id_taptest_table_p50000_p54000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p55000', ARRAY[1000], 'Check count from id_taptest_table_p50000_p55000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p56000', ARRAY[1000], 'Check count from id_taptest_table_p50000_p56000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p57000', ARRAY[1000], 'Check count from id_taptest_table_p50000_p57000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p58000', ARRAY[1000], 'Check count from id_taptest_table_p50000_p58000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p59000', ARRAY[1000], 'Check count from id_taptest_table_p50000_p59000');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p60000', 'Check that parent table id_taptest_table_p60000 has had data moved to partition ');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p60000', ARRAY[1000], 'Check count from id_taptest_table_p60000_p60000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p61000', ARRAY[1000], 'Check count from id_taptest_table_p60000_p61000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p62000', ARRAY[1000], 'Check count from id_taptest_table_p60000_p62000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p63000', ARRAY[1000], 'Check count from id_taptest_table_p60000_p63000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p64000', ARRAY[1000], 'Check count from id_taptest_table_p60000_p64000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p65000', ARRAY[1000], 'Check count from id_taptest_table_p60000_p65000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p66000', ARRAY[1000], 'Check count from id_taptest_table_p60000_p66000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p67000', ARRAY[1000], 'Check count from id_taptest_table_p60000_p67000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p68000', ARRAY[1000], 'Check count from id_taptest_table_p60000_p68000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p69000', ARRAY[1000], 'Check count from id_taptest_table_p60000_p69000');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p70000', 'Check that parent table id_taptest_table_p70000 has had data moved to partition ');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p70000', ARRAY[1000], 'Check count from id_taptest_table_p70000_p70000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p71000', ARRAY[1000], 'Check count from id_taptest_table_p70000_p71000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p72000', ARRAY[1000], 'Check count from id_taptest_table_p70000_p72000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p73000', ARRAY[1000], 'Check count from id_taptest_table_p70000_p73000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p74000', ARRAY[1000], 'Check count from id_taptest_table_p70000_p74000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p75000', ARRAY[1000], 'Check count from id_taptest_table_p70000_p75000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p76000', ARRAY[1000], 'Check count from id_taptest_table_p70000_p76000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p77000', ARRAY[1000], 'Check count from id_taptest_table_p70000_p77000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p78000', ARRAY[1000], 'Check count from id_taptest_table_p70000_p78000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p79000', ARRAY[1000], 'Check count from id_taptest_table_p70000_p79000');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p80000', 'Check that parent table id_taptest_table_p80000 has had data moved to partition ');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p80000', ARRAY[1000], 'Check count from id_taptest_table_p80000_p80000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p81000', ARRAY[1000], 'Check count from id_taptest_table_p80000_p81000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p82000', ARRAY[1000], 'Check count from id_taptest_table_p80000_p82000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p83000', ARRAY[1000], 'Check count from id_taptest_table_p80000_p83000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p84000', ARRAY[1000], 'Check count from id_taptest_table_p80000_p84000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p85000', ARRAY[1000], 'Check count from id_taptest_table_p80000_p85000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p86000', ARRAY[1000], 'Check count from id_taptest_table_p80000_p86000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p87000', ARRAY[1000], 'Check count from id_taptest_table_p80000_p87000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p88000', ARRAY[1000], 'Check count from id_taptest_table_p80000_p88000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p89000', ARRAY[1000], 'Check count from id_taptest_table_p80000_p89000');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p90000', 'Check that parent table id_taptest_table_p90000 has had data moved to partition ');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p90000', ARRAY[1000], 'Check count from id_taptest_table_p90000_p90000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p91000', ARRAY[1000], 'Check count from id_taptest_table_p90000_p91000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p92000', ARRAY[1000], 'Check count from id_taptest_table_p90000_p92000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p93000', ARRAY[1000], 'Check count from id_taptest_table_p90000_p93000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p94000', ARRAY[1000], 'Check count from id_taptest_table_p90000_p94000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p95000', ARRAY[1000], 'Check count from id_taptest_table_p90000_p95000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p96000', ARRAY[1000], 'Check count from id_taptest_table_p90000_p96000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p97000', ARRAY[1000], 'Check count from id_taptest_table_p90000_p97000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p98000', ARRAY[1000], 'Check count from id_taptest_table_p90000_p98000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p99000', ARRAY[1000], 'Check count from id_taptest_table_p90000_p99000');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p100000', 'Check that parent table id_taptest_table_p100000 has had data moved to partition ');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p100000', ARRAY[1], 'Check count from id_taptest_table_p100000_p100000');

-- Create next level of subpartitions
SELECT create_sub_parent('partman_test.id_taptest_table_p0', 'col1', 'id', '100', p_jobmon := false, p_premake := 2);
SELECT create_sub_parent('partman_test.id_taptest_table_p10000', 'col1', 'id', '100', p_jobmon := false, p_premake := 2);
SELECT create_sub_parent('partman_test.id_taptest_table_p20000', 'col1', 'id', '100', p_jobmon := false, p_premake := 2);
SELECT create_sub_parent('partman_test.id_taptest_table_p30000', 'col1', 'id', '100', p_jobmon := false, p_premake := 2);
SELECT create_sub_parent('partman_test.id_taptest_table_p40000', 'col1', 'id', '100', p_jobmon := false, p_premake := 2);
SELECT create_sub_parent('partman_test.id_taptest_table_p50000', 'col1', 'id', '100', p_jobmon := false, p_premake := 2);
SELECT create_sub_parent('partman_test.id_taptest_table_p60000', 'col1', 'id', '100', p_jobmon := false, p_premake := 2);
SELECT create_sub_parent('partman_test.id_taptest_table_p70000', 'col1', 'id', '100', p_jobmon := false, p_premake := 2);
SELECT create_sub_parent('partman_test.id_taptest_table_p80000', 'col1', 'id', '100', p_jobmon := false, p_premake := 2);
SELECT create_sub_parent('partman_test.id_taptest_table_p90000', 'col1', 'id', '100', p_jobmon := false, p_premake := 2);
SELECT create_sub_parent('partman_test.id_taptest_table_p100000', 'col1', 'id', '100', p_jobmon := false, p_premake := 2);
SELECT create_sub_parent('partman_test.id_taptest_table_p110000', 'col1', 'id', '100', p_jobmon := false, p_premake := 2);
SELECT create_sub_parent('partman_test.id_taptest_table_p120000', 'col1', 'id', '100', p_jobmon := false, p_premake := 2);

SELECT results_eq('SELECT sub_parent FROM part_config_sub ORDER BY sub_parent',
    ARRAY['partman_test.id_taptest_table',
    'partman_test.id_taptest_table_p0',
    'partman_test.id_taptest_table_p10000',
    'partman_test.id_taptest_table_p100000',
    'partman_test.id_taptest_table_p110000',
    'partman_test.id_taptest_table_p120000',
    'partman_test.id_taptest_table_p20000',
    'partman_test.id_taptest_table_p30000',
    'partman_test.id_taptest_table_p40000',
    'partman_test.id_taptest_table_p50000',
    'partman_test.id_taptest_table_p60000',
    'partman_test.id_taptest_table_p70000',
    'partman_test.id_taptest_table_p80000',
    'partman_test.id_taptest_table_p90000' ],
    'Check that part_config_sub has all tables configured as needed');

-- Test for normal partitions that should be made based on current max value of 100,000
SELECT has_table('partman_test', 'id_taptest_table_p90000_p99000_p99800', 'Check id_taptest_table_p90000_p99000_p99800 exists');
SELECT has_table('partman_test', 'id_taptest_table_p90000_p99000_p99900', 'Check id_taptest_table_p90000_p99000_p99800 exists');
SELECT has_table('partman_test', 'id_taptest_table_p100000_p100000_p100000', 'Check id_taptest_table_p100000_p100000_p100000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p100000_p100000_p100100', 'Check id_taptest_table_p100000_p100000_p100100 exists');
SELECT has_table('partman_test', 'id_taptest_table_p100000_p100000_p100200', 'Check id_taptest_table_p100000_p100000_p100200 exists');

-- Tests that ensure minimal partition was made in all sets
SELECT has_table('partman_test', 'id_taptest_table_p0_p0_p0', 'Check id_taptest_table_p0_p0_p0 exists');
SELECT has_table('partman_test', 'id_taptest_table_p0_p1000_p1000', 'Check id_taptest_table_p0_p1000_p1000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p0_p2000_p2000', 'Check id_taptest_table_p0_p2000_p2000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p0_p3000_p3000', 'Check id_taptest_table_p0_p3000_p3000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p0_p4000_p4000', 'Check id_taptest_table_p0_p4000_p4000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p0_p5000_p5000', 'Check id_taptest_table_p0_p5000_p5000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p0_p6000_p6000', 'Check id_taptest_table_p0_p6000_p6000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p0_p7000_p7000', 'Check id_taptest_table_p0_p7000_p7000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p0_p8000_p8000', 'Check id_taptest_table_p0_p8000_p8000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p0_p9000_p9000', 'Check id_taptest_table_p0_p9000_p1000 exists');

SELECT has_table('partman_test', 'id_taptest_table_p10000_p10000_p10000', 'Check id_taptest_table_p10000_p10000_p10000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p10000_p11000_p11000', 'Check id_taptest_table_p10000_p11000_p11000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p10000_p12000_p12000', 'Check id_taptest_table_p10000_p12000_p12000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p10000_p13000_p13000', 'Check id_taptest_table_p10000_p13000_p13000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p10000_p14000_p14000', 'Check id_taptest_table_p10000_p14000_p14000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p10000_p15000_p15000', 'Check id_taptest_table_p10000_p15000_p15000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p10000_p16000_p16000', 'Check id_taptest_table_p10000_p16000_p16000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p10000_p17000_p17000', 'Check id_taptest_table_p10000_p17000_p17000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p10000_p18000_p18000', 'Check id_taptest_table_p10000_p18000_p18000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p10000_p19000_p19000', 'Check id_taptest_table_p10000_p19000_p19000 exists');

SELECT has_table('partman_test', 'id_taptest_table_p20000_p20000_p20000', 'Check id_taptest_table_p20000_p20000_p20000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p20000_p21000_p21000', 'Check id_taptest_table_p20000_p21000_p21000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p20000_p22000_p22000', 'Check id_taptest_table_p20000_p22000_p22000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p20000_p23000_p23000', 'Check id_taptest_table_p20000_p23000_p23000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p20000_p24000_p24000', 'Check id_taptest_table_p10000_p24000_p24000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p20000_p25000_p25000', 'Check id_taptest_table_p20000_p25000_p25000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p20000_p26000_p26000', 'Check id_taptest_table_p20000_p26000_p26000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p20000_p27000_p27000', 'Check id_taptest_table_p20000_p27000_p27000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p20000_p28000_p28000', 'Check id_taptest_table_p20000_p28000_p28000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p20000_p29000_p29000', 'Check id_taptest_table_p20000_p29000_p29000 exists');

SELECT has_table('partman_test', 'id_taptest_table_p30000_p30000_p30000', 'Check id_taptest_table_p30000_p30000_p30000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p30000_p31000_p31000', 'Check id_taptest_table_p30000_p31000_p31000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p30000_p32000_p32000', 'Check id_taptest_table_p30000_p32000_p32000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p30000_p33000_p33000', 'Check id_taptest_table_p30000_p33000_p33000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p30000_p34000_p34000', 'Check id_taptest_table_p30000_p34000_p34000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p30000_p35000_p35000', 'Check id_taptest_table_p30000_p35000_p35000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p30000_p36000_p36000', 'Check id_taptest_table_p30000_p36000_p36000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p30000_p37000_p37000', 'Check id_taptest_table_p30000_p37000_p37000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p30000_p38000_p38000', 'Check id_taptest_table_p30000_p38000_p38000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p30000_p39000_p39000', 'Check id_taptest_table_p30000_p39000_p39000 exists');

SELECT has_table('partman_test', 'id_taptest_table_p40000_p40000_p40000', 'Check id_taptest_table_p40000_p40000_p40000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p40000_p41000_p41000', 'Check id_taptest_table_p40000_p41000_p41000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p40000_p42000_p42000', 'Check id_taptest_table_p40000_p42000_p42000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p40000_p43000_p43000', 'Check id_taptest_table_p40000_p43000_p43000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p40000_p44000_p44000', 'Check id_taptest_table_p40000_p44000_p44000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p40000_p45000_p45000', 'Check id_taptest_table_p40000_p45000_p45000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p40000_p46000_p46000', 'Check id_taptest_table_p40000_p46000_p46000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p40000_p47000_p47000', 'Check id_taptest_table_p40000_p47000_p47000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p40000_p48000_p48000', 'Check id_taptest_table_p40000_p48000_p48000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p40000_p49000_p49000', 'Check id_taptest_table_p40000_p49000_p49000 exists');

SELECT has_table('partman_test', 'id_taptest_table_p50000_p50000_p50000', 'Check id_taptest_table_p50000_p50000_p50000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p50000_p51000_p51000', 'Check id_taptest_table_p50000_p51000_p51000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p50000_p52000_p52000', 'Check id_taptest_table_p50000_p52000_p52000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p50000_p53000_p53000', 'Check id_taptest_table_p50000_p53000_p53000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p50000_p54000_p54000', 'Check id_taptest_table_p50000_p54000_p54000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p50000_p55000_p55000', 'Check id_taptest_table_p50000_p55000_p55000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p50000_p56000_p56000', 'Check id_taptest_table_p50000_p56000_p56000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p50000_p57000_p57000', 'Check id_taptest_table_p50000_p57000_p57000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p50000_p58000_p58000', 'Check id_taptest_table_p50000_p58000_p58000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p50000_p59000_p59000', 'Check id_taptest_table_p50000_p59000_p59000 exists');

SELECT has_table('partman_test', 'id_taptest_table_p60000_p60000_p60000', 'Check id_taptest_table_p60000_p60000_p60000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p60000_p61000_p61000', 'Check id_taptest_table_p60000_p61000_p61000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p60000_p62000_p62000', 'Check id_taptest_table_p60000_p62000_p62000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p60000_p63000_p63000', 'Check id_taptest_table_p60000_p63000_p63000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p60000_p64000_p64000', 'Check id_taptest_table_p60000_p64000_p64000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p60000_p65000_p65000', 'Check id_taptest_table_p60000_p65000_p65000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p60000_p66000_p66000', 'Check id_taptest_table_p60000_p66000_p66000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p60000_p67000_p67000', 'Check id_taptest_table_p60000_p67000_p67000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p60000_p68000_p68000', 'Check id_taptest_table_p60000_p68000_p68000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p60000_p69000_p69000', 'Check id_taptest_table_p60000_p69000_p69000 exists');

SELECT has_table('partman_test', 'id_taptest_table_p70000_p70000_p70000', 'Check id_taptest_table_p70000_p70000_p70000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p70000_p71000_p71000', 'Check id_taptest_table_p70000_p71000_p71000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p70000_p72000_p72000', 'Check id_taptest_table_p70000_p72000_p72000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p70000_p73000_p73000', 'Check id_taptest_table_p70000_p73000_p73000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p70000_p74000_p74000', 'Check id_taptest_table_p70000_p74000_p74000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p70000_p75000_p75000', 'Check id_taptest_table_p70000_p75000_p75000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p70000_p76000_p76000', 'Check id_taptest_table_p70000_p76000_p76000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p70000_p77000_p77000', 'Check id_taptest_table_p70000_p77000_p77000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p70000_p78000_p78000', 'Check id_taptest_table_p70000_p78000_p78000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p70000_p79000_p79000', 'Check id_taptest_table_p70000_p79000_p79000 exists');

SELECT has_table('partman_test', 'id_taptest_table_p80000_p80000_p80000', 'Check id_taptest_table_p80000_p80000_p80000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p80000_p81000_p81000', 'Check id_taptest_table_p80000_p81000_p80000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p80000_p82000_p82000', 'Check id_taptest_table_p80000_p82000_p80000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p80000_p83000_p83000', 'Check id_taptest_table_p80000_p83000_p80000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p80000_p84000_p84000', 'Check id_taptest_table_p80000_p84000_p80000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p80000_p85000_p85000', 'Check id_taptest_table_p80000_p85000_p80000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p80000_p86000_p86000', 'Check id_taptest_table_p80000_p86000_p80000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p80000_p87000_p87000', 'Check id_taptest_table_p80000_p87000_p80000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p80000_p88000_p88000', 'Check id_taptest_table_p80000_p88000_p80000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p80000_p89000_p89000', 'Check id_taptest_table_p80000_p89000_p80000 exists');

SELECT has_table('partman_test', 'id_taptest_table_p90000_p90000_p90000', 'Check id_taptest_table_p90000_p90000_p90000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p90000_p91000_p91000', 'Check id_taptest_table_p90000_p91000_p91000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p90000_p92000_p92000', 'Check id_taptest_table_p90000_p92000_p92000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p90000_p93000_p93000', 'Check id_taptest_table_p90000_p93000_p93000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p90000_p94000_p94000', 'Check id_taptest_table_p90000_p94000_p94000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p90000_p95000_p95000', 'Check id_taptest_table_p90000_p95000_p95000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p90000_p96000_p96000', 'Check id_taptest_table_p90000_p96000_p96000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p90000_p97000_p97000', 'Check id_taptest_table_p90000_p97000_p97000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p90000_p98000_p98000', 'Check id_taptest_table_p90000_p98000_p98000 exists');

-- All the extra partitions above exist because there is data in that range and it was partitioned out
-- Do a hasnt check just for sanity
SELECT has_table('partman_test', 'id_taptest_table_p100000_p100000_p100000', 'Check id_taptest_table_p100000_p100000_p100000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p100000_p101000_p101000', 'Check id_taptest_table_p100000_p101000_p101000 exists');
SELECT has_table('partman_test', 'id_taptest_table_p100000_p102000_p102000', 'Check id_taptest_table_p100000_p102000_p102000 exists');
SELECT hasnt_table('partman_test', 'id_taptest_table_p100000_p103000_p103000', 'Check id_taptest_table_p100000_p103000_p103000 exists');

SELECT has_table('partman_test', 'id_taptest_table_p110000_p110000_p110000', 'Check id_taptest_table_p110000_p110000_p110000 exists');
SELECT hasnt_table('partman_test', 'id_taptest_table_p110000_p111000_p111000', 'Check id_taptest_table_p110000_p111000_p111000 does not exist');

SELECT has_table('partman_test', 'id_taptest_table_p120000_p120000_p120000', 'Check id_taptest_table_p120000_p120000_p120000 exists');
SELECT hasnt_table('partman_test', 'id_taptest_table_p120000_p121000_p121000', 'Check id_taptest_table_p120000_p121000_p121000 does not exist');

-- Partition all data yet again
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p0_p0'', p_batch_count := 20)::int', ARRAY[999], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p0_p0');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p0_p1000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p0_p1000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p0_p2000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p0_p2000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p0_p3000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p0_p3000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p0_p4000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p0_p4000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p0_p5000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p0_p5000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p0_p6000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p0_p6000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p0_p7000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p0_p7000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p0_p8000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p0_p8000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p0_p9000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p0_p9000');

SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p10000_p10000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p10000_p10000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p10000_p11000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p10000_p11000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p10000_p12000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p10000_p12000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p10000_p13000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p10000_p13000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p10000_p14000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p10000_p14000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p10000_p15000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p10000_p15000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p10000_p16000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p10000_p16000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p10000_p17000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p10000_p17000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p10000_p18000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p10000_p18000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p10000_p19000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p10000_p19000');

SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p20000_p20000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p20000_p20000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p20000_p21000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p20000_p21000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p20000_p22000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p20000_p22000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p20000_p23000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p20000_p23000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p20000_p24000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p20000_p24000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p20000_p25000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p20000_p25000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p20000_p26000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p20000_p26000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p20000_p27000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p20000_p27000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p20000_p28000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p20000_p28000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p20000_p29000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p20000_p29000');

SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p30000_p30000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p30000_p30000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p30000_p31000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p30000_p31000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p30000_p32000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p30000_p32000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p30000_p33000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p30000_p33000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p30000_p34000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p30000_p34000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p30000_p35000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p30000_p35000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p30000_p36000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p30000_p36000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p30000_p37000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p30000_p37000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p30000_p38000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p30000_p38000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p30000_p39000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p30000_p39000');

SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p40000_p40000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p40000_p40000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p40000_p41000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p40000_p41000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p40000_p42000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p40000_p42000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p40000_p43000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p40000_p43000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p40000_p44000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p40000_p44000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p40000_p45000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p40000_p45000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p40000_p46000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p40000_p46000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p40000_p47000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p40000_p47000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p40000_p48000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p40000_p48000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p40000_p49000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p40000_p49000');

SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p50000_p50000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p50000_p50000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p50000_p51000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p50000_p51000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p50000_p52000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p50000_p52000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p50000_p53000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p50000_p53000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p50000_p54000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p50000_p54000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p50000_p55000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p50000_p55000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p50000_p56000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p50000_p56000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p50000_p57000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p50000_p57000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p50000_p58000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p50000_p58000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p50000_p59000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p50000_p59000');

SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p60000_p60000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p60000_p60000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p60000_p61000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p60000_p61000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p60000_p62000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p60000_p62000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p60000_p63000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p60000_p63000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p60000_p64000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p60000_p64000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p60000_p65000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p60000_p65000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p60000_p66000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p60000_p66000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p60000_p67000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p60000_p67000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p60000_p68000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p60000_p68000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p60000_p69000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p60000_p69000');

SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p70000_p70000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p70000_p70000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p70000_p71000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p70000_p71000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p70000_p72000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p70000_p72000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p70000_p73000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p70000_p73000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p70000_p74000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p70000_p74000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p70000_p75000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p70000_p75000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p70000_p76000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p70000_p76000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p70000_p77000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p70000_p77000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p70000_p78000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p70000_p78000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p70000_p79000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p70000_p79000');

SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p80000_p80000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p80000_p80000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p80000_p81000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p80000_p81000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p80000_p82000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p80000_p82000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p80000_p83000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p80000_p83000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p80000_p84000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p80000_p84000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p80000_p85000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p80000_p85000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p80000_p86000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p80000_p86000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p80000_p87000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p80000_p87000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p80000_p88000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p80000_p88000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p80000_p89000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p80000_p89000');

SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p90000_p90000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p90000_p90000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p90000_p91000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p90000_p91000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p90000_p92000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p90000_p92000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p90000_p93000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p90000_p93000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p90000_p94000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p90000_p94000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p90000_p95000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p90000_p95000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p90000_p96000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p90000_p96000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p90000_p97000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p90000_p97000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p90000_p98000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p90000_p98000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p90000_p99000'', p_batch_count := 20)::int', ARRAY[1000], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p90000_p99000');

SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p100000_p100000'', p_batch_count := 20)::int', ARRAY[1], 'Check that partitioning function returns correct count of rows moved for id_taptest_table_p100000_p100000');

-- Test that all parent tables partitions have no data
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table', 'Check that parent table has had data moved to partition');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table', ARRAY[100000], 'Check count from parent table');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p0', 'Check that parent table id_taptest_table_p0 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p10000', 'Check that parent table id_taptest_table_p10000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p20000', 'Check that parent table id_taptest_table_p20000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p30000', 'Check that parent table id_taptest_table_p30000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p40000', 'Check that parent table id_taptest_table_p40000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p50000', 'Check that parent table id_taptest_table_p50000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p60000', 'Check that parent table id_taptest_table_p60000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p70000', 'Check that parent table id_taptest_table_p70000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p80000', 'Check that parent table id_taptest_table_p80000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p90000', 'Check that parent table id_taptest_table_p90000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p100000', 'Check that parent table id_taptest_table_p100000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p0_p0', 'Check that parent table id_taptest_table_p0_p0 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p0_p1000', 'Check that parent table id_taptest_table_p0_p1000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p0_p2000', 'Check that parent table id_taptest_table_p0_p2000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p0_p3000', 'Check that parent table id_taptest_table_p0_p3000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p0_p4000', 'Check that parent table id_taptest_table_p0_p4000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p0_p5000', 'Check that parent table id_taptest_table_p0_p5000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p0_p6000', 'Check that parent table id_taptest_table_p0_p6000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p0_p7000', 'Check that parent table id_taptest_table_p0_p7000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p0_p8000', 'Check that parent table id_taptest_table_p0_p8000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p0_p9000', 'Check that parent table id_taptest_table_p0_p9000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p10000_p10000', 'Check that parent table id_taptest_table_p10000_p10000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p10000_p11000', 'Check that parent table id_taptest_table_p10000_p11000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p10000_p12000', 'Check that parent table id_taptest_table_p10000_p12000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p10000_p13000', 'Check that parent table id_taptest_table_p10000_p13000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p10000_p14000', 'Check that parent table id_taptest_table_p10000_p14000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p10000_p15000', 'Check that parent table id_taptest_table_p10000_p15000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p10000_p16000', 'Check that parent table id_taptest_table_p10000_p16000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p10000_p17000', 'Check that parent table id_taptest_table_p10000_p17000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p10000_p18000', 'Check that parent table id_taptest_table_p10000_p18000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p10000_p19000', 'Check that parent table id_taptest_table_p10000_p19000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p20000_p20000', 'Check that parent table id_taptest_table_p20000_p20000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p20000_p22000', 'Check that parent table id_taptest_table_p20000_p22000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p20000_p23000', 'Check that parent table id_taptest_table_p20000_p23000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p20000_p24000', 'Check that parent table id_taptest_table_p20000_p24000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p20000_p25000', 'Check that parent table id_taptest_table_p20000_p25000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p20000_p26000', 'Check that parent table id_taptest_table_p20000_p26000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p20000_p27000', 'Check that parent table id_taptest_table_p20000_p27000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p20000_p28000', 'Check that parent table id_taptest_table_p20000_p28000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p20000_p29000', 'Check that parent table id_taptest_table_p20000_p29000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p30000_p30000', 'Check that parent table id_taptest_table_p30000_p30000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p30000_p31000', 'Check that parent table id_taptest_table_p30000_p31000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p30000_p32000', 'Check that parent table id_taptest_table_p30000_p32000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p30000_p33000', 'Check that parent table id_taptest_table_p30000_p33000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p30000_p34000', 'Check that parent table id_taptest_table_p30000_p34000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p30000_p35000', 'Check that parent table id_taptest_table_p30000_p35000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p30000_p36000', 'Check that parent table id_taptest_table_p30000_p36000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p30000_p37000', 'Check that parent table id_taptest_table_p30000_p37000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p30000_p38000', 'Check that parent table id_taptest_table_p30000_p38000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p30000_p39000', 'Check that parent table id_taptest_table_p30000_p39000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p40000_p40000', 'Check that parent table id_taptest_table_p40000_p40000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p40000_p41000', 'Check that parent table id_taptest_table_p40000_p41000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p40000_p42000', 'Check that parent table id_taptest_table_p40000_p42000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p40000_p43000', 'Check that parent table id_taptest_table_p40000_p43000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p40000_p44000', 'Check that parent table id_taptest_table_p40000_p44000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p40000_p45000', 'Check that parent table id_taptest_table_p40000_p45000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p40000_p46000', 'Check that parent table id_taptest_table_p40000_p46000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p40000_p47000', 'Check that parent table id_taptest_table_p40000_p47000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p40000_p48000', 'Check that parent table id_taptest_table_p40000_p48000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p40000_p49000', 'Check that parent table id_taptest_table_p40000_p49000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p50000_p50000', 'Check that parent table id_taptest_table_p50000_p50000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p50000_p51000', 'Check that parent table id_taptest_table_p50000_p51000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p50000_p52000', 'Check that parent table id_taptest_table_p50000_p52000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p50000_p53000', 'Check that parent table id_taptest_table_p50000_p53000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p50000_p54000', 'Check that parent table id_taptest_table_p50000_p54000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p50000_p55000', 'Check that parent table id_taptest_table_p50000_p55000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p50000_p56000', 'Check that parent table id_taptest_table_p50000_p56000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p50000_p57000', 'Check that parent table id_taptest_table_p50000_p57000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p50000_p58000', 'Check that parent table id_taptest_table_p50000_p58000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p50000_p59000', 'Check that parent table id_taptest_table_p50000_p59000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p60000_p60000', 'Check that parent table id_taptest_table_p60000_p60000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p60000_p61000', 'Check that parent table id_taptest_table_p60000_p61000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p60000_p62000', 'Check that parent table id_taptest_table_p60000_p62000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p60000_p63000', 'Check that parent table id_taptest_table_p60000_p63000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p60000_p64000', 'Check that parent table id_taptest_table_p60000_p64000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p60000_p65000', 'Check that parent table id_taptest_table_p60000_p65000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p60000_p66000', 'Check that parent table id_taptest_table_p60000_p66000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p60000_p67000', 'Check that parent table id_taptest_table_p60000_p67000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p60000_p68000', 'Check that parent table id_taptest_table_p60000_p68000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p60000_p69000', 'Check that parent table id_taptest_table_p60000_p69000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p70000_p70000', 'Check that parent table id_taptest_table_p70000_p70000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p70000_p71000', 'Check that parent table id_taptest_table_p70000_p71000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p70000_p72000', 'Check that parent table id_taptest_table_p70000_p72000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p70000_p73000', 'Check that parent table id_taptest_table_p70000_p73000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p70000_p74000', 'Check that parent table id_taptest_table_p70000_p74000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p70000_p75000', 'Check that parent table id_taptest_table_p70000_p75000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p70000_p76000', 'Check that parent table id_taptest_table_p70000_p76000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p70000_p77000', 'Check that parent table id_taptest_table_p70000_p77000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p70000_p78000', 'Check that parent table id_taptest_table_p70000_p78000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p70000_p79000', 'Check that parent table id_taptest_table_p70000_p79000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p80000_p80000', 'Check that parent table id_taptest_table_p80000_p80000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p80000_p81000', 'Check that parent table id_taptest_table_p80000_p81000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p80000_p82000', 'Check that parent table id_taptest_table_p80000_p82000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p80000_p83000', 'Check that parent table id_taptest_table_p80000_p83000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p80000_p84000', 'Check that parent table id_taptest_table_p80000_p84000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p80000_p85000', 'Check that parent table id_taptest_table_p80000_p85000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p80000_p86000', 'Check that parent table id_taptest_table_p80000_p86000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p80000_p87000', 'Check that parent table id_taptest_table_p80000_p87000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p80000_p88000', 'Check that parent table id_taptest_table_p80000_p88000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p80000_p89000', 'Check that parent table id_taptest_table_p80000_p89000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p90000_p90000', 'Check that parent table id_taptest_table_p90000_p90000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p90000_p91000', 'Check that parent table id_taptest_table_p90000_p91000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p90000_p92000', 'Check that parent table id_taptest_table_p90000_p92000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p90000_p93000', 'Check that parent table id_taptest_table_p90000_p93000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p90000_p94000', 'Check that parent table id_taptest_table_p90000_p94000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p90000_p95000', 'Check that parent table id_taptest_table_p90000_p95000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p90000_p96000', 'Check that parent table id_taptest_table_p90000_p96000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p90000_p97000', 'Check that parent table id_taptest_table_p90000_p97000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p90000_p98000', 'Check that parent table id_taptest_table_p90000_p98000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p90000_p99000', 'Check that parent table id_taptest_table_p90000_p99000 has had data moved to partition ');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p100000_p100000', 'Check that parent table id_taptest_table_p100000_p100000 has had data moved to partition ');

-- Test that all child partitions have their data/exist
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p0_p0', ARRAY[99], 'Check count from id_taptest_table_p0_p0_p0');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p0_p100', ARRAY[100], 'Check count from id_taptest_table_p0_p0_p100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p0_p200', ARRAY[100], 'Check count from id_taptest_table_p0_p0_p200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p0_p300', ARRAY[100], 'Check count from id_taptest_table_p0_p0_p300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p0_p400', ARRAY[100], 'Check count from id_taptest_table_p0_p0_p400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p0_p500', ARRAY[100], 'Check count from id_taptest_table_p0_p0_p500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p0_p600', ARRAY[100], 'Check count from id_taptest_table_p0_p0_p600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p0_p700', ARRAY[100], 'Check count from id_taptest_table_p0_p0_p700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p0_p800', ARRAY[100], 'Check count from id_taptest_table_p0_p0_p800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p0_p900', ARRAY[100], 'Check count from id_taptest_table_p0_p0_p900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p1000_p1000', ARRAY[100], 'Check count from id_taptest_table_p0_p1000_p1000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p1000_p1100', ARRAY[100], 'Check count from id_taptest_table_p0_p1000_p1100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p1000_p1200', ARRAY[100], 'Check count from id_taptest_table_p0_p1000_p1200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p1000_p1300', ARRAY[100], 'Check count from id_taptest_table_p0_p1000_p1300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p1000_p1400', ARRAY[100], 'Check count from id_taptest_table_p0_p1000_p1400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p1000_p1500', ARRAY[100], 'Check count from id_taptest_table_p0_p1000_p1500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p1000_p1600', ARRAY[100], 'Check count from id_taptest_table_p0_p1000_p1600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p1000_p1700', ARRAY[100], 'Check count from id_taptest_table_p0_p1000_p1700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p1000_p1800', ARRAY[100], 'Check count from id_taptest_table_p0_p1000_p1800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p1000_p1900', ARRAY[100], 'Check count from id_taptest_table_p0_p1000_p1900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p2000_p2000', ARRAY[100], 'Check count from id_taptest_table_p0_p2000_p2000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p2000_p2100', ARRAY[100], 'Check count from id_taptest_table_p0_p2000_p2100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p2000_p2200', ARRAY[100], 'Check count from id_taptest_table_p0_p2000_p2200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p2000_p2300', ARRAY[100], 'Check count from id_taptest_table_p0_p2000_p2300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p2000_p2400', ARRAY[100], 'Check count from id_taptest_table_p0_p2000_p2400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p2000_p2500', ARRAY[100], 'Check count from id_taptest_table_p0_p2000_p2500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p2000_p2600', ARRAY[100], 'Check count from id_taptest_table_p0_p2000_p2600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p2000_p2700', ARRAY[100], 'Check count from id_taptest_table_p0_p2000_p2700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p2000_p2800', ARRAY[100], 'Check count from id_taptest_table_p0_p2000_p2800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p2000_p2900', ARRAY[100], 'Check count from id_taptest_table_p0_p2000_p2900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p3000_p3000', ARRAY[100], 'Check count from id_taptest_table_p0_p3000_p3000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p3000_p3100', ARRAY[100], 'Check count from id_taptest_table_p0_p3000_p3100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p3000_p3200', ARRAY[100], 'Check count from id_taptest_table_p0_p3000_p3200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p3000_p3300', ARRAY[100], 'Check count from id_taptest_table_p0_p3000_p3300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p3000_p3400', ARRAY[100], 'Check count from id_taptest_table_p0_p3000_p3400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p3000_p3500', ARRAY[100], 'Check count from id_taptest_table_p0_p3000_p3500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p3000_p3600', ARRAY[100], 'Check count from id_taptest_table_p0_p3000_p3600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p3000_p3700', ARRAY[100], 'Check count from id_taptest_table_p0_p3000_p3700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p3000_p3800', ARRAY[100], 'Check count from id_taptest_table_p0_p3000_p3800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p3000_p3900', ARRAY[100], 'Check count from id_taptest_table_p0_p3000_p3900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p4000_p4000', ARRAY[100], 'Check count from id_taptest_table_p0_p4000_p4000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p4000_p4100', ARRAY[100], 'Check count from id_taptest_table_p0_p4000_p4100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p4000_p4200', ARRAY[100], 'Check count from id_taptest_table_p0_p4000_p4200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p4000_p4300', ARRAY[100], 'Check count from id_taptest_table_p0_p4000_p4300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p4000_p4400', ARRAY[100], 'Check count from id_taptest_table_p0_p4000_p4400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p4000_p4500', ARRAY[100], 'Check count from id_taptest_table_p0_p4000_p4500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p4000_p4600', ARRAY[100], 'Check count from id_taptest_table_p0_p4000_p4600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p4000_p4700', ARRAY[100], 'Check count from id_taptest_table_p0_p4000_p4700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p4000_p4800', ARRAY[100], 'Check count from id_taptest_table_p0_p4000_p4800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p4000_p4900', ARRAY[100], 'Check count from id_taptest_table_p0_p4000_p4900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p5000_p5000', ARRAY[100], 'Check count from id_taptest_table_p0_p5000_p5000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p5000_p5100', ARRAY[100], 'Check count from id_taptest_table_p0_p5000_p5100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p5000_p5200', ARRAY[100], 'Check count from id_taptest_table_p0_p5000_p5200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p5000_p5300', ARRAY[100], 'Check count from id_taptest_table_p0_p5000_p5300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p5000_p5400', ARRAY[100], 'Check count from id_taptest_table_p0_p5000_p5400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p5000_p5500', ARRAY[100], 'Check count from id_taptest_table_p0_p5000_p5500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p5000_p5600', ARRAY[100], 'Check count from id_taptest_table_p0_p5000_p5600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p5000_p5700', ARRAY[100], 'Check count from id_taptest_table_p0_p5000_p5700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p5000_p5800', ARRAY[100], 'Check count from id_taptest_table_p0_p5000_p5800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p5000_p5900', ARRAY[100], 'Check count from id_taptest_table_p0_p5000_p5900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p6000_p6000', ARRAY[100], 'Check count from id_taptest_table_p0_p6000_p6000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p6000_p6100', ARRAY[100], 'Check count from id_taptest_table_p0_p6000_p6100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p6000_p6200', ARRAY[100], 'Check count from id_taptest_table_p0_p6000_p6200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p6000_p6300', ARRAY[100], 'Check count from id_taptest_table_p0_p6000_p6300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p6000_p6400', ARRAY[100], 'Check count from id_taptest_table_p0_p6000_p6400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p6000_p6500', ARRAY[100], 'Check count from id_taptest_table_p0_p6000_p6500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p6000_p6600', ARRAY[100], 'Check count from id_taptest_table_p0_p6000_p6600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p6000_p6700', ARRAY[100], 'Check count from id_taptest_table_p0_p6000_p6700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p6000_p6800', ARRAY[100], 'Check count from id_taptest_table_p0_p6000_p6800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p6000_p6900', ARRAY[100], 'Check count from id_taptest_table_p0_p6000_p6900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p7000_p7000', ARRAY[100], 'Check count from id_taptest_table_p0_p7000_p7000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p7000_p7100', ARRAY[100], 'Check count from id_taptest_table_p0_p7000_p7100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p7000_p7200', ARRAY[100], 'Check count from id_taptest_table_p0_p7000_p7200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p7000_p7300', ARRAY[100], 'Check count from id_taptest_table_p0_p7000_p7300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p7000_p7400', ARRAY[100], 'Check count from id_taptest_table_p0_p7000_p7400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p7000_p7500', ARRAY[100], 'Check count from id_taptest_table_p0_p7000_p7500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p7000_p7600', ARRAY[100], 'Check count from id_taptest_table_p0_p7000_p7600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p7000_p7700', ARRAY[100], 'Check count from id_taptest_table_p0_p7000_p7700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p7000_p7800', ARRAY[100], 'Check count from id_taptest_table_p0_p7000_p7800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p7000_p7900', ARRAY[100], 'Check count from id_taptest_table_p0_p7000_p7900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p8000_p8000', ARRAY[100], 'Check count from id_taptest_table_p0_p8000_p8000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p8000_p8100', ARRAY[100], 'Check count from id_taptest_table_p0_p8000_p8100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p8000_p8200', ARRAY[100], 'Check count from id_taptest_table_p0_p8000_p8200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p8000_p8300', ARRAY[100], 'Check count from id_taptest_table_p0_p8000_p8300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p8000_p8400', ARRAY[100], 'Check count from id_taptest_table_p0_p8000_p8400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p8000_p8500', ARRAY[100], 'Check count from id_taptest_table_p0_p8000_p8500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p8000_p8600', ARRAY[100], 'Check count from id_taptest_table_p0_p8000_p8600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p8000_p8700', ARRAY[100], 'Check count from id_taptest_table_p0_p8000_p8700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p8000_p8800', ARRAY[100], 'Check count from id_taptest_table_p0_p8000_p8800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p8000_p8900', ARRAY[100], 'Check count from id_taptest_table_p0_p8000_p8900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p9000_p9000', ARRAY[100], 'Check count from id_taptest_table_p0_p9000_p9000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p9000_p9100', ARRAY[100], 'Check count from id_taptest_table_p0_p9000_p9100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p9000_p9200', ARRAY[100], 'Check count from id_taptest_table_p0_p9000_p9200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p9000_p9300', ARRAY[100], 'Check count from id_taptest_table_p0_p9000_p9300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p9000_p9400', ARRAY[100], 'Check count from id_taptest_table_p0_p9000_p9400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p9000_p9500', ARRAY[100], 'Check count from id_taptest_table_p0_p9000_p9500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p9000_p9600', ARRAY[100], 'Check count from id_taptest_table_p0_p9000_p9600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p9000_p9700', ARRAY[100], 'Check count from id_taptest_table_p0_p9000_p9700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p9000_p9800', ARRAY[100], 'Check count from id_taptest_table_p0_p9000_p9800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p0_p9000_p9900', ARRAY[100], 'Check count from id_taptest_table_p0_p9000_p9900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p10000_p10000', ARRAY[100], 'Check count from id_taptest_table_p10000_p10000_p10000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p10000_p10100', ARRAY[100], 'Check count from id_taptest_table_p10000_p10000_p10100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p10000_p10200', ARRAY[100], 'Check count from id_taptest_table_p10000_p10000_p10200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p10000_p10300', ARRAY[100], 'Check count from id_taptest_table_p10000_p10000_p10300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p10000_p10400', ARRAY[100], 'Check count from id_taptest_table_p10000_p10000_p10400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p10000_p10500', ARRAY[100], 'Check count from id_taptest_table_p10000_p10000_p10500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p10000_p10600', ARRAY[100], 'Check count from id_taptest_table_p10000_p10000_p10600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p10000_p10700', ARRAY[100], 'Check count from id_taptest_table_p10000_p10000_p10700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p10000_p10800', ARRAY[100], 'Check count from id_taptest_table_p10000_p10000_p10800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p10000_p10900', ARRAY[100], 'Check count from id_taptest_table_p10000_p10000_p10900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p11000_p11000', ARRAY[100], 'Check count from id_taptest_table_p10000_p11000_p11000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p11000_p11100', ARRAY[100], 'Check count from id_taptest_table_p10000_p11000_p11100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p11000_p11200', ARRAY[100], 'Check count from id_taptest_table_p10000_p11000_p11200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p11000_p11300', ARRAY[100], 'Check count from id_taptest_table_p10000_p11000_p11300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p11000_p11400', ARRAY[100], 'Check count from id_taptest_table_p10000_p11000_p11400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p11000_p11500', ARRAY[100], 'Check count from id_taptest_table_p10000_p11000_p11500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p11000_p11600', ARRAY[100], 'Check count from id_taptest_table_p10000_p11000_p11600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p11000_p11700', ARRAY[100], 'Check count from id_taptest_table_p10000_p11000_p11700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p11000_p11800', ARRAY[100], 'Check count from id_taptest_table_p10000_p11000_p11800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p11000_p11900', ARRAY[100], 'Check count from id_taptest_table_p10000_p11000_p11900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p12000_p12000', ARRAY[100], 'Check count from id_taptest_table_p10000_p12000_p12000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p12000_p12100', ARRAY[100], 'Check count from id_taptest_table_p10000_p12000_p12100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p12000_p12200', ARRAY[100], 'Check count from id_taptest_table_p10000_p12000_p12200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p12000_p12300', ARRAY[100], 'Check count from id_taptest_table_p10000_p12000_p12300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p12000_p12400', ARRAY[100], 'Check count from id_taptest_table_p10000_p12000_p12400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p12000_p12500', ARRAY[100], 'Check count from id_taptest_table_p10000_p12000_p12500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p12000_p12600', ARRAY[100], 'Check count from id_taptest_table_p10000_p12000_p12600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p12000_p12700', ARRAY[100], 'Check count from id_taptest_table_p10000_p12000_p12700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p12000_p12800', ARRAY[100], 'Check count from id_taptest_table_p10000_p12000_p12800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p12000_p12900', ARRAY[100], 'Check count from id_taptest_table_p10000_p12000_p12900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p13000_p13000', ARRAY[100], 'Check count from id_taptest_table_p10000_p13000_p13000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p13000_p13100', ARRAY[100], 'Check count from id_taptest_table_p10000_p13000_p13100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p13000_p13200', ARRAY[100], 'Check count from id_taptest_table_p10000_p13000_p13200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p13000_p13300', ARRAY[100], 'Check count from id_taptest_table_p10000_p13000_p13300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p13000_p13400', ARRAY[100], 'Check count from id_taptest_table_p10000_p13000_p13400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p13000_p13500', ARRAY[100], 'Check count from id_taptest_table_p10000_p13000_p13500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p13000_p13600', ARRAY[100], 'Check count from id_taptest_table_p10000_p13000_p13600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p13000_p13700', ARRAY[100], 'Check count from id_taptest_table_p10000_p13000_p13700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p13000_p13800', ARRAY[100], 'Check count from id_taptest_table_p10000_p13000_p13800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p13000_p13900', ARRAY[100], 'Check count from id_taptest_table_p10000_p13000_p13900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p14000_p14000', ARRAY[100], 'Check count from id_taptest_table_p10000_p14000_p14000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p14000_p14100', ARRAY[100], 'Check count from id_taptest_table_p10000_p14000_p14100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p14000_p14200', ARRAY[100], 'Check count from id_taptest_table_p10000_p14000_p14200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p14000_p14300', ARRAY[100], 'Check count from id_taptest_table_p10000_p14000_p14300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p14000_p14400', ARRAY[100], 'Check count from id_taptest_table_p10000_p14000_p14400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p14000_p14500', ARRAY[100], 'Check count from id_taptest_table_p10000_p14000_p14500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p14000_p14600', ARRAY[100], 'Check count from id_taptest_table_p10000_p14000_p14600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p14000_p14700', ARRAY[100], 'Check count from id_taptest_table_p10000_p14000_p14700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p14000_p14800', ARRAY[100], 'Check count from id_taptest_table_p10000_p14000_p14800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p14000_p14900', ARRAY[100], 'Check count from id_taptest_table_p10000_p14000_p14900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p15000_p15000', ARRAY[100], 'Check count from id_taptest_table_p10000_p15000_p15000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p15000_p15100', ARRAY[100], 'Check count from id_taptest_table_p10000_p15000_p15100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p15000_p15200', ARRAY[100], 'Check count from id_taptest_table_p10000_p15000_p15200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p15000_p15300', ARRAY[100], 'Check count from id_taptest_table_p10000_p15000_p15300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p15000_p15400', ARRAY[100], 'Check count from id_taptest_table_p10000_p15000_p15400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p15000_p15500', ARRAY[100], 'Check count from id_taptest_table_p10000_p15000_p15500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p15000_p15600', ARRAY[100], 'Check count from id_taptest_table_p10000_p15000_p15600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p15000_p15700', ARRAY[100], 'Check count from id_taptest_table_p10000_p15000_p15700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p15000_p15800', ARRAY[100], 'Check count from id_taptest_table_p10000_p15000_p15800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p15000_p15900', ARRAY[100], 'Check count from id_taptest_table_p10000_p15000_p15900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p16000_p16000', ARRAY[100], 'Check count from id_taptest_table_p10000_p16000_p16000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p16000_p16100', ARRAY[100], 'Check count from id_taptest_table_p10000_p16000_p16100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p16000_p16200', ARRAY[100], 'Check count from id_taptest_table_p10000_p16000_p16200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p16000_p16300', ARRAY[100], 'Check count from id_taptest_table_p10000_p16000_p16300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p16000_p16400', ARRAY[100], 'Check count from id_taptest_table_p10000_p16000_p16400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p16000_p16500', ARRAY[100], 'Check count from id_taptest_table_p10000_p16000_p16500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p16000_p16600', ARRAY[100], 'Check count from id_taptest_table_p10000_p16000_p16600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p16000_p16700', ARRAY[100], 'Check count from id_taptest_table_p10000_p16000_p16700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p16000_p16800', ARRAY[100], 'Check count from id_taptest_table_p10000_p16000_p16800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p16000_p16900', ARRAY[100], 'Check count from id_taptest_table_p10000_p16000_p16900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p17000_p17000', ARRAY[100], 'Check count from id_taptest_table_p10000_p17000_p17000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p17000_p17100', ARRAY[100], 'Check count from id_taptest_table_p10000_p17000_p17100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p17000_p17200', ARRAY[100], 'Check count from id_taptest_table_p10000_p17000_p17200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p17000_p17300', ARRAY[100], 'Check count from id_taptest_table_p10000_p17000_p17300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p17000_p17400', ARRAY[100], 'Check count from id_taptest_table_p10000_p17000_p17400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p17000_p17500', ARRAY[100], 'Check count from id_taptest_table_p10000_p17000_p17500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p17000_p17600', ARRAY[100], 'Check count from id_taptest_table_p10000_p17000_p17600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p17000_p17700', ARRAY[100], 'Check count from id_taptest_table_p10000_p17000_p17700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p17000_p17800', ARRAY[100], 'Check count from id_taptest_table_p10000_p17000_p17800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p17000_p17900', ARRAY[100], 'Check count from id_taptest_table_p10000_p17000_p17900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p18000_p18000', ARRAY[100], 'Check count from id_taptest_table_p10000_p18000_p18000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p18000_p18100', ARRAY[100], 'Check count from id_taptest_table_p10000_p18000_p18100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p18000_p18200', ARRAY[100], 'Check count from id_taptest_table_p10000_p18000_p18200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p18000_p18300', ARRAY[100], 'Check count from id_taptest_table_p10000_p18000_p18300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p18000_p18400', ARRAY[100], 'Check count from id_taptest_table_p10000_p18000_p18400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p18000_p18500', ARRAY[100], 'Check count from id_taptest_table_p10000_p18000_p18500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p18000_p18600', ARRAY[100], 'Check count from id_taptest_table_p10000_p18000_p18600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p18000_p18700', ARRAY[100], 'Check count from id_taptest_table_p10000_p18000_p18700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p18000_p18800', ARRAY[100], 'Check count from id_taptest_table_p10000_p18000_p18800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p18000_p18900', ARRAY[100], 'Check count from id_taptest_table_p10000_p18000_p18900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p19000_p19000', ARRAY[100], 'Check count from id_taptest_table_p10000_p19000_p19000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p19000_p19100', ARRAY[100], 'Check count from id_taptest_table_p10000_p19000_p19100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p19000_p19200', ARRAY[100], 'Check count from id_taptest_table_p10000_p19000_p19200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p19000_p19300', ARRAY[100], 'Check count from id_taptest_table_p10000_p19000_p19300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p19000_p19400', ARRAY[100], 'Check count from id_taptest_table_p10000_p19000_p19400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p19000_p19500', ARRAY[100], 'Check count from id_taptest_table_p10000_p19000_p19500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p19000_p19600', ARRAY[100], 'Check count from id_taptest_table_p10000_p19000_p19600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p19000_p19700', ARRAY[100], 'Check count from id_taptest_table_p10000_p19000_p19700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p19000_p19800', ARRAY[100], 'Check count from id_taptest_table_p10000_p19000_p19800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p10000_p19000_p19900', ARRAY[100], 'Check count from id_taptest_table_p10000_p19000_p19900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p20000_p20000', ARRAY[100], 'Check count from id_taptest_table_p20000_p20000_p20000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p20000_p20100', ARRAY[100], 'Check count from id_taptest_table_p20000_p20000_p20100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p20000_p20200', ARRAY[100], 'Check count from id_taptest_table_p20000_p20000_p20200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p20000_p20300', ARRAY[100], 'Check count from id_taptest_table_p20000_p20000_p20300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p20000_p20400', ARRAY[100], 'Check count from id_taptest_table_p20000_p20000_p20400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p20000_p20500', ARRAY[100], 'Check count from id_taptest_table_p20000_p20000_p20500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p20000_p20600', ARRAY[100], 'Check count from id_taptest_table_p20000_p20000_p20600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p20000_p20700', ARRAY[100], 'Check count from id_taptest_table_p20000_p20000_p20700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p20000_p20800', ARRAY[100], 'Check count from id_taptest_table_p20000_p20000_p20800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p20000_p20900', ARRAY[100], 'Check count from id_taptest_table_p20000_p20000_p20900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p21000_p21000', ARRAY[100], 'Check count from id_taptest_table_p20000_p21000_p21000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p21000_p21100', ARRAY[100], 'Check count from id_taptest_table_p20000_p21000_p21100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p21000_p21200', ARRAY[100], 'Check count from id_taptest_table_p20000_p21000_p21200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p21000_p21300', ARRAY[100], 'Check count from id_taptest_table_p20000_p21000_p21300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p21000_p21400', ARRAY[100], 'Check count from id_taptest_table_p20000_p21000_p21400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p21000_p21500', ARRAY[100], 'Check count from id_taptest_table_p20000_p21000_p21500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p21000_p21600', ARRAY[100], 'Check count from id_taptest_table_p20000_p21000_p21600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p21000_p21700', ARRAY[100], 'Check count from id_taptest_table_p20000_p21000_p21700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p21000_p21800', ARRAY[100], 'Check count from id_taptest_table_p20000_p21000_p21800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p21000_p21900', ARRAY[100], 'Check count from id_taptest_table_p20000_p21000_p21900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p22000_p22000', ARRAY[100], 'Check count from id_taptest_table_p20000_p22000_p22000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p22000_p22100', ARRAY[100], 'Check count from id_taptest_table_p20000_p22000_p22100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p22000_p22200', ARRAY[100], 'Check count from id_taptest_table_p20000_p22000_p22200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p22000_p22300', ARRAY[100], 'Check count from id_taptest_table_p20000_p22000_p22300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p22000_p22400', ARRAY[100], 'Check count from id_taptest_table_p20000_p22000_p22400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p22000_p22500', ARRAY[100], 'Check count from id_taptest_table_p20000_p22000_p22500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p22000_p22600', ARRAY[100], 'Check count from id_taptest_table_p20000_p22000_p22600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p22000_p22700', ARRAY[100], 'Check count from id_taptest_table_p20000_p22000_p22700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p22000_p22800', ARRAY[100], 'Check count from id_taptest_table_p20000_p22000_p22800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p22000_p22900', ARRAY[100], 'Check count from id_taptest_table_p20000_p22000_p22900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p23000_p23000', ARRAY[100], 'Check count from id_taptest_table_p20000_p23000_p23000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p23000_p23100', ARRAY[100], 'Check count from id_taptest_table_p20000_p23000_p23100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p23000_p23200', ARRAY[100], 'Check count from id_taptest_table_p20000_p23000_p23200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p23000_p23300', ARRAY[100], 'Check count from id_taptest_table_p20000_p23000_p23300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p23000_p23400', ARRAY[100], 'Check count from id_taptest_table_p20000_p23000_p23400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p23000_p23500', ARRAY[100], 'Check count from id_taptest_table_p20000_p23000_p23500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p23000_p23600', ARRAY[100], 'Check count from id_taptest_table_p20000_p23000_p23600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p23000_p23700', ARRAY[100], 'Check count from id_taptest_table_p20000_p23000_p23700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p23000_p23800', ARRAY[100], 'Check count from id_taptest_table_p20000_p23000_p23800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p23000_p23900', ARRAY[100], 'Check count from id_taptest_table_p20000_p23000_p23900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p24000_p24000', ARRAY[100], 'Check count from id_taptest_table_p20000_p24000_p24000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p24000_p24100', ARRAY[100], 'Check count from id_taptest_table_p20000_p24000_p24100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p24000_p24200', ARRAY[100], 'Check count from id_taptest_table_p20000_p24000_p24200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p24000_p24300', ARRAY[100], 'Check count from id_taptest_table_p20000_p24000_p24300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p24000_p24400', ARRAY[100], 'Check count from id_taptest_table_p20000_p24000_p24400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p24000_p24500', ARRAY[100], 'Check count from id_taptest_table_p20000_p24000_p24500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p24000_p24600', ARRAY[100], 'Check count from id_taptest_table_p20000_p24000_p24600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p24000_p24700', ARRAY[100], 'Check count from id_taptest_table_p20000_p24000_p24700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p24000_p24800', ARRAY[100], 'Check count from id_taptest_table_p20000_p24000_p24800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p24000_p24900', ARRAY[100], 'Check count from id_taptest_table_p20000_p24000_p24900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p25000_p25000', ARRAY[100], 'Check count from id_taptest_table_p20000_p25000_p25000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p25000_p25100', ARRAY[100], 'Check count from id_taptest_table_p20000_p25000_p25100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p25000_p25200', ARRAY[100], 'Check count from id_taptest_table_p20000_p25000_p25200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p25000_p25300', ARRAY[100], 'Check count from id_taptest_table_p20000_p25000_p25300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p25000_p25400', ARRAY[100], 'Check count from id_taptest_table_p20000_p25000_p25400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p25000_p25500', ARRAY[100], 'Check count from id_taptest_table_p20000_p25000_p25500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p25000_p25600', ARRAY[100], 'Check count from id_taptest_table_p20000_p25000_p25600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p25000_p25700', ARRAY[100], 'Check count from id_taptest_table_p20000_p25000_p25700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p25000_p25800', ARRAY[100], 'Check count from id_taptest_table_p20000_p25000_p25800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p25000_p25900', ARRAY[100], 'Check count from id_taptest_table_p20000_p25000_p25900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p26000_p26000', ARRAY[100], 'Check count from id_taptest_table_p20000_p26000_p26000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p26000_p26100', ARRAY[100], 'Check count from id_taptest_table_p20000_p26000_p26100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p26000_p26200', ARRAY[100], 'Check count from id_taptest_table_p20000_p26000_p26200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p26000_p26300', ARRAY[100], 'Check count from id_taptest_table_p20000_p26000_p26300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p26000_p26400', ARRAY[100], 'Check count from id_taptest_table_p20000_p26000_p26400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p26000_p26500', ARRAY[100], 'Check count from id_taptest_table_p20000_p26000_p26500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p26000_p26600', ARRAY[100], 'Check count from id_taptest_table_p20000_p26000_p26600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p26000_p26700', ARRAY[100], 'Check count from id_taptest_table_p20000_p26000_p26700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p26000_p26800', ARRAY[100], 'Check count from id_taptest_table_p20000_p26000_p26800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p26000_p26900', ARRAY[100], 'Check count from id_taptest_table_p20000_p26000_p26900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p27000_p27000', ARRAY[100], 'Check count from id_taptest_table_p20000_p27000_p27000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p27000_p27100', ARRAY[100], 'Check count from id_taptest_table_p20000_p27000_p27100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p27000_p27200', ARRAY[100], 'Check count from id_taptest_table_p20000_p27000_p27200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p27000_p27300', ARRAY[100], 'Check count from id_taptest_table_p20000_p27000_p27300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p27000_p27400', ARRAY[100], 'Check count from id_taptest_table_p20000_p27000_p27400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p27000_p27500', ARRAY[100], 'Check count from id_taptest_table_p20000_p27000_p27500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p27000_p27600', ARRAY[100], 'Check count from id_taptest_table_p20000_p27000_p27600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p27000_p27700', ARRAY[100], 'Check count from id_taptest_table_p20000_p27000_p27700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p27000_p27800', ARRAY[100], 'Check count from id_taptest_table_p20000_p27000_p27800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p27000_p27900', ARRAY[100], 'Check count from id_taptest_table_p20000_p27000_p27900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p28000_p28000', ARRAY[100], 'Check count from id_taptest_table_p20000_p28000_p28000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p28000_p28100', ARRAY[100], 'Check count from id_taptest_table_p20000_p28000_p28100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p28000_p28200', ARRAY[100], 'Check count from id_taptest_table_p20000_p28000_p28200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p28000_p28300', ARRAY[100], 'Check count from id_taptest_table_p20000_p28000_p28300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p28000_p28400', ARRAY[100], 'Check count from id_taptest_table_p20000_p28000_p28400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p28000_p28500', ARRAY[100], 'Check count from id_taptest_table_p20000_p28000_p28500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p28000_p28600', ARRAY[100], 'Check count from id_taptest_table_p20000_p28000_p28600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p28000_p28700', ARRAY[100], 'Check count from id_taptest_table_p20000_p28000_p28700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p28000_p28800', ARRAY[100], 'Check count from id_taptest_table_p20000_p28000_p28800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p28000_p28900', ARRAY[100], 'Check count from id_taptest_table_p20000_p28000_p28900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p29000_p29000', ARRAY[100], 'Check count from id_taptest_table_p20000_p29000_p29000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p29000_p29100', ARRAY[100], 'Check count from id_taptest_table_p20000_p29000_p29100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p29000_p29200', ARRAY[100], 'Check count from id_taptest_table_p20000_p29000_p29200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p29000_p29300', ARRAY[100], 'Check count from id_taptest_table_p20000_p29000_p29300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p29000_p29400', ARRAY[100], 'Check count from id_taptest_table_p20000_p29000_p29400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p29000_p29500', ARRAY[100], 'Check count from id_taptest_table_p20000_p29000_p29500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p29000_p29600', ARRAY[100], 'Check count from id_taptest_table_p20000_p29000_p29600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p29000_p29700', ARRAY[100], 'Check count from id_taptest_table_p20000_p29000_p29700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p29000_p29800', ARRAY[100], 'Check count from id_taptest_table_p20000_p29000_p29800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p20000_p29000_p29900', ARRAY[100], 'Check count from id_taptest_table_p20000_p29000_p29900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p30000_p30000', ARRAY[100], 'Check count from id_taptest_table_p30000_p30000_p30000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p30000_p30100', ARRAY[100], 'Check count from id_taptest_table_p30000_p30000_p30100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p30000_p30200', ARRAY[100], 'Check count from id_taptest_table_p30000_p30000_p30200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p30000_p30300', ARRAY[100], 'Check count from id_taptest_table_p30000_p30000_p30300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p30000_p30400', ARRAY[100], 'Check count from id_taptest_table_p30000_p30000_p30400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p30000_p30500', ARRAY[100], 'Check count from id_taptest_table_p30000_p30000_p30500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p30000_p30600', ARRAY[100], 'Check count from id_taptest_table_p30000_p30000_p30600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p30000_p30700', ARRAY[100], 'Check count from id_taptest_table_p30000_p30000_p30700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p30000_p30800', ARRAY[100], 'Check count from id_taptest_table_p30000_p30000_p30800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p30000_p30900', ARRAY[100], 'Check count from id_taptest_table_p30000_p30000_p30900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p31000_p31000', ARRAY[100], 'Check count from id_taptest_table_p30000_p31000_p31000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p31000_p31100', ARRAY[100], 'Check count from id_taptest_table_p30000_p31000_p31100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p31000_p31200', ARRAY[100], 'Check count from id_taptest_table_p30000_p31000_p31200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p31000_p31300', ARRAY[100], 'Check count from id_taptest_table_p30000_p31000_p31300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p31000_p31400', ARRAY[100], 'Check count from id_taptest_table_p30000_p31000_p31400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p31000_p31500', ARRAY[100], 'Check count from id_taptest_table_p30000_p31000_p31500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p31000_p31600', ARRAY[100], 'Check count from id_taptest_table_p30000_p31000_p31600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p31000_p31700', ARRAY[100], 'Check count from id_taptest_table_p30000_p31000_p31700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p31000_p31800', ARRAY[100], 'Check count from id_taptest_table_p30000_p31000_p31800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p31000_p31900', ARRAY[100], 'Check count from id_taptest_table_p30000_p31000_p31900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p32000_p32000', ARRAY[100], 'Check count from id_taptest_table_p30000_p32000_p32000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p32000_p32100', ARRAY[100], 'Check count from id_taptest_table_p30000_p32000_p32100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p32000_p32200', ARRAY[100], 'Check count from id_taptest_table_p30000_p32000_p32200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p32000_p32300', ARRAY[100], 'Check count from id_taptest_table_p30000_p32000_p32300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p32000_p32400', ARRAY[100], 'Check count from id_taptest_table_p30000_p32000_p32400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p32000_p32500', ARRAY[100], 'Check count from id_taptest_table_p30000_p32000_p32500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p32000_p32600', ARRAY[100], 'Check count from id_taptest_table_p30000_p32000_p32600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p32000_p32700', ARRAY[100], 'Check count from id_taptest_table_p30000_p32000_p32700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p32000_p32800', ARRAY[100], 'Check count from id_taptest_table_p30000_p32000_p32800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p32000_p32900', ARRAY[100], 'Check count from id_taptest_table_p30000_p32000_p32900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p33000_p33000', ARRAY[100], 'Check count from id_taptest_table_p30000_p33000_p33000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p33000_p33100', ARRAY[100], 'Check count from id_taptest_table_p30000_p33000_p33100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p33000_p33200', ARRAY[100], 'Check count from id_taptest_table_p30000_p33000_p33200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p33000_p33300', ARRAY[100], 'Check count from id_taptest_table_p30000_p33000_p33300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p33000_p33400', ARRAY[100], 'Check count from id_taptest_table_p30000_p33000_p33400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p33000_p33500', ARRAY[100], 'Check count from id_taptest_table_p30000_p33000_p33500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p33000_p33600', ARRAY[100], 'Check count from id_taptest_table_p30000_p33000_p33600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p33000_p33700', ARRAY[100], 'Check count from id_taptest_table_p30000_p33000_p33700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p33000_p33800', ARRAY[100], 'Check count from id_taptest_table_p30000_p33000_p33800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p33000_p33900', ARRAY[100], 'Check count from id_taptest_table_p30000_p33000_p33900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p34000_p34000', ARRAY[100], 'Check count from id_taptest_table_p30000_p34000_p34000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p34000_p34100', ARRAY[100], 'Check count from id_taptest_table_p30000_p34000_p34100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p34000_p34200', ARRAY[100], 'Check count from id_taptest_table_p30000_p34000_p34200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p34000_p34300', ARRAY[100], 'Check count from id_taptest_table_p30000_p34000_p34300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p34000_p34400', ARRAY[100], 'Check count from id_taptest_table_p30000_p34000_p34400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p34000_p34500', ARRAY[100], 'Check count from id_taptest_table_p30000_p34000_p34500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p34000_p34600', ARRAY[100], 'Check count from id_taptest_table_p30000_p34000_p34600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p34000_p34700', ARRAY[100], 'Check count from id_taptest_table_p30000_p34000_p34700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p34000_p34800', ARRAY[100], 'Check count from id_taptest_table_p30000_p34000_p34800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p34000_p34900', ARRAY[100], 'Check count from id_taptest_table_p30000_p34000_p34900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p35000_p35000', ARRAY[100], 'Check count from id_taptest_table_p30000_p35000_p35000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p35000_p35100', ARRAY[100], 'Check count from id_taptest_table_p30000_p35000_p35100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p35000_p35200', ARRAY[100], 'Check count from id_taptest_table_p30000_p35000_p35200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p35000_p35300', ARRAY[100], 'Check count from id_taptest_table_p30000_p35000_p35300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p35000_p35400', ARRAY[100], 'Check count from id_taptest_table_p30000_p35000_p35400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p35000_p35500', ARRAY[100], 'Check count from id_taptest_table_p30000_p35000_p35500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p35000_p35600', ARRAY[100], 'Check count from id_taptest_table_p30000_p35000_p35600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p35000_p35700', ARRAY[100], 'Check count from id_taptest_table_p30000_p35000_p35700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p35000_p35800', ARRAY[100], 'Check count from id_taptest_table_p30000_p35000_p35800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p35000_p35900', ARRAY[100], 'Check count from id_taptest_table_p30000_p35000_p35900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p36000_p36000', ARRAY[100], 'Check count from id_taptest_table_p30000_p36000_p36000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p36000_p36100', ARRAY[100], 'Check count from id_taptest_table_p30000_p36000_p36100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p36000_p36200', ARRAY[100], 'Check count from id_taptest_table_p30000_p36000_p36200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p36000_p36300', ARRAY[100], 'Check count from id_taptest_table_p30000_p36000_p36300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p36000_p36400', ARRAY[100], 'Check count from id_taptest_table_p30000_p36000_p36400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p36000_p36500', ARRAY[100], 'Check count from id_taptest_table_p30000_p36000_p36500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p36000_p36600', ARRAY[100], 'Check count from id_taptest_table_p30000_p36000_p36600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p36000_p36700', ARRAY[100], 'Check count from id_taptest_table_p30000_p36000_p36700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p36000_p36800', ARRAY[100], 'Check count from id_taptest_table_p30000_p36000_p36800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p36000_p36900', ARRAY[100], 'Check count from id_taptest_table_p30000_p36000_p36900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p37000_p37000', ARRAY[100], 'Check count from id_taptest_table_p30000_p37000_p37000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p37000_p37100', ARRAY[100], 'Check count from id_taptest_table_p30000_p37000_p37100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p37000_p37200', ARRAY[100], 'Check count from id_taptest_table_p30000_p37000_p37200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p37000_p37300', ARRAY[100], 'Check count from id_taptest_table_p30000_p37000_p37300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p37000_p37400', ARRAY[100], 'Check count from id_taptest_table_p30000_p37000_p37400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p37000_p37500', ARRAY[100], 'Check count from id_taptest_table_p30000_p37000_p37500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p37000_p37600', ARRAY[100], 'Check count from id_taptest_table_p30000_p37000_p37600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p37000_p37700', ARRAY[100], 'Check count from id_taptest_table_p30000_p37000_p37700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p37000_p37800', ARRAY[100], 'Check count from id_taptest_table_p30000_p37000_p37800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p37000_p37900', ARRAY[100], 'Check count from id_taptest_table_p30000_p37000_p37900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p38000_p38000', ARRAY[100], 'Check count from id_taptest_table_p30000_p38000_p38000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p38000_p38100', ARRAY[100], 'Check count from id_taptest_table_p30000_p38000_p38100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p38000_p38200', ARRAY[100], 'Check count from id_taptest_table_p30000_p38000_p38200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p38000_p38300', ARRAY[100], 'Check count from id_taptest_table_p30000_p38000_p38300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p38000_p38400', ARRAY[100], 'Check count from id_taptest_table_p30000_p38000_p38400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p38000_p38500', ARRAY[100], 'Check count from id_taptest_table_p30000_p38000_p38500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p38000_p38600', ARRAY[100], 'Check count from id_taptest_table_p30000_p38000_p38600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p38000_p38700', ARRAY[100], 'Check count from id_taptest_table_p30000_p38000_p38700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p38000_p38800', ARRAY[100], 'Check count from id_taptest_table_p30000_p38000_p38800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p38000_p38900', ARRAY[100], 'Check count from id_taptest_table_p30000_p38000_p38900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p39000_p39000', ARRAY[100], 'Check count from id_taptest_table_p30000_p39000_p39000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p39000_p39100', ARRAY[100], 'Check count from id_taptest_table_p30000_p39000_p39100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p39000_p39200', ARRAY[100], 'Check count from id_taptest_table_p30000_p39000_p39200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p39000_p39300', ARRAY[100], 'Check count from id_taptest_table_p30000_p39000_p39300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p39000_p39400', ARRAY[100], 'Check count from id_taptest_table_p30000_p39000_p39400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p39000_p39500', ARRAY[100], 'Check count from id_taptest_table_p30000_p39000_p39500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p39000_p39600', ARRAY[100], 'Check count from id_taptest_table_p30000_p39000_p39600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p39000_p39700', ARRAY[100], 'Check count from id_taptest_table_p30000_p39000_p39700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p39000_p39800', ARRAY[100], 'Check count from id_taptest_table_p30000_p39000_p39800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p30000_p39000_p39900', ARRAY[100], 'Check count from id_taptest_table_p30000_p39000_p39900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p40000_p40000', ARRAY[100], 'Check count from id_taptest_table_p40000_p40000_p40000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p40000_p40100', ARRAY[100], 'Check count from id_taptest_table_p40000_p40000_p40100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p40000_p40200', ARRAY[100], 'Check count from id_taptest_table_p40000_p40000_p40200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p40000_p40300', ARRAY[100], 'Check count from id_taptest_table_p40000_p40000_p40300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p40000_p40400', ARRAY[100], 'Check count from id_taptest_table_p40000_p40000_p40400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p40000_p40500', ARRAY[100], 'Check count from id_taptest_table_p40000_p40000_p40500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p40000_p40600', ARRAY[100], 'Check count from id_taptest_table_p40000_p40000_p40600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p40000_p40700', ARRAY[100], 'Check count from id_taptest_table_p40000_p40000_p40700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p40000_p40800', ARRAY[100], 'Check count from id_taptest_table_p40000_p40000_p40800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p40000_p40900', ARRAY[100], 'Check count from id_taptest_table_p40000_p40000_p40900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p41000_p41000', ARRAY[100], 'Check count from id_taptest_table_p40000_p41000_p41000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p41000_p41100', ARRAY[100], 'Check count from id_taptest_table_p40000_p41000_p41100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p41000_p41200', ARRAY[100], 'Check count from id_taptest_table_p40000_p41000_p41200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p41000_p41300', ARRAY[100], 'Check count from id_taptest_table_p40000_p41000_p41300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p41000_p41400', ARRAY[100], 'Check count from id_taptest_table_p40000_p41000_p41400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p41000_p41500', ARRAY[100], 'Check count from id_taptest_table_p40000_p41000_p41500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p41000_p41600', ARRAY[100], 'Check count from id_taptest_table_p40000_p41000_p41600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p41000_p41700', ARRAY[100], 'Check count from id_taptest_table_p40000_p41000_p41700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p41000_p41800', ARRAY[100], 'Check count from id_taptest_table_p40000_p41000_p41800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p41000_p41900', ARRAY[100], 'Check count from id_taptest_table_p40000_p41000_p41900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p42000_p42000', ARRAY[100], 'Check count from id_taptest_table_p40000_p42000_p42000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p42000_p42100', ARRAY[100], 'Check count from id_taptest_table_p40000_p42000_p42100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p42000_p42200', ARRAY[100], 'Check count from id_taptest_table_p40000_p42000_p42200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p42000_p42300', ARRAY[100], 'Check count from id_taptest_table_p40000_p42000_p42300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p42000_p42400', ARRAY[100], 'Check count from id_taptest_table_p40000_p42000_p42400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p42000_p42500', ARRAY[100], 'Check count from id_taptest_table_p40000_p42000_p42500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p42000_p42600', ARRAY[100], 'Check count from id_taptest_table_p40000_p42000_p42600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p42000_p42700', ARRAY[100], 'Check count from id_taptest_table_p40000_p42000_p42700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p42000_p42800', ARRAY[100], 'Check count from id_taptest_table_p40000_p42000_p42800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p42000_p42900', ARRAY[100], 'Check count from id_taptest_table_p40000_p42000_p42900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p43000_p43000', ARRAY[100], 'Check count from id_taptest_table_p40000_p43000_p43000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p43000_p43100', ARRAY[100], 'Check count from id_taptest_table_p40000_p43000_p43100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p43000_p43200', ARRAY[100], 'Check count from id_taptest_table_p40000_p43000_p43200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p43000_p43300', ARRAY[100], 'Check count from id_taptest_table_p40000_p43000_p43300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p43000_p43400', ARRAY[100], 'Check count from id_taptest_table_p40000_p43000_p43400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p43000_p43500', ARRAY[100], 'Check count from id_taptest_table_p40000_p43000_p43500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p43000_p43600', ARRAY[100], 'Check count from id_taptest_table_p40000_p43000_p43600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p43000_p43700', ARRAY[100], 'Check count from id_taptest_table_p40000_p43000_p43700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p43000_p43800', ARRAY[100], 'Check count from id_taptest_table_p40000_p43000_p43800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p43000_p43900', ARRAY[100], 'Check count from id_taptest_table_p40000_p43000_p43900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p44000_p44000', ARRAY[100], 'Check count from id_taptest_table_p40000_p44000_p44000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p44000_p44100', ARRAY[100], 'Check count from id_taptest_table_p40000_p44000_p44100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p44000_p44200', ARRAY[100], 'Check count from id_taptest_table_p40000_p44000_p44200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p44000_p44300', ARRAY[100], 'Check count from id_taptest_table_p40000_p44000_p44300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p44000_p44400', ARRAY[100], 'Check count from id_taptest_table_p40000_p44000_p44400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p44000_p44500', ARRAY[100], 'Check count from id_taptest_table_p40000_p44000_p44500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p44000_p44600', ARRAY[100], 'Check count from id_taptest_table_p40000_p44000_p44600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p44000_p44700', ARRAY[100], 'Check count from id_taptest_table_p40000_p44000_p44700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p44000_p44800', ARRAY[100], 'Check count from id_taptest_table_p40000_p44000_p44800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p44000_p44900', ARRAY[100], 'Check count from id_taptest_table_p40000_p44000_p44900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p45000_p45000', ARRAY[100], 'Check count from id_taptest_table_p40000_p45000_p45000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p45000_p45100', ARRAY[100], 'Check count from id_taptest_table_p40000_p45000_p45100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p45000_p45200', ARRAY[100], 'Check count from id_taptest_table_p40000_p45000_p45200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p45000_p45300', ARRAY[100], 'Check count from id_taptest_table_p40000_p45000_p45300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p45000_p45400', ARRAY[100], 'Check count from id_taptest_table_p40000_p45000_p45400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p45000_p45500', ARRAY[100], 'Check count from id_taptest_table_p40000_p45000_p45500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p45000_p45600', ARRAY[100], 'Check count from id_taptest_table_p40000_p45000_p45600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p45000_p45700', ARRAY[100], 'Check count from id_taptest_table_p40000_p45000_p45700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p45000_p45800', ARRAY[100], 'Check count from id_taptest_table_p40000_p45000_p45800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p45000_p45900', ARRAY[100], 'Check count from id_taptest_table_p40000_p45000_p45900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p46000_p46000', ARRAY[100], 'Check count from id_taptest_table_p40000_p46000_p46000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p46000_p46100', ARRAY[100], 'Check count from id_taptest_table_p40000_p46000_p46100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p46000_p46200', ARRAY[100], 'Check count from id_taptest_table_p40000_p46000_p46200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p46000_p46300', ARRAY[100], 'Check count from id_taptest_table_p40000_p46000_p46300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p46000_p46400', ARRAY[100], 'Check count from id_taptest_table_p40000_p46000_p46400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p46000_p46500', ARRAY[100], 'Check count from id_taptest_table_p40000_p46000_p46500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p46000_p46600', ARRAY[100], 'Check count from id_taptest_table_p40000_p46000_p46600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p46000_p46700', ARRAY[100], 'Check count from id_taptest_table_p40000_p46000_p46700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p46000_p46800', ARRAY[100], 'Check count from id_taptest_table_p40000_p46000_p46800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p46000_p46900', ARRAY[100], 'Check count from id_taptest_table_p40000_p46000_p46900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p47000_p47000', ARRAY[100], 'Check count from id_taptest_table_p40000_p47000_p47000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p47000_p47100', ARRAY[100], 'Check count from id_taptest_table_p40000_p47000_p47100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p47000_p47200', ARRAY[100], 'Check count from id_taptest_table_p40000_p47000_p47200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p47000_p47300', ARRAY[100], 'Check count from id_taptest_table_p40000_p47000_p47300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p47000_p47400', ARRAY[100], 'Check count from id_taptest_table_p40000_p47000_p47400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p47000_p47500', ARRAY[100], 'Check count from id_taptest_table_p40000_p47000_p47500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p47000_p47600', ARRAY[100], 'Check count from id_taptest_table_p40000_p47000_p47600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p47000_p47700', ARRAY[100], 'Check count from id_taptest_table_p40000_p47000_p47700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p47000_p47800', ARRAY[100], 'Check count from id_taptest_table_p40000_p47000_p47800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p47000_p47900', ARRAY[100], 'Check count from id_taptest_table_p40000_p47000_p47900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p48000_p48000', ARRAY[100], 'Check count from id_taptest_table_p40000_p48000_p48000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p48000_p48100', ARRAY[100], 'Check count from id_taptest_table_p40000_p48000_p48100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p48000_p48200', ARRAY[100], 'Check count from id_taptest_table_p40000_p48000_p48200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p48000_p48300', ARRAY[100], 'Check count from id_taptest_table_p40000_p48000_p48300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p48000_p48400', ARRAY[100], 'Check count from id_taptest_table_p40000_p48000_p48400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p48000_p48500', ARRAY[100], 'Check count from id_taptest_table_p40000_p48000_p48500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p48000_p48600', ARRAY[100], 'Check count from id_taptest_table_p40000_p48000_p48600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p48000_p48700', ARRAY[100], 'Check count from id_taptest_table_p40000_p48000_p48700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p48000_p48800', ARRAY[100], 'Check count from id_taptest_table_p40000_p48000_p48800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p48000_p48900', ARRAY[100], 'Check count from id_taptest_table_p40000_p48000_p48900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p49000_p49000', ARRAY[100], 'Check count from id_taptest_table_p40000_p49000_p49000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p49000_p49100', ARRAY[100], 'Check count from id_taptest_table_p40000_p49000_p49100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p49000_p49200', ARRAY[100], 'Check count from id_taptest_table_p40000_p49000_p49200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p49000_p49300', ARRAY[100], 'Check count from id_taptest_table_p40000_p49000_p49300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p49000_p49400', ARRAY[100], 'Check count from id_taptest_table_p40000_p49000_p49400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p49000_p49500', ARRAY[100], 'Check count from id_taptest_table_p40000_p49000_p49500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p49000_p49600', ARRAY[100], 'Check count from id_taptest_table_p40000_p49000_p49600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p49000_p49700', ARRAY[100], 'Check count from id_taptest_table_p40000_p49000_p49700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p49000_p49800', ARRAY[100], 'Check count from id_taptest_table_p40000_p49000_p49800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p40000_p49000_p49900', ARRAY[100], 'Check count from id_taptest_table_p40000_p49000_p49900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p50000_p50000', ARRAY[100], 'Check count from id_taptest_table_p50000_p50000_p50000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p50000_p50100', ARRAY[100], 'Check count from id_taptest_table_p50000_p50000_p50100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p50000_p50200', ARRAY[100], 'Check count from id_taptest_table_p50000_p50000_p50200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p50000_p50300', ARRAY[100], 'Check count from id_taptest_table_p50000_p50000_p50300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p50000_p50400', ARRAY[100], 'Check count from id_taptest_table_p50000_p50000_p50400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p50000_p50500', ARRAY[100], 'Check count from id_taptest_table_p50000_p50000_p50500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p50000_p50600', ARRAY[100], 'Check count from id_taptest_table_p50000_p50000_p50600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p50000_p50700', ARRAY[100], 'Check count from id_taptest_table_p50000_p50000_p50700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p50000_p50800', ARRAY[100], 'Check count from id_taptest_table_p50000_p50000_p50800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p50000_p50900', ARRAY[100], 'Check count from id_taptest_table_p50000_p50000_p50900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p51000_p51000', ARRAY[100], 'Check count from id_taptest_table_p50000_p51000_p51000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p51000_p51100', ARRAY[100], 'Check count from id_taptest_table_p50000_p51000_p51100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p51000_p51200', ARRAY[100], 'Check count from id_taptest_table_p50000_p51000_p51200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p51000_p51300', ARRAY[100], 'Check count from id_taptest_table_p50000_p51000_p51300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p51000_p51400', ARRAY[100], 'Check count from id_taptest_table_p50000_p51000_p51400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p51000_p51500', ARRAY[100], 'Check count from id_taptest_table_p50000_p51000_p51500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p51000_p51600', ARRAY[100], 'Check count from id_taptest_table_p50000_p51000_p51600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p51000_p51700', ARRAY[100], 'Check count from id_taptest_table_p50000_p51000_p51700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p51000_p51800', ARRAY[100], 'Check count from id_taptest_table_p50000_p51000_p51800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p51000_p51900', ARRAY[100], 'Check count from id_taptest_table_p50000_p51000_p51900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p52000_p52000', ARRAY[100], 'Check count from id_taptest_table_p50000_p52000_p52000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p52000_p52100', ARRAY[100], 'Check count from id_taptest_table_p50000_p52000_p52100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p52000_p52200', ARRAY[100], 'Check count from id_taptest_table_p50000_p52000_p52200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p52000_p52300', ARRAY[100], 'Check count from id_taptest_table_p50000_p52000_p52300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p52000_p52400', ARRAY[100], 'Check count from id_taptest_table_p50000_p52000_p52400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p52000_p52500', ARRAY[100], 'Check count from id_taptest_table_p50000_p52000_p52500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p52000_p52600', ARRAY[100], 'Check count from id_taptest_table_p50000_p52000_p52600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p52000_p52700', ARRAY[100], 'Check count from id_taptest_table_p50000_p52000_p52700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p52000_p52800', ARRAY[100], 'Check count from id_taptest_table_p50000_p52000_p52800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p52000_p52900', ARRAY[100], 'Check count from id_taptest_table_p50000_p52000_p52900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p53000_p53000', ARRAY[100], 'Check count from id_taptest_table_p50000_p53000_p53000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p53000_p53100', ARRAY[100], 'Check count from id_taptest_table_p50000_p53000_p53100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p53000_p53200', ARRAY[100], 'Check count from id_taptest_table_p50000_p53000_p53200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p53000_p53300', ARRAY[100], 'Check count from id_taptest_table_p50000_p53000_p53300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p53000_p53400', ARRAY[100], 'Check count from id_taptest_table_p50000_p53000_p53400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p53000_p53500', ARRAY[100], 'Check count from id_taptest_table_p50000_p53000_p53500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p53000_p53600', ARRAY[100], 'Check count from id_taptest_table_p50000_p53000_p53600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p53000_p53700', ARRAY[100], 'Check count from id_taptest_table_p50000_p53000_p53700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p53000_p53800', ARRAY[100], 'Check count from id_taptest_table_p50000_p53000_p53800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p53000_p53900', ARRAY[100], 'Check count from id_taptest_table_p50000_p53000_p53900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p54000_p54000', ARRAY[100], 'Check count from id_taptest_table_p50000_p54000_p54000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p54000_p54100', ARRAY[100], 'Check count from id_taptest_table_p50000_p54000_p54100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p54000_p54200', ARRAY[100], 'Check count from id_taptest_table_p50000_p54000_p54200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p54000_p54300', ARRAY[100], 'Check count from id_taptest_table_p50000_p54000_p54300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p54000_p54400', ARRAY[100], 'Check count from id_taptest_table_p50000_p54000_p54400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p54000_p54500', ARRAY[100], 'Check count from id_taptest_table_p50000_p54000_p54500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p54000_p54600', ARRAY[100], 'Check count from id_taptest_table_p50000_p54000_p54600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p54000_p54700', ARRAY[100], 'Check count from id_taptest_table_p50000_p54000_p54700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p54000_p54800', ARRAY[100], 'Check count from id_taptest_table_p50000_p54000_p54800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p54000_p54900', ARRAY[100], 'Check count from id_taptest_table_p50000_p54000_p54900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p55000_p55000', ARRAY[100], 'Check count from id_taptest_table_p50000_p55000_p55000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p55000_p55100', ARRAY[100], 'Check count from id_taptest_table_p50000_p55000_p55100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p55000_p55200', ARRAY[100], 'Check count from id_taptest_table_p50000_p55000_p55200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p55000_p55300', ARRAY[100], 'Check count from id_taptest_table_p50000_p55000_p55300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p55000_p55400', ARRAY[100], 'Check count from id_taptest_table_p50000_p55000_p55400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p55000_p55500', ARRAY[100], 'Check count from id_taptest_table_p50000_p55000_p55500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p55000_p55600', ARRAY[100], 'Check count from id_taptest_table_p50000_p55000_p55600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p55000_p55700', ARRAY[100], 'Check count from id_taptest_table_p50000_p55000_p55700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p55000_p55800', ARRAY[100], 'Check count from id_taptest_table_p50000_p55000_p55800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p55000_p55900', ARRAY[100], 'Check count from id_taptest_table_p50000_p55000_p55900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p56000_p56000', ARRAY[100], 'Check count from id_taptest_table_p50000_p56000_p56000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p56000_p56100', ARRAY[100], 'Check count from id_taptest_table_p50000_p56000_p56100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p56000_p56200', ARRAY[100], 'Check count from id_taptest_table_p50000_p56000_p56200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p56000_p56300', ARRAY[100], 'Check count from id_taptest_table_p50000_p56000_p56300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p56000_p56400', ARRAY[100], 'Check count from id_taptest_table_p50000_p56000_p56400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p56000_p56500', ARRAY[100], 'Check count from id_taptest_table_p50000_p56000_p56500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p56000_p56600', ARRAY[100], 'Check count from id_taptest_table_p50000_p56000_p56600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p56000_p56700', ARRAY[100], 'Check count from id_taptest_table_p50000_p56000_p56700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p56000_p56800', ARRAY[100], 'Check count from id_taptest_table_p50000_p56000_p56800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p56000_p56900', ARRAY[100], 'Check count from id_taptest_table_p50000_p56000_p56900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p57000_p57000', ARRAY[100], 'Check count from id_taptest_table_p50000_p57000_p57000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p57000_p57100', ARRAY[100], 'Check count from id_taptest_table_p50000_p57000_p57100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p57000_p57200', ARRAY[100], 'Check count from id_taptest_table_p50000_p57000_p57200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p57000_p57300', ARRAY[100], 'Check count from id_taptest_table_p50000_p57000_p57300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p57000_p57400', ARRAY[100], 'Check count from id_taptest_table_p50000_p57000_p57400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p57000_p57500', ARRAY[100], 'Check count from id_taptest_table_p50000_p57000_p57500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p57000_p57600', ARRAY[100], 'Check count from id_taptest_table_p50000_p57000_p57600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p57000_p57700', ARRAY[100], 'Check count from id_taptest_table_p50000_p57000_p57700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p57000_p57800', ARRAY[100], 'Check count from id_taptest_table_p50000_p57000_p57800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p57000_p57900', ARRAY[100], 'Check count from id_taptest_table_p50000_p57000_p57900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p58000_p58000', ARRAY[100], 'Check count from id_taptest_table_p50000_p58000_p58000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p58000_p58100', ARRAY[100], 'Check count from id_taptest_table_p50000_p58000_p58100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p58000_p58200', ARRAY[100], 'Check count from id_taptest_table_p50000_p58000_p58200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p58000_p58300', ARRAY[100], 'Check count from id_taptest_table_p50000_p58000_p58300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p58000_p58400', ARRAY[100], 'Check count from id_taptest_table_p50000_p58000_p58400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p58000_p58500', ARRAY[100], 'Check count from id_taptest_table_p50000_p58000_p58500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p58000_p58600', ARRAY[100], 'Check count from id_taptest_table_p50000_p58000_p58600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p58000_p58700', ARRAY[100], 'Check count from id_taptest_table_p50000_p58000_p58700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p58000_p58800', ARRAY[100], 'Check count from id_taptest_table_p50000_p58000_p58800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p58000_p58900', ARRAY[100], 'Check count from id_taptest_table_p50000_p58000_p58900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p59000_p59000', ARRAY[100], 'Check count from id_taptest_table_p50000_p59000_p59000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p59000_p59100', ARRAY[100], 'Check count from id_taptest_table_p50000_p59000_p59100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p59000_p59200', ARRAY[100], 'Check count from id_taptest_table_p50000_p59000_p59200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p59000_p59300', ARRAY[100], 'Check count from id_taptest_table_p50000_p59000_p59300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p59000_p59400', ARRAY[100], 'Check count from id_taptest_table_p50000_p59000_p59400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p59000_p59500', ARRAY[100], 'Check count from id_taptest_table_p50000_p59000_p59500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p59000_p59600', ARRAY[100], 'Check count from id_taptest_table_p50000_p59000_p59600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p59000_p59700', ARRAY[100], 'Check count from id_taptest_table_p50000_p59000_p59700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p59000_p59800', ARRAY[100], 'Check count from id_taptest_table_p50000_p59000_p59800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p50000_p59000_p59900', ARRAY[100], 'Check count from id_taptest_table_p50000_p59000_p59900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p60000_p60000', ARRAY[100], 'Check count from id_taptest_table_p60000_p60000_p60000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p60000_p60100', ARRAY[100], 'Check count from id_taptest_table_p60000_p60000_p60100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p60000_p60200', ARRAY[100], 'Check count from id_taptest_table_p60000_p60000_p60200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p60000_p60300', ARRAY[100], 'Check count from id_taptest_table_p60000_p60000_p60300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p60000_p60400', ARRAY[100], 'Check count from id_taptest_table_p60000_p60000_p60400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p60000_p60500', ARRAY[100], 'Check count from id_taptest_table_p60000_p60000_p60500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p60000_p60600', ARRAY[100], 'Check count from id_taptest_table_p60000_p60000_p60600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p60000_p60700', ARRAY[100], 'Check count from id_taptest_table_p60000_p60000_p60700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p60000_p60800', ARRAY[100], 'Check count from id_taptest_table_p60000_p60000_p60800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p60000_p60900', ARRAY[100], 'Check count from id_taptest_table_p60000_p60000_p60900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p61000_p61000', ARRAY[100], 'Check count from id_taptest_table_p60000_p61000_p61000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p61000_p61100', ARRAY[100], 'Check count from id_taptest_table_p60000_p61000_p61100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p61000_p61200', ARRAY[100], 'Check count from id_taptest_table_p60000_p61000_p61200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p61000_p61300', ARRAY[100], 'Check count from id_taptest_table_p60000_p61000_p61300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p61000_p61400', ARRAY[100], 'Check count from id_taptest_table_p60000_p61000_p61400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p61000_p61500', ARRAY[100], 'Check count from id_taptest_table_p60000_p61000_p61500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p61000_p61600', ARRAY[100], 'Check count from id_taptest_table_p60000_p61000_p61600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p61000_p61700', ARRAY[100], 'Check count from id_taptest_table_p60000_p61000_p61700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p61000_p61800', ARRAY[100], 'Check count from id_taptest_table_p60000_p61000_p61800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p61000_p61900', ARRAY[100], 'Check count from id_taptest_table_p60000_p61000_p61900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p62000_p62000', ARRAY[100], 'Check count from id_taptest_table_p60000_p62000_p62000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p62000_p62100', ARRAY[100], 'Check count from id_taptest_table_p60000_p62000_p62100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p62000_p62200', ARRAY[100], 'Check count from id_taptest_table_p60000_p62000_p62200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p62000_p62300', ARRAY[100], 'Check count from id_taptest_table_p60000_p62000_p62300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p62000_p62400', ARRAY[100], 'Check count from id_taptest_table_p60000_p62000_p62400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p62000_p62500', ARRAY[100], 'Check count from id_taptest_table_p60000_p62000_p62500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p62000_p62600', ARRAY[100], 'Check count from id_taptest_table_p60000_p62000_p62600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p62000_p62700', ARRAY[100], 'Check count from id_taptest_table_p60000_p62000_p62700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p62000_p62800', ARRAY[100], 'Check count from id_taptest_table_p60000_p62000_p62800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p62000_p62900', ARRAY[100], 'Check count from id_taptest_table_p60000_p62000_p62900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p63000_p63000', ARRAY[100], 'Check count from id_taptest_table_p60000_p63000_p63000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p63000_p63100', ARRAY[100], 'Check count from id_taptest_table_p60000_p63000_p63100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p63000_p63200', ARRAY[100], 'Check count from id_taptest_table_p60000_p63000_p63200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p63000_p63300', ARRAY[100], 'Check count from id_taptest_table_p60000_p63000_p63300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p63000_p63400', ARRAY[100], 'Check count from id_taptest_table_p60000_p63000_p63400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p63000_p63500', ARRAY[100], 'Check count from id_taptest_table_p60000_p63000_p63500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p63000_p63600', ARRAY[100], 'Check count from id_taptest_table_p60000_p63000_p63600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p63000_p63700', ARRAY[100], 'Check count from id_taptest_table_p60000_p63000_p63700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p63000_p63800', ARRAY[100], 'Check count from id_taptest_table_p60000_p63000_p63800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p63000_p63900', ARRAY[100], 'Check count from id_taptest_table_p60000_p63000_p63900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p64000_p64000', ARRAY[100], 'Check count from id_taptest_table_p60000_p64000_p64000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p64000_p64100', ARRAY[100], 'Check count from id_taptest_table_p60000_p64000_p64100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p64000_p64200', ARRAY[100], 'Check count from id_taptest_table_p60000_p64000_p64200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p64000_p64300', ARRAY[100], 'Check count from id_taptest_table_p60000_p64000_p64300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p64000_p64400', ARRAY[100], 'Check count from id_taptest_table_p60000_p64000_p64400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p64000_p64500', ARRAY[100], 'Check count from id_taptest_table_p60000_p64000_p64500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p64000_p64600', ARRAY[100], 'Check count from id_taptest_table_p60000_p64000_p64600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p64000_p64700', ARRAY[100], 'Check count from id_taptest_table_p60000_p64000_p64700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p64000_p64800', ARRAY[100], 'Check count from id_taptest_table_p60000_p64000_p64800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p64000_p64900', ARRAY[100], 'Check count from id_taptest_table_p60000_p64000_p64900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p65000_p65000', ARRAY[100], 'Check count from id_taptest_table_p60000_p65000_p65000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p65000_p65100', ARRAY[100], 'Check count from id_taptest_table_p60000_p65000_p65100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p65000_p65200', ARRAY[100], 'Check count from id_taptest_table_p60000_p65000_p65200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p65000_p65300', ARRAY[100], 'Check count from id_taptest_table_p60000_p65000_p65300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p65000_p65400', ARRAY[100], 'Check count from id_taptest_table_p60000_p65000_p65400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p65000_p65500', ARRAY[100], 'Check count from id_taptest_table_p60000_p65000_p65500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p65000_p65600', ARRAY[100], 'Check count from id_taptest_table_p60000_p65000_p65600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p65000_p65700', ARRAY[100], 'Check count from id_taptest_table_p60000_p65000_p65700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p65000_p65800', ARRAY[100], 'Check count from id_taptest_table_p60000_p65000_p65800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p65000_p65900', ARRAY[100], 'Check count from id_taptest_table_p60000_p65000_p65900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p66000_p66000', ARRAY[100], 'Check count from id_taptest_table_p60000_p66000_p66000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p66000_p66100', ARRAY[100], 'Check count from id_taptest_table_p60000_p66000_p66100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p66000_p66200', ARRAY[100], 'Check count from id_taptest_table_p60000_p66000_p66200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p66000_p66300', ARRAY[100], 'Check count from id_taptest_table_p60000_p66000_p66300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p66000_p66400', ARRAY[100], 'Check count from id_taptest_table_p60000_p66000_p66400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p66000_p66500', ARRAY[100], 'Check count from id_taptest_table_p60000_p66000_p66500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p66000_p66600', ARRAY[100], 'Check count from id_taptest_table_p60000_p66000_p66600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p66000_p66700', ARRAY[100], 'Check count from id_taptest_table_p60000_p66000_p66700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p66000_p66800', ARRAY[100], 'Check count from id_taptest_table_p60000_p66000_p66800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p66000_p66900', ARRAY[100], 'Check count from id_taptest_table_p60000_p66000_p66900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p67000_p67000', ARRAY[100], 'Check count from id_taptest_table_p60000_p67000_p67000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p67000_p67100', ARRAY[100], 'Check count from id_taptest_table_p60000_p67000_p67100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p67000_p67200', ARRAY[100], 'Check count from id_taptest_table_p60000_p67000_p67200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p67000_p67300', ARRAY[100], 'Check count from id_taptest_table_p60000_p67000_p67300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p67000_p67400', ARRAY[100], 'Check count from id_taptest_table_p60000_p67000_p67400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p67000_p67500', ARRAY[100], 'Check count from id_taptest_table_p60000_p67000_p67500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p67000_p67600', ARRAY[100], 'Check count from id_taptest_table_p60000_p67000_p67600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p67000_p67700', ARRAY[100], 'Check count from id_taptest_table_p60000_p67000_p67700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p67000_p67800', ARRAY[100], 'Check count from id_taptest_table_p60000_p67000_p67800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p67000_p67900', ARRAY[100], 'Check count from id_taptest_table_p60000_p67000_p67900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p68000_p68000', ARRAY[100], 'Check count from id_taptest_table_p60000_p68000_p68000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p68000_p68100', ARRAY[100], 'Check count from id_taptest_table_p60000_p68000_p68100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p68000_p68200', ARRAY[100], 'Check count from id_taptest_table_p60000_p68000_p68200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p68000_p68300', ARRAY[100], 'Check count from id_taptest_table_p60000_p68000_p68300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p68000_p68400', ARRAY[100], 'Check count from id_taptest_table_p60000_p68000_p68400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p68000_p68500', ARRAY[100], 'Check count from id_taptest_table_p60000_p68000_p68500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p68000_p68600', ARRAY[100], 'Check count from id_taptest_table_p60000_p68000_p68600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p68000_p68700', ARRAY[100], 'Check count from id_taptest_table_p60000_p68000_p68700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p68000_p68800', ARRAY[100], 'Check count from id_taptest_table_p60000_p68000_p68800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p68000_p68900', ARRAY[100], 'Check count from id_taptest_table_p60000_p68000_p68900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p69000_p69000', ARRAY[100], 'Check count from id_taptest_table_p60000_p69000_p69000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p69000_p69100', ARRAY[100], 'Check count from id_taptest_table_p60000_p69000_p69100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p69000_p69200', ARRAY[100], 'Check count from id_taptest_table_p60000_p69000_p69200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p69000_p69300', ARRAY[100], 'Check count from id_taptest_table_p60000_p69000_p69300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p69000_p69400', ARRAY[100], 'Check count from id_taptest_table_p60000_p69000_p69400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p69000_p69500', ARRAY[100], 'Check count from id_taptest_table_p60000_p69000_p69500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p69000_p69600', ARRAY[100], 'Check count from id_taptest_table_p60000_p69000_p69600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p69000_p69700', ARRAY[100], 'Check count from id_taptest_table_p60000_p69000_p69700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p69000_p69800', ARRAY[100], 'Check count from id_taptest_table_p60000_p69000_p69800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p60000_p69000_p69900', ARRAY[100], 'Check count from id_taptest_table_p60000_p69000_p69900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p70000_p70000', ARRAY[100], 'Check count from id_taptest_table_p70000_p70000_p70000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p70000_p70100', ARRAY[100], 'Check count from id_taptest_table_p70000_p70000_p70100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p70000_p70200', ARRAY[100], 'Check count from id_taptest_table_p70000_p70000_p70200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p70000_p70300', ARRAY[100], 'Check count from id_taptest_table_p70000_p70000_p70300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p70000_p70400', ARRAY[100], 'Check count from id_taptest_table_p70000_p70000_p70400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p70000_p70500', ARRAY[100], 'Check count from id_taptest_table_p70000_p70000_p70500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p70000_p70600', ARRAY[100], 'Check count from id_taptest_table_p70000_p70000_p70600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p70000_p70700', ARRAY[100], 'Check count from id_taptest_table_p70000_p70000_p70700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p70000_p70800', ARRAY[100], 'Check count from id_taptest_table_p70000_p70000_p70800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p70000_p70900', ARRAY[100], 'Check count from id_taptest_table_p70000_p70000_p70900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p71000_p71000', ARRAY[100], 'Check count from id_taptest_table_p70000_p71000_p71000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p71000_p71100', ARRAY[100], 'Check count from id_taptest_table_p70000_p71000_p71100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p71000_p71200', ARRAY[100], 'Check count from id_taptest_table_p70000_p71000_p71200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p71000_p71300', ARRAY[100], 'Check count from id_taptest_table_p70000_p71000_p71300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p71000_p71400', ARRAY[100], 'Check count from id_taptest_table_p70000_p71000_p71400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p71000_p71500', ARRAY[100], 'Check count from id_taptest_table_p70000_p71000_p71500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p71000_p71600', ARRAY[100], 'Check count from id_taptest_table_p70000_p71000_p71600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p71000_p71700', ARRAY[100], 'Check count from id_taptest_table_p70000_p71000_p71700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p71000_p71800', ARRAY[100], 'Check count from id_taptest_table_p70000_p71000_p71800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p71000_p71900', ARRAY[100], 'Check count from id_taptest_table_p70000_p71000_p71900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p72000_p72000', ARRAY[100], 'Check count from id_taptest_table_p70000_p72000_p72000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p72000_p72100', ARRAY[100], 'Check count from id_taptest_table_p70000_p72000_p72100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p72000_p72200', ARRAY[100], 'Check count from id_taptest_table_p70000_p72000_p72200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p72000_p72300', ARRAY[100], 'Check count from id_taptest_table_p70000_p72000_p72300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p72000_p72400', ARRAY[100], 'Check count from id_taptest_table_p70000_p72000_p72400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p72000_p72500', ARRAY[100], 'Check count from id_taptest_table_p70000_p72000_p72500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p72000_p72600', ARRAY[100], 'Check count from id_taptest_table_p70000_p72000_p72600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p72000_p72700', ARRAY[100], 'Check count from id_taptest_table_p70000_p72000_p72700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p72000_p72800', ARRAY[100], 'Check count from id_taptest_table_p70000_p72000_p72800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p72000_p72900', ARRAY[100], 'Check count from id_taptest_table_p70000_p72000_p72900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p73000_p73000', ARRAY[100], 'Check count from id_taptest_table_p70000_p73000_p73000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p73000_p73100', ARRAY[100], 'Check count from id_taptest_table_p70000_p73000_p73100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p73000_p73200', ARRAY[100], 'Check count from id_taptest_table_p70000_p73000_p73200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p73000_p73300', ARRAY[100], 'Check count from id_taptest_table_p70000_p73000_p73300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p73000_p73400', ARRAY[100], 'Check count from id_taptest_table_p70000_p73000_p73400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p73000_p73500', ARRAY[100], 'Check count from id_taptest_table_p70000_p73000_p73500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p73000_p73600', ARRAY[100], 'Check count from id_taptest_table_p70000_p73000_p73600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p73000_p73700', ARRAY[100], 'Check count from id_taptest_table_p70000_p73000_p73700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p73000_p73800', ARRAY[100], 'Check count from id_taptest_table_p70000_p73000_p73800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p73000_p73900', ARRAY[100], 'Check count from id_taptest_table_p70000_p73000_p73900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p74000_p74000', ARRAY[100], 'Check count from id_taptest_table_p70000_p74000_p74000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p74000_p74100', ARRAY[100], 'Check count from id_taptest_table_p70000_p74000_p74100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p74000_p74200', ARRAY[100], 'Check count from id_taptest_table_p70000_p74000_p74200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p74000_p74300', ARRAY[100], 'Check count from id_taptest_table_p70000_p74000_p74300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p74000_p74400', ARRAY[100], 'Check count from id_taptest_table_p70000_p74000_p74400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p74000_p74500', ARRAY[100], 'Check count from id_taptest_table_p70000_p74000_p74500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p74000_p74600', ARRAY[100], 'Check count from id_taptest_table_p70000_p74000_p74600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p74000_p74700', ARRAY[100], 'Check count from id_taptest_table_p70000_p74000_p74700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p74000_p74800', ARRAY[100], 'Check count from id_taptest_table_p70000_p74000_p74800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p74000_p74900', ARRAY[100], 'Check count from id_taptest_table_p70000_p74000_p74900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p75000_p75000', ARRAY[100], 'Check count from id_taptest_table_p70000_p75000_p75000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p75000_p75100', ARRAY[100], 'Check count from id_taptest_table_p70000_p75000_p75100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p75000_p75200', ARRAY[100], 'Check count from id_taptest_table_p70000_p75000_p75200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p75000_p75300', ARRAY[100], 'Check count from id_taptest_table_p70000_p75000_p75300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p75000_p75400', ARRAY[100], 'Check count from id_taptest_table_p70000_p75000_p75400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p75000_p75500', ARRAY[100], 'Check count from id_taptest_table_p70000_p75000_p75500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p75000_p75600', ARRAY[100], 'Check count from id_taptest_table_p70000_p75000_p75600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p75000_p75700', ARRAY[100], 'Check count from id_taptest_table_p70000_p75000_p75700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p75000_p75800', ARRAY[100], 'Check count from id_taptest_table_p70000_p75000_p75800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p75000_p75900', ARRAY[100], 'Check count from id_taptest_table_p70000_p75000_p75900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p76000_p76000', ARRAY[100], 'Check count from id_taptest_table_p70000_p76000_p76000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p76000_p76100', ARRAY[100], 'Check count from id_taptest_table_p70000_p76000_p76100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p76000_p76200', ARRAY[100], 'Check count from id_taptest_table_p70000_p76000_p76200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p76000_p76300', ARRAY[100], 'Check count from id_taptest_table_p70000_p76000_p76300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p76000_p76400', ARRAY[100], 'Check count from id_taptest_table_p70000_p76000_p76400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p76000_p76500', ARRAY[100], 'Check count from id_taptest_table_p70000_p76000_p76500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p76000_p76600', ARRAY[100], 'Check count from id_taptest_table_p70000_p76000_p76600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p76000_p76700', ARRAY[100], 'Check count from id_taptest_table_p70000_p76000_p76700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p76000_p76800', ARRAY[100], 'Check count from id_taptest_table_p70000_p76000_p76800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p76000_p76900', ARRAY[100], 'Check count from id_taptest_table_p70000_p76000_p76900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p77000_p77000', ARRAY[100], 'Check count from id_taptest_table_p70000_p77000_p77000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p77000_p77100', ARRAY[100], 'Check count from id_taptest_table_p70000_p77000_p77100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p77000_p77200', ARRAY[100], 'Check count from id_taptest_table_p70000_p77000_p77200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p77000_p77300', ARRAY[100], 'Check count from id_taptest_table_p70000_p77000_p77300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p77000_p77400', ARRAY[100], 'Check count from id_taptest_table_p70000_p77000_p77400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p77000_p77500', ARRAY[100], 'Check count from id_taptest_table_p70000_p77000_p77500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p77000_p77600', ARRAY[100], 'Check count from id_taptest_table_p70000_p77000_p77600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p77000_p77700', ARRAY[100], 'Check count from id_taptest_table_p70000_p77000_p77700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p77000_p77800', ARRAY[100], 'Check count from id_taptest_table_p70000_p77000_p77800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p77000_p77900', ARRAY[100], 'Check count from id_taptest_table_p70000_p77000_p77900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p78000_p78000', ARRAY[100], 'Check count from id_taptest_table_p70000_p78000_p78000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p78000_p78100', ARRAY[100], 'Check count from id_taptest_table_p70000_p78000_p78100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p78000_p78200', ARRAY[100], 'Check count from id_taptest_table_p70000_p78000_p78200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p78000_p78300', ARRAY[100], 'Check count from id_taptest_table_p70000_p78000_p78300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p78000_p78400', ARRAY[100], 'Check count from id_taptest_table_p70000_p78000_p78400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p78000_p78500', ARRAY[100], 'Check count from id_taptest_table_p70000_p78000_p78500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p78000_p78600', ARRAY[100], 'Check count from id_taptest_table_p70000_p78000_p78600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p78000_p78700', ARRAY[100], 'Check count from id_taptest_table_p70000_p78000_p78700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p78000_p78800', ARRAY[100], 'Check count from id_taptest_table_p70000_p78000_p78800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p78000_p78900', ARRAY[100], 'Check count from id_taptest_table_p70000_p78000_p78900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p79000_p79000', ARRAY[100], 'Check count from id_taptest_table_p70000_p79000_p79000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p79000_p79100', ARRAY[100], 'Check count from id_taptest_table_p70000_p79000_p79100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p79000_p79200', ARRAY[100], 'Check count from id_taptest_table_p70000_p79000_p79200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p79000_p79300', ARRAY[100], 'Check count from id_taptest_table_p70000_p79000_p79300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p79000_p79400', ARRAY[100], 'Check count from id_taptest_table_p70000_p79000_p79400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p79000_p79500', ARRAY[100], 'Check count from id_taptest_table_p70000_p79000_p79500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p79000_p79600', ARRAY[100], 'Check count from id_taptest_table_p70000_p79000_p79600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p79000_p79700', ARRAY[100], 'Check count from id_taptest_table_p70000_p79000_p79700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p79000_p79800', ARRAY[100], 'Check count from id_taptest_table_p70000_p79000_p79800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p70000_p79000_p79900', ARRAY[100], 'Check count from id_taptest_table_p70000_p79000_p79900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p80000_p80000', ARRAY[100], 'Check count from id_taptest_table_p80000_p80000_p80000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p80000_p80100', ARRAY[100], 'Check count from id_taptest_table_p80000_p80000_p80100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p80000_p80200', ARRAY[100], 'Check count from id_taptest_table_p80000_p80000_p80200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p80000_p80300', ARRAY[100], 'Check count from id_taptest_table_p80000_p80000_p80300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p80000_p80400', ARRAY[100], 'Check count from id_taptest_table_p80000_p80000_p80400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p80000_p80500', ARRAY[100], 'Check count from id_taptest_table_p80000_p80000_p80500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p80000_p80600', ARRAY[100], 'Check count from id_taptest_table_p80000_p80000_p80600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p80000_p80700', ARRAY[100], 'Check count from id_taptest_table_p80000_p80000_p80700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p80000_p80800', ARRAY[100], 'Check count from id_taptest_table_p80000_p80000_p80800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p80000_p80900', ARRAY[100], 'Check count from id_taptest_table_p80000_p80000_p80900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p81000_p81000', ARRAY[100], 'Check count from id_taptest_table_p80000_p81000_p81000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p81000_p81100', ARRAY[100], 'Check count from id_taptest_table_p80000_p81000_p81100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p81000_p81200', ARRAY[100], 'Check count from id_taptest_table_p80000_p81000_p81200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p81000_p81300', ARRAY[100], 'Check count from id_taptest_table_p80000_p81000_p81300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p81000_p81400', ARRAY[100], 'Check count from id_taptest_table_p80000_p81000_p81400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p81000_p81500', ARRAY[100], 'Check count from id_taptest_table_p80000_p81000_p81500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p81000_p81600', ARRAY[100], 'Check count from id_taptest_table_p80000_p81000_p81600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p81000_p81700', ARRAY[100], 'Check count from id_taptest_table_p80000_p81000_p81700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p81000_p81800', ARRAY[100], 'Check count from id_taptest_table_p80000_p81000_p81800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p81000_p81900', ARRAY[100], 'Check count from id_taptest_table_p80000_p81000_p81900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p82000_p82000', ARRAY[100], 'Check count from id_taptest_table_p80000_p82000_p82000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p82000_p82100', ARRAY[100], 'Check count from id_taptest_table_p80000_p82000_p82100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p82000_p82200', ARRAY[100], 'Check count from id_taptest_table_p80000_p82000_p82200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p82000_p82300', ARRAY[100], 'Check count from id_taptest_table_p80000_p82000_p82300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p82000_p82400', ARRAY[100], 'Check count from id_taptest_table_p80000_p82000_p82400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p82000_p82500', ARRAY[100], 'Check count from id_taptest_table_p80000_p82000_p82500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p82000_p82600', ARRAY[100], 'Check count from id_taptest_table_p80000_p82000_p82600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p82000_p82700', ARRAY[100], 'Check count from id_taptest_table_p80000_p82000_p82700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p82000_p82800', ARRAY[100], 'Check count from id_taptest_table_p80000_p82000_p82800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p82000_p82900', ARRAY[100], 'Check count from id_taptest_table_p80000_p82000_p82900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p83000_p83000', ARRAY[100], 'Check count from id_taptest_table_p80000_p83000_p83000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p83000_p83100', ARRAY[100], 'Check count from id_taptest_table_p80000_p83000_p83100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p83000_p83200', ARRAY[100], 'Check count from id_taptest_table_p80000_p83000_p83200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p83000_p83300', ARRAY[100], 'Check count from id_taptest_table_p80000_p83000_p83300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p83000_p83400', ARRAY[100], 'Check count from id_taptest_table_p80000_p83000_p83400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p83000_p83500', ARRAY[100], 'Check count from id_taptest_table_p80000_p83000_p83500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p83000_p83600', ARRAY[100], 'Check count from id_taptest_table_p80000_p83000_p83600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p83000_p83700', ARRAY[100], 'Check count from id_taptest_table_p80000_p83000_p83700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p83000_p83800', ARRAY[100], 'Check count from id_taptest_table_p80000_p83000_p83800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p83000_p83900', ARRAY[100], 'Check count from id_taptest_table_p80000_p83000_p83900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p84000_p84000', ARRAY[100], 'Check count from id_taptest_table_p80000_p84000_p84000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p84000_p84100', ARRAY[100], 'Check count from id_taptest_table_p80000_p84000_p84100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p84000_p84200', ARRAY[100], 'Check count from id_taptest_table_p80000_p84000_p84200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p84000_p84300', ARRAY[100], 'Check count from id_taptest_table_p80000_p84000_p84300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p84000_p84400', ARRAY[100], 'Check count from id_taptest_table_p80000_p84000_p84400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p84000_p84500', ARRAY[100], 'Check count from id_taptest_table_p80000_p84000_p84500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p84000_p84600', ARRAY[100], 'Check count from id_taptest_table_p80000_p84000_p84600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p84000_p84700', ARRAY[100], 'Check count from id_taptest_table_p80000_p84000_p84700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p84000_p84800', ARRAY[100], 'Check count from id_taptest_table_p80000_p84000_p84800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p84000_p84900', ARRAY[100], 'Check count from id_taptest_table_p80000_p84000_p84900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p85000_p85000', ARRAY[100], 'Check count from id_taptest_table_p80000_p85000_p85000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p85000_p85100', ARRAY[100], 'Check count from id_taptest_table_p80000_p85000_p85100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p85000_p85200', ARRAY[100], 'Check count from id_taptest_table_p80000_p85000_p85200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p85000_p85300', ARRAY[100], 'Check count from id_taptest_table_p80000_p85000_p85300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p85000_p85400', ARRAY[100], 'Check count from id_taptest_table_p80000_p85000_p85400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p85000_p85500', ARRAY[100], 'Check count from id_taptest_table_p80000_p85000_p85500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p85000_p85600', ARRAY[100], 'Check count from id_taptest_table_p80000_p85000_p85600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p85000_p85700', ARRAY[100], 'Check count from id_taptest_table_p80000_p85000_p85700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p85000_p85800', ARRAY[100], 'Check count from id_taptest_table_p80000_p85000_p85800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p85000_p85900', ARRAY[100], 'Check count from id_taptest_table_p80000_p85000_p85900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p86000_p86000', ARRAY[100], 'Check count from id_taptest_table_p80000_p86000_p86000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p86000_p86100', ARRAY[100], 'Check count from id_taptest_table_p80000_p86000_p86100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p86000_p86200', ARRAY[100], 'Check count from id_taptest_table_p80000_p86000_p86200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p86000_p86300', ARRAY[100], 'Check count from id_taptest_table_p80000_p86000_p86300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p86000_p86400', ARRAY[100], 'Check count from id_taptest_table_p80000_p86000_p86400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p86000_p86500', ARRAY[100], 'Check count from id_taptest_table_p80000_p86000_p86500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p86000_p86600', ARRAY[100], 'Check count from id_taptest_table_p80000_p86000_p86600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p86000_p86700', ARRAY[100], 'Check count from id_taptest_table_p80000_p86000_p86700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p86000_p86800', ARRAY[100], 'Check count from id_taptest_table_p80000_p86000_p86800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p86000_p86900', ARRAY[100], 'Check count from id_taptest_table_p80000_p86000_p86900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p87000_p87000', ARRAY[100], 'Check count from id_taptest_table_p80000_p87000_p87000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p87000_p87100', ARRAY[100], 'Check count from id_taptest_table_p80000_p87000_p87100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p87000_p87200', ARRAY[100], 'Check count from id_taptest_table_p80000_p87000_p87200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p87000_p87300', ARRAY[100], 'Check count from id_taptest_table_p80000_p87000_p87300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p87000_p87400', ARRAY[100], 'Check count from id_taptest_table_p80000_p87000_p87400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p87000_p87500', ARRAY[100], 'Check count from id_taptest_table_p80000_p87000_p87500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p87000_p87600', ARRAY[100], 'Check count from id_taptest_table_p80000_p87000_p87600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p87000_p87700', ARRAY[100], 'Check count from id_taptest_table_p80000_p87000_p87700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p87000_p87800', ARRAY[100], 'Check count from id_taptest_table_p80000_p87000_p87800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p87000_p87900', ARRAY[100], 'Check count from id_taptest_table_p80000_p87000_p87900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p88000_p88000', ARRAY[100], 'Check count from id_taptest_table_p80000_p88000_p88000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p88000_p88100', ARRAY[100], 'Check count from id_taptest_table_p80000_p88000_p88100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p88000_p88200', ARRAY[100], 'Check count from id_taptest_table_p80000_p88000_p88200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p88000_p88300', ARRAY[100], 'Check count from id_taptest_table_p80000_p88000_p88300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p88000_p88400', ARRAY[100], 'Check count from id_taptest_table_p80000_p88000_p88400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p88000_p88500', ARRAY[100], 'Check count from id_taptest_table_p80000_p88000_p88500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p88000_p88600', ARRAY[100], 'Check count from id_taptest_table_p80000_p88000_p88600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p88000_p88700', ARRAY[100], 'Check count from id_taptest_table_p80000_p88000_p88700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p88000_p88800', ARRAY[100], 'Check count from id_taptest_table_p80000_p88000_p88800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p88000_p88900', ARRAY[100], 'Check count from id_taptest_table_p80000_p88000_p88900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p89000_p89000', ARRAY[100], 'Check count from id_taptest_table_p80000_p89000_p89000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p89000_p89100', ARRAY[100], 'Check count from id_taptest_table_p80000_p89000_p89100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p89000_p89200', ARRAY[100], 'Check count from id_taptest_table_p80000_p89000_p89200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p89000_p89300', ARRAY[100], 'Check count from id_taptest_table_p80000_p89000_p89300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p89000_p89400', ARRAY[100], 'Check count from id_taptest_table_p80000_p89000_p89400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p89000_p89500', ARRAY[100], 'Check count from id_taptest_table_p80000_p89000_p89500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p89000_p89600', ARRAY[100], 'Check count from id_taptest_table_p80000_p89000_p89600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p89000_p89700', ARRAY[100], 'Check count from id_taptest_table_p80000_p89000_p89700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p89000_p89800', ARRAY[100], 'Check count from id_taptest_table_p80000_p89000_p89800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p80000_p89000_p89900', ARRAY[100], 'Check count from id_taptest_table_p80000_p89000_p89900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p90000_p90000', ARRAY[100], 'Check count from id_taptest_table_p90000_p90000_p90000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p90000_p90100', ARRAY[100], 'Check count from id_taptest_table_p90000_p90000_p90100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p90000_p90200', ARRAY[100], 'Check count from id_taptest_table_p90000_p90000_p90200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p90000_p90300', ARRAY[100], 'Check count from id_taptest_table_p90000_p90000_p90300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p90000_p90400', ARRAY[100], 'Check count from id_taptest_table_p90000_p90000_p90400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p90000_p90500', ARRAY[100], 'Check count from id_taptest_table_p90000_p90000_p90500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p90000_p90600', ARRAY[100], 'Check count from id_taptest_table_p90000_p90000_p90600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p90000_p90700', ARRAY[100], 'Check count from id_taptest_table_p90000_p90000_p90700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p90000_p90800', ARRAY[100], 'Check count from id_taptest_table_p90000_p90000_p90800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p90000_p90900', ARRAY[100], 'Check count from id_taptest_table_p90000_p90000_p90900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p91000_p91000', ARRAY[100], 'Check count from id_taptest_table_p90000_p91000_p91000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p91000_p91100', ARRAY[100], 'Check count from id_taptest_table_p90000_p91000_p91100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p91000_p91200', ARRAY[100], 'Check count from id_taptest_table_p90000_p91000_p91200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p91000_p91300', ARRAY[100], 'Check count from id_taptest_table_p90000_p91000_p91300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p91000_p91400', ARRAY[100], 'Check count from id_taptest_table_p90000_p91000_p91400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p91000_p91500', ARRAY[100], 'Check count from id_taptest_table_p90000_p91000_p91500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p91000_p91600', ARRAY[100], 'Check count from id_taptest_table_p90000_p91000_p91600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p91000_p91700', ARRAY[100], 'Check count from id_taptest_table_p90000_p91000_p91700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p91000_p91800', ARRAY[100], 'Check count from id_taptest_table_p90000_p91000_p91800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p91000_p91900', ARRAY[100], 'Check count from id_taptest_table_p90000_p91000_p91900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p92000_p92000', ARRAY[100], 'Check count from id_taptest_table_p90000_p92000_p92000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p92000_p92100', ARRAY[100], 'Check count from id_taptest_table_p90000_p92000_p92100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p92000_p92200', ARRAY[100], 'Check count from id_taptest_table_p90000_p92000_p92200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p92000_p92300', ARRAY[100], 'Check count from id_taptest_table_p90000_p92000_p92300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p92000_p92400', ARRAY[100], 'Check count from id_taptest_table_p90000_p92000_p92400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p92000_p92500', ARRAY[100], 'Check count from id_taptest_table_p90000_p92000_p92500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p92000_p92600', ARRAY[100], 'Check count from id_taptest_table_p90000_p92000_p92600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p92000_p92700', ARRAY[100], 'Check count from id_taptest_table_p90000_p92000_p92700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p92000_p92800', ARRAY[100], 'Check count from id_taptest_table_p90000_p92000_p92800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p92000_p92900', ARRAY[100], 'Check count from id_taptest_table_p90000_p92000_p92900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p93000_p93000', ARRAY[100], 'Check count from id_taptest_table_p90000_p93000_p93000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p93000_p93100', ARRAY[100], 'Check count from id_taptest_table_p90000_p93000_p93100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p93000_p93200', ARRAY[100], 'Check count from id_taptest_table_p90000_p93000_p93200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p93000_p93300', ARRAY[100], 'Check count from id_taptest_table_p90000_p93000_p93300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p93000_p93400', ARRAY[100], 'Check count from id_taptest_table_p90000_p93000_p93400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p93000_p93500', ARRAY[100], 'Check count from id_taptest_table_p90000_p93000_p93500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p93000_p93600', ARRAY[100], 'Check count from id_taptest_table_p90000_p93000_p93600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p93000_p93700', ARRAY[100], 'Check count from id_taptest_table_p90000_p93000_p93700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p93000_p93800', ARRAY[100], 'Check count from id_taptest_table_p90000_p93000_p93800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p93000_p93900', ARRAY[100], 'Check count from id_taptest_table_p90000_p93000_p93900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p94000_p94000', ARRAY[100], 'Check count from id_taptest_table_p90000_p94000_p94000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p94000_p94100', ARRAY[100], 'Check count from id_taptest_table_p90000_p94000_p94100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p94000_p94200', ARRAY[100], 'Check count from id_taptest_table_p90000_p94000_p94200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p94000_p94300', ARRAY[100], 'Check count from id_taptest_table_p90000_p94000_p94300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p94000_p94400', ARRAY[100], 'Check count from id_taptest_table_p90000_p94000_p94400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p94000_p94500', ARRAY[100], 'Check count from id_taptest_table_p90000_p94000_p94500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p94000_p94600', ARRAY[100], 'Check count from id_taptest_table_p90000_p94000_p94600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p94000_p94700', ARRAY[100], 'Check count from id_taptest_table_p90000_p94000_p94700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p94000_p94800', ARRAY[100], 'Check count from id_taptest_table_p90000_p94000_p94800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p94000_p94900', ARRAY[100], 'Check count from id_taptest_table_p90000_p94000_p94900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p95000_p95000', ARRAY[100], 'Check count from id_taptest_table_p90000_p95000_p95000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p95000_p95100', ARRAY[100], 'Check count from id_taptest_table_p90000_p95000_p95100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p95000_p95200', ARRAY[100], 'Check count from id_taptest_table_p90000_p95000_p95200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p95000_p95300', ARRAY[100], 'Check count from id_taptest_table_p90000_p95000_p95300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p95000_p95400', ARRAY[100], 'Check count from id_taptest_table_p90000_p95000_p95400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p95000_p95500', ARRAY[100], 'Check count from id_taptest_table_p90000_p95000_p95500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p95000_p95600', ARRAY[100], 'Check count from id_taptest_table_p90000_p95000_p95600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p95000_p95700', ARRAY[100], 'Check count from id_taptest_table_p90000_p95000_p95700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p95000_p95800', ARRAY[100], 'Check count from id_taptest_table_p90000_p95000_p95800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p95000_p95900', ARRAY[100], 'Check count from id_taptest_table_p90000_p95000_p95900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p96000_p96000', ARRAY[100], 'Check count from id_taptest_table_p90000_p96000_p96000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p96000_p96100', ARRAY[100], 'Check count from id_taptest_table_p90000_p96000_p96100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p96000_p96200', ARRAY[100], 'Check count from id_taptest_table_p90000_p96000_p96200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p96000_p96300', ARRAY[100], 'Check count from id_taptest_table_p90000_p96000_p96300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p96000_p96400', ARRAY[100], 'Check count from id_taptest_table_p90000_p96000_p96400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p96000_p96500', ARRAY[100], 'Check count from id_taptest_table_p90000_p96000_p96500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p96000_p96600', ARRAY[100], 'Check count from id_taptest_table_p90000_p96000_p96600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p96000_p96700', ARRAY[100], 'Check count from id_taptest_table_p90000_p96000_p96700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p96000_p96800', ARRAY[100], 'Check count from id_taptest_table_p90000_p96000_p96800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p96000_p96900', ARRAY[100], 'Check count from id_taptest_table_p90000_p96000_p96900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p97000_p97000', ARRAY[100], 'Check count from id_taptest_table_p90000_p97000_p97000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p97000_p97100', ARRAY[100], 'Check count from id_taptest_table_p90000_p97000_p97100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p97000_p97200', ARRAY[100], 'Check count from id_taptest_table_p90000_p97000_p97200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p97000_p97300', ARRAY[100], 'Check count from id_taptest_table_p90000_p97000_p97300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p97000_p97400', ARRAY[100], 'Check count from id_taptest_table_p90000_p97000_p97400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p97000_p97500', ARRAY[100], 'Check count from id_taptest_table_p90000_p97000_p97500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p97000_p97600', ARRAY[100], 'Check count from id_taptest_table_p90000_p97000_p97600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p97000_p97700', ARRAY[100], 'Check count from id_taptest_table_p90000_p97000_p97700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p97000_p97800', ARRAY[100], 'Check count from id_taptest_table_p90000_p97000_p97800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p97000_p97900', ARRAY[100], 'Check count from id_taptest_table_p90000_p97000_p97900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p98000_p98000', ARRAY[100], 'Check count from id_taptest_table_p90000_p98000_p98000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p98000_p98100', ARRAY[100], 'Check count from id_taptest_table_p90000_p98000_p98100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p98000_p98200', ARRAY[100], 'Check count from id_taptest_table_p90000_p98000_p98200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p98000_p98300', ARRAY[100], 'Check count from id_taptest_table_p90000_p98000_p98300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p98000_p98400', ARRAY[100], 'Check count from id_taptest_table_p90000_p98000_p98400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p98000_p98500', ARRAY[100], 'Check count from id_taptest_table_p90000_p98000_p98500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p98000_p98600', ARRAY[100], 'Check count from id_taptest_table_p90000_p98000_p98600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p98000_p98700', ARRAY[100], 'Check count from id_taptest_table_p90000_p98000_p98700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p98000_p98800', ARRAY[100], 'Check count from id_taptest_table_p90000_p98000_p98800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p98000_p98900', ARRAY[100], 'Check count from id_taptest_table_p90000_p98000_p98900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p99000_p99000', ARRAY[100], 'Check count from id_taptest_table_p90000_p99000_p99000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p99000_p99100', ARRAY[100], 'Check count from id_taptest_table_p90000_p99000_p99100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p99000_p99200', ARRAY[100], 'Check count from id_taptest_table_p90000_p99000_p99200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p99000_p99300', ARRAY[100], 'Check count from id_taptest_table_p90000_p99000_p99300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p99000_p99400', ARRAY[100], 'Check count from id_taptest_table_p90000_p99000_p99400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p99000_p99500', ARRAY[100], 'Check count from id_taptest_table_p90000_p99000_p99500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p99000_p99600', ARRAY[100], 'Check count from id_taptest_table_p90000_p99000_p99600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p99000_p99700', ARRAY[100], 'Check count from id_taptest_table_p90000_p99000_p99700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p99000_p99800', ARRAY[100], 'Check count from id_taptest_table_p90000_p99000_p99800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p90000_p99000_p99900', ARRAY[100], 'Check count from id_taptest_table_p90000_p99000_p99900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p100000_p100000', ARRAY[1], 'Check count from id_taptest_table_p100000_p100000_p100000');

-- INSERT batch 2
INSERT INTO partman_test.id_taptest_table (col1) VALUES (generate_series(100001, 100100));

SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table', 'Check that parent table partman_test.id_taptest_table is empty');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table', ARRAY[100100], 'Check count from parent table partman_test.id_taptest_table (175000)');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p100000', 'Check that parent table partman_test.id_taptest_table_p100000 is empty');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p100000_p100000', 'Check that parent table partman_test.id_taptest_table_p100000_p100000 is empty');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p100000_p101000', 'Check that parent table partman_test.id_taptest_table_p100000_p101000 is empty');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p100000_p100000', ARRAY[100], 'Check count from id_taptest_table_p100000_p100000_p100000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p100000_p100100', ARRAY[1], 'Check count from id_taptest_table_p100000_p100000_p100100');

SELECT run_maintenance();
SELECT has_table('partman_test', 'id_taptest_table_p100000_p100000_p100300', 'Check id_taptest_table_p100000_p100000_p100300 exists');
SELECT hasnt_table('partman_test', 'id_taptest_table_p100000_p100000_p100400', 'Check id_taptest_table_p100000_p100000_p100400 does not exists');

UPDATE part_config SET premake = 11 WHERE parent_table LIKE 'partman_test.id_taptest_table%' AND partition_type = 'id';
SELECT run_maintenance();

INSERT INTO partman_test.id_taptest_table (col1) VALUES (generate_series(100101,107500));

-- Stuff likely went into some parent tables. It's diffcult to test a constant stream of input data to regularly run run_maintenence() against.
SELECT results_eq('SELECT parent_table, count::int FROM check_parent() ORDER BY parent_table', $$VALUES 
                                                                                                ('partman_test.id_taptest_table_p100000_p101000', 900), 
                                                                                                ('partman_test.id_taptest_table_p100000_p102000', 900), 
                                                                                                ('partman_test.id_taptest_table_p100000_p103000', 900), 
                                                                                                ('partman_test.id_taptest_table_p100000_p104000', 900), 
                                                                                                ('partman_test.id_taptest_table_p100000_p105000', 900), 
                                                                                                ('partman_test.id_taptest_table_p100000_p106000', 900), 
                                                                                                ('partman_test.id_taptest_table_p100000_p107000',  401)$$, 
                    'check_parent() run to see if stuff was put into parent tables');


SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p100000_p101000'', p_batch_count := 20)::int', ARRAY[900], 
    'Check that partitioning function returns correct count of rows moved for id_taptest_table_p100000_p101000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p100000_p102000'', p_batch_count := 20)::int', ARRAY[900], 
    'Check that partitioning function returns correct count of rows moved for id_taptest_table_p100000_p102000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p100000_p103000'', p_batch_count := 20)::int', ARRAY[900], 
    'Check that partitioning function returns correct count of rows moved for id_taptest_table_p100000_p103000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p100000_p104000'', p_batch_count := 20)::int', ARRAY[900], 
    'Check that partitioning function returns correct count of rows moved for id_taptest_table_p100000_p104000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p100000_p105000'', p_batch_count := 20)::int', ARRAY[900], 
    'Check that partitioning function returns correct count of rows moved for id_taptest_table_p100000_p105000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p100000_p106000'', p_batch_count := 20)::int', ARRAY[900], 
    'Check that partitioning function returns correct count of rows moved for id_taptest_table_p100000_p106000');
SELECT results_eq('SELECT partition_data_id(''partman_test.id_taptest_table_p100000_p107000'', p_batch_count := 20)::int', ARRAY[401], 
    'Check that partitioning function returns correct count of rows moved for id_taptest_table_p100000_p107000');

SELECT is_empty('SELECT * from check_parent()', 'check_parent() should return nothing now.');

-- Check for the rest of batch 2 tables now
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p100000_p100000', ARRAY[100], 'Check count fromid_taptest_table_p100000_p100000_p100000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p100000_p100100', ARRAY[100], 'Check count fromid_taptest_table_p100000_p100000_p100100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p100000_p100200', ARRAY[100], 'Check count fromid_taptest_table_p100000_p100000_p100200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p100000_p100300', ARRAY[100], 'Check count fromid_taptest_table_p100000_p100000_p100300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p100000_p100400', ARRAY[100], 'Check count fromid_taptest_table_p100000_p100000_p100400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p100000_p100500', ARRAY[100], 'Check count fromid_taptest_table_p100000_p100000_p100500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p100000_p100600', ARRAY[100], 'Check count fromid_taptest_table_p100000_p100000_p100600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p100000_p100700', ARRAY[100], 'Check count fromid_taptest_table_p100000_p100000_p100700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p100000_p100800', ARRAY[100], 'Check count fromid_taptest_table_p100000_p100000_p100800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p100000_p100900', ARRAY[100], 'Check count fromid_taptest_table_p100000_p100000_p100900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p101000_p101000', ARRAY[100], 'Check count fromid_taptest_table_p100000_p101000_p101000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p101000_p101100', ARRAY[100], 'Check count fromid_taptest_table_p100000_p101000_p101100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p101000_p101200', ARRAY[100], 'Check count fromid_taptest_table_p100000_p101000_p101200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p101000_p101300', ARRAY[100], 'Check count fromid_taptest_table_p100000_p101000_p101300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p101000_p101400', ARRAY[100], 'Check count fromid_taptest_table_p100000_p101000_p101400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p101000_p101500', ARRAY[100], 'Check count fromid_taptest_table_p100000_p101000_p101500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p101000_p101600', ARRAY[100], 'Check count fromid_taptest_table_p100000_p101000_p101600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p101000_p101700', ARRAY[100], 'Check count fromid_taptest_table_p100000_p101000_p101700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p101000_p101800', ARRAY[100], 'Check count fromid_taptest_table_p100000_p101000_p101800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p101000_p101900', ARRAY[100], 'Check count fromid_taptest_table_p100000_p101000_p101900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p102000_p102000', ARRAY[100], 'Check count fromid_taptest_table_p100000_p102000_p102000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p102000_p102100', ARRAY[100], 'Check count fromid_taptest_table_p100000_p102000_p102100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p102000_p102200', ARRAY[100], 'Check count fromid_taptest_table_p100000_p102000_p102200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p102000_p102300', ARRAY[100], 'Check count fromid_taptest_table_p100000_p102000_p102300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p102000_p102400', ARRAY[100], 'Check count fromid_taptest_table_p100000_p102000_p102400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p102000_p102500', ARRAY[100], 'Check count fromid_taptest_table_p100000_p102000_p102500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p102000_p102600', ARRAY[100], 'Check count fromid_taptest_table_p100000_p102000_p102600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p102000_p102700', ARRAY[100], 'Check count fromid_taptest_table_p100000_p102000_p102700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p102000_p102800', ARRAY[100], 'Check count fromid_taptest_table_p100000_p102000_p102800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p102000_p102900', ARRAY[100], 'Check count fromid_taptest_table_p100000_p102000_p102900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p103000_p103000', ARRAY[100], 'Check count fromid_taptest_table_p100000_p103000_p103000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p103000_p103100', ARRAY[100], 'Check count fromid_taptest_table_p100000_p103000_p103100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p103000_p103200', ARRAY[100], 'Check count fromid_taptest_table_p100000_p103000_p103200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p103000_p103300', ARRAY[100], 'Check count fromid_taptest_table_p100000_p103000_p103300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p103000_p103400', ARRAY[100], 'Check count fromid_taptest_table_p100000_p103000_p103400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p103000_p103500', ARRAY[100], 'Check count fromid_taptest_table_p100000_p103000_p103500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p103000_p103600', ARRAY[100], 'Check count fromid_taptest_table_p100000_p103000_p103600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p103000_p103700', ARRAY[100], 'Check count fromid_taptest_table_p100000_p103000_p103700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p103000_p103800', ARRAY[100], 'Check count fromid_taptest_table_p100000_p103000_p103800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p103000_p103900', ARRAY[100], 'Check count fromid_taptest_table_p100000_p103000_p103900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p104000_p104000', ARRAY[100], 'Check count fromid_taptest_table_p100000_p104000_p104000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p104000_p104100', ARRAY[100], 'Check count fromid_taptest_table_p100000_p104000_p104100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p104000_p104200', ARRAY[100], 'Check count fromid_taptest_table_p100000_p104000_p104200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p104000_p104300', ARRAY[100], 'Check count fromid_taptest_table_p100000_p104000_p104300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p104000_p104400', ARRAY[100], 'Check count fromid_taptest_table_p100000_p104000_p104400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p104000_p104500', ARRAY[100], 'Check count fromid_taptest_table_p100000_p104000_p104500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p104000_p104600', ARRAY[100], 'Check count fromid_taptest_table_p100000_p104000_p104600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p104000_p104700', ARRAY[100], 'Check count fromid_taptest_table_p100000_p104000_p104700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p104000_p104800', ARRAY[100], 'Check count fromid_taptest_table_p100000_p104000_p104800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p104000_p104900', ARRAY[100], 'Check count fromid_taptest_table_p100000_p104000_p104900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p105000_p105000', ARRAY[100], 'Check count fromid_taptest_table_p100000_p105000_p105000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p105000_p105100', ARRAY[100], 'Check count fromid_taptest_table_p100000_p105000_p105100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p105000_p105200', ARRAY[100], 'Check count fromid_taptest_table_p100000_p105000_p105200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p105000_p105300', ARRAY[100], 'Check count fromid_taptest_table_p100000_p105000_p105300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p105000_p105400', ARRAY[100], 'Check count fromid_taptest_table_p100000_p105000_p105400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p105000_p105500', ARRAY[100], 'Check count fromid_taptest_table_p100000_p105000_p105500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p105000_p105600', ARRAY[100], 'Check count fromid_taptest_table_p100000_p105000_p105600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p105000_p105700', ARRAY[100], 'Check count fromid_taptest_table_p100000_p105000_p105700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p105000_p105800', ARRAY[100], 'Check count fromid_taptest_table_p100000_p105000_p105800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p105000_p105900', ARRAY[100], 'Check count fromid_taptest_table_p100000_p105000_p105900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p106000_p106000', ARRAY[100], 'Check count fromid_taptest_table_p100000_p106000_p106000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p106000_p106100', ARRAY[100], 'Check count fromid_taptest_table_p100000_p106000_p106100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p106000_p106200', ARRAY[100], 'Check count fromid_taptest_table_p100000_p106000_p106200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p106000_p106300', ARRAY[100], 'Check count fromid_taptest_table_p100000_p106000_p106300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p106000_p106400', ARRAY[100], 'Check count fromid_taptest_table_p100000_p106000_p106400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p106000_p106500', ARRAY[100], 'Check count fromid_taptest_table_p100000_p106000_p106500');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p106000_p106600', ARRAY[100], 'Check count fromid_taptest_table_p100000_p106000_p106600');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p106000_p106700', ARRAY[100], 'Check count fromid_taptest_table_p100000_p106000_p106700');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p106000_p106800', ARRAY[100], 'Check count fromid_taptest_table_p100000_p106000_p106800');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p106000_p106900', ARRAY[100], 'Check count fromid_taptest_table_p100000_p106000_p106900');

SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p107000_p107000', ARRAY[100], 'Check count fromid_taptest_table_p100000_p107000_p107000');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p107000_p107100', ARRAY[100], 'Check count fromid_taptest_table_p100000_p107000_p107100');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p107000_p107200', ARRAY[100], 'Check count fromid_taptest_table_p100000_p107000_p107200');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p107000_p107300', ARRAY[100], 'Check count fromid_taptest_table_p100000_p107000_p107300');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p107000_p107400', ARRAY[100], 'Check count fromid_taptest_table_p100000_p107000_p107400');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table_p100000_p107000_p107500', ARRAY[1], 'Check count fromid_taptest_table_p100000_p107000_p107500');

SELECT run_maintenance();

-- UNDO ALL THE THINGS!!
SELECT throws_matching('SELECT undo_partition_id(''partman_test.id_taptest_table'', 20, p_keep_table := false)',
'Child table for this parent has child table\(s\) itself \(partman_test\.id_taptest_table_p0\)\. Run undo partitioning on this table or remove inheritance first to ensure all data is properly moved to parent.*',
'Check that undoing partitions is prevented if subpartitions still exist');

-- First the sub-sub parents
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p0_p0'', 20, p_keep_table := false)::int', ARRAY[999], 'Undo partitioning for parent table partman_test.id_taptest_table_p0_p0');

SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p0_p1000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p0_p1000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p0_p2000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p0_p2000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p0_p3000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p0_p3000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p0_p4000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p0_p4000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p0_p5000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p0_p5000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p0_p6000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p0_p6000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p0_p7000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p0_p7000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p0_p8000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p0_p8000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p0_p9000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p0_p9000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p10000_p10000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p10000_p10000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p10000_p11000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p10000_p11000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p10000_p12000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p10000_p12000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p10000_p13000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p10000_p13000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p10000_p14000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p10000_p14000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p10000_p15000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p10000_p15000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p10000_p16000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p10000_p16000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p10000_p17000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p10000_p17000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p10000_p18000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p10000_p18000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p10000_p19000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p10000_p19000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p20000_p20000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p20000_p20000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p20000_p21000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p20000_p21000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p20000_p22000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p20000_p22000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p20000_p23000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p20000_p23000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p20000_p24000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p20000_p24000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p20000_p25000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p20000_p25000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p20000_p26000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p20000_p26000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p20000_p27000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p20000_p27000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p20000_p28000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p20000_p28000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p20000_p29000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p20000_p29000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p30000_p30000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p30000_p30000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p30000_p31000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p30000_p31000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p30000_p32000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p30000_p32000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p30000_p33000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p30000_p33000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p30000_p34000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p30000_p34000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p30000_p35000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p30000_p35000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p30000_p36000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p30000_p36000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p30000_p37000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p30000_p37000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p30000_p38000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p30000_p38000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p30000_p39000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p30000_p39000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p40000_p40000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p40000_p40000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p40000_p41000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p40000_p41000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p40000_p42000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p40000_p42000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p40000_p43000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p40000_p43000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p40000_p44000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p40000_p44000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p40000_p45000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p40000_p45000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p40000_p46000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p40000_p46000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p40000_p47000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p40000_p47000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p40000_p48000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p40000_p48000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p40000_p49000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p40000_p49000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p50000_p50000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p50000_p50000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p50000_p51000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p50000_p51000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p50000_p52000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p50000_p52000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p50000_p53000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p50000_p53000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p50000_p54000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p50000_p54000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p50000_p55000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p50000_p55000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p50000_p56000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p50000_p56000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p50000_p57000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p50000_p57000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p50000_p58000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p50000_p58000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p50000_p59000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p50000_p59000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p60000_p60000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p60000_p60000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p60000_p61000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p60000_p61000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p60000_p62000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p60000_p62000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p60000_p63000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p60000_p63000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p60000_p64000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p60000_p64000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p60000_p65000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p60000_p65000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p60000_p66000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p60000_p66000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p60000_p67000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p60000_p67000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p60000_p68000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p60000_p68000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p60000_p69000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p60000_p69000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p70000_p70000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p70000_p70000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p70000_p71000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p70000_p71000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p70000_p72000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p70000_p72000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p70000_p73000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p70000_p73000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p70000_p74000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p70000_p74000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p70000_p75000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p70000_p75000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p70000_p76000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p70000_p76000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p70000_p77000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p70000_p77000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p70000_p78000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p70000_p78000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p70000_p79000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p70000_p79000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p80000_p80000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p80000_p80000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p80000_p81000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p80000_p81000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p80000_p82000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p80000_p82000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p80000_p83000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p80000_p83000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p80000_p84000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p80000_p84000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p80000_p85000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p80000_p85000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p80000_p86000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p80000_p86000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p80000_p87000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p80000_p87000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p80000_p88000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p80000_p88000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p80000_p89000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p80000_p89000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p90000_p90000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p90000_p90000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p90000_p91000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p90000_p91000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p90000_p92000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p90000_p92000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p90000_p93000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p90000_p93000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p90000_p94000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p90000_p94000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p90000_p95000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p90000_p95000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p90000_p96000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p90000_p96000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p90000_p97000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p90000_p97000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p90000_p98000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p90000_p98000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p90000_p99000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p90000_p99000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p100000_p100000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p100000_p100000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p100000_p101000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p100000_p101000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p100000_p102000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p100000_p102000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p100000_p103000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p100000_p103000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p100000_p104000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p100000_p104000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p100000_p105000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p100000_p105000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p100000_p106000'', 20, p_keep_table := false)::int', ARRAY[1000], 'Undo partitioning for parent table partman_test.id_taptest_table_p100000_p106000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p100000_p107000'', 20, p_keep_table := false)::int', ARRAY[501], 'Undo partitioning for parent table partman_test.id_taptest_table_p100000_p107000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p100000_p108000'', 20, p_keep_table := false)::int', ARRAY[0], 'Undo partitioning for parent table partman_test.id_taptest_table_p100000_p108000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p100000_p109000'', 20, p_keep_table := false)::int', ARRAY[0], 'Undo partitioning for parent table partman_test.id_taptest_table_p100000_p109000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p110000_p110000'', 20, p_keep_table := false)::int', ARRAY[0], 'Undo partitioning for parent table partman_test.id_taptest_table_p110000_p110000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p120000_p120000'', 20, p_keep_table := false)::int', ARRAY[0], 'Undo partitioning for parent table partman_test.id_taptest_table_p120000_p120000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p130000_p130000'', 20, p_keep_table := false)::int', ARRAY[0], 'Undo partitioning for parent table partman_test.id_taptest_table_p130000_p130000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p140000_p140000'', 20, p_keep_table := false)::int', ARRAY[0], 'Undo partitioning for parent table partman_test.id_taptest_table_p140000_p140000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p150000_p150000'', 20, p_keep_table := false)::int', ARRAY[0], 'Undo partitioning for parent table partman_test.id_taptest_table_p150000_p150000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p160000_p160000'', 20, p_keep_table := false)::int', ARRAY[0], 'Undo partitioning for parent table partman_test.id_taptest_table_p160000_p160000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p170000_p170000'', 20, p_keep_table := false)::int', ARRAY[0], 'Undo partitioning for parent table partman_test.id_taptest_table_p170000_p170000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p180000_p180000'', 20, p_keep_table := false)::int', ARRAY[0], 'Undo partitioning for parent table partman_test.id_taptest_table_p180000_p180000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p190000_p190000'', 20, p_keep_table := false)::int', ARRAY[0], 'Undo partitioning for parent table partman_test.id_taptest_table_p190000_p190000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p200000_p200000'', 20, p_keep_table := false)::int', ARRAY[0], 'Undo partitioning for parent table partman_test.id_taptest_table_p200000_p200000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p210000_p210000'', 20, p_keep_table := false)::int', ARRAY[0], 'Undo partitioning for parent table partman_test.id_taptest_table_p210000_p210000');


-- Check that lowest child tables were removed (TODO need to clean this list up, it's got everything)
SELECT hasnt_table('partman_test.id_taptest_table_p0_p0_p0', 'Check that table partman_test.id_taptest_table_p0_p0_p0 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p0_p100', 'Check that table partman_test.id_taptest_table_p0_p0_p100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p0_p200', 'Check that table partman_test.id_taptest_table_p0_p0_p200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p0_p300', 'Check that table partman_test.id_taptest_table_p0_p0_p300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p0_p400', 'Check that table partman_test.id_taptest_table_p0_p0_p400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p0_p500', 'Check that table partman_test.id_taptest_table_p0_p0_p500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p0_p600', 'Check that table partman_test.id_taptest_table_p0_p0_p600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p0_p700', 'Check that table partman_test.id_taptest_table_p0_p0_p700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p0_p800', 'Check that table partman_test.id_taptest_table_p0_p0_p800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p0_p900', 'Check that table partman_test.id_taptest_table_p0_p0_p900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p1000_p1000', 'Check that table partman_test.id_taptest_table_p0_p1000_p1000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p1000_p1100', 'Check that table partman_test.id_taptest_table_p0_p1000_p1100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p1000_p1200', 'Check that table partman_test.id_taptest_table_p0_p1000_p1200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p1000_p1300', 'Check that table partman_test.id_taptest_table_p0_p1000_p1300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p1000_p1400', 'Check that table partman_test.id_taptest_table_p0_p1000_p1400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p1000_p1500', 'Check that table partman_test.id_taptest_table_p0_p1000_p1500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p1000_p1600', 'Check that table partman_test.id_taptest_table_p0_p1000_p1600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p1000_p1700', 'Check that table partman_test.id_taptest_table_p0_p1000_p1700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p1000_p1800', 'Check that table partman_test.id_taptest_table_p0_p1000_p1800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p1000_p1900', 'Check that table partman_test.id_taptest_table_p0_p1000_p1900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p2000_p2000', 'Check that table partman_test.id_taptest_table_p0_p2000_p2000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p2000_p2100', 'Check that table partman_test.id_taptest_table_p0_p2000_p2100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p2000_p2200', 'Check that table partman_test.id_taptest_table_p0_p2000_p2200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p2000_p2300', 'Check that table partman_test.id_taptest_table_p0_p2000_p2300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p2000_p2400', 'Check that table partman_test.id_taptest_table_p0_p2000_p2400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p2000_p2500', 'Check that table partman_test.id_taptest_table_p0_p2000_p2500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p2000_p2600', 'Check that table partman_test.id_taptest_table_p0_p2000_p2600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p2000_p2700', 'Check that table partman_test.id_taptest_table_p0_p2000_p2700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p2000_p2800', 'Check that table partman_test.id_taptest_table_p0_p2000_p2800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p2000_p2900', 'Check that table partman_test.id_taptest_table_p0_p2000_p2900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p3000_p3000', 'Check that table partman_test.id_taptest_table_p0_p3000_p3000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p3000_p3100', 'Check that table partman_test.id_taptest_table_p0_p3000_p3100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p3000_p3200', 'Check that table partman_test.id_taptest_table_p0_p3000_p3200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p3000_p3300', 'Check that table partman_test.id_taptest_table_p0_p3000_p3300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p3000_p3400', 'Check that table partman_test.id_taptest_table_p0_p3000_p3400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p3000_p3500', 'Check that table partman_test.id_taptest_table_p0_p3000_p3500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p3000_p3600', 'Check that table partman_test.id_taptest_table_p0_p3000_p3600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p3000_p3700', 'Check that table partman_test.id_taptest_table_p0_p3000_p3700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p3000_p3800', 'Check that table partman_test.id_taptest_table_p0_p3000_p3800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p3000_p3900', 'Check that table partman_test.id_taptest_table_p0_p3000_p3900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p4000_p4000', 'Check that table partman_test.id_taptest_table_p0_p4000_p4000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p4000_p4100', 'Check that table partman_test.id_taptest_table_p0_p4000_p4100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p4000_p4200', 'Check that table partman_test.id_taptest_table_p0_p4000_p4200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p4000_p4300', 'Check that table partman_test.id_taptest_table_p0_p4000_p4300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p4000_p4400', 'Check that table partman_test.id_taptest_table_p0_p4000_p4400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p4000_p4500', 'Check that table partman_test.id_taptest_table_p0_p4000_p4500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p4000_p4600', 'Check that table partman_test.id_taptest_table_p0_p4000_p4600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p4000_p4700', 'Check that table partman_test.id_taptest_table_p0_p4000_p4700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p4000_p4800', 'Check that table partman_test.id_taptest_table_p0_p4000_p4800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p4000_p4900', 'Check that table partman_test.id_taptest_table_p0_p4000_p4900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p5000_p5000', 'Check that table partman_test.id_taptest_table_p0_p5000_p5000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p5000_p5100', 'Check that table partman_test.id_taptest_table_p0_p5000_p5100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p5000_p5200', 'Check that table partman_test.id_taptest_table_p0_p5000_p5200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p5000_p5300', 'Check that table partman_test.id_taptest_table_p0_p5000_p5300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p5000_p5400', 'Check that table partman_test.id_taptest_table_p0_p5000_p5400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p5000_p5500', 'Check that table partman_test.id_taptest_table_p0_p5000_p5500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p5000_p5600', 'Check that table partman_test.id_taptest_table_p0_p5000_p5600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p5000_p5700', 'Check that table partman_test.id_taptest_table_p0_p5000_p5700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p5000_p5800', 'Check that table partman_test.id_taptest_table_p0_p5000_p5800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p5000_p5900', 'Check that table partman_test.id_taptest_table_p0_p5000_p5900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p6000_p6000', 'Check that table partman_test.id_taptest_table_p0_p6000_p6000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p6000_p6100', 'Check that table partman_test.id_taptest_table_p0_p6000_p6100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p6000_p6200', 'Check that table partman_test.id_taptest_table_p0_p6000_p6200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p6000_p6300', 'Check that table partman_test.id_taptest_table_p0_p6000_p6300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p6000_p6400', 'Check that table partman_test.id_taptest_table_p0_p6000_p6400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p6000_p6500', 'Check that table partman_test.id_taptest_table_p0_p6000_p6500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p6000_p6600', 'Check that table partman_test.id_taptest_table_p0_p6000_p6600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p6000_p6700', 'Check that table partman_test.id_taptest_table_p0_p6000_p6700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p6000_p6800', 'Check that table partman_test.id_taptest_table_p0_p6000_p6800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p6000_p6900', 'Check that table partman_test.id_taptest_table_p0_p6000_p6900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p7000_p7000', 'Check that table partman_test.id_taptest_table_p0_p7000_p7000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p7000_p7100', 'Check that table partman_test.id_taptest_table_p0_p7000_p7100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p7000_p7200', 'Check that table partman_test.id_taptest_table_p0_p7000_p7200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p7000_p7300', 'Check that table partman_test.id_taptest_table_p0_p7000_p7300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p7000_p7400', 'Check that table partman_test.id_taptest_table_p0_p7000_p7400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p7000_p7500', 'Check that table partman_test.id_taptest_table_p0_p7000_p7500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p7000_p7600', 'Check that table partman_test.id_taptest_table_p0_p7000_p7600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p7000_p7700', 'Check that table partman_test.id_taptest_table_p0_p7000_p7700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p7000_p7800', 'Check that table partman_test.id_taptest_table_p0_p7000_p7800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p7000_p7900', 'Check that table partman_test.id_taptest_table_p0_p7000_p7900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p8000_p8000', 'Check that table partman_test.id_taptest_table_p0_p8000_p8000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p8000_p8100', 'Check that table partman_test.id_taptest_table_p0_p8000_p8100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p8000_p8200', 'Check that table partman_test.id_taptest_table_p0_p8000_p8200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p8000_p8300', 'Check that table partman_test.id_taptest_table_p0_p8000_p8300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p8000_p8400', 'Check that table partman_test.id_taptest_table_p0_p8000_p8400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p8000_p8500', 'Check that table partman_test.id_taptest_table_p0_p8000_p8500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p8000_p8600', 'Check that table partman_test.id_taptest_table_p0_p8000_p8600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p8000_p8700', 'Check that table partman_test.id_taptest_table_p0_p8000_p8700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p8000_p8800', 'Check that table partman_test.id_taptest_table_p0_p8000_p8800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p8000_p8900', 'Check that table partman_test.id_taptest_table_p0_p8000_p8900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p9000_p9000', 'Check that table partman_test.id_taptest_table_p0_p9000_p9000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p9000_p9100', 'Check that table partman_test.id_taptest_table_p0_p9000_p9100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p9000_p9200', 'Check that table partman_test.id_taptest_table_p0_p9000_p9200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p9000_p9300', 'Check that table partman_test.id_taptest_table_p0_p9000_p9300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p9000_p9400', 'Check that table partman_test.id_taptest_table_p0_p9000_p9400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p9000_p9500', 'Check that table partman_test.id_taptest_table_p0_p9000_p9500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p9000_p9600', 'Check that table partman_test.id_taptest_table_p0_p9000_p9600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p9000_p9700', 'Check that table partman_test.id_taptest_table_p0_p9000_p9700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p9000_p9800', 'Check that table partman_test.id_taptest_table_p0_p9000_p9800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p9000_p9900', 'Check that table partman_test.id_taptest_table_p0_p9000_p9900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p100000_p100000', 'Check that table partman_test.id_taptest_table_p100000_p100000_p100000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p100000_p100100', 'Check that table partman_test.id_taptest_table_p100000_p100000_p100100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p100000_p100200', 'Check that table partman_test.id_taptest_table_p100000_p100000_p100200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p100000_p100300', 'Check that table partman_test.id_taptest_table_p100000_p100000_p100300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p100000_p100400', 'Check that table partman_test.id_taptest_table_p100000_p100000_p100400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p100000_p100500', 'Check that table partman_test.id_taptest_table_p100000_p100000_p100500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p100000_p100600', 'Check that table partman_test.id_taptest_table_p100000_p100000_p100600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p100000_p100700', 'Check that table partman_test.id_taptest_table_p100000_p100000_p100700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p100000_p100800', 'Check that table partman_test.id_taptest_table_p100000_p100000_p100800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p100000_p100900', 'Check that table partman_test.id_taptest_table_p100000_p100000_p100900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p101000_p101000', 'Check that table partman_test.id_taptest_table_p100000_p101000_p101000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p101000_p101100', 'Check that table partman_test.id_taptest_table_p100000_p101000_p101100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p101000_p101200', 'Check that table partman_test.id_taptest_table_p100000_p101000_p101200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p101000_p101300', 'Check that table partman_test.id_taptest_table_p100000_p101000_p101300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p101000_p101400', 'Check that table partman_test.id_taptest_table_p100000_p101000_p101400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p101000_p101500', 'Check that table partman_test.id_taptest_table_p100000_p101000_p101500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p101000_p101600', 'Check that table partman_test.id_taptest_table_p100000_p101000_p101600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p101000_p101700', 'Check that table partman_test.id_taptest_table_p100000_p101000_p101700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p101000_p101800', 'Check that table partman_test.id_taptest_table_p100000_p101000_p101800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p101000_p101900', 'Check that table partman_test.id_taptest_table_p100000_p101000_p101900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p102000_p102000', 'Check that table partman_test.id_taptest_table_p100000_p102000_p102000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p102000_p102100', 'Check that table partman_test.id_taptest_table_p100000_p102000_p102100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p102000_p102200', 'Check that table partman_test.id_taptest_table_p100000_p102000_p102200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p102000_p102300', 'Check that table partman_test.id_taptest_table_p100000_p102000_p102300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p102000_p102400', 'Check that table partman_test.id_taptest_table_p100000_p102000_p102400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p102000_p102500', 'Check that table partman_test.id_taptest_table_p100000_p102000_p102500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p102000_p102600', 'Check that table partman_test.id_taptest_table_p100000_p102000_p102600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p102000_p102700', 'Check that table partman_test.id_taptest_table_p100000_p102000_p102700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p102000_p102800', 'Check that table partman_test.id_taptest_table_p100000_p102000_p102800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p102000_p102900', 'Check that table partman_test.id_taptest_table_p100000_p102000_p102900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p103000_p103000', 'Check that table partman_test.id_taptest_table_p100000_p103000_p103000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p103000_p103100', 'Check that table partman_test.id_taptest_table_p100000_p103000_p103100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p103000_p103200', 'Check that table partman_test.id_taptest_table_p100000_p103000_p103200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p103000_p103300', 'Check that table partman_test.id_taptest_table_p100000_p103000_p103300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p103000_p103400', 'Check that table partman_test.id_taptest_table_p100000_p103000_p103400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p103000_p103500', 'Check that table partman_test.id_taptest_table_p100000_p103000_p103500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p103000_p103600', 'Check that table partman_test.id_taptest_table_p100000_p103000_p103600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p103000_p103700', 'Check that table partman_test.id_taptest_table_p100000_p103000_p103700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p103000_p103800', 'Check that table partman_test.id_taptest_table_p100000_p103000_p103800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p103000_p103900', 'Check that table partman_test.id_taptest_table_p100000_p103000_p103900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p104000_p104000', 'Check that table partman_test.id_taptest_table_p100000_p104000_p104000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p104000_p104100', 'Check that table partman_test.id_taptest_table_p100000_p104000_p104100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p104000_p104200', 'Check that table partman_test.id_taptest_table_p100000_p104000_p104200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p104000_p104300', 'Check that table partman_test.id_taptest_table_p100000_p104000_p104300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p104000_p104400', 'Check that table partman_test.id_taptest_table_p100000_p104000_p104400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p104000_p104500', 'Check that table partman_test.id_taptest_table_p100000_p104000_p104500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p104000_p104600', 'Check that table partman_test.id_taptest_table_p100000_p104000_p104600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p104000_p104700', 'Check that table partman_test.id_taptest_table_p100000_p104000_p104700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p104000_p104800', 'Check that table partman_test.id_taptest_table_p100000_p104000_p104800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p104000_p104900', 'Check that table partman_test.id_taptest_table_p100000_p104000_p104900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p105000_p105000', 'Check that table partman_test.id_taptest_table_p100000_p105000_p105000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p105000_p105100', 'Check that table partman_test.id_taptest_table_p100000_p105000_p105100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p105000_p105200', 'Check that table partman_test.id_taptest_table_p100000_p105000_p105200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p105000_p105300', 'Check that table partman_test.id_taptest_table_p100000_p105000_p105300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p105000_p105400', 'Check that table partman_test.id_taptest_table_p100000_p105000_p105400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p105000_p105500', 'Check that table partman_test.id_taptest_table_p100000_p105000_p105500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p105000_p105600', 'Check that table partman_test.id_taptest_table_p100000_p105000_p105600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p105000_p105700', 'Check that table partman_test.id_taptest_table_p100000_p105000_p105700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p105000_p105800', 'Check that table partman_test.id_taptest_table_p100000_p105000_p105800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p105000_p105900', 'Check that table partman_test.id_taptest_table_p100000_p105000_p105900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p106000_p106000', 'Check that table partman_test.id_taptest_table_p100000_p106000_p106000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p106000_p106100', 'Check that table partman_test.id_taptest_table_p100000_p106000_p106100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p106000_p106200', 'Check that table partman_test.id_taptest_table_p100000_p106000_p106200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p106000_p106300', 'Check that table partman_test.id_taptest_table_p100000_p106000_p106300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p106000_p106400', 'Check that table partman_test.id_taptest_table_p100000_p106000_p106400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p106000_p106500', 'Check that table partman_test.id_taptest_table_p100000_p106000_p106500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p106000_p106600', 'Check that table partman_test.id_taptest_table_p100000_p106000_p106600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p106000_p106700', 'Check that table partman_test.id_taptest_table_p100000_p106000_p106700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p106000_p106800', 'Check that table partman_test.id_taptest_table_p100000_p106000_p106800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p106000_p106900', 'Check that table partman_test.id_taptest_table_p100000_p106000_p106900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p107000_p107000', 'Check that table partman_test.id_taptest_table_p100000_p107000_p107000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p107000_p107100', 'Check that table partman_test.id_taptest_table_p100000_p107000_p107100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p107000_p107200', 'Check that table partman_test.id_taptest_table_p100000_p107000_p107200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p107000_p107300', 'Check that table partman_test.id_taptest_table_p100000_p107000_p107300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p107000_p107400', 'Check that table partman_test.id_taptest_table_p100000_p107000_p107400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p107000_p107500', 'Check that table partman_test.id_taptest_table_p100000_p107000_p107500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p107000_p107600', 'Check that table partman_test.id_taptest_table_p100000_p107000_p107600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p107000_p107700', 'Check that table partman_test.id_taptest_table_p100000_p107000_p107700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p108000_p108000', 'Check that table partman_test.id_taptest_table_p100000_p108000_p108000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p109000_p109000', 'Check that table partman_test.id_taptest_table_p100000_p109000_p109000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p10000_p10000', 'Check that table partman_test.id_taptest_table_p10000_p10000_p10000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p10000_p10100', 'Check that table partman_test.id_taptest_table_p10000_p10000_p10100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p10000_p10200', 'Check that table partman_test.id_taptest_table_p10000_p10000_p10200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p10000_p10300', 'Check that table partman_test.id_taptest_table_p10000_p10000_p10300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p10000_p10400', 'Check that table partman_test.id_taptest_table_p10000_p10000_p10400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p10000_p10500', 'Check that table partman_test.id_taptest_table_p10000_p10000_p10500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p10000_p10600', 'Check that table partman_test.id_taptest_table_p10000_p10000_p10600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p10000_p10700', 'Check that table partman_test.id_taptest_table_p10000_p10000_p10700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p10000_p10800', 'Check that table partman_test.id_taptest_table_p10000_p10000_p10800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p10000_p10900', 'Check that table partman_test.id_taptest_table_p10000_p10000_p10900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p11000_p11000', 'Check that table partman_test.id_taptest_table_p10000_p11000_p11000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p11000_p11100', 'Check that table partman_test.id_taptest_table_p10000_p11000_p11100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p11000_p11200', 'Check that table partman_test.id_taptest_table_p10000_p11000_p11200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p11000_p11300', 'Check that table partman_test.id_taptest_table_p10000_p11000_p11300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p11000_p11400', 'Check that table partman_test.id_taptest_table_p10000_p11000_p11400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p11000_p11500', 'Check that table partman_test.id_taptest_table_p10000_p11000_p11500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p11000_p11600', 'Check that table partman_test.id_taptest_table_p10000_p11000_p11600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p11000_p11700', 'Check that table partman_test.id_taptest_table_p10000_p11000_p11700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p11000_p11800', 'Check that table partman_test.id_taptest_table_p10000_p11000_p11800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p11000_p11900', 'Check that table partman_test.id_taptest_table_p10000_p11000_p11900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p12000_p12000', 'Check that table partman_test.id_taptest_table_p10000_p12000_p12000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p12000_p12100', 'Check that table partman_test.id_taptest_table_p10000_p12000_p12100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p12000_p12200', 'Check that table partman_test.id_taptest_table_p10000_p12000_p12200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p12000_p12300', 'Check that table partman_test.id_taptest_table_p10000_p12000_p12300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p12000_p12400', 'Check that table partman_test.id_taptest_table_p10000_p12000_p12400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p12000_p12500', 'Check that table partman_test.id_taptest_table_p10000_p12000_p12500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p12000_p12600', 'Check that table partman_test.id_taptest_table_p10000_p12000_p12600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p12000_p12700', 'Check that table partman_test.id_taptest_table_p10000_p12000_p12700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p12000_p12800', 'Check that table partman_test.id_taptest_table_p10000_p12000_p12800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p12000_p12900', 'Check that table partman_test.id_taptest_table_p10000_p12000_p12900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p13000_p13000', 'Check that table partman_test.id_taptest_table_p10000_p13000_p13000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p13000_p13100', 'Check that table partman_test.id_taptest_table_p10000_p13000_p13100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p13000_p13200', 'Check that table partman_test.id_taptest_table_p10000_p13000_p13200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p13000_p13300', 'Check that table partman_test.id_taptest_table_p10000_p13000_p13300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p13000_p13400', 'Check that table partman_test.id_taptest_table_p10000_p13000_p13400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p13000_p13500', 'Check that table partman_test.id_taptest_table_p10000_p13000_p13500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p13000_p13600', 'Check that table partman_test.id_taptest_table_p10000_p13000_p13600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p13000_p13700', 'Check that table partman_test.id_taptest_table_p10000_p13000_p13700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p13000_p13800', 'Check that table partman_test.id_taptest_table_p10000_p13000_p13800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p13000_p13900', 'Check that table partman_test.id_taptest_table_p10000_p13000_p13900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p14000_p14000', 'Check that table partman_test.id_taptest_table_p10000_p14000_p14000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p14000_p14100', 'Check that table partman_test.id_taptest_table_p10000_p14000_p14100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p14000_p14200', 'Check that table partman_test.id_taptest_table_p10000_p14000_p14200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p14000_p14300', 'Check that table partman_test.id_taptest_table_p10000_p14000_p14300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p14000_p14400', 'Check that table partman_test.id_taptest_table_p10000_p14000_p14400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p14000_p14500', 'Check that table partman_test.id_taptest_table_p10000_p14000_p14500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p14000_p14600', 'Check that table partman_test.id_taptest_table_p10000_p14000_p14600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p14000_p14700', 'Check that table partman_test.id_taptest_table_p10000_p14000_p14700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p14000_p14800', 'Check that table partman_test.id_taptest_table_p10000_p14000_p14800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p14000_p14900', 'Check that table partman_test.id_taptest_table_p10000_p14000_p14900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p15000_p15000', 'Check that table partman_test.id_taptest_table_p10000_p15000_p15000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p15000_p15100', 'Check that table partman_test.id_taptest_table_p10000_p15000_p15100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p15000_p15200', 'Check that table partman_test.id_taptest_table_p10000_p15000_p15200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p15000_p15300', 'Check that table partman_test.id_taptest_table_p10000_p15000_p15300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p15000_p15400', 'Check that table partman_test.id_taptest_table_p10000_p15000_p15400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p15000_p15500', 'Check that table partman_test.id_taptest_table_p10000_p15000_p15500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p15000_p15600', 'Check that table partman_test.id_taptest_table_p10000_p15000_p15600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p15000_p15700', 'Check that table partman_test.id_taptest_table_p10000_p15000_p15700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p15000_p15800', 'Check that table partman_test.id_taptest_table_p10000_p15000_p15800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p15000_p15900', 'Check that table partman_test.id_taptest_table_p10000_p15000_p15900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p16000_p16000', 'Check that table partman_test.id_taptest_table_p10000_p16000_p16000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p16000_p16100', 'Check that table partman_test.id_taptest_table_p10000_p16000_p16100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p16000_p16200', 'Check that table partman_test.id_taptest_table_p10000_p16000_p16200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p16000_p16300', 'Check that table partman_test.id_taptest_table_p10000_p16000_p16300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p16000_p16400', 'Check that table partman_test.id_taptest_table_p10000_p16000_p16400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p16000_p16500', 'Check that table partman_test.id_taptest_table_p10000_p16000_p16500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p16000_p16600', 'Check that table partman_test.id_taptest_table_p10000_p16000_p16600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p16000_p16700', 'Check that table partman_test.id_taptest_table_p10000_p16000_p16700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p16000_p16800', 'Check that table partman_test.id_taptest_table_p10000_p16000_p16800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p16000_p16900', 'Check that table partman_test.id_taptest_table_p10000_p16000_p16900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p17000_p17000', 'Check that table partman_test.id_taptest_table_p10000_p17000_p17000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p17000_p17100', 'Check that table partman_test.id_taptest_table_p10000_p17000_p17100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p17000_p17200', 'Check that table partman_test.id_taptest_table_p10000_p17000_p17200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p17000_p17300', 'Check that table partman_test.id_taptest_table_p10000_p17000_p17300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p17000_p17400', 'Check that table partman_test.id_taptest_table_p10000_p17000_p17400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p17000_p17500', 'Check that table partman_test.id_taptest_table_p10000_p17000_p17500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p17000_p17600', 'Check that table partman_test.id_taptest_table_p10000_p17000_p17600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p17000_p17700', 'Check that table partman_test.id_taptest_table_p10000_p17000_p17700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p17000_p17800', 'Check that table partman_test.id_taptest_table_p10000_p17000_p17800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p17000_p17900', 'Check that table partman_test.id_taptest_table_p10000_p17000_p17900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p18000_p18000', 'Check that table partman_test.id_taptest_table_p10000_p18000_p18000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p18000_p18100', 'Check that table partman_test.id_taptest_table_p10000_p18000_p18100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p18000_p18200', 'Check that table partman_test.id_taptest_table_p10000_p18000_p18200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p18000_p18300', 'Check that table partman_test.id_taptest_table_p10000_p18000_p18300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p18000_p18400', 'Check that table partman_test.id_taptest_table_p10000_p18000_p18400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p18000_p18500', 'Check that table partman_test.id_taptest_table_p10000_p18000_p18500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p18000_p18600', 'Check that table partman_test.id_taptest_table_p10000_p18000_p18600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p18000_p18700', 'Check that table partman_test.id_taptest_table_p10000_p18000_p18700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p18000_p18800', 'Check that table partman_test.id_taptest_table_p10000_p18000_p18800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p18000_p18900', 'Check that table partman_test.id_taptest_table_p10000_p18000_p18900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p19000_p19000', 'Check that table partman_test.id_taptest_table_p10000_p19000_p19000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p19000_p19100', 'Check that table partman_test.id_taptest_table_p10000_p19000_p19100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p19000_p19200', 'Check that table partman_test.id_taptest_table_p10000_p19000_p19200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p19000_p19300', 'Check that table partman_test.id_taptest_table_p10000_p19000_p19300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p19000_p19400', 'Check that table partman_test.id_taptest_table_p10000_p19000_p19400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p19000_p19500', 'Check that table partman_test.id_taptest_table_p10000_p19000_p19500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p19000_p19600', 'Check that table partman_test.id_taptest_table_p10000_p19000_p19600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p19000_p19700', 'Check that table partman_test.id_taptest_table_p10000_p19000_p19700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p19000_p19800', 'Check that table partman_test.id_taptest_table_p10000_p19000_p19800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p19000_p19900', 'Check that table partman_test.id_taptest_table_p10000_p19000_p19900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p110000_p110000_p110000', 'Check that table partman_test.id_taptest_table_p110000_p110000_p110000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p120000_p120000_p120000', 'Check that table partman_test.id_taptest_table_p120000_p120000_p120000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p130000_p130000_p130000', 'Check that table partman_test.id_taptest_table_p130000_p130000_p130000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p140000_p140000_p140000', 'Check that table partman_test.id_taptest_table_p140000_p140000_p140000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p150000_p150000_p150000', 'Check that table partman_test.id_taptest_table_p150000_p150000_p150000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p160000_p160000_p160000', 'Check that table partman_test.id_taptest_table_p160000_p160000_p160000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p170000_p170000_p170000', 'Check that table partman_test.id_taptest_table_p170000_p170000_p170000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p180000_p180000_p180000', 'Check that table partman_test.id_taptest_table_p180000_p180000_p180000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p190000_p190000_p190000', 'Check that table partman_test.id_taptest_table_p190000_p190000_p190000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p200000_p200000_p200000', 'Check that table partman_test.id_taptest_table_p200000_p200000_p200000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p20000_p20000', 'Check that table partman_test.id_taptest_table_p20000_p20000_p20000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p20000_p20100', 'Check that table partman_test.id_taptest_table_p20000_p20000_p20100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p20000_p20200', 'Check that table partman_test.id_taptest_table_p20000_p20000_p20200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p20000_p20300', 'Check that table partman_test.id_taptest_table_p20000_p20000_p20300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p20000_p20400', 'Check that table partman_test.id_taptest_table_p20000_p20000_p20400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p20000_p20500', 'Check that table partman_test.id_taptest_table_p20000_p20000_p20500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p20000_p20600', 'Check that table partman_test.id_taptest_table_p20000_p20000_p20600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p20000_p20700', 'Check that table partman_test.id_taptest_table_p20000_p20000_p20700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p20000_p20800', 'Check that table partman_test.id_taptest_table_p20000_p20000_p20800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p20000_p20900', 'Check that table partman_test.id_taptest_table_p20000_p20000_p20900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p21000_p21000', 'Check that table partman_test.id_taptest_table_p20000_p21000_p21000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p21000_p21100', 'Check that table partman_test.id_taptest_table_p20000_p21000_p21100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p21000_p21200', 'Check that table partman_test.id_taptest_table_p20000_p21000_p21200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p21000_p21300', 'Check that table partman_test.id_taptest_table_p20000_p21000_p21300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p21000_p21400', 'Check that table partman_test.id_taptest_table_p20000_p21000_p21400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p21000_p21500', 'Check that table partman_test.id_taptest_table_p20000_p21000_p21500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p21000_p21600', 'Check that table partman_test.id_taptest_table_p20000_p21000_p21600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p21000_p21700', 'Check that table partman_test.id_taptest_table_p20000_p21000_p21700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p21000_p21800', 'Check that table partman_test.id_taptest_table_p20000_p21000_p21800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p21000_p21900', 'Check that table partman_test.id_taptest_table_p20000_p21000_p21900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p22000_p22000', 'Check that table partman_test.id_taptest_table_p20000_p22000_p22000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p22000_p22100', 'Check that table partman_test.id_taptest_table_p20000_p22000_p22100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p22000_p22200', 'Check that table partman_test.id_taptest_table_p20000_p22000_p22200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p22000_p22300', 'Check that table partman_test.id_taptest_table_p20000_p22000_p22300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p22000_p22400', 'Check that table partman_test.id_taptest_table_p20000_p22000_p22400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p22000_p22500', 'Check that table partman_test.id_taptest_table_p20000_p22000_p22500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p22000_p22600', 'Check that table partman_test.id_taptest_table_p20000_p22000_p22600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p22000_p22700', 'Check that table partman_test.id_taptest_table_p20000_p22000_p22700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p22000_p22800', 'Check that table partman_test.id_taptest_table_p20000_p22000_p22800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p22000_p22900', 'Check that table partman_test.id_taptest_table_p20000_p22000_p22900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p23000_p23000', 'Check that table partman_test.id_taptest_table_p20000_p23000_p23000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p23000_p23100', 'Check that table partman_test.id_taptest_table_p20000_p23000_p23100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p23000_p23200', 'Check that table partman_test.id_taptest_table_p20000_p23000_p23200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p23000_p23300', 'Check that table partman_test.id_taptest_table_p20000_p23000_p23300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p23000_p23400', 'Check that table partman_test.id_taptest_table_p20000_p23000_p23400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p23000_p23500', 'Check that table partman_test.id_taptest_table_p20000_p23000_p23500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p23000_p23600', 'Check that table partman_test.id_taptest_table_p20000_p23000_p23600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p23000_p23700', 'Check that table partman_test.id_taptest_table_p20000_p23000_p23700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p23000_p23800', 'Check that table partman_test.id_taptest_table_p20000_p23000_p23800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p23000_p23900', 'Check that table partman_test.id_taptest_table_p20000_p23000_p23900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p24000_p24000', 'Check that table partman_test.id_taptest_table_p20000_p24000_p24000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p24000_p24100', 'Check that table partman_test.id_taptest_table_p20000_p24000_p24100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p24000_p24200', 'Check that table partman_test.id_taptest_table_p20000_p24000_p24200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p24000_p24300', 'Check that table partman_test.id_taptest_table_p20000_p24000_p24300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p24000_p24400', 'Check that table partman_test.id_taptest_table_p20000_p24000_p24400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p24000_p24500', 'Check that table partman_test.id_taptest_table_p20000_p24000_p24500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p24000_p24600', 'Check that table partman_test.id_taptest_table_p20000_p24000_p24600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p24000_p24700', 'Check that table partman_test.id_taptest_table_p20000_p24000_p24700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p24000_p24800', 'Check that table partman_test.id_taptest_table_p20000_p24000_p24800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p24000_p24900', 'Check that table partman_test.id_taptest_table_p20000_p24000_p24900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p25000_p25000', 'Check that table partman_test.id_taptest_table_p20000_p25000_p25000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p25000_p25100', 'Check that table partman_test.id_taptest_table_p20000_p25000_p25100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p25000_p25200', 'Check that table partman_test.id_taptest_table_p20000_p25000_p25200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p25000_p25300', 'Check that table partman_test.id_taptest_table_p20000_p25000_p25300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p25000_p25400', 'Check that table partman_test.id_taptest_table_p20000_p25000_p25400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p25000_p25500', 'Check that table partman_test.id_taptest_table_p20000_p25000_p25500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p25000_p25600', 'Check that table partman_test.id_taptest_table_p20000_p25000_p25600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p25000_p25700', 'Check that table partman_test.id_taptest_table_p20000_p25000_p25700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p25000_p25800', 'Check that table partman_test.id_taptest_table_p20000_p25000_p25800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p25000_p25900', 'Check that table partman_test.id_taptest_table_p20000_p25000_p25900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p26000_p26000', 'Check that table partman_test.id_taptest_table_p20000_p26000_p26000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p26000_p26100', 'Check that table partman_test.id_taptest_table_p20000_p26000_p26100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p26000_p26200', 'Check that table partman_test.id_taptest_table_p20000_p26000_p26200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p26000_p26300', 'Check that table partman_test.id_taptest_table_p20000_p26000_p26300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p26000_p26400', 'Check that table partman_test.id_taptest_table_p20000_p26000_p26400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p26000_p26500', 'Check that table partman_test.id_taptest_table_p20000_p26000_p26500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p26000_p26600', 'Check that table partman_test.id_taptest_table_p20000_p26000_p26600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p26000_p26700', 'Check that table partman_test.id_taptest_table_p20000_p26000_p26700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p26000_p26800', 'Check that table partman_test.id_taptest_table_p20000_p26000_p26800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p26000_p26900', 'Check that table partman_test.id_taptest_table_p20000_p26000_p26900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p27000_p27000', 'Check that table partman_test.id_taptest_table_p20000_p27000_p27000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p27000_p27100', 'Check that table partman_test.id_taptest_table_p20000_p27000_p27100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p27000_p27200', 'Check that table partman_test.id_taptest_table_p20000_p27000_p27200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p27000_p27300', 'Check that table partman_test.id_taptest_table_p20000_p27000_p27300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p27000_p27400', 'Check that table partman_test.id_taptest_table_p20000_p27000_p27400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p27000_p27500', 'Check that table partman_test.id_taptest_table_p20000_p27000_p27500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p27000_p27600', 'Check that table partman_test.id_taptest_table_p20000_p27000_p27600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p27000_p27700', 'Check that table partman_test.id_taptest_table_p20000_p27000_p27700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p27000_p27800', 'Check that table partman_test.id_taptest_table_p20000_p27000_p27800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p27000_p27900', 'Check that table partman_test.id_taptest_table_p20000_p27000_p27900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p28000_p28000', 'Check that table partman_test.id_taptest_table_p20000_p28000_p28000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p28000_p28100', 'Check that table partman_test.id_taptest_table_p20000_p28000_p28100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p28000_p28200', 'Check that table partman_test.id_taptest_table_p20000_p28000_p28200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p28000_p28300', 'Check that table partman_test.id_taptest_table_p20000_p28000_p28300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p28000_p28400', 'Check that table partman_test.id_taptest_table_p20000_p28000_p28400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p28000_p28500', 'Check that table partman_test.id_taptest_table_p20000_p28000_p28500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p28000_p28600', 'Check that table partman_test.id_taptest_table_p20000_p28000_p28600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p28000_p28700', 'Check that table partman_test.id_taptest_table_p20000_p28000_p28700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p28000_p28800', 'Check that table partman_test.id_taptest_table_p20000_p28000_p28800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p28000_p28900', 'Check that table partman_test.id_taptest_table_p20000_p28000_p28900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p29000_p29000', 'Check that table partman_test.id_taptest_table_p20000_p29000_p29000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p29000_p29100', 'Check that table partman_test.id_taptest_table_p20000_p29000_p29100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p29000_p29200', 'Check that table partman_test.id_taptest_table_p20000_p29000_p29200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p29000_p29300', 'Check that table partman_test.id_taptest_table_p20000_p29000_p29300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p29000_p29400', 'Check that table partman_test.id_taptest_table_p20000_p29000_p29400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p29000_p29500', 'Check that table partman_test.id_taptest_table_p20000_p29000_p29500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p29000_p29600', 'Check that table partman_test.id_taptest_table_p20000_p29000_p29600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p29000_p29700', 'Check that table partman_test.id_taptest_table_p20000_p29000_p29700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p29000_p29800', 'Check that table partman_test.id_taptest_table_p20000_p29000_p29800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p29000_p29900', 'Check that table partman_test.id_taptest_table_p20000_p29000_p29900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p210000_p210000_p210000', 'Check that table partman_test.id_taptest_table_p210000_p210000_p210000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p30000_p30000', 'Check that table partman_test.id_taptest_table_p30000_p30000_p30000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p30000_p30100', 'Check that table partman_test.id_taptest_table_p30000_p30000_p30100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p30000_p30200', 'Check that table partman_test.id_taptest_table_p30000_p30000_p30200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p30000_p30300', 'Check that table partman_test.id_taptest_table_p30000_p30000_p30300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p30000_p30400', 'Check that table partman_test.id_taptest_table_p30000_p30000_p30400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p30000_p30500', 'Check that table partman_test.id_taptest_table_p30000_p30000_p30500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p30000_p30600', 'Check that table partman_test.id_taptest_table_p30000_p30000_p30600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p30000_p30700', 'Check that table partman_test.id_taptest_table_p30000_p30000_p30700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p30000_p30800', 'Check that table partman_test.id_taptest_table_p30000_p30000_p30800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p30000_p30900', 'Check that table partman_test.id_taptest_table_p30000_p30000_p30900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p31000_p31000', 'Check that table partman_test.id_taptest_table_p30000_p31000_p31000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p31000_p31100', 'Check that table partman_test.id_taptest_table_p30000_p31000_p31100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p31000_p31200', 'Check that table partman_test.id_taptest_table_p30000_p31000_p31200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p31000_p31300', 'Check that table partman_test.id_taptest_table_p30000_p31000_p31300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p31000_p31400', 'Check that table partman_test.id_taptest_table_p30000_p31000_p31400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p31000_p31500', 'Check that table partman_test.id_taptest_table_p30000_p31000_p31500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p31000_p31600', 'Check that table partman_test.id_taptest_table_p30000_p31000_p31600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p31000_p31700', 'Check that table partman_test.id_taptest_table_p30000_p31000_p31700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p31000_p31800', 'Check that table partman_test.id_taptest_table_p30000_p31000_p31800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p31000_p31900', 'Check that table partman_test.id_taptest_table_p30000_p31000_p31900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p32000_p32000', 'Check that table partman_test.id_taptest_table_p30000_p32000_p32000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p32000_p32100', 'Check that table partman_test.id_taptest_table_p30000_p32000_p32100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p32000_p32200', 'Check that table partman_test.id_taptest_table_p30000_p32000_p32200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p32000_p32300', 'Check that table partman_test.id_taptest_table_p30000_p32000_p32300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p32000_p32400', 'Check that table partman_test.id_taptest_table_p30000_p32000_p32400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p32000_p32500', 'Check that table partman_test.id_taptest_table_p30000_p32000_p32500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p32000_p32600', 'Check that table partman_test.id_taptest_table_p30000_p32000_p32600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p32000_p32700', 'Check that table partman_test.id_taptest_table_p30000_p32000_p32700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p32000_p32800', 'Check that table partman_test.id_taptest_table_p30000_p32000_p32800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p32000_p32900', 'Check that table partman_test.id_taptest_table_p30000_p32000_p32900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p33000_p33000', 'Check that table partman_test.id_taptest_table_p30000_p33000_p33000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p33000_p33100', 'Check that table partman_test.id_taptest_table_p30000_p33000_p33100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p33000_p33200', 'Check that table partman_test.id_taptest_table_p30000_p33000_p33200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p33000_p33300', 'Check that table partman_test.id_taptest_table_p30000_p33000_p33300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p33000_p33400', 'Check that table partman_test.id_taptest_table_p30000_p33000_p33400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p33000_p33500', 'Check that table partman_test.id_taptest_table_p30000_p33000_p33500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p33000_p33600', 'Check that table partman_test.id_taptest_table_p30000_p33000_p33600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p33000_p33700', 'Check that table partman_test.id_taptest_table_p30000_p33000_p33700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p33000_p33800', 'Check that table partman_test.id_taptest_table_p30000_p33000_p33800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p33000_p33900', 'Check that table partman_test.id_taptest_table_p30000_p33000_p33900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p34000_p34000', 'Check that table partman_test.id_taptest_table_p30000_p34000_p34000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p34000_p34100', 'Check that table partman_test.id_taptest_table_p30000_p34000_p34100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p34000_p34200', 'Check that table partman_test.id_taptest_table_p30000_p34000_p34200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p34000_p34300', 'Check that table partman_test.id_taptest_table_p30000_p34000_p34300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p34000_p34400', 'Check that table partman_test.id_taptest_table_p30000_p34000_p34400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p34000_p34500', 'Check that table partman_test.id_taptest_table_p30000_p34000_p34500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p34000_p34600', 'Check that table partman_test.id_taptest_table_p30000_p34000_p34600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p34000_p34700', 'Check that table partman_test.id_taptest_table_p30000_p34000_p34700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p34000_p34800', 'Check that table partman_test.id_taptest_table_p30000_p34000_p34800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p34000_p34900', 'Check that table partman_test.id_taptest_table_p30000_p34000_p34900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p35000_p35000', 'Check that table partman_test.id_taptest_table_p30000_p35000_p35000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p35000_p35100', 'Check that table partman_test.id_taptest_table_p30000_p35000_p35100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p35000_p35200', 'Check that table partman_test.id_taptest_table_p30000_p35000_p35200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p35000_p35300', 'Check that table partman_test.id_taptest_table_p30000_p35000_p35300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p35000_p35400', 'Check that table partman_test.id_taptest_table_p30000_p35000_p35400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p35000_p35500', 'Check that table partman_test.id_taptest_table_p30000_p35000_p35500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p35000_p35600', 'Check that table partman_test.id_taptest_table_p30000_p35000_p35600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p35000_p35700', 'Check that table partman_test.id_taptest_table_p30000_p35000_p35700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p35000_p35800', 'Check that table partman_test.id_taptest_table_p30000_p35000_p35800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p35000_p35900', 'Check that table partman_test.id_taptest_table_p30000_p35000_p35900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p36000_p36000', 'Check that table partman_test.id_taptest_table_p30000_p36000_p36000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p36000_p36100', 'Check that table partman_test.id_taptest_table_p30000_p36000_p36100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p36000_p36200', 'Check that table partman_test.id_taptest_table_p30000_p36000_p36200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p36000_p36300', 'Check that table partman_test.id_taptest_table_p30000_p36000_p36300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p36000_p36400', 'Check that table partman_test.id_taptest_table_p30000_p36000_p36400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p36000_p36500', 'Check that table partman_test.id_taptest_table_p30000_p36000_p36500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p36000_p36600', 'Check that table partman_test.id_taptest_table_p30000_p36000_p36600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p36000_p36700', 'Check that table partman_test.id_taptest_table_p30000_p36000_p36700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p36000_p36800', 'Check that table partman_test.id_taptest_table_p30000_p36000_p36800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p36000_p36900', 'Check that table partman_test.id_taptest_table_p30000_p36000_p36900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p37000_p37000', 'Check that table partman_test.id_taptest_table_p30000_p37000_p37000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p37000_p37100', 'Check that table partman_test.id_taptest_table_p30000_p37000_p37100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p37000_p37200', 'Check that table partman_test.id_taptest_table_p30000_p37000_p37200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p37000_p37300', 'Check that table partman_test.id_taptest_table_p30000_p37000_p37300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p37000_p37400', 'Check that table partman_test.id_taptest_table_p30000_p37000_p37400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p37000_p37500', 'Check that table partman_test.id_taptest_table_p30000_p37000_p37500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p37000_p37600', 'Check that table partman_test.id_taptest_table_p30000_p37000_p37600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p37000_p37700', 'Check that table partman_test.id_taptest_table_p30000_p37000_p37700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p37000_p37800', 'Check that table partman_test.id_taptest_table_p30000_p37000_p37800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p37000_p37900', 'Check that table partman_test.id_taptest_table_p30000_p37000_p37900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p38000_p38000', 'Check that table partman_test.id_taptest_table_p30000_p38000_p38000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p38000_p38100', 'Check that table partman_test.id_taptest_table_p30000_p38000_p38100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p38000_p38200', 'Check that table partman_test.id_taptest_table_p30000_p38000_p38200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p38000_p38300', 'Check that table partman_test.id_taptest_table_p30000_p38000_p38300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p38000_p38400', 'Check that table partman_test.id_taptest_table_p30000_p38000_p38400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p38000_p38500', 'Check that table partman_test.id_taptest_table_p30000_p38000_p38500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p38000_p38600', 'Check that table partman_test.id_taptest_table_p30000_p38000_p38600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p38000_p38700', 'Check that table partman_test.id_taptest_table_p30000_p38000_p38700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p38000_p38800', 'Check that table partman_test.id_taptest_table_p30000_p38000_p38800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p38000_p38900', 'Check that table partman_test.id_taptest_table_p30000_p38000_p38900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p39000_p39000', 'Check that table partman_test.id_taptest_table_p30000_p39000_p39000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p39000_p39100', 'Check that table partman_test.id_taptest_table_p30000_p39000_p39100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p39000_p39200', 'Check that table partman_test.id_taptest_table_p30000_p39000_p39200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p39000_p39300', 'Check that table partman_test.id_taptest_table_p30000_p39000_p39300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p39000_p39400', 'Check that table partman_test.id_taptest_table_p30000_p39000_p39400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p39000_p39500', 'Check that table partman_test.id_taptest_table_p30000_p39000_p39500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p39000_p39600', 'Check that table partman_test.id_taptest_table_p30000_p39000_p39600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p39000_p39700', 'Check that table partman_test.id_taptest_table_p30000_p39000_p39700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p39000_p39800', 'Check that table partman_test.id_taptest_table_p30000_p39000_p39800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p39000_p39900', 'Check that table partman_test.id_taptest_table_p30000_p39000_p39900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p40000_p40000', 'Check that table partman_test.id_taptest_table_p40000_p40000_p40000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p40000_p40100', 'Check that table partman_test.id_taptest_table_p40000_p40000_p40100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p40000_p40200', 'Check that table partman_test.id_taptest_table_p40000_p40000_p40200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p40000_p40300', 'Check that table partman_test.id_taptest_table_p40000_p40000_p40300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p40000_p40400', 'Check that table partman_test.id_taptest_table_p40000_p40000_p40400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p40000_p40500', 'Check that table partman_test.id_taptest_table_p40000_p40000_p40500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p40000_p40600', 'Check that table partman_test.id_taptest_table_p40000_p40000_p40600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p40000_p40700', 'Check that table partman_test.id_taptest_table_p40000_p40000_p40700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p40000_p40800', 'Check that table partman_test.id_taptest_table_p40000_p40000_p40800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p40000_p40900', 'Check that table partman_test.id_taptest_table_p40000_p40000_p40900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p41000_p41000', 'Check that table partman_test.id_taptest_table_p40000_p41000_p41000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p41000_p41100', 'Check that table partman_test.id_taptest_table_p40000_p41000_p41100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p41000_p41200', 'Check that table partman_test.id_taptest_table_p40000_p41000_p41200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p41000_p41300', 'Check that table partman_test.id_taptest_table_p40000_p41000_p41300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p41000_p41400', 'Check that table partman_test.id_taptest_table_p40000_p41000_p41400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p41000_p41500', 'Check that table partman_test.id_taptest_table_p40000_p41000_p41500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p41000_p41600', 'Check that table partman_test.id_taptest_table_p40000_p41000_p41600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p41000_p41700', 'Check that table partman_test.id_taptest_table_p40000_p41000_p41700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p41000_p41800', 'Check that table partman_test.id_taptest_table_p40000_p41000_p41800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p41000_p41900', 'Check that table partman_test.id_taptest_table_p40000_p41000_p41900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p42000_p42000', 'Check that table partman_test.id_taptest_table_p40000_p42000_p42000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p42000_p42100', 'Check that table partman_test.id_taptest_table_p40000_p42000_p42100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p42000_p42200', 'Check that table partman_test.id_taptest_table_p40000_p42000_p42200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p42000_p42300', 'Check that table partman_test.id_taptest_table_p40000_p42000_p42300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p42000_p42400', 'Check that table partman_test.id_taptest_table_p40000_p42000_p42400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p42000_p42500', 'Check that table partman_test.id_taptest_table_p40000_p42000_p42500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p42000_p42600', 'Check that table partman_test.id_taptest_table_p40000_p42000_p42600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p42000_p42700', 'Check that table partman_test.id_taptest_table_p40000_p42000_p42700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p42000_p42800', 'Check that table partman_test.id_taptest_table_p40000_p42000_p42800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p42000_p42900', 'Check that table partman_test.id_taptest_table_p40000_p42000_p42900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p43000_p43000', 'Check that table partman_test.id_taptest_table_p40000_p43000_p43000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p43000_p43100', 'Check that table partman_test.id_taptest_table_p40000_p43000_p43100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p43000_p43200', 'Check that table partman_test.id_taptest_table_p40000_p43000_p43200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p43000_p43300', 'Check that table partman_test.id_taptest_table_p40000_p43000_p43300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p43000_p43400', 'Check that table partman_test.id_taptest_table_p40000_p43000_p43400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p43000_p43500', 'Check that table partman_test.id_taptest_table_p40000_p43000_p43500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p43000_p43600', 'Check that table partman_test.id_taptest_table_p40000_p43000_p43600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p43000_p43700', 'Check that table partman_test.id_taptest_table_p40000_p43000_p43700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p43000_p43800', 'Check that table partman_test.id_taptest_table_p40000_p43000_p43800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p43000_p43900', 'Check that table partman_test.id_taptest_table_p40000_p43000_p43900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p44000_p44000', 'Check that table partman_test.id_taptest_table_p40000_p44000_p44000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p44000_p44100', 'Check that table partman_test.id_taptest_table_p40000_p44000_p44100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p44000_p44200', 'Check that table partman_test.id_taptest_table_p40000_p44000_p44200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p44000_p44300', 'Check that table partman_test.id_taptest_table_p40000_p44000_p44300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p44000_p44400', 'Check that table partman_test.id_taptest_table_p40000_p44000_p44400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p44000_p44500', 'Check that table partman_test.id_taptest_table_p40000_p44000_p44500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p44000_p44600', 'Check that table partman_test.id_taptest_table_p40000_p44000_p44600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p44000_p44700', 'Check that table partman_test.id_taptest_table_p40000_p44000_p44700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p44000_p44800', 'Check that table partman_test.id_taptest_table_p40000_p44000_p44800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p44000_p44900', 'Check that table partman_test.id_taptest_table_p40000_p44000_p44900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p45000_p45000', 'Check that table partman_test.id_taptest_table_p40000_p45000_p45000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p45000_p45100', 'Check that table partman_test.id_taptest_table_p40000_p45000_p45100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p45000_p45200', 'Check that table partman_test.id_taptest_table_p40000_p45000_p45200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p45000_p45300', 'Check that table partman_test.id_taptest_table_p40000_p45000_p45300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p45000_p45400', 'Check that table partman_test.id_taptest_table_p40000_p45000_p45400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p45000_p45500', 'Check that table partman_test.id_taptest_table_p40000_p45000_p45500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p45000_p45600', 'Check that table partman_test.id_taptest_table_p40000_p45000_p45600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p45000_p45700', 'Check that table partman_test.id_taptest_table_p40000_p45000_p45700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p45000_p45800', 'Check that table partman_test.id_taptest_table_p40000_p45000_p45800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p45000_p45900', 'Check that table partman_test.id_taptest_table_p40000_p45000_p45900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p46000_p46000', 'Check that table partman_test.id_taptest_table_p40000_p46000_p46000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p46000_p46100', 'Check that table partman_test.id_taptest_table_p40000_p46000_p46100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p46000_p46200', 'Check that table partman_test.id_taptest_table_p40000_p46000_p46200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p46000_p46300', 'Check that table partman_test.id_taptest_table_p40000_p46000_p46300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p46000_p46400', 'Check that table partman_test.id_taptest_table_p40000_p46000_p46400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p46000_p46500', 'Check that table partman_test.id_taptest_table_p40000_p46000_p46500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p46000_p46600', 'Check that table partman_test.id_taptest_table_p40000_p46000_p46600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p46000_p46700', 'Check that table partman_test.id_taptest_table_p40000_p46000_p46700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p46000_p46800', 'Check that table partman_test.id_taptest_table_p40000_p46000_p46800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p46000_p46900', 'Check that table partman_test.id_taptest_table_p40000_p46000_p46900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p47000_p47000', 'Check that table partman_test.id_taptest_table_p40000_p47000_p47000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p47000_p47100', 'Check that table partman_test.id_taptest_table_p40000_p47000_p47100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p47000_p47200', 'Check that table partman_test.id_taptest_table_p40000_p47000_p47200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p47000_p47300', 'Check that table partman_test.id_taptest_table_p40000_p47000_p47300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p47000_p47400', 'Check that table partman_test.id_taptest_table_p40000_p47000_p47400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p47000_p47500', 'Check that table partman_test.id_taptest_table_p40000_p47000_p47500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p47000_p47600', 'Check that table partman_test.id_taptest_table_p40000_p47000_p47600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p47000_p47700', 'Check that table partman_test.id_taptest_table_p40000_p47000_p47700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p47000_p47800', 'Check that table partman_test.id_taptest_table_p40000_p47000_p47800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p47000_p47900', 'Check that table partman_test.id_taptest_table_p40000_p47000_p47900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p48000_p48000', 'Check that table partman_test.id_taptest_table_p40000_p48000_p48000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p48000_p48100', 'Check that table partman_test.id_taptest_table_p40000_p48000_p48100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p48000_p48200', 'Check that table partman_test.id_taptest_table_p40000_p48000_p48200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p48000_p48300', 'Check that table partman_test.id_taptest_table_p40000_p48000_p48300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p48000_p48400', 'Check that table partman_test.id_taptest_table_p40000_p48000_p48400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p48000_p48500', 'Check that table partman_test.id_taptest_table_p40000_p48000_p48500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p48000_p48600', 'Check that table partman_test.id_taptest_table_p40000_p48000_p48600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p48000_p48700', 'Check that table partman_test.id_taptest_table_p40000_p48000_p48700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p48000_p48800', 'Check that table partman_test.id_taptest_table_p40000_p48000_p48800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p48000_p48900', 'Check that table partman_test.id_taptest_table_p40000_p48000_p48900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p49000_p49000', 'Check that table partman_test.id_taptest_table_p40000_p49000_p49000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p49000_p49100', 'Check that table partman_test.id_taptest_table_p40000_p49000_p49100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p49000_p49200', 'Check that table partman_test.id_taptest_table_p40000_p49000_p49200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p49000_p49300', 'Check that table partman_test.id_taptest_table_p40000_p49000_p49300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p49000_p49400', 'Check that table partman_test.id_taptest_table_p40000_p49000_p49400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p49000_p49500', 'Check that table partman_test.id_taptest_table_p40000_p49000_p49500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p49000_p49600', 'Check that table partman_test.id_taptest_table_p40000_p49000_p49600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p49000_p49700', 'Check that table partman_test.id_taptest_table_p40000_p49000_p49700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p49000_p49800', 'Check that table partman_test.id_taptest_table_p40000_p49000_p49800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p49000_p49900', 'Check that table partman_test.id_taptest_table_p40000_p49000_p49900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p50000_p50000', 'Check that table partman_test.id_taptest_table_p50000_p50000_p50000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p50000_p50100', 'Check that table partman_test.id_taptest_table_p50000_p50000_p50100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p50000_p50200', 'Check that table partman_test.id_taptest_table_p50000_p50000_p50200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p50000_p50300', 'Check that table partman_test.id_taptest_table_p50000_p50000_p50300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p50000_p50400', 'Check that table partman_test.id_taptest_table_p50000_p50000_p50400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p50000_p50500', 'Check that table partman_test.id_taptest_table_p50000_p50000_p50500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p50000_p50600', 'Check that table partman_test.id_taptest_table_p50000_p50000_p50600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p50000_p50700', 'Check that table partman_test.id_taptest_table_p50000_p50000_p50700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p50000_p50800', 'Check that table partman_test.id_taptest_table_p50000_p50000_p50800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p50000_p50900', 'Check that table partman_test.id_taptest_table_p50000_p50000_p50900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p51000_p51000', 'Check that table partman_test.id_taptest_table_p50000_p51000_p51000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p51000_p51100', 'Check that table partman_test.id_taptest_table_p50000_p51000_p51100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p51000_p51200', 'Check that table partman_test.id_taptest_table_p50000_p51000_p51200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p51000_p51300', 'Check that table partman_test.id_taptest_table_p50000_p51000_p51300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p51000_p51400', 'Check that table partman_test.id_taptest_table_p50000_p51000_p51400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p51000_p51500', 'Check that table partman_test.id_taptest_table_p50000_p51000_p51500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p51000_p51600', 'Check that table partman_test.id_taptest_table_p50000_p51000_p51600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p51000_p51700', 'Check that table partman_test.id_taptest_table_p50000_p51000_p51700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p51000_p51800', 'Check that table partman_test.id_taptest_table_p50000_p51000_p51800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p51000_p51900', 'Check that table partman_test.id_taptest_table_p50000_p51000_p51900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p52000_p52000', 'Check that table partman_test.id_taptest_table_p50000_p52000_p52000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p52000_p52100', 'Check that table partman_test.id_taptest_table_p50000_p52000_p52100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p52000_p52200', 'Check that table partman_test.id_taptest_table_p50000_p52000_p52200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p52000_p52300', 'Check that table partman_test.id_taptest_table_p50000_p52000_p52300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p52000_p52400', 'Check that table partman_test.id_taptest_table_p50000_p52000_p52400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p52000_p52500', 'Check that table partman_test.id_taptest_table_p50000_p52000_p52500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p52000_p52600', 'Check that table partman_test.id_taptest_table_p50000_p52000_p52600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p52000_p52700', 'Check that table partman_test.id_taptest_table_p50000_p52000_p52700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p52000_p52800', 'Check that table partman_test.id_taptest_table_p50000_p52000_p52800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p52000_p52900', 'Check that table partman_test.id_taptest_table_p50000_p52000_p52900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p53000_p53000', 'Check that table partman_test.id_taptest_table_p50000_p53000_p53000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p53000_p53100', 'Check that table partman_test.id_taptest_table_p50000_p53000_p53100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p53000_p53200', 'Check that table partman_test.id_taptest_table_p50000_p53000_p53200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p53000_p53300', 'Check that table partman_test.id_taptest_table_p50000_p53000_p53300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p53000_p53400', 'Check that table partman_test.id_taptest_table_p50000_p53000_p53400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p53000_p53500', 'Check that table partman_test.id_taptest_table_p50000_p53000_p53500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p53000_p53600', 'Check that table partman_test.id_taptest_table_p50000_p53000_p53600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p53000_p53700', 'Check that table partman_test.id_taptest_table_p50000_p53000_p53700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p53000_p53800', 'Check that table partman_test.id_taptest_table_p50000_p53000_p53800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p53000_p53900', 'Check that table partman_test.id_taptest_table_p50000_p53000_p53900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p54000_p54000', 'Check that table partman_test.id_taptest_table_p50000_p54000_p54000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p54000_p54100', 'Check that table partman_test.id_taptest_table_p50000_p54000_p54100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p54000_p54200', 'Check that table partman_test.id_taptest_table_p50000_p54000_p54200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p54000_p54300', 'Check that table partman_test.id_taptest_table_p50000_p54000_p54300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p54000_p54400', 'Check that table partman_test.id_taptest_table_p50000_p54000_p54400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p54000_p54500', 'Check that table partman_test.id_taptest_table_p50000_p54000_p54500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p54000_p54600', 'Check that table partman_test.id_taptest_table_p50000_p54000_p54600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p54000_p54700', 'Check that table partman_test.id_taptest_table_p50000_p54000_p54700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p54000_p54800', 'Check that table partman_test.id_taptest_table_p50000_p54000_p54800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p54000_p54900', 'Check that table partman_test.id_taptest_table_p50000_p54000_p54900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p55000_p55000', 'Check that table partman_test.id_taptest_table_p50000_p55000_p55000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p55000_p55100', 'Check that table partman_test.id_taptest_table_p50000_p55000_p55100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p55000_p55200', 'Check that table partman_test.id_taptest_table_p50000_p55000_p55200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p55000_p55300', 'Check that table partman_test.id_taptest_table_p50000_p55000_p55300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p55000_p55400', 'Check that table partman_test.id_taptest_table_p50000_p55000_p55400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p55000_p55500', 'Check that table partman_test.id_taptest_table_p50000_p55000_p55500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p55000_p55600', 'Check that table partman_test.id_taptest_table_p50000_p55000_p55600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p55000_p55700', 'Check that table partman_test.id_taptest_table_p50000_p55000_p55700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p55000_p55800', 'Check that table partman_test.id_taptest_table_p50000_p55000_p55800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p55000_p55900', 'Check that table partman_test.id_taptest_table_p50000_p55000_p55900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p56000_p56000', 'Check that table partman_test.id_taptest_table_p50000_p56000_p56000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p56000_p56100', 'Check that table partman_test.id_taptest_table_p50000_p56000_p56100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p56000_p56200', 'Check that table partman_test.id_taptest_table_p50000_p56000_p56200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p56000_p56300', 'Check that table partman_test.id_taptest_table_p50000_p56000_p56300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p56000_p56400', 'Check that table partman_test.id_taptest_table_p50000_p56000_p56400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p56000_p56500', 'Check that table partman_test.id_taptest_table_p50000_p56000_p56500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p56000_p56600', 'Check that table partman_test.id_taptest_table_p50000_p56000_p56600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p56000_p56700', 'Check that table partman_test.id_taptest_table_p50000_p56000_p56700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p56000_p56800', 'Check that table partman_test.id_taptest_table_p50000_p56000_p56800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p56000_p56900', 'Check that table partman_test.id_taptest_table_p50000_p56000_p56900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p57000_p57000', 'Check that table partman_test.id_taptest_table_p50000_p57000_p57000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p57000_p57100', 'Check that table partman_test.id_taptest_table_p50000_p57000_p57100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p57000_p57200', 'Check that table partman_test.id_taptest_table_p50000_p57000_p57200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p57000_p57300', 'Check that table partman_test.id_taptest_table_p50000_p57000_p57300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p57000_p57400', 'Check that table partman_test.id_taptest_table_p50000_p57000_p57400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p57000_p57500', 'Check that table partman_test.id_taptest_table_p50000_p57000_p57500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p57000_p57600', 'Check that table partman_test.id_taptest_table_p50000_p57000_p57600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p57000_p57700', 'Check that table partman_test.id_taptest_table_p50000_p57000_p57700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p57000_p57800', 'Check that table partman_test.id_taptest_table_p50000_p57000_p57800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p57000_p57900', 'Check that table partman_test.id_taptest_table_p50000_p57000_p57900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p58000_p58000', 'Check that table partman_test.id_taptest_table_p50000_p58000_p58000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p58000_p58100', 'Check that table partman_test.id_taptest_table_p50000_p58000_p58100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p58000_p58200', 'Check that table partman_test.id_taptest_table_p50000_p58000_p58200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p58000_p58300', 'Check that table partman_test.id_taptest_table_p50000_p58000_p58300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p58000_p58400', 'Check that table partman_test.id_taptest_table_p50000_p58000_p58400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p58000_p58500', 'Check that table partman_test.id_taptest_table_p50000_p58000_p58500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p58000_p58600', 'Check that table partman_test.id_taptest_table_p50000_p58000_p58600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p58000_p58700', 'Check that table partman_test.id_taptest_table_p50000_p58000_p58700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p58000_p58800', 'Check that table partman_test.id_taptest_table_p50000_p58000_p58800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p58000_p58900', 'Check that table partman_test.id_taptest_table_p50000_p58000_p58900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p59000_p59000', 'Check that table partman_test.id_taptest_table_p50000_p59000_p59000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p59000_p59100', 'Check that table partman_test.id_taptest_table_p50000_p59000_p59100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p59000_p59200', 'Check that table partman_test.id_taptest_table_p50000_p59000_p59200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p59000_p59300', 'Check that table partman_test.id_taptest_table_p50000_p59000_p59300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p59000_p59400', 'Check that table partman_test.id_taptest_table_p50000_p59000_p59400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p59000_p59500', 'Check that table partman_test.id_taptest_table_p50000_p59000_p59500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p59000_p59600', 'Check that table partman_test.id_taptest_table_p50000_p59000_p59600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p59000_p59700', 'Check that table partman_test.id_taptest_table_p50000_p59000_p59700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p59000_p59800', 'Check that table partman_test.id_taptest_table_p50000_p59000_p59800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p59000_p59900', 'Check that table partman_test.id_taptest_table_p50000_p59000_p59900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p60000_p60000', 'Check that table partman_test.id_taptest_table_p60000_p60000_p60000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p60000_p60100', 'Check that table partman_test.id_taptest_table_p60000_p60000_p60100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p60000_p60200', 'Check that table partman_test.id_taptest_table_p60000_p60000_p60200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p60000_p60300', 'Check that table partman_test.id_taptest_table_p60000_p60000_p60300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p60000_p60400', 'Check that table partman_test.id_taptest_table_p60000_p60000_p60400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p60000_p60500', 'Check that table partman_test.id_taptest_table_p60000_p60000_p60500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p60000_p60600', 'Check that table partman_test.id_taptest_table_p60000_p60000_p60600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p60000_p60700', 'Check that table partman_test.id_taptest_table_p60000_p60000_p60700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p60000_p60800', 'Check that table partman_test.id_taptest_table_p60000_p60000_p60800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p60000_p60900', 'Check that table partman_test.id_taptest_table_p60000_p60000_p60900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p61000_p61000', 'Check that table partman_test.id_taptest_table_p60000_p61000_p61000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p61000_p61100', 'Check that table partman_test.id_taptest_table_p60000_p61000_p61100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p61000_p61200', 'Check that table partman_test.id_taptest_table_p60000_p61000_p61200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p61000_p61300', 'Check that table partman_test.id_taptest_table_p60000_p61000_p61300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p61000_p61400', 'Check that table partman_test.id_taptest_table_p60000_p61000_p61400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p61000_p61500', 'Check that table partman_test.id_taptest_table_p60000_p61000_p61500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p61000_p61600', 'Check that table partman_test.id_taptest_table_p60000_p61000_p61600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p61000_p61700', 'Check that table partman_test.id_taptest_table_p60000_p61000_p61700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p61000_p61800', 'Check that table partman_test.id_taptest_table_p60000_p61000_p61800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p61000_p61900', 'Check that table partman_test.id_taptest_table_p60000_p61000_p61900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p62000_p62000', 'Check that table partman_test.id_taptest_table_p60000_p62000_p62000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p62000_p62100', 'Check that table partman_test.id_taptest_table_p60000_p62000_p62100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p62000_p62200', 'Check that table partman_test.id_taptest_table_p60000_p62000_p62200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p62000_p62300', 'Check that table partman_test.id_taptest_table_p60000_p62000_p62300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p62000_p62400', 'Check that table partman_test.id_taptest_table_p60000_p62000_p62400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p62000_p62500', 'Check that table partman_test.id_taptest_table_p60000_p62000_p62500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p62000_p62600', 'Check that table partman_test.id_taptest_table_p60000_p62000_p62600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p62000_p62700', 'Check that table partman_test.id_taptest_table_p60000_p62000_p62700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p62000_p62800', 'Check that table partman_test.id_taptest_table_p60000_p62000_p62800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p62000_p62900', 'Check that table partman_test.id_taptest_table_p60000_p62000_p62900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p63000_p63000', 'Check that table partman_test.id_taptest_table_p60000_p63000_p63000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p63000_p63100', 'Check that table partman_test.id_taptest_table_p60000_p63000_p63100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p63000_p63200', 'Check that table partman_test.id_taptest_table_p60000_p63000_p63200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p63000_p63300', 'Check that table partman_test.id_taptest_table_p60000_p63000_p63300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p63000_p63400', 'Check that table partman_test.id_taptest_table_p60000_p63000_p63400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p63000_p63500', 'Check that table partman_test.id_taptest_table_p60000_p63000_p63500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p63000_p63600', 'Check that table partman_test.id_taptest_table_p60000_p63000_p63600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p63000_p63700', 'Check that table partman_test.id_taptest_table_p60000_p63000_p63700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p63000_p63800', 'Check that table partman_test.id_taptest_table_p60000_p63000_p63800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p63000_p63900', 'Check that table partman_test.id_taptest_table_p60000_p63000_p63900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p64000_p64000', 'Check that table partman_test.id_taptest_table_p60000_p64000_p64000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p64000_p64100', 'Check that table partman_test.id_taptest_table_p60000_p64000_p64100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p64000_p64200', 'Check that table partman_test.id_taptest_table_p60000_p64000_p64200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p64000_p64300', 'Check that table partman_test.id_taptest_table_p60000_p64000_p64300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p64000_p64400', 'Check that table partman_test.id_taptest_table_p60000_p64000_p64400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p64000_p64500', 'Check that table partman_test.id_taptest_table_p60000_p64000_p64500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p64000_p64600', 'Check that table partman_test.id_taptest_table_p60000_p64000_p64600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p64000_p64700', 'Check that table partman_test.id_taptest_table_p60000_p64000_p64700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p64000_p64800', 'Check that table partman_test.id_taptest_table_p60000_p64000_p64800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p64000_p64900', 'Check that table partman_test.id_taptest_table_p60000_p64000_p64900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p65000_p65000', 'Check that table partman_test.id_taptest_table_p60000_p65000_p65000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p65000_p65100', 'Check that table partman_test.id_taptest_table_p60000_p65000_p65100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p65000_p65200', 'Check that table partman_test.id_taptest_table_p60000_p65000_p65200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p65000_p65300', 'Check that table partman_test.id_taptest_table_p60000_p65000_p65300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p65000_p65400', 'Check that table partman_test.id_taptest_table_p60000_p65000_p65400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p65000_p65500', 'Check that table partman_test.id_taptest_table_p60000_p65000_p65500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p65000_p65600', 'Check that table partman_test.id_taptest_table_p60000_p65000_p65600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p65000_p65700', 'Check that table partman_test.id_taptest_table_p60000_p65000_p65700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p65000_p65800', 'Check that table partman_test.id_taptest_table_p60000_p65000_p65800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p65000_p65900', 'Check that table partman_test.id_taptest_table_p60000_p65000_p65900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p66000_p66000', 'Check that table partman_test.id_taptest_table_p60000_p66000_p66000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p66000_p66100', 'Check that table partman_test.id_taptest_table_p60000_p66000_p66100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p66000_p66200', 'Check that table partman_test.id_taptest_table_p60000_p66000_p66200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p66000_p66300', 'Check that table partman_test.id_taptest_table_p60000_p66000_p66300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p66000_p66400', 'Check that table partman_test.id_taptest_table_p60000_p66000_p66400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p66000_p66500', 'Check that table partman_test.id_taptest_table_p60000_p66000_p66500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p66000_p66600', 'Check that table partman_test.id_taptest_table_p60000_p66000_p66600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p66000_p66700', 'Check that table partman_test.id_taptest_table_p60000_p66000_p66700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p66000_p66800', 'Check that table partman_test.id_taptest_table_p60000_p66000_p66800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p66000_p66900', 'Check that table partman_test.id_taptest_table_p60000_p66000_p66900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p67000_p67000', 'Check that table partman_test.id_taptest_table_p60000_p67000_p67000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p67000_p67100', 'Check that table partman_test.id_taptest_table_p60000_p67000_p67100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p67000_p67200', 'Check that table partman_test.id_taptest_table_p60000_p67000_p67200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p67000_p67300', 'Check that table partman_test.id_taptest_table_p60000_p67000_p67300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p67000_p67400', 'Check that table partman_test.id_taptest_table_p60000_p67000_p67400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p67000_p67500', 'Check that table partman_test.id_taptest_table_p60000_p67000_p67500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p67000_p67600', 'Check that table partman_test.id_taptest_table_p60000_p67000_p67600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p67000_p67700', 'Check that table partman_test.id_taptest_table_p60000_p67000_p67700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p67000_p67800', 'Check that table partman_test.id_taptest_table_p60000_p67000_p67800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p67000_p67900', 'Check that table partman_test.id_taptest_table_p60000_p67000_p67900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p68000_p68000', 'Check that table partman_test.id_taptest_table_p60000_p68000_p68000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p68000_p68100', 'Check that table partman_test.id_taptest_table_p60000_p68000_p68100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p68000_p68200', 'Check that table partman_test.id_taptest_table_p60000_p68000_p68200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p68000_p68300', 'Check that table partman_test.id_taptest_table_p60000_p68000_p68300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p68000_p68400', 'Check that table partman_test.id_taptest_table_p60000_p68000_p68400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p68000_p68500', 'Check that table partman_test.id_taptest_table_p60000_p68000_p68500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p68000_p68600', 'Check that table partman_test.id_taptest_table_p60000_p68000_p68600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p68000_p68700', 'Check that table partman_test.id_taptest_table_p60000_p68000_p68700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p68000_p68800', 'Check that table partman_test.id_taptest_table_p60000_p68000_p68800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p68000_p68900', 'Check that table partman_test.id_taptest_table_p60000_p68000_p68900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p69000_p69000', 'Check that table partman_test.id_taptest_table_p60000_p69000_p69000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p69000_p69100', 'Check that table partman_test.id_taptest_table_p60000_p69000_p69100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p69000_p69200', 'Check that table partman_test.id_taptest_table_p60000_p69000_p69200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p69000_p69300', 'Check that table partman_test.id_taptest_table_p60000_p69000_p69300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p69000_p69400', 'Check that table partman_test.id_taptest_table_p60000_p69000_p69400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p69000_p69500', 'Check that table partman_test.id_taptest_table_p60000_p69000_p69500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p69000_p69600', 'Check that table partman_test.id_taptest_table_p60000_p69000_p69600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p69000_p69700', 'Check that table partman_test.id_taptest_table_p60000_p69000_p69700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p69000_p69800', 'Check that table partman_test.id_taptest_table_p60000_p69000_p69800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p69000_p69900', 'Check that table partman_test.id_taptest_table_p60000_p69000_p69900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p70000_p70000', 'Check that table partman_test.id_taptest_table_p70000_p70000_p70000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p70000_p70100', 'Check that table partman_test.id_taptest_table_p70000_p70000_p70100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p70000_p70200', 'Check that table partman_test.id_taptest_table_p70000_p70000_p70200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p70000_p70300', 'Check that table partman_test.id_taptest_table_p70000_p70000_p70300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p70000_p70400', 'Check that table partman_test.id_taptest_table_p70000_p70000_p70400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p70000_p70500', 'Check that table partman_test.id_taptest_table_p70000_p70000_p70500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p70000_p70600', 'Check that table partman_test.id_taptest_table_p70000_p70000_p70600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p70000_p70700', 'Check that table partman_test.id_taptest_table_p70000_p70000_p70700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p70000_p70800', 'Check that table partman_test.id_taptest_table_p70000_p70000_p70800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p70000_p70900', 'Check that table partman_test.id_taptest_table_p70000_p70000_p70900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p71000_p71000', 'Check that table partman_test.id_taptest_table_p70000_p71000_p71000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p71000_p71100', 'Check that table partman_test.id_taptest_table_p70000_p71000_p71100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p71000_p71200', 'Check that table partman_test.id_taptest_table_p70000_p71000_p71200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p71000_p71300', 'Check that table partman_test.id_taptest_table_p70000_p71000_p71300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p71000_p71400', 'Check that table partman_test.id_taptest_table_p70000_p71000_p71400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p71000_p71500', 'Check that table partman_test.id_taptest_table_p70000_p71000_p71500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p71000_p71600', 'Check that table partman_test.id_taptest_table_p70000_p71000_p71600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p71000_p71700', 'Check that table partman_test.id_taptest_table_p70000_p71000_p71700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p71000_p71800', 'Check that table partman_test.id_taptest_table_p70000_p71000_p71800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p71000_p71900', 'Check that table partman_test.id_taptest_table_p70000_p71000_p71900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p72000_p72000', 'Check that table partman_test.id_taptest_table_p70000_p72000_p72000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p72000_p72100', 'Check that table partman_test.id_taptest_table_p70000_p72000_p72100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p72000_p72200', 'Check that table partman_test.id_taptest_table_p70000_p72000_p72200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p72000_p72300', 'Check that table partman_test.id_taptest_table_p70000_p72000_p72300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p72000_p72400', 'Check that table partman_test.id_taptest_table_p70000_p72000_p72400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p72000_p72500', 'Check that table partman_test.id_taptest_table_p70000_p72000_p72500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p72000_p72600', 'Check that table partman_test.id_taptest_table_p70000_p72000_p72600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p72000_p72700', 'Check that table partman_test.id_taptest_table_p70000_p72000_p72700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p72000_p72800', 'Check that table partman_test.id_taptest_table_p70000_p72000_p72800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p72000_p72900', 'Check that table partman_test.id_taptest_table_p70000_p72000_p72900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p73000_p73000', 'Check that table partman_test.id_taptest_table_p70000_p73000_p73000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p73000_p73100', 'Check that table partman_test.id_taptest_table_p70000_p73000_p73100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p73000_p73200', 'Check that table partman_test.id_taptest_table_p70000_p73000_p73200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p73000_p73300', 'Check that table partman_test.id_taptest_table_p70000_p73000_p73300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p73000_p73400', 'Check that table partman_test.id_taptest_table_p70000_p73000_p73400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p73000_p73500', 'Check that table partman_test.id_taptest_table_p70000_p73000_p73500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p73000_p73600', 'Check that table partman_test.id_taptest_table_p70000_p73000_p73600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p73000_p73700', 'Check that table partman_test.id_taptest_table_p70000_p73000_p73700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p73000_p73800', 'Check that table partman_test.id_taptest_table_p70000_p73000_p73800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p73000_p73900', 'Check that table partman_test.id_taptest_table_p70000_p73000_p73900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p74000_p74000', 'Check that table partman_test.id_taptest_table_p70000_p74000_p74000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p74000_p74100', 'Check that table partman_test.id_taptest_table_p70000_p74000_p74100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p74000_p74200', 'Check that table partman_test.id_taptest_table_p70000_p74000_p74200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p74000_p74300', 'Check that table partman_test.id_taptest_table_p70000_p74000_p74300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p74000_p74400', 'Check that table partman_test.id_taptest_table_p70000_p74000_p74400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p74000_p74500', 'Check that table partman_test.id_taptest_table_p70000_p74000_p74500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p74000_p74600', 'Check that table partman_test.id_taptest_table_p70000_p74000_p74600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p74000_p74700', 'Check that table partman_test.id_taptest_table_p70000_p74000_p74700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p74000_p74800', 'Check that table partman_test.id_taptest_table_p70000_p74000_p74800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p74000_p74900', 'Check that table partman_test.id_taptest_table_p70000_p74000_p74900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p75000_p75000', 'Check that table partman_test.id_taptest_table_p70000_p75000_p75000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p75000_p75100', 'Check that table partman_test.id_taptest_table_p70000_p75000_p75100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p75000_p75200', 'Check that table partman_test.id_taptest_table_p70000_p75000_p75200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p75000_p75300', 'Check that table partman_test.id_taptest_table_p70000_p75000_p75300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p75000_p75400', 'Check that table partman_test.id_taptest_table_p70000_p75000_p75400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p75000_p75500', 'Check that table partman_test.id_taptest_table_p70000_p75000_p75500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p75000_p75600', 'Check that table partman_test.id_taptest_table_p70000_p75000_p75600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p75000_p75700', 'Check that table partman_test.id_taptest_table_p70000_p75000_p75700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p75000_p75800', 'Check that table partman_test.id_taptest_table_p70000_p75000_p75800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p75000_p75900', 'Check that table partman_test.id_taptest_table_p70000_p75000_p75900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p76000_p76000', 'Check that table partman_test.id_taptest_table_p70000_p76000_p76000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p76000_p76100', 'Check that table partman_test.id_taptest_table_p70000_p76000_p76100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p76000_p76200', 'Check that table partman_test.id_taptest_table_p70000_p76000_p76200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p76000_p76300', 'Check that table partman_test.id_taptest_table_p70000_p76000_p76300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p76000_p76400', 'Check that table partman_test.id_taptest_table_p70000_p76000_p76400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p76000_p76500', 'Check that table partman_test.id_taptest_table_p70000_p76000_p76500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p76000_p76600', 'Check that table partman_test.id_taptest_table_p70000_p76000_p76600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p76000_p76700', 'Check that table partman_test.id_taptest_table_p70000_p76000_p76700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p76000_p76800', 'Check that table partman_test.id_taptest_table_p70000_p76000_p76800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p76000_p76900', 'Check that table partman_test.id_taptest_table_p70000_p76000_p76900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p77000_p77000', 'Check that table partman_test.id_taptest_table_p70000_p77000_p77000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p77000_p77100', 'Check that table partman_test.id_taptest_table_p70000_p77000_p77100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p77000_p77200', 'Check that table partman_test.id_taptest_table_p70000_p77000_p77200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p77000_p77300', 'Check that table partman_test.id_taptest_table_p70000_p77000_p77300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p77000_p77400', 'Check that table partman_test.id_taptest_table_p70000_p77000_p77400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p77000_p77500', 'Check that table partman_test.id_taptest_table_p70000_p77000_p77500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p77000_p77600', 'Check that table partman_test.id_taptest_table_p70000_p77000_p77600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p77000_p77700', 'Check that table partman_test.id_taptest_table_p70000_p77000_p77700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p77000_p77800', 'Check that table partman_test.id_taptest_table_p70000_p77000_p77800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p77000_p77900', 'Check that table partman_test.id_taptest_table_p70000_p77000_p77900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p78000_p78000', 'Check that table partman_test.id_taptest_table_p70000_p78000_p78000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p78000_p78100', 'Check that table partman_test.id_taptest_table_p70000_p78000_p78100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p78000_p78200', 'Check that table partman_test.id_taptest_table_p70000_p78000_p78200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p78000_p78300', 'Check that table partman_test.id_taptest_table_p70000_p78000_p78300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p78000_p78400', 'Check that table partman_test.id_taptest_table_p70000_p78000_p78400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p78000_p78500', 'Check that table partman_test.id_taptest_table_p70000_p78000_p78500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p78000_p78600', 'Check that table partman_test.id_taptest_table_p70000_p78000_p78600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p78000_p78700', 'Check that table partman_test.id_taptest_table_p70000_p78000_p78700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p78000_p78800', 'Check that table partman_test.id_taptest_table_p70000_p78000_p78800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p78000_p78900', 'Check that table partman_test.id_taptest_table_p70000_p78000_p78900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p79000_p79000', 'Check that table partman_test.id_taptest_table_p70000_p79000_p79000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p79000_p79100', 'Check that table partman_test.id_taptest_table_p70000_p79000_p79100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p79000_p79200', 'Check that table partman_test.id_taptest_table_p70000_p79000_p79200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p79000_p79300', 'Check that table partman_test.id_taptest_table_p70000_p79000_p79300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p79000_p79400', 'Check that table partman_test.id_taptest_table_p70000_p79000_p79400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p79000_p79500', 'Check that table partman_test.id_taptest_table_p70000_p79000_p79500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p79000_p79600', 'Check that table partman_test.id_taptest_table_p70000_p79000_p79600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p79000_p79700', 'Check that table partman_test.id_taptest_table_p70000_p79000_p79700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p79000_p79800', 'Check that table partman_test.id_taptest_table_p70000_p79000_p79800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p79000_p79900', 'Check that table partman_test.id_taptest_table_p70000_p79000_p79900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p80000_p80000', 'Check that table partman_test.id_taptest_table_p80000_p80000_p80000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p80000_p80100', 'Check that table partman_test.id_taptest_table_p80000_p80000_p80100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p80000_p80200', 'Check that table partman_test.id_taptest_table_p80000_p80000_p80200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p80000_p80300', 'Check that table partman_test.id_taptest_table_p80000_p80000_p80300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p80000_p80400', 'Check that table partman_test.id_taptest_table_p80000_p80000_p80400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p80000_p80500', 'Check that table partman_test.id_taptest_table_p80000_p80000_p80500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p80000_p80600', 'Check that table partman_test.id_taptest_table_p80000_p80000_p80600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p80000_p80700', 'Check that table partman_test.id_taptest_table_p80000_p80000_p80700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p80000_p80800', 'Check that table partman_test.id_taptest_table_p80000_p80000_p80800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p80000_p80900', 'Check that table partman_test.id_taptest_table_p80000_p80000_p80900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p81000_p81000', 'Check that table partman_test.id_taptest_table_p80000_p81000_p81000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p81000_p81100', 'Check that table partman_test.id_taptest_table_p80000_p81000_p81100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p81000_p81200', 'Check that table partman_test.id_taptest_table_p80000_p81000_p81200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p81000_p81300', 'Check that table partman_test.id_taptest_table_p80000_p81000_p81300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p81000_p81400', 'Check that table partman_test.id_taptest_table_p80000_p81000_p81400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p81000_p81500', 'Check that table partman_test.id_taptest_table_p80000_p81000_p81500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p81000_p81600', 'Check that table partman_test.id_taptest_table_p80000_p81000_p81600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p81000_p81700', 'Check that table partman_test.id_taptest_table_p80000_p81000_p81700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p81000_p81800', 'Check that table partman_test.id_taptest_table_p80000_p81000_p81800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p81000_p81900', 'Check that table partman_test.id_taptest_table_p80000_p81000_p81900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p82000_p82000', 'Check that table partman_test.id_taptest_table_p80000_p82000_p82000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p82000_p82100', 'Check that table partman_test.id_taptest_table_p80000_p82000_p82100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p82000_p82200', 'Check that table partman_test.id_taptest_table_p80000_p82000_p82200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p82000_p82300', 'Check that table partman_test.id_taptest_table_p80000_p82000_p82300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p82000_p82400', 'Check that table partman_test.id_taptest_table_p80000_p82000_p82400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p82000_p82500', 'Check that table partman_test.id_taptest_table_p80000_p82000_p82500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p82000_p82600', 'Check that table partman_test.id_taptest_table_p80000_p82000_p82600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p82000_p82700', 'Check that table partman_test.id_taptest_table_p80000_p82000_p82700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p82000_p82800', 'Check that table partman_test.id_taptest_table_p80000_p82000_p82800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p82000_p82900', 'Check that table partman_test.id_taptest_table_p80000_p82000_p82900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p83000_p83000', 'Check that table partman_test.id_taptest_table_p80000_p83000_p83000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p83000_p83100', 'Check that table partman_test.id_taptest_table_p80000_p83000_p83100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p83000_p83200', 'Check that table partman_test.id_taptest_table_p80000_p83000_p83200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p83000_p83300', 'Check that table partman_test.id_taptest_table_p80000_p83000_p83300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p83000_p83400', 'Check that table partman_test.id_taptest_table_p80000_p83000_p83400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p83000_p83500', 'Check that table partman_test.id_taptest_table_p80000_p83000_p83500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p83000_p83600', 'Check that table partman_test.id_taptest_table_p80000_p83000_p83600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p83000_p83700', 'Check that table partman_test.id_taptest_table_p80000_p83000_p83700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p83000_p83800', 'Check that table partman_test.id_taptest_table_p80000_p83000_p83800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p83000_p83900', 'Check that table partman_test.id_taptest_table_p80000_p83000_p83900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p84000_p84000', 'Check that table partman_test.id_taptest_table_p80000_p84000_p84000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p84000_p84100', 'Check that table partman_test.id_taptest_table_p80000_p84000_p84100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p84000_p84200', 'Check that table partman_test.id_taptest_table_p80000_p84000_p84200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p84000_p84300', 'Check that table partman_test.id_taptest_table_p80000_p84000_p84300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p84000_p84400', 'Check that table partman_test.id_taptest_table_p80000_p84000_p84400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p84000_p84500', 'Check that table partman_test.id_taptest_table_p80000_p84000_p84500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p84000_p84600', 'Check that table partman_test.id_taptest_table_p80000_p84000_p84600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p84000_p84700', 'Check that table partman_test.id_taptest_table_p80000_p84000_p84700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p84000_p84800', 'Check that table partman_test.id_taptest_table_p80000_p84000_p84800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p84000_p84900', 'Check that table partman_test.id_taptest_table_p80000_p84000_p84900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p85000_p85000', 'Check that table partman_test.id_taptest_table_p80000_p85000_p85000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p85000_p85100', 'Check that table partman_test.id_taptest_table_p80000_p85000_p85100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p85000_p85200', 'Check that table partman_test.id_taptest_table_p80000_p85000_p85200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p85000_p85300', 'Check that table partman_test.id_taptest_table_p80000_p85000_p85300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p85000_p85400', 'Check that table partman_test.id_taptest_table_p80000_p85000_p85400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p85000_p85500', 'Check that table partman_test.id_taptest_table_p80000_p85000_p85500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p85000_p85600', 'Check that table partman_test.id_taptest_table_p80000_p85000_p85600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p85000_p85700', 'Check that table partman_test.id_taptest_table_p80000_p85000_p85700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p85000_p85800', 'Check that table partman_test.id_taptest_table_p80000_p85000_p85800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p85000_p85900', 'Check that table partman_test.id_taptest_table_p80000_p85000_p85900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p86000_p86000', 'Check that table partman_test.id_taptest_table_p80000_p86000_p86000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p86000_p86100', 'Check that table partman_test.id_taptest_table_p80000_p86000_p86100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p86000_p86200', 'Check that table partman_test.id_taptest_table_p80000_p86000_p86200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p86000_p86300', 'Check that table partman_test.id_taptest_table_p80000_p86000_p86300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p86000_p86400', 'Check that table partman_test.id_taptest_table_p80000_p86000_p86400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p86000_p86500', 'Check that table partman_test.id_taptest_table_p80000_p86000_p86500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p86000_p86600', 'Check that table partman_test.id_taptest_table_p80000_p86000_p86600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p86000_p86700', 'Check that table partman_test.id_taptest_table_p80000_p86000_p86700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p86000_p86800', 'Check that table partman_test.id_taptest_table_p80000_p86000_p86800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p86000_p86900', 'Check that table partman_test.id_taptest_table_p80000_p86000_p86900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p87000_p87000', 'Check that table partman_test.id_taptest_table_p80000_p87000_p87000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p87000_p87100', 'Check that table partman_test.id_taptest_table_p80000_p87000_p87100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p87000_p87200', 'Check that table partman_test.id_taptest_table_p80000_p87000_p87200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p87000_p87300', 'Check that table partman_test.id_taptest_table_p80000_p87000_p87300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p87000_p87400', 'Check that table partman_test.id_taptest_table_p80000_p87000_p87400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p87000_p87500', 'Check that table partman_test.id_taptest_table_p80000_p87000_p87500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p87000_p87600', 'Check that table partman_test.id_taptest_table_p80000_p87000_p87600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p87000_p87700', 'Check that table partman_test.id_taptest_table_p80000_p87000_p87700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p87000_p87800', 'Check that table partman_test.id_taptest_table_p80000_p87000_p87800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p87000_p87900', 'Check that table partman_test.id_taptest_table_p80000_p87000_p87900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p88000_p88000', 'Check that table partman_test.id_taptest_table_p80000_p88000_p88000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p88000_p88100', 'Check that table partman_test.id_taptest_table_p80000_p88000_p88100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p88000_p88200', 'Check that table partman_test.id_taptest_table_p80000_p88000_p88200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p88000_p88300', 'Check that table partman_test.id_taptest_table_p80000_p88000_p88300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p88000_p88400', 'Check that table partman_test.id_taptest_table_p80000_p88000_p88400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p88000_p88500', 'Check that table partman_test.id_taptest_table_p80000_p88000_p88500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p88000_p88600', 'Check that table partman_test.id_taptest_table_p80000_p88000_p88600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p88000_p88700', 'Check that table partman_test.id_taptest_table_p80000_p88000_p88700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p88000_p88800', 'Check that table partman_test.id_taptest_table_p80000_p88000_p88800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p88000_p88900', 'Check that table partman_test.id_taptest_table_p80000_p88000_p88900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p89000_p89000', 'Check that table partman_test.id_taptest_table_p80000_p89000_p89000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p89000_p89100', 'Check that table partman_test.id_taptest_table_p80000_p89000_p89100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p89000_p89200', 'Check that table partman_test.id_taptest_table_p80000_p89000_p89200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p89000_p89300', 'Check that table partman_test.id_taptest_table_p80000_p89000_p89300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p89000_p89400', 'Check that table partman_test.id_taptest_table_p80000_p89000_p89400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p89000_p89500', 'Check that table partman_test.id_taptest_table_p80000_p89000_p89500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p89000_p89600', 'Check that table partman_test.id_taptest_table_p80000_p89000_p89600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p89000_p89700', 'Check that table partman_test.id_taptest_table_p80000_p89000_p89700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p89000_p89800', 'Check that table partman_test.id_taptest_table_p80000_p89000_p89800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p89000_p89900', 'Check that table partman_test.id_taptest_table_p80000_p89000_p89900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p90000_p90000', 'Check that table partman_test.id_taptest_table_p90000_p90000_p90000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p90000_p90100', 'Check that table partman_test.id_taptest_table_p90000_p90000_p90100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p90000_p90200', 'Check that table partman_test.id_taptest_table_p90000_p90000_p90200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p90000_p90300', 'Check that table partman_test.id_taptest_table_p90000_p90000_p90300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p90000_p90400', 'Check that table partman_test.id_taptest_table_p90000_p90000_p90400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p90000_p90500', 'Check that table partman_test.id_taptest_table_p90000_p90000_p90500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p90000_p90600', 'Check that table partman_test.id_taptest_table_p90000_p90000_p90600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p90000_p90700', 'Check that table partman_test.id_taptest_table_p90000_p90000_p90700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p90000_p90800', 'Check that table partman_test.id_taptest_table_p90000_p90000_p90800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p90000_p90900', 'Check that table partman_test.id_taptest_table_p90000_p90000_p90900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p91000_p91000', 'Check that table partman_test.id_taptest_table_p90000_p91000_p91000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p91000_p91100', 'Check that table partman_test.id_taptest_table_p90000_p91000_p91100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p91000_p91200', 'Check that table partman_test.id_taptest_table_p90000_p91000_p91200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p91000_p91300', 'Check that table partman_test.id_taptest_table_p90000_p91000_p91300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p91000_p91400', 'Check that table partman_test.id_taptest_table_p90000_p91000_p91400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p91000_p91500', 'Check that table partman_test.id_taptest_table_p90000_p91000_p91500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p91000_p91600', 'Check that table partman_test.id_taptest_table_p90000_p91000_p91600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p91000_p91700', 'Check that table partman_test.id_taptest_table_p90000_p91000_p91700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p91000_p91800', 'Check that table partman_test.id_taptest_table_p90000_p91000_p91800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p91000_p91900', 'Check that table partman_test.id_taptest_table_p90000_p91000_p91900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p92000_p92000', 'Check that table partman_test.id_taptest_table_p90000_p92000_p92000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p92000_p92100', 'Check that table partman_test.id_taptest_table_p90000_p92000_p92100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p92000_p92200', 'Check that table partman_test.id_taptest_table_p90000_p92000_p92200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p92000_p92300', 'Check that table partman_test.id_taptest_table_p90000_p92000_p92300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p92000_p92400', 'Check that table partman_test.id_taptest_table_p90000_p92000_p92400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p92000_p92500', 'Check that table partman_test.id_taptest_table_p90000_p92000_p92500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p92000_p92600', 'Check that table partman_test.id_taptest_table_p90000_p92000_p92600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p92000_p92700', 'Check that table partman_test.id_taptest_table_p90000_p92000_p92700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p92000_p92800', 'Check that table partman_test.id_taptest_table_p90000_p92000_p92800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p92000_p92900', 'Check that table partman_test.id_taptest_table_p90000_p92000_p92900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p93000_p93000', 'Check that table partman_test.id_taptest_table_p90000_p93000_p93000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p93000_p93100', 'Check that table partman_test.id_taptest_table_p90000_p93000_p93100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p93000_p93200', 'Check that table partman_test.id_taptest_table_p90000_p93000_p93200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p93000_p93300', 'Check that table partman_test.id_taptest_table_p90000_p93000_p93300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p93000_p93400', 'Check that table partman_test.id_taptest_table_p90000_p93000_p93400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p93000_p93500', 'Check that table partman_test.id_taptest_table_p90000_p93000_p93500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p93000_p93600', 'Check that table partman_test.id_taptest_table_p90000_p93000_p93600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p93000_p93700', 'Check that table partman_test.id_taptest_table_p90000_p93000_p93700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p93000_p93800', 'Check that table partman_test.id_taptest_table_p90000_p93000_p93800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p93000_p93900', 'Check that table partman_test.id_taptest_table_p90000_p93000_p93900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p94000_p94000', 'Check that table partman_test.id_taptest_table_p90000_p94000_p94000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p94000_p94100', 'Check that table partman_test.id_taptest_table_p90000_p94000_p94100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p94000_p94200', 'Check that table partman_test.id_taptest_table_p90000_p94000_p94200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p94000_p94300', 'Check that table partman_test.id_taptest_table_p90000_p94000_p94300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p94000_p94400', 'Check that table partman_test.id_taptest_table_p90000_p94000_p94400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p94000_p94500', 'Check that table partman_test.id_taptest_table_p90000_p94000_p94500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p94000_p94600', 'Check that table partman_test.id_taptest_table_p90000_p94000_p94600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p94000_p94700', 'Check that table partman_test.id_taptest_table_p90000_p94000_p94700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p94000_p94800', 'Check that table partman_test.id_taptest_table_p90000_p94000_p94800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p94000_p94900', 'Check that table partman_test.id_taptest_table_p90000_p94000_p94900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p95000_p95000', 'Check that table partman_test.id_taptest_table_p90000_p95000_p95000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p95000_p95100', 'Check that table partman_test.id_taptest_table_p90000_p95000_p95100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p95000_p95200', 'Check that table partman_test.id_taptest_table_p90000_p95000_p95200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p95000_p95300', 'Check that table partman_test.id_taptest_table_p90000_p95000_p95300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p95000_p95400', 'Check that table partman_test.id_taptest_table_p90000_p95000_p95400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p95000_p95500', 'Check that table partman_test.id_taptest_table_p90000_p95000_p95500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p95000_p95600', 'Check that table partman_test.id_taptest_table_p90000_p95000_p95600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p95000_p95700', 'Check that table partman_test.id_taptest_table_p90000_p95000_p95700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p95000_p95800', 'Check that table partman_test.id_taptest_table_p90000_p95000_p95800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p95000_p95900', 'Check that table partman_test.id_taptest_table_p90000_p95000_p95900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p96000_p96000', 'Check that table partman_test.id_taptest_table_p90000_p96000_p96000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p96000_p96100', 'Check that table partman_test.id_taptest_table_p90000_p96000_p96100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p96000_p96200', 'Check that table partman_test.id_taptest_table_p90000_p96000_p96200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p96000_p96300', 'Check that table partman_test.id_taptest_table_p90000_p96000_p96300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p96000_p96400', 'Check that table partman_test.id_taptest_table_p90000_p96000_p96400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p96000_p96500', 'Check that table partman_test.id_taptest_table_p90000_p96000_p96500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p96000_p96600', 'Check that table partman_test.id_taptest_table_p90000_p96000_p96600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p96000_p96700', 'Check that table partman_test.id_taptest_table_p90000_p96000_p96700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p96000_p96800', 'Check that table partman_test.id_taptest_table_p90000_p96000_p96800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p96000_p96900', 'Check that table partman_test.id_taptest_table_p90000_p96000_p96900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p97000_p97000', 'Check that table partman_test.id_taptest_table_p90000_p97000_p97000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p97000_p97100', 'Check that table partman_test.id_taptest_table_p90000_p97000_p97100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p97000_p97200', 'Check that table partman_test.id_taptest_table_p90000_p97000_p97200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p97000_p97300', 'Check that table partman_test.id_taptest_table_p90000_p97000_p97300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p97000_p97400', 'Check that table partman_test.id_taptest_table_p90000_p97000_p97400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p97000_p97500', 'Check that table partman_test.id_taptest_table_p90000_p97000_p97500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p97000_p97600', 'Check that table partman_test.id_taptest_table_p90000_p97000_p97600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p97000_p97700', 'Check that table partman_test.id_taptest_table_p90000_p97000_p97700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p97000_p97800', 'Check that table partman_test.id_taptest_table_p90000_p97000_p97800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p97000_p97900', 'Check that table partman_test.id_taptest_table_p90000_p97000_p97900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p98000_p98000', 'Check that table partman_test.id_taptest_table_p90000_p98000_p98000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p98000_p98100', 'Check that table partman_test.id_taptest_table_p90000_p98000_p98100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p98000_p98200', 'Check that table partman_test.id_taptest_table_p90000_p98000_p98200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p98000_p98300', 'Check that table partman_test.id_taptest_table_p90000_p98000_p98300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p98000_p98400', 'Check that table partman_test.id_taptest_table_p90000_p98000_p98400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p98000_p98500', 'Check that table partman_test.id_taptest_table_p90000_p98000_p98500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p98000_p98600', 'Check that table partman_test.id_taptest_table_p90000_p98000_p98600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p98000_p98700', 'Check that table partman_test.id_taptest_table_p90000_p98000_p98700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p98000_p98800', 'Check that table partman_test.id_taptest_table_p90000_p98000_p98800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p98000_p98900', 'Check that table partman_test.id_taptest_table_p90000_p98000_p98900 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p99000_p99000', 'Check that table partman_test.id_taptest_table_p90000_p99000_p99000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p99000_p99100', 'Check that table partman_test.id_taptest_table_p90000_p99000_p99100 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p99000_p99200', 'Check that table partman_test.id_taptest_table_p90000_p99000_p99200 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p99000_p99300', 'Check that table partman_test.id_taptest_table_p90000_p99000_p99300 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p99000_p99400', 'Check that table partman_test.id_taptest_table_p90000_p99000_p99400 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p99000_p99500', 'Check that table partman_test.id_taptest_table_p90000_p99000_p99500 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p99000_p99600', 'Check that table partman_test.id_taptest_table_p90000_p99000_p99600 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p99000_p99700', 'Check that table partman_test.id_taptest_table_p90000_p99000_p99700 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p99000_p99800', 'Check that table partman_test.id_taptest_table_p90000_p99000_p99800 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p99000_p99900', 'Check that table partman_test.id_taptest_table_p90000_p99000_p99900 no longer exists');

-- Recheck that all parents partitions have their data
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table', 'Check that parent table is still empty');
SELECT results_eq('SELECT count(*)::int FROM partman_test.id_taptest_table', ARRAY[107500], 'Check count from parent table');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p0', 'Check that parent table id_taptest_table_p0 is still empty ');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p0_p0', ARRAY[999], 'Check count from id_taptest_table_p0_p0');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p0_p1000', ARRAY[1000], 'Check count from id_taptest_table_p0_p1000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p0_p2000', ARRAY[1000], 'Check count from id_taptest_table_p0_p2000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p0_p3000', ARRAY[1000], 'Check count from id_taptest_table_p0_p3000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p0_p4000', ARRAY[1000], 'Check count from id_taptest_table_p0_p4000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p0_p5000', ARRAY[1000], 'Check count from id_taptest_table_p0_p5000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p0_p6000', ARRAY[1000], 'Check count from id_taptest_table_p0_p6000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p0_p7000', ARRAY[1000], 'Check count from id_taptest_table_p0_p7000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p0_p8000', ARRAY[1000], 'Check count from id_taptest_table_p0_p8000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p0_p9000', ARRAY[1000], 'Check count from id_taptest_table_p0_p9000');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p10000', 'Check that parent table id_taptest_table_p10000 is still empty ');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p10000_p10000', ARRAY[1000], 'Check count from id_taptest_table_p10000_p10000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p10000_p11000', ARRAY[1000], 'Check count from id_taptest_table_p10000_p11000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p10000_p12000', ARRAY[1000], 'Check count from id_taptest_table_p10000_p12000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p10000_p13000', ARRAY[1000], 'Check count from id_taptest_table_p10000_p13000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p10000_p14000', ARRAY[1000], 'Check count from id_taptest_table_p10000_p14000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p10000_p15000', ARRAY[1000], 'Check count from id_taptest_table_p10000_p15000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p10000_p16000', ARRAY[1000], 'Check count from id_taptest_table_p10000_p16000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p10000_p17000', ARRAY[1000], 'Check count from id_taptest_table_p10000_p17000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p10000_p18000', ARRAY[1000], 'Check count from id_taptest_table_p10000_p18000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p10000_p19000', ARRAY[1000], 'Check count from id_taptest_table_p10000_p19000');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p20000', 'Check that parent table id_taptest_table_p20000 is still empty ');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p20000_p20000', ARRAY[1000], 'Check count from id_taptest_table_p20000_p20000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p20000_p21000', ARRAY[1000], 'Check count from id_taptest_table_p20000_p21000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p20000_p22000', ARRAY[1000], 'Check count from id_taptest_table_p20000_p22000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p20000_p23000', ARRAY[1000], 'Check count from id_taptest_table_p20000_p23000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p20000_p24000', ARRAY[1000], 'Check count from id_taptest_table_p20000_p24000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p20000_p25000', ARRAY[1000], 'Check count from id_taptest_table_p20000_p25000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p20000_p26000', ARRAY[1000], 'Check count from id_taptest_table_p20000_p26000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p20000_p27000', ARRAY[1000], 'Check count from id_taptest_table_p20000_p27000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p20000_p28000', ARRAY[1000], 'Check count from id_taptest_table_p20000_p28000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p20000_p29000', ARRAY[1000], 'Check count from id_taptest_table_p20000_p29000');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p30000', 'Check that parent table id_taptest_table_p30000 is still empty ');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p30000_p30000', ARRAY[1000], 'Check count from id_taptest_table_p30000_p30000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p30000_p31000', ARRAY[1000], 'Check count from id_taptest_table_p30000_p31000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p30000_p32000', ARRAY[1000], 'Check count from id_taptest_table_p30000_p32000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p30000_p33000', ARRAY[1000], 'Check count from id_taptest_table_p30000_p33000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p30000_p34000', ARRAY[1000], 'Check count from id_taptest_table_p30000_p34000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p30000_p35000', ARRAY[1000], 'Check count from id_taptest_table_p30000_p35000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p30000_p36000', ARRAY[1000], 'Check count from id_taptest_table_p30000_p36000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p30000_p37000', ARRAY[1000], 'Check count from id_taptest_table_p30000_p37000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p30000_p38000', ARRAY[1000], 'Check count from id_taptest_table_p30000_p38000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p30000_p39000', ARRAY[1000], 'Check count from id_taptest_table_p30000_p39000');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p40000', 'Check that parent table id_taptest_table_p40000 is still empty ');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p40000_p40000', ARRAY[1000], 'Check count from id_taptest_table_p40000_p40000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p40000_p41000', ARRAY[1000], 'Check count from id_taptest_table_p40000_p41000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p40000_p42000', ARRAY[1000], 'Check count from id_taptest_table_p40000_p42000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p40000_p43000', ARRAY[1000], 'Check count from id_taptest_table_p40000_p43000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p40000_p44000', ARRAY[1000], 'Check count from id_taptest_table_p40000_p44000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p40000_p45000', ARRAY[1000], 'Check count from id_taptest_table_p40000_p45000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p40000_p46000', ARRAY[1000], 'Check count from id_taptest_table_p40000_p46000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p40000_p47000', ARRAY[1000], 'Check count from id_taptest_table_p40000_p47000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p40000_p48000', ARRAY[1000], 'Check count from id_taptest_table_p40000_p48000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p40000_p49000', ARRAY[1000], 'Check count from id_taptest_table_p40000_p49000');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p50000', 'Check that parent table id_taptest_table_p50000 is still empty ');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p50000_p50000', ARRAY[1000], 'Check count from id_taptest_table_p50000_p50000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p50000_p51000', ARRAY[1000], 'Check count from id_taptest_table_p50000_p51000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p50000_p52000', ARRAY[1000], 'Check count from id_taptest_table_p50000_p52000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p50000_p53000', ARRAY[1000], 'Check count from id_taptest_table_p50000_p53000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p50000_p54000', ARRAY[1000], 'Check count from id_taptest_table_p50000_p54000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p50000_p55000', ARRAY[1000], 'Check count from id_taptest_table_p50000_p55000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p50000_p56000', ARRAY[1000], 'Check count from id_taptest_table_p50000_p56000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p50000_p57000', ARRAY[1000], 'Check count from id_taptest_table_p50000_p57000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p50000_p58000', ARRAY[1000], 'Check count from id_taptest_table_p50000_p58000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p50000_p59000', ARRAY[1000], 'Check count from id_taptest_table_p50000_p59000');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p60000', 'Check that parent table id_taptest_table_p60000 is still empty ');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p60000_p60000', ARRAY[1000], 'Check count from id_taptest_table_p60000_p60000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p60000_p61000', ARRAY[1000], 'Check count from id_taptest_table_p60000_p61000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p60000_p62000', ARRAY[1000], 'Check count from id_taptest_table_p60000_p62000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p60000_p63000', ARRAY[1000], 'Check count from id_taptest_table_p60000_p63000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p60000_p64000', ARRAY[1000], 'Check count from id_taptest_table_p60000_p64000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p60000_p65000', ARRAY[1000], 'Check count from id_taptest_table_p60000_p65000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p60000_p66000', ARRAY[1000], 'Check count from id_taptest_table_p60000_p66000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p60000_p67000', ARRAY[1000], 'Check count from id_taptest_table_p60000_p67000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p60000_p68000', ARRAY[1000], 'Check count from id_taptest_table_p60000_p68000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p60000_p69000', ARRAY[1000], 'Check count from id_taptest_table_p60000_p69000');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p70000', 'Check that parent table id_taptest_table_p70000 is still empty ');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p70000_p70000', ARRAY[1000], 'Check count from id_taptest_table_p70000_p70000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p70000_p71000', ARRAY[1000], 'Check count from id_taptest_table_p70000_p71000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p70000_p72000', ARRAY[1000], 'Check count from id_taptest_table_p70000_p72000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p70000_p73000', ARRAY[1000], 'Check count from id_taptest_table_p70000_p73000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p70000_p74000', ARRAY[1000], 'Check count from id_taptest_table_p70000_p74000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p70000_p75000', ARRAY[1000], 'Check count from id_taptest_table_p70000_p75000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p70000_p76000', ARRAY[1000], 'Check count from id_taptest_table_p70000_p76000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p70000_p77000', ARRAY[1000], 'Check count from id_taptest_table_p70000_p77000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p70000_p78000', ARRAY[1000], 'Check count from id_taptest_table_p70000_p78000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p70000_p79000', ARRAY[1000], 'Check count from id_taptest_table_p70000_p79000');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p80000', 'Check that parent table id_taptest_table_p80000 is still empty ');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p80000_p80000', ARRAY[1000], 'Check count from id_taptest_table_p80000_p80000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p80000_p81000', ARRAY[1000], 'Check count from id_taptest_table_p80000_p81000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p80000_p82000', ARRAY[1000], 'Check count from id_taptest_table_p80000_p82000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p80000_p83000', ARRAY[1000], 'Check count from id_taptest_table_p80000_p83000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p80000_p84000', ARRAY[1000], 'Check count from id_taptest_table_p80000_p84000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p80000_p85000', ARRAY[1000], 'Check count from id_taptest_table_p80000_p85000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p80000_p86000', ARRAY[1000], 'Check count from id_taptest_table_p80000_p86000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p80000_p87000', ARRAY[1000], 'Check count from id_taptest_table_p80000_p87000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p80000_p88000', ARRAY[1000], 'Check count from id_taptest_table_p80000_p88000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p80000_p89000', ARRAY[1000], 'Check count from id_taptest_table_p80000_p89000');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p90000', 'Check that parent table id_taptest_table_p90000 is still empty ');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p90000_p90000', ARRAY[1000], 'Check count from id_taptest_table_p90000_p90000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p90000_p91000', ARRAY[1000], 'Check count from id_taptest_table_p90000_p91000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p90000_p92000', ARRAY[1000], 'Check count from id_taptest_table_p90000_p92000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p90000_p93000', ARRAY[1000], 'Check count from id_taptest_table_p90000_p93000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p90000_p94000', ARRAY[1000], 'Check count from id_taptest_table_p90000_p94000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p90000_p95000', ARRAY[1000], 'Check count from id_taptest_table_p90000_p95000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p90000_p96000', ARRAY[1000], 'Check count from id_taptest_table_p90000_p96000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p90000_p97000', ARRAY[1000], 'Check count from id_taptest_table_p90000_p97000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p90000_p98000', ARRAY[1000], 'Check count from id_taptest_table_p90000_p98000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p90000_p99000', ARRAY[1000], 'Check count from id_taptest_table_p90000_p99000');
SELECT is_empty('SELECT * FROM ONLY partman_test.id_taptest_table_p100000', 'Check that parent table id_taptest_table_p100000 is still empty ');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p100000_p100000', ARRAY[1000], 'Check count from id_taptest_table_p100000_p100000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p100000_p101000', ARRAY[1000], 'Check count from id_taptest_table_p100000_p100000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p100000_p102000', ARRAY[1000], 'Check count from id_taptest_table_p100000_p100000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p100000_p103000', ARRAY[1000], 'Check count from id_taptest_table_p100000_p100000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p100000_p104000', ARRAY[1000], 'Check count from id_taptest_table_p100000_p100000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p100000_p105000', ARRAY[1000], 'Check count from id_taptest_table_p100000_p100000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p100000_p106000', ARRAY[1000], 'Check count from id_taptest_table_p100000_p100000');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table_p100000_p107000', ARRAY[501], 'Check count from id_taptest_table_p100000_p100000');

-- Undo sub-parent partitions
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p0'', 20, p_keep_table := false)::int', ARRAY[9999], 'Undo partitioning for parent table partman_test.id_taptest_table_p0');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p10000'', 20, p_keep_table := false)::int', ARRAY[10000], 'Undo partitioning for parent table partman_test.id_taptest_table_p10000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p20000'', 20, p_keep_table := false)::int', ARRAY[10000], 'Undo partitioning for parent table partman_test.id_taptest_table_p20000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p30000'', 20, p_keep_table := false)::int', ARRAY[10000], 'Undo partitioning for parent table partman_test.id_taptest_table_p30000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p40000'', 20, p_keep_table := false)::int', ARRAY[10000], 'Undo partitioning for parent table partman_test.id_taptest_table_p40000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p50000'', 20, p_keep_table := false)::int', ARRAY[10000], 'Undo partitioning for parent table partman_test.id_taptest_table_p50000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p60000'', 20, p_keep_table := false)::int', ARRAY[10000], 'Undo partitioning for parent table partman_test.id_taptest_table_p60000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p70000'', 20, p_keep_table := false)::int', ARRAY[10000], 'Undo partitioning for parent table partman_test.id_taptest_table_p70000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p80000'', 20, p_keep_table := false)::int', ARRAY[10000], 'Undo partitioning for parent table partman_test.id_taptest_table_p80000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p90000'', 20, p_keep_table := false)::int', ARRAY[10000], 'Undo partitioning for parent table partman_test.id_taptest_table_p90000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p100000'', 20, p_keep_table := false)::int', ARRAY[7501], 'Undo partitioning for parent table partman_test.id_taptest_table_p100000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p110000'', 20, p_keep_table := false)::int', ARRAY[0], 'Undo partitioning for parent table partman_test.id_taptest_table_p110000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p120000'', 20, p_keep_table := false)::int', ARRAY[0], 'Undo partitioning for parent table partman_test.id_taptest_table_p120000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p130000'', 20, p_keep_table := false)::int', ARRAY[0], 'Undo partitioning for parent table partman_test.id_taptest_table_p130000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p140000'', 20, p_keep_table := false)::int', ARRAY[0], 'Undo partitioning for parent table partman_test.id_taptest_table_p140000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p150000'', 20, p_keep_table := false)::int', ARRAY[0], 'Undo partitioning for parent table partman_test.id_taptest_table_p150000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p160000'', 20, p_keep_table := false)::int', ARRAY[0], 'Undo partitioning for parent table partman_test.id_taptest_table_p160000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p170000'', 20, p_keep_table := false)::int', ARRAY[0], 'Undo partitioning for parent table partman_test.id_taptest_table_p170000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p180000'', 20, p_keep_table := false)::int', ARRAY[0], 'Undo partitioning for parent table partman_test.id_taptest_table_p180000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p190000'', 20, p_keep_table := false)::int', ARRAY[0], 'Undo partitioning for parent table partman_test.id_taptest_table_p190000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p200000'', 20, p_keep_table := false)::int', ARRAY[0], 'Undo partitioning for parent table partman_test.id_taptest_table_p200000');
SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table_p210000'', 20, p_keep_table := false)::int', ARRAY[0], 'Undo partitioning for parent table partman_test.id_taptest_table_p210000');

SELECT hasnt_table('partman_test.id_taptest_table_p0_p0', 'Check that table partman_test.id_taptest_table_p0_p0 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p1000', 'Check that table partman_test.id_taptest_table_p0_p1000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p2000', 'Check that table partman_test.id_taptest_table_p0_p2000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p3000', 'Check that table partman_test.id_taptest_table_p0_p3000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p4000', 'Check that table partman_test.id_taptest_table_p0_p4000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p5000', 'Check that table partman_test.id_taptest_table_p0_p5000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p6000', 'Check that table partman_test.id_taptest_table_p0_p6000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p7000', 'Check that table partman_test.id_taptest_table_p0_p7000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p8000', 'Check that table partman_test.id_taptest_table_p0_p8000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p0_p9000', 'Check that table partman_test.id_taptest_table_p0_p9000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p100000', 'Check that table partman_test.id_taptest_table_p100000_p100000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p101000', 'Check that table partman_test.id_taptest_table_p100000_p101000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p102000', 'Check that table partman_test.id_taptest_table_p100000_p102000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p103000', 'Check that table partman_test.id_taptest_table_p100000_p103000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p104000', 'Check that table partman_test.id_taptest_table_p100000_p104000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p105000', 'Check that table partman_test.id_taptest_table_p100000_p105000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p106000', 'Check that table partman_test.id_taptest_table_p100000_p106000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p107000', 'Check that table partman_test.id_taptest_table_p100000_p107000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p108000', 'Check that table partman_test.id_taptest_table_p100000_p108000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000_p109000', 'Check that table partman_test.id_taptest_table_p100000_p109000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p10000', 'Check that table partman_test.id_taptest_table_p10000_p10000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p11000', 'Check that table partman_test.id_taptest_table_p10000_p11000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p12000', 'Check that table partman_test.id_taptest_table_p10000_p12000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p13000', 'Check that table partman_test.id_taptest_table_p10000_p13000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p14000', 'Check that table partman_test.id_taptest_table_p10000_p14000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p15000', 'Check that table partman_test.id_taptest_table_p10000_p15000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p16000', 'Check that table partman_test.id_taptest_table_p10000_p16000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p17000', 'Check that table partman_test.id_taptest_table_p10000_p17000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p18000', 'Check that table partman_test.id_taptest_table_p10000_p18000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000_p19000', 'Check that table partman_test.id_taptest_table_p10000_p19000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p110000_p110000', 'Check that table partman_test.id_taptest_table_p110000_p110000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p120000_p120000', 'Check that table partman_test.id_taptest_table_p120000_p120000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p130000_p130000', 'Check that table partman_test.id_taptest_table_p130000_p130000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p140000_p140000', 'Check that table partman_test.id_taptest_table_p140000_p140000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p150000_p150000', 'Check that table partman_test.id_taptest_table_p150000_p150000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p160000_p160000', 'Check that table partman_test.id_taptest_table_p160000_p160000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p170000_p170000', 'Check that table partman_test.id_taptest_table_p170000_p170000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p180000_p180000', 'Check that table partman_test.id_taptest_table_p180000_p180000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p190000_p190000', 'Check that table partman_test.id_taptest_table_p190000_p190000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p200000_p200000', 'Check that table partman_test.id_taptest_table_p200000_p200000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p20000', 'Check that table partman_test.id_taptest_table_p20000_p20000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p21000', 'Check that table partman_test.id_taptest_table_p20000_p21000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p22000', 'Check that table partman_test.id_taptest_table_p20000_p22000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p23000', 'Check that table partman_test.id_taptest_table_p20000_p23000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p24000', 'Check that table partman_test.id_taptest_table_p20000_p24000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p25000', 'Check that table partman_test.id_taptest_table_p20000_p25000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p26000', 'Check that table partman_test.id_taptest_table_p20000_p26000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p27000', 'Check that table partman_test.id_taptest_table_p20000_p27000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p28000', 'Check that table partman_test.id_taptest_table_p20000_p28000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000_p29000', 'Check that table partman_test.id_taptest_table_p20000_p29000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p210000_p210000', 'Check that table partman_test.id_taptest_table_p210000_p210000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p30000', 'Check that table partman_test.id_taptest_table_p30000_p30000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p31000', 'Check that table partman_test.id_taptest_table_p30000_p31000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p32000', 'Check that table partman_test.id_taptest_table_p30000_p32000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p33000', 'Check that table partman_test.id_taptest_table_p30000_p33000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p34000', 'Check that table partman_test.id_taptest_table_p30000_p34000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p35000', 'Check that table partman_test.id_taptest_table_p30000_p35000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p36000', 'Check that table partman_test.id_taptest_table_p30000_p36000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p37000', 'Check that table partman_test.id_taptest_table_p30000_p37000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p38000', 'Check that table partman_test.id_taptest_table_p30000_p38000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000_p39000', 'Check that table partman_test.id_taptest_table_p30000_p39000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p40000', 'Check that table partman_test.id_taptest_table_p40000_p40000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p41000', 'Check that table partman_test.id_taptest_table_p40000_p41000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p42000', 'Check that table partman_test.id_taptest_table_p40000_p42000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p43000', 'Check that table partman_test.id_taptest_table_p40000_p43000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p44000', 'Check that table partman_test.id_taptest_table_p40000_p44000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p45000', 'Check that table partman_test.id_taptest_table_p40000_p45000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p46000', 'Check that table partman_test.id_taptest_table_p40000_p46000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p47000', 'Check that table partman_test.id_taptest_table_p40000_p47000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p48000', 'Check that table partman_test.id_taptest_table_p40000_p48000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000_p49000', 'Check that table partman_test.id_taptest_table_p40000_p49000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p50000', 'Check that table partman_test.id_taptest_table_p50000_p50000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p51000', 'Check that table partman_test.id_taptest_table_p50000_p51000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p52000', 'Check that table partman_test.id_taptest_table_p50000_p52000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p53000', 'Check that table partman_test.id_taptest_table_p50000_p53000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p54000', 'Check that table partman_test.id_taptest_table_p50000_p54000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p55000', 'Check that table partman_test.id_taptest_table_p50000_p55000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p56000', 'Check that table partman_test.id_taptest_table_p50000_p56000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p57000', 'Check that table partman_test.id_taptest_table_p50000_p57000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p58000', 'Check that table partman_test.id_taptest_table_p50000_p58000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000_p59000', 'Check that table partman_test.id_taptest_table_p50000_p59000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p60000', 'Check that table partman_test.id_taptest_table_p60000_p60000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p61000', 'Check that table partman_test.id_taptest_table_p60000_p61000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p62000', 'Check that table partman_test.id_taptest_table_p60000_p62000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p63000', 'Check that table partman_test.id_taptest_table_p60000_p63000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p64000', 'Check that table partman_test.id_taptest_table_p60000_p64000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p65000', 'Check that table partman_test.id_taptest_table_p60000_p65000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p66000', 'Check that table partman_test.id_taptest_table_p60000_p66000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p67000', 'Check that table partman_test.id_taptest_table_p60000_p67000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p68000', 'Check that table partman_test.id_taptest_table_p60000_p68000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000_p69000', 'Check that table partman_test.id_taptest_table_p60000_p69000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p70000', 'Check that table partman_test.id_taptest_table_p70000_p70000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p71000', 'Check that table partman_test.id_taptest_table_p70000_p71000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p72000', 'Check that table partman_test.id_taptest_table_p70000_p72000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p73000', 'Check that table partman_test.id_taptest_table_p70000_p73000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p74000', 'Check that table partman_test.id_taptest_table_p70000_p74000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p75000', 'Check that table partman_test.id_taptest_table_p70000_p75000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p76000', 'Check that table partman_test.id_taptest_table_p70000_p76000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p77000', 'Check that table partman_test.id_taptest_table_p70000_p77000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p78000', 'Check that table partman_test.id_taptest_table_p70000_p78000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000_p79000', 'Check that table partman_test.id_taptest_table_p70000_p79000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p80000', 'Check that table partman_test.id_taptest_table_p80000_p80000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p81000', 'Check that table partman_test.id_taptest_table_p80000_p81000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p82000', 'Check that table partman_test.id_taptest_table_p80000_p82000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p83000', 'Check that table partman_test.id_taptest_table_p80000_p83000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p84000', 'Check that table partman_test.id_taptest_table_p80000_p84000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p85000', 'Check that table partman_test.id_taptest_table_p80000_p85000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p86000', 'Check that table partman_test.id_taptest_table_p80000_p86000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p87000', 'Check that table partman_test.id_taptest_table_p80000_p87000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p88000', 'Check that table partman_test.id_taptest_table_p80000_p88000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000_p89000', 'Check that table partman_test.id_taptest_table_p80000_p89000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p90000', 'Check that table partman_test.id_taptest_table_p90000_p90000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p91000', 'Check that table partman_test.id_taptest_table_p90000_p91000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p92000', 'Check that table partman_test.id_taptest_table_p90000_p92000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p93000', 'Check that table partman_test.id_taptest_table_p90000_p93000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p94000', 'Check that table partman_test.id_taptest_table_p90000_p94000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p95000', 'Check that table partman_test.id_taptest_table_p90000_p95000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p96000', 'Check that table partman_test.id_taptest_table_p90000_p96000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p97000', 'Check that table partman_test.id_taptest_table_p90000_p97000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p98000', 'Check that table partman_test.id_taptest_table_p90000_p98000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000_p99000', 'Check that table partman_test.id_taptest_table_p90000_p99000 no longer exists');

SELECT results_eq('SELECT undo_partition_id(''partman_test.id_taptest_table'', 20, p_keep_table := false)::int', ARRAY[107500], 'Undo partitioning for final parent table partman_test.id_taptest_table');
SELECT results_eq('SELECT count(*)::int FROM ONLY partman_test.id_taptest_table', ARRAY[107500], 'Check count from final, non-partitioned table');

SELECT hasnt_table('partman_test.id_taptest_table_p0', 'Check that table partman_test.id_taptest_table_p0 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p10000', 'Check that table partman_test.id_taptest_table_p10000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p100000', 'Check that table partman_test.id_taptest_table_p100000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p110000', 'Check that table partman_test.id_taptest_table_p110000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p120000', 'Check that table partman_test.id_taptest_table_p120000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p130000', 'Check that table partman_test.id_taptest_table_p130000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p140000', 'Check that table partman_test.id_taptest_table_p140000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p150000', 'Check that table partman_test.id_taptest_table_p150000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p160000', 'Check that table partman_test.id_taptest_table_p160000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p170000', 'Check that table partman_test.id_taptest_table_p170000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p180000', 'Check that table partman_test.id_taptest_table_p180000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p190000', 'Check that table partman_test.id_taptest_table_p190000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p20000', 'Check that table partman_test.id_taptest_table_p20000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p200000', 'Check that table partman_test.id_taptest_table_p200000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p210000', 'Check that table partman_test.id_taptest_table_p210000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p30000', 'Check that table partman_test.id_taptest_table_p30000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p40000', 'Check that table partman_test.id_taptest_table_p40000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p50000', 'Check that table partman_test.id_taptest_table_p50000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p60000', 'Check that table partman_test.id_taptest_table_p60000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p70000', 'Check that table partman_test.id_taptest_table_p70000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p80000', 'Check that table partman_test.id_taptest_table_p80000 no longer exists');
SELECT hasnt_table('partman_test.id_taptest_table_p90000', 'Check that table partman_test.id_taptest_table_p90000 no longer exists');

SELECT is_empty('SELECT * FROM part_config WHERE parent_table LIKE ''partman_test.id_taptest_table%''', 'Check that part_config has all test tables removed');
SELECT is_empty('SELECT * FROM part_config_sub WHERE sub_parent LIKE ''partman_test.id_taptest_table%''', 'Check that part_config_sub has all test tables removed');

SELECT * FROM finish();
ROLLBACK;
