.TH PFTP 1L "GNU File Transfer Utilities" "FSF" \" -*- nroff -*-
.SH NAME
pftp \- fast data transfer program
.SH SYNOPSIS
.br
Server:
.B pftp
[portnumber] [OPTIONS]
.br
.br
Client:
.B pftp
[portnumber] [OPTIONS] [hostname] [files]
.br
.SH DESCRIPTION
This manual page
documents the GNU version of
.BR pftp .
.BR pftp
transfers data from host to host.  All line feed characters contained
in file and directory names are converted to underline characters.
There is no authorization mechanism necessary but possible.  Up to
255 connections are possible at a time.  If pftp is started by inetd
the number of connections is unlimited.  First the server has to be
started at the destination host with a port number in the range of
1025 and 65535.  The server may also be started as a daemon
by the internet daemon or by a normal user in the background.
Thereafter the client may send data to the port of the destination
host.  By default
.BR pftp
uses TCP based connections.  However you can also send UDP datagrams
to the server based just on UDP.
.BR pftp
supports unicast, broadcast, and multicast.  See section
.BR EXAMPLES
for further information.

.SS OPTIONS
One important hint: Unless you use a host name number from your host
name list, always put all of your options before the host name on
command line.  You can combine options as ever you want.  But keep in
mind that there are some options which have optional numbers.  Thus if
you set the host number right after such an option
.BR pftp
could mistaken this as the options optional number.  To be on the save
side just put the host name number as your first option followed by
all other options.  Options on command line have highest priority.
.sp
.TP
.I "\-"
Hereby the client sends all data from standard input to the destination
host.  If the client and the server are started with this option, the
server sends all bytes to standard output.  If on the other hand the
server was started with this option, but the client sends regular files,
the server copies all files to disk.  If only the client was started with
the option, the server copies the received stream to a file called
.IR Stream.x .
.IR x
is an increasing number beginning at one.  The client reads one character
at a time as well as the server, i.e. sending many characters with
`-' eats a lot of cpu time and might be slower (see `-b[NUM]').
.TP
.I "\-a"
Always overwrite existing files. (Server option only)
.TP
.I "\-aN1aN2..."
Seek the N1th offset from the beginning of the first file, the N2th offset
from the beginning of the second file etc.  If a file is incomplete
received then you may try to send just the missing part of the file, i.e.
N1 respectively N2 is the size of the incomplete file.  I suggest to
truncate the incomplete file by a several bytes at first.  Then start the
server in the appropriate directory and choose `a' when the server asks
you. (Client option only)
.TP
.I "\-ANUM"
You can limit the number of clients allowed at once to NUM.  The
default number is 255.
.TP
.I "\-b[NUM]"
Same as `-' except that a string of size NUM is read and written at once.
.BR pftp
does not limit this value.  So whatever your system supports you may
set.  The default string size for `-b' is 4096.  Hereby as well as
when sending files the net buffer size defaults to 32768 unless
`-B[NUM]' is given on command line.
.TP
.I "\-bb"
Same as `-b32768'.
.TP
.I "\-B[NUM]"
Sets the maximum net buffer size, i.e. SO_SNDBUF resp. SO_RCVBUF (see
.BR setsockopt (2)),
specified by `NUM' or if `NUM' is omitted by the variable
.IR PFTPNETBUF
(see
.BR ENVIRONMENT ).
The default maximum net buffer size is 32768.  This applies to data
sent or received.  The net buffer size is not the window size, which
is determined by TCP in kernel space on the server side, though.  But
the bigger you set this size the bigger the window size mostly is
although the window size is dynamically determined.  The better your
network connection is the bigger the net buffer size can be (see also
"TCP/IP Network Administration", Second Edition by Craig Hunt, O'Reilly
& Associates, p. 20).
.TP
.I "\-BB"
Same as `-B65536'.
.TP
.I "\-c hostnames"
Connections are accepted from clients with specified host names only.
All other clients are simply refused. Host names can also be given
as numbers which are looked up in your
.BR pftp
resource file (see
.BR RESOURCES ).
If no host names are specified the variable
.IR PFTPCLIENTS
is read instead (see
.BR ENVIRONMENT ).
To use command line given clients as well as clients specified in the
variable
.IR PFTPCLIENTS
you may use something like `-cc hostnames', where hostnames are your
command line given host names.  You may also specify domain names: All
host names that begin with a dot are supposed to be domain names, all
host names that begin with an `@' followed by a net in
numbers-and-dots (IPv4) respectively numbers-and-colons (IPv6)
notation are supposed to be nets.  For UDP based connections you will
probably need a fast machine when receiving video streams.  One hint
to
.BR pftp 's
IPv6 version: You can mix IPv6 and IPv4 addresses, but keep in mind
that IPv4 addresses always have to be mapped, i.e. `@130.149.0.0'
should be given as `@::ffff:130.149.0.0'.  The same rule applies to
your host name list entries. (Server option only)
.TP
.I "\-d[=DIR]"
The daemon works just like the server started from inetd (see `-i' ).
There are just two differences:  First the daemon keeps running
and second the daemon may be started by a normal user.  If your system
has shadow password you have to set the variable
.IR PFTPPASS
unless the daemon is running with root  privileges.  If the daemon is
started with root privileges
.BR pftp
listens on its officially assigned system port number 662.  The client
needs this option to send data to the daemon started by a normal user
on a user port.  You should use `-i' respectively `-n' if you want to
send data to the daemon started with root privileges, i.e.
.BR pftp 's
daemon is listening on its officially assigned system port number 662.
.TP
.I "\-D=DIR"
Change to directory DIR before receiving data.  (Server option only)
.TP
.I "\-e"
Create a normal password (MD5) with crypt().  If you want to set
the variable
.IR PFTPPASS
you may need the password.
.TP
.I "\-f[n]"
Filter all files before sending them over the network, i.e. the
standard output of the filter on the client side is connected to the
standard input of the filter on the server side.  The filters are
specified by
.IR PFTPCFILTER
respectively
.IR PFTPSFILTER
(see
.BR ENVIRONMENT ).
If you need to interact with a filter program use option `-q'!
(TCP based connections only)
.TP
.I "\-F"
Determine MPEG AUDIO bitrate and set the bandwidth accordingly.  This
is just a simple determination,
i.e.
.BR pftp
looks at the first frame header of each file to determine the bitrate.
This may fail for some streams since the bitrate usually changes
permanently.  So the bitrate found in the first frame header is no
more than an avarage value.  Nevertheless most MPEG AUDIO players
buffer a large enough amount of the stream.  Thus even if the streams
are sent with a constant bitrate it works quite well that way.
If the bitrate is not recognized the current file will be skipped.
Keep in mind
.BR pftp
is a multi functional data transfer program but no internet radio. ;^)
(Client option only)
.TP
.I "\-G"
Set optimized values for your Gigabit Ethernet link, i.e. the string
size is set to `65000' (see
.IR PFTPGIGASTR )
and the net buffer size is set to `128000' (see
.IR PFTPGIGANET ).
Please, adjust the values to your system needs.  Values given to `-B'
and `-b' are just ignored.  Use this option on the server as well as
on the client side.  Keep in mind that your ipmtu might also be
adjusted to send JUMBO packets if your system supports this.  This
option is meant for TCP based connections.
.TP
.I "\-i[=DIR]"
Start
.BR pftp
from `/etc/inetd.conf' by inetd.  You do need a system
.BR pftp
resource file
which is located in `/etc/pftp.conf'.  If there is no resource file
the connection is closed.  The following lines may be specified in
`/etc/inetd.conf' (see
.BR inetd (8))
and `/etc/services' (see
.BR services (5))
in order to start the
.BR pftp
server by inetd with the capability to copy files as well as
directories and to accept specified clients only:
.sp
.RS +1i
.ta 0.5i 1.0i
.nf
for `/etc/inetd.conf' (all on one line):
pftp stream  tcp  nowait  root
/usr/bin/pftp pftp -irc
.sp
for `/etc/services':
pftp     662/tcp
.fi
.RE
.sp
.TP
.I ""
At first
.BR pftp
reads the system resource file located in `/etc/pftp.conf' and gets the
user name and the number of the filter program to be used from the
client.  Both is sent raw through the net,  i.e. a port sniffer may see
them.  Then
.BR pftp
starts two subprocesses and changes their setuid/setgid bits to
the user's setuid/setgid bits--root is denied by default (see
.BR PFTPNOROOT ).
Now the password is sent filtered through the net.  Thus it is up to you
to decide which level of security you need.  The server changes the
directory to DIR if given by the client or to the user's home directory
and sets the environment variables `HOME' and `USER' appropriately.  The
user must have a
.BR pftp
resource file in his/her home directory from which the filter program is
to be read.
.sp
The client needs this option to send data to the server started with
root privileges and to set the destination directory DIR which is set
to the remote user's home directory if =DIR is omitted.  The port
number is set to
.BR pftp 's
officially assigned system port number 662.  The port number found in
the
.BR pftp
resource file is
ignored.
.TP
.I "\-I"
The client will also send the last time of modification, the user and
group id of the files and directories (see `-r'), as well as the
permission bits of directories if `-r' is used.  The server will
accept and set the information.  The access time is set to the value
of the last modification time.  Also empty directories are copied that
way if `-r' is given on command line.  Furthermore empty files and
FIFOs are copied and also devices if the server respectively the
daemon runs with root privileges.  To use this option by default set
the variable
.I PFTPSINFO
to `1'.
.TP
.I "\-j"
Read file and directory (see `-r') names from standard input one file
name per line.  This
option can also be used if you want to send file information about
directories without using `-r', e.g.
.sp
.RS +1i
.ta 0.5i 1.0i
.nf
find dir -depth | pftp -jIL user@remote_host
.fi
.RE
.sp
.TP
.I ""
will send the files read from standard input and set the information
of all files and directories.  Option `-[b]' is silently ignored.
(Client option only)
.TP
.I "\-l"
List host names from file `.pftprc' and send files.  New hosts can be
added to the host name list by calling
.BR pftp
with the host name.  This option cannot be used in standard input
mode!  (Client option only)
.TP
.I "\-L"
Do not follow symbolic links.  The link names are temporaryly saved
in a file.  The file is sent after all other files have been sent.
On the target host this file is called `PFTP_MAKE_LINKS'.  It is
just a shell script file you may execute as such `./PFTP_MAKE_LINKS'
to automatically create all symbolic links.  The local temporary
file is removed after it was sent.  For secrurity reasons you may
also check the shell script before you execute it.  If no symbolic
links were found no PFTP_MAKE_LINKS file is sent.  (Client option only)
.TP
.I "\-m[NUM]"
Same as `-u[NUM] with all capabilities except that multicasting is
enabled.  So it is needed to send or receive multicasted datagrams unless
one of the other `-m' options is chosen.  All `-m' options imply this
option.  So you only need it to change the default payload length.  Be
sure that you enabled multicasting for your side, i.e.  the following
needs to be done on the Linux Operating System: 1) Enable multicasting
within your kernel sources options (Networking options ---> IP:
multicasting).  2) Set the appropriate route (route add -net 224.0.0.0
netmask 240.0.0.0 dev multicasted_interface).  If everything is fine you
should find `/proc/net/igmp' in your file system.  (See also the excellent
document: `HOWTO/Multicasting'.)
.TP
.I "\-mg GROUP"
Set the multicast group to GROUP.  In order to receive multicasted
datagrams you need to join a multicast group. (Server option only)
.TP
.I "\-mi IADDR"
Use the interface IADDR at your local host for sending respectively
receiving multicasted datagrams.  By default the kernel chooses an
interface for you.
.TP
.I "\-ml"
By default
.BR pftp
unsets looping back of datagrams.  Thus if you want to receive back
what you sent from your local host you will need this option.  (Client
option only)
.TP
.I "\-mtNUM"
Set the time to live (IPv4) respectively the hop limit (IPv6).  Defaults
to 1. (Client option only)
.TP
.I "\-M[=FILE]"
In combination with `-n' the message file FILE will be added to the data.
If =FILE is omitted: interactively edit a message file (see
.IR PFTPEDITOR ).
This option implies `-n'. (Client option only)
.TP
.I "\-N[NUM]"
Peek for new data in the upload directory.  If you used a host specific
PFTPRECEIVE variable which points to a different upload directory you
can set NUM to the number of the host name list entry. Thus you can peek
for new data in the directory where the host specific variable points to.
.TP
.I "\-n"
If no further options are given starts the simple
.BR pftp
file and directory manager.  Else: Send data to another user.  The other
user must have set the variable
.IR PFTPRECEIVE
to the absolute path of an upload directory (see
.BR ENVIRONMENT ).
On the remote host
.BR pftp
has to be started by inetd (see `-i') or run
as a daemon (see `-d').  This option is implied if something like this
.sp
.RS +1i
.ta 0.5i 1.0i
.nf
pftp user@remote_host files
.fi
.RE
.sp
.TP
.I ""
is given on command line.  The port is set to
.BR pftp 's
officially assigned system port number 662.
.TP
.I "\-n=SUBJECT"
Same as `-n' but also add subject line SUBJECT to the data.
.TP
.I "\-nl"
Using host specific
.IR PFTPRECEIVE
variables you can choose the upload directory from your host name
list and enter the pfm (see also `-N[NUM]').
.TP
.I "\-nn"
Same as `-n' but interactively ask for a subject line and add that line
to the data.
.TP
.I "\-NUM"
Choose host NUM from host name list. (Client option only)
.TP
.I "\-o"
TCP: Accept only one connection at a time. (Server option only)
.TP
.I "\-p[NUM]"
This option works just like `-b[NUM]' except that all data received,
i.e. also files, are sent to standard output.  If `NUM' is omitted
standard output is unbuffered. (Server option only)
.TP
.I "\-pp"
Same as `-p32768'. (Server option only)
.TP
.I "\-P[NUM]"
Sets the datagram priority to NUM.  If `NUM' is omitted the value
defaults to 4.  This option is not supported on all systems.  On the
Linux Operating System it is supported.  If you don't use this option
.BR pftp
automatically sets the Type-Of-Service (TOS) field (see
.BR ip (4))
of the IP header for TCP based connections.  If your system supports
it the following settings are made:  If `-w[NUM]' is used it defaults
to `IPTOS_MINCOST' and otherwise it is set to `IPTOS_THROUGHPUT'.  If
not it is just not set.  (Client option only)
.TP
.I "\-q"
Silent mode.  Unless options given on command line are misused or unknown
.BR pftp
will produce no output to stderr.  By default all existing files are
skipped.  If option `-a' is given on command line all existing files
are overwritten.  If the environment variable
.IR PFTPSLOG
is set to the absolute path of a log file, the server
logs all data normally written to stderr
(see
.BR ENVIRONMENT ).
This option is meant for shell skripts and the like.  To be more
manageable for scripts there are 52 return statuses, which are listed
in the README file.  You should use this option if you want to pipe
output of
.BR pftp
into a pager otherwise
.BR pftp
resets its own terminal modes on exit.  It is also needed if you need
to interact with the filter program.
.TP
.I "\-r"
If the server and the client are started with this option, all files
received from the client are copied into the appropriate directories.
If necessary
.BR pftp
creates new directories within the current directory, i.e.  the
directory where the server was started from. If only the client is
started with this option, all files sent by the client are copied into
the current directory.  For security reasons the server does not save
files in upper directories, e.g. a `/', or `..'  at the beginning of a
file name is just ignored.  Also combinations of such are ignored.
.sp
In combination with `-T[NUM]' a random string for the net performance
test is used.  The random string is produced only once (see also
`-R') and then send again and again.
.TP
.I "\-R"
If the remote file already exists a `.x' will be suffixed to the new
file, where `x' is an increasing number starting at one.  This option
is only recognized if
.BR pftp
was started as a server on command line (see also
.IR PFTPRENAME
).
.sp
In combination with `-T[NUM]' a random string for the net performance
test is used.  A new random string for every loop is produced (see
also `-r'), which consumes a lot of cpu time.
.TP
.I "\-s"
TCP: Always skip existing files.  UDP: Display on the fly the number
of bytes received by the datagrams. (Server option only)
.TP
.I "\-SNUM"
Using UDP based data transfer used to drop every NUMth datagram.  It
is meant to test the stability of the application on the server side.
On the Linux Operating System you can interactively increase or
decrease the value by typing `h' respectively `b'.  Typing `0'
means that no datagram will be dropped.  (Client option only)
.TP
.I "\-T[NUM]"
Perform a net performance test.  NUM is the number of bytes being sent
during the test.  You must adjust the input buffer size with
`-b[NUM]'.  You can also set the net buffer size (see `-B[NUM]'), the
datagram priority (see `-P[NUM]'), and the bandwidth (see `-w[NUM]').
For a UDP based test you cannot set the net buffer size, though.  But
you can adjust the payload length with `-u[NUM]'.  In combination with
`-r' respectively `-R' a random string is sent while the buffer size
respectively the payload length is the first seed of the random
numbers.  Using `-r' the same random string is sent again and again,
whereas with option `-R' a new random string is produced within every
loop--this consumes a lot of cpu time.
.TP
.I "\-u[NUM]"
Use UDP as data transfer protocol.  NUM is the payload length, i.e.
the size of the string sent at once at a time.  The default size is
1472.  You cannot combine this option with `-B', `-d', `-f', and `-i'.
.sp
On the client side you can send data and files as if using normal TCP
based connections.  Be advised to set the bandwidth (see `-w[NUM]').
On the Linux Operating System you can interactively increase or
decrease the bandwidth by typing `=' to increase it by 64 bytes or `.'
to increase by one byte respectively `-' to decrease it by 64 bytes or
`,' to decrease by one byte, and interactively drop datagrams
periodically by typing `h' respectively `b'.  Type `0' to stop
dropping of datagrams.  This is meant to test your applications on the
server side.  You can stop and continue sending datagrams by typing
space.  You can skip the current file by typing `n'.  The datagrams
are sent without any further protocol header--just UDP.  Thus you can
use the client to send data to any program that is able to receive
datagrams via UDP.  Likewise
.BR pftp 's
server can be used to receive any data via UDP, i.e.  the server does
not care if datagrams are lost.
.sp
You can also set the string length to be received at once by NUM.  The
default size is 1472. Since the mechanism is meant to send AUDIO and VIDEO
streams, all data received is written to standard output.    On the Linux
Operating System you can interactively turn on and off of displaying the
number of bytes received by typing `s' on the server side (you will
need a fast terminal to display on the fly the number of bytes
received).
.TP
.I "\-v"
Ouputs buffer sizes, the bandwidth, datagram priority (if supported),
and the filter program being used.
.TP
.I "\-w[NUM]"
Sets bandwidth in bytes per second specified by `NUM' or if `NUM' is
omitted by the variable
.IR PFTPBANDWID .
UDP: On the Linux Operating System this value can be interactively
changed by typing `=' respectively `-'.  (Client option only)
.TP
.I "\-W"
Displays the warranty.
.TP
.I "\-x"
Lets the server exit after the first connection. (Server option only)
.TP
.I "hostname"
hostname may look like a host name list entry (see
.BR RESOURCES )
without the following port number.
.BR pftp
contacts the server started with root privileges if a user name is
given on command line, i.e. the port number is set to 662.  If a user
name and a password is included option `-i' is implied.  If a user
name is included option `-n' respectively `-i' is implied.  Thus you
don't need to specify option `-n' or `-i'.
.PP
.SS EXAMPLES
In order to send two files start the server with a port number at
your choice at the destination host (port numbers between 1025 and
32768 are always legal unless they are in use--then simply choose
another port number):
.sp
.RS +.5i
pftp 1234
.RE
.sp
Then start the client with the same port number at the origin host:
.sp
.RS +.5i
pftp 1234 destinationhost file1 file2
.RE
.sp
The server is waiting for connections until you quit it by typing `q'
(Linux) or `^C' (other Systems).
.PP
Now we want to copy the current directory including all subdirectories.
Start the server at the destination host with option `-r':
.sp
.RS +.5i
pftp 1234 -r
.RE
.sp
And analogeously start the client with the same option:
.sp
.RS +.5i
pftp 1234 -r destinationhost .
.RE
.sp
I suggest to let
.BR pftp
create the file `.pftprc' to start
.BR pftp
with a default port number. See section
.BR RESOURCES
for further details.  If you start
.BR pftp
without having a resource file and you use options, or omit some, that
could also be looked up in this
file,
.BR pftp
will ask you if you want it to create a resource file.
.sp
To send data from standard input using the default port number  start
the server with option `-' and redirect the standard output wherever
you want to:
.sp
.RS +.5i
pftp - > file
.RE
.sp
The client is started as usual but this time with option `-':
.sp
.RS +.5i
pftp - destinationhost_or_host_number < file
.RE
.sp
Imagine you want to send files to a
.BR pftp
server started with root privileges and upload the files in the
directory `$HOME/misc' where `$HOME' is the remote user's home
directory.  If the remote host name is for example listed in your host
name list as number one you may want to use the following
.sp
.RS +.5i
pftp -1i=misc files
.RE
.sp
If your host name list entry does not contain the remote user's login
name and maybe the password you will be asked for login name and
password.
.sp
Now lets send data to a friend of whom you have no password.  The
destination host is listed in your host name list as number 7.  Further
more you want to use a filter program for the connection and also send not
merely files but also directories.  Thus all you have to type is 
.sp
.RS +.5i
pftp -7frn data
.RE
.sp
where data is files and directories.  In this case the first filter
listed in your filter variable will be used which is the opposite filter
program of the other user's first filter program.

Now let's send directory `dir' to another user recursively.
The following implies `-n':
.sp
.RS +.5i
pftp -r user@remote_host_name dir
.RE
.sp
Some programs are able to read data from standard input.  Assuming
there is a huge file on a remote server we just want to read in by
such a program you can do the following on the program's server side:
.sp
.RS +.5i
pftp -xu | program -
.RE
.sp
(Keep in mind that when sending datagrams the program reading from
standard input is in charge if datagrams are lost.  If the program is
not able to handle incomplete data you need to use TCP based data
transfer: exchange `u' with `pp' for example on the server side and
just drop the `u' on the client side.)  And on the client side with a
bandwidth of about 169 KBytes:
.sp
.RS +.5i
pftp -uw173056 remote_host_name files
.RE
.sp
That is the way to use UDP based data tansfer with
.BR pftp .
You might welcome that when omitting the `x' the server keeps running
without closing standard output.  Thus if the `program' supports it
you can let another client connecting the server and sending its data
without ever restarting the server.

Now let's do the latter example for the multicasted case:  Assuming
we want to use multicast group 225.0.0.27 and keep our trafic within our
local subnet:
.sp
.RS +.5i
pftp -xmg 225.0.0.27 | program -
.RE
.sp
And on the client side with a bandwidth of about 169 KBytes:
.sp
.RS +.5i
pftp -mw173056 225.0.0.27 files
.RE
.sp
Another important feature of
.BR pftp
is that you can send not merely files but also messages.  You might say,
well I can send e-mails.  But what differs sending messages with
.BR pftp
and sending messages with the mail system is that it is reliable, i.e.
you know that the message arrived where you want it.  Imagine you
want to send just a message to a user on a remote host.  Thereby
using filter number one from your filter list and adding a subject line
and a message interactively.
.sp
.RS +.5i
pftp -nnMf user@remote_host
.RE
.sp
If `remote_host' is a number the corresponding host from your host name
list is taken.  You can set your favorite editor with the variable
.IR PFTPEDITOR .
If you do not save the message file with your editor the sending will
be discarded.
.sp
Imagine the following situation: You want to install a completely new
distribution of your operating system.  Unfortunately the current
system and the users home directories are on the same partition--of
course, next time you choose a different one.  But the problem stays
the same for now.  To solve the problem you may copy the whole home
directory to a different computer you have access to.  So just start
.BR pftp 's
server on the remote host as such
.sp
.RS +.5i
pftp -Irx
.RE
.sp
Now you can start the client on your local computer as follows:
.sp
.RS +.5i
pftp -LIr remote_host /home
.RE
.sp
The `L' prevents
.BR pftp
from following symbolic links.  Instead a script file is sent
afterwards to the remote host which can be executed to set the links.
Remember to start the client with root privileges to ensure that all
files are accessible for the client.  You may also set the variable
PFTPLOG on the client side to the absolute path of an error log file
since
.BR pftp
does not exit if files are not accessible.
.sp
Another problem that might occur is that you have a very large gzipped
archive file on one host which you want to unpack on another host but
without uploading the file before unpacking it.  Here is the solution
with
.BR pftp :
First start the server on the target host
.sp
.RS +.5i
pftp -xpp | gzip -cd | tar xvf -
.RE
.sp
and then send the archive file with
.BR pftp 's
client
.sp
.RS +.5i
pftp target_host linux-2.2.13.tar.gz
.RE
.sp
Using the GNU version of
.BR tar
(see
.BR tar (1))
you can also use option `z' of
.BR tar
instead of `gzip -cd |'.
.sp
.sp
.SH RESOURCES
There are two resource files
.BR pftp
may read in.  The system resource file `/etc/pftp.conf' is read in if
.BR pftp
is started with root privileges.  The user's resource file `~/.pftprc'
is read otherwise.  Both files have the following format: At first all
needed default variables have to be specified and at the end of the
file goes the host name list.  Host names may be followed by a port
number (on the same line).  If no port number is given the default one
set with
.IR PFTPPORT
is used.  At most 255 characters are read in per line.  Variables are
set in the resource file like the following:
.sp
.RS +.5i
.ta 0.5i 1.0i
.nf
PFTPPORT 1234
.fi
.RE
.sp
A host name list entry may look like one of these:
.sp
.RS +1i
.ta 0.5i 1.0i
.nf
 username:passwd@hostname port
 username:passwd@hostname
 username@hostname port
 username@hostname
 hostname port
 hostname
 @V<variable name>
 @F<file name>
 @X.X.X.X
 .domain.name
.fi
.RE
.sp
username is the name of the remote user if you send data to the daemon
or to the server started by inetd.  passwd is remote user's password.
If you send data to the normal server username and passwd are ignored.
Of course the password is not shown if
.BR pftp
was started with `-l'.  Empty lines and all comments between a `#' and
the end of a line are ignored.
The eighth and nineth line shows line substitution (see
.BR "Line and value substitutions" ).
The last two lines are only recognized by the server (see
.BR "Host specific variables recognized by the server" ).
The client just ignores these last two lines.  Keep in mind that IPv4
addresses have to be mapped if you use the IPv6 version of
.BR pftp ,
i.e. `127.0.0.1' has to be given as `::ffff:127.0.0.1'.
.sp
.SH ENVIRONMENT
.sp
There are two types of variables: default variables, and host specific
variables.  A default variable is used if the corresponding host
specific variable is not found.
.sp
.SS "Host specific variables recognized by the client"
If the client is started with `-NUM' 
(see
.BR OPTIONS )
variables that follow the host name list entry number NUM are prefered
to the default variables at the beginning of the resource file.  The
next host name list entry (NUM+1) terminates the list of host specific
variables.  Host name list entries that are only recognized by the
server  and variables that are not recognized by the client are
ignored.
.sp
.SS "Host specific variables recognized by the server"
If
.BR pftp
was started as a daemon (see `-d' and `-i') all remote host names are
compared with those in the user's resource file.  If a match is found
and the host name list entry is followed by host specific variables
those variables are read instead of the corresponding default
variables at the beginning of the user's resource file.  The first
match found is used!
.sp
The daemon/server recognizes also two further types of host name list
entries.  The first matches the net given in numbers-and-dots
notation, e.g suppose you want to use the same host specific variables
for all remote hosts of net 130.149.0.0 then the host name list entry
looks like
.sp
.RS +1i
.ta 0.5i 1.0i
.nf
 @130.149.0.0
.fi
.RE
.sp
and is followed by its host specific variables.  The second matches
the domain name the remote host belongs to, e.g. suppose you want to
use the same host specific variables for all remote hosts with domain
name tu-berlin.de then the host name list entry looks like
.sp
.RS +1i
.ta 0.5i 1.0i
.nf
 .tu-berlin.de
.fi
.RE
.sp
and is followed by its host specific variables.  Variables that are
not recognized by the server are ignored.
.sp
.SS "Line and value substitutions"
If a line or a variable value begins with a `@V<variable name>'
respectively a `@F<file name>' then the line or the variable value is
substituted by the value of the environment variable `variable name'
respectively by the first line of the file `file name'.
.sp
.SS "Variables"
Variables denoted with `<*>' may also be set as environment variables.
Those denoted with `<c>' are recognized by the client as a host
specific variable, variables denoted with `<d>' are recognized by the
daemon as a host specific variable, and variables denoted with `<s>'
are recognized by the server started on command line as a host
specific variable.  Command line settings have highest priority;
environment variables have higher priority than variables specified in
the resource file.
.TP
.I PFTPAINFO <d>
If set to `1' file information received from the client (see
.IR PFTPSINFO
and `-I') is accepted and applied by the daemon.  By default it is set
to `1'.
.TP
.I PFTPAUSER
May be used to specify an alias name for a real login name.  If the
alias name is set the real login name is denied.  If
.BR pftp
was started by the internet daemon alias names have to be specified in
`/etc/pftp.conf'.  Otherwise within the
.BR pftp
resource file of the user who started the daemon.  If the login name
is omitted or equals the alias name the user with that login name is
prevented from receiving data by the daemon or the server started by
the internet daemon.  An alias is set as follows
.sp
.RS +1i
.ta 0.5i 1.0i
.nf
PFTPAUSER alias_name login_name
.fi
.RE
.sp
.TP
.I PFTPBANDWID <*> <c>
Holds the value of the bandwidth (see `-w') in bytes per second.  By
default
.BR pftp
sends as fast
as possible.
.TP
.I PFTPCFILTER <*> <c> and PFTPSFILTER <*> <d> <s>
If on the client side variable
.IR PFTPCFILTER
and on the server side variable
.IR PFTPSFILTER
hold names of filter programs with possible options the filters will
be used if `-f' is given on command line.  The variables may hold the
absolute path to several filters.  All filter programs have to be
seperated by colons.  You may choose a specific filter program with
`-fn' where n is the number of the filter program.  The first filter
program has number 1.  If n is not given the first filter program will
be used.  In order to list all client filters set n to C, to list all
server filters set n to S.  To see the host specific filter variables
use `-NUM' respectively `-l'.  Technically speeking:
.BR pftp
sends its data right into the standard input of the filter program.
The standard output of the filter program on the client side is
directly, i.e. via the network,  connected to the standard input of
the filter program on the server side.  On the server side
.BR pftp
reads the data right from the standard ouput of the filter program.
Thus keep in mind that the filter on the client side is just the
opposite of the filter on the server side!  If you need to interact
with your filter program you should use option `-q' to prevent
.BR pftp
from blocking keyboard input.
.TP
.I PFTPCFVARnum <c> and PFTPSFVARnum <d> <s>
If your filter program needs environment variables to be set you can
use these variables to do so.  PFTPCFVARnum is used for the client and
PFTPSFVARnum for the server side.  `num' is the number of your filter
program in the filter program list.  If `num' is omitted the variables
will be used if there are no filter number specific variables.  The
variables are set right before the filter program is started. Variable
settings are seperated by colons.  Suppose you want to set environment
variables for the first filter program then variables are set like this
.sp
.RS +1i
.ta 0.5i 1.0i
.nf
PFTPCFVAR1 variable1 value1:variable2 value2
PFTPSFVAR1 variable1 value1:variable2 value2
.fi
.RE
.sp
.TP
.I PFTPCLIENTS <*> and PFTPDCLIENT
May hold all client host names that are accepted.  The names are
seperated by spaces.  So if `-c' follows no host name that variable is
read instead.
.BR pftp
converts all host names to the numbers-and-dots (IPv6:
numbers-and-colons) notation and compares them with the remote host
names that are going to send data.  You can also specify a net in
numbers-and-dots notation (e.g.  @130.149.0.0) respectively a domain
name (e.g.  .tu-berlin.de) from which hosts are accepted.  PFTPDCLIENT
is used by the daemon.  It offers the user the chance to choose
accepted hosts too.  But the user can only accept those hosts which
are also accepted by root, e.g. if
.BR pftp
was started with `-c' the user can only choose hosts from the list of
hosts root accepts.
.TP
.I PFTPEDITOR <*> <c>
Holds the name of the editor.  The default editor is `vi'.
.TP
.I PFTPFORCEF <d>
This variable is meant for the paranoic. ;^)  If set to `1' clients
have to use a filter program otherwise they get a `User accepts no
files' message.
.TP
.I PFTPGIGANET <c>
Holds the net buffer size for Gigabit Ethernet links (see `-G').  The
default value when using `-G' is `128000'.
.TP
.I PFTPGIGASTR <c>
Holds the string size for Gigabit Ethernet links (see `-G').  The
default value when using `-G' is `65000'.
.TP
.I PFTPIUPDATE <c>
The pfm updates the main menu looking for incoming data in the specified
interval in seconds.  The default value is two seconds.  Zero means no
update.  You can always update a menu with `^L'.
.TP
.I PFTPLOG <*>
If the variable
.IR PFTPLOG
is set to the absolute path of an error file, the client is logging
all error messages that occur, while sending files, in the error file.
Since the client does not exit on errors concerning unreadable or
empty files and directories, it might be useful to log the error
messages.  So you can send these mostly few files afterwards.
.TP
.I PFTPLOGFILE
If set to `1', and
.IR PFTPSLOG
is set, logs also all file and directory names being transfered.
.TP
.I PFTPNETBUF <*> <c>
Sets the maximum net buffer size in bytes (see `-B').
.TP
.I PFTPNOROOT
If set to `0' allows root `login' when
.BR pftp
is running as a daemon with root privileges (see `-d') or was started by
inetd (see `-i').  The default setting is `1'.
.TP
.I PFTPPAGER <*> <c>
Holds the name of the pager.  The default pager is
.BR pftp 's
internal pager.  The internal pager's help is called by typing `?'.
.TP
.I PFTPPASS <d>
If set to an encrypted normal password using crypt() (see crypt(3)) or
.BR pftp
called with option `-e'  this password is used instead of the user's
system password.  If your system has shadow password and you want to
run the daemon without root privileges you do need this variable to be
set.  You may set it to `*' in order to deny login at all.
.TP
.I PFTPPERCENT
If set to `1'
.BR pftp
outputs the percentage of bytes sent, but not received, from the
current file.  The lack depends on the window size (see also
`-B[NUM]').  Sending files will be slower by some tenth of a second.
.TP
.I PFTPPORT
Holds the default port number.
.TP
.I PFTPRECEIVE <d>
Holds the absolute path of an upload directory for files and
directories sent by other users (see `-n').  If this variable is unset
no other user will be allowed to upload files and directories.
.TP
.I PFTPRENAME <d>
If the remote file already exists a `.x' will be suffixed to the new
file, where `x' is an increasing number starting at one.  This boolean
variable is only read if
.BR pftp
runs as a daemon (see also `-R').
.TP
.I PFTPSINFO <c> <s>
If set to `1' the last time of modification, the user and group id of
files and directories as well as permission bits of directories are
always sent.  If accepted on the server side (see also
.IR PFTPAINFO
and `-I') the information will be set and even empty files, FIFOS and
empty directories will be created.  If
.I PFTPNOROOT
is set to 0 also devices are copied.  Keep in mind that only the
superuser is allowed to creat devices.  By default it is set to `0'.
.TP
.I PFTPSLOG <*>
If set to the absolute path of a log file the daemon as well as
the server started by inetd log all connections.
.TP
.I PFTPSORTBY <c>
Determines sorting order within the pfm.  May be set to `a' for
alphabetical (this is the default setting), `s' for size, and `t' for
the time of last change.
.TP
.I PFTPUPLIMIT <d>
Sets a limit in kilo bytes to the upload directory (see
.BR PFTPRECEIVE ).
The size defaults to 4096 kilo bytes.  Setting
.I PFTPUPLIMIT
to zero means to set no limit at all.  This is useful for big sites
with large upload directories.  If more than one client is sending
data to the same user
.BR pftp
is recalculating the directory size before each file to be sent.  This
takes more time the larger the upload directory is and the more data
is already contained in the upload directory.
.SH AUTHOR
Ben Schluricke
.SH DEDICATION
This program is dedicated to
.BR "Heather O'Rourke" .
.SH "SEE ALSO"
rcp(1), scp(1), kpftp(1)
.SH BUGS
Setting the net buffer size to zero may crash older systems.  So you
should use a buffer size of zero for test purposes only.  Most newer
systems set a buffer size of zero to one by default.
.sp
You may see the latest bug report and the latest version of
.BR pftp
at `http://www.pftp.de'.

If you find any bug, please drop me an e-mail.
.sp
.RS +1.2i
support@pftp.de
.RE
.sp
Every comment via e-mail will be appreciated!
