#ifndef _PFE_CORE_MIX_H
#define _PFE_CORE_MIX_H 1002653673
/* generated 2001-1009-2054 ../../../pfe/../mk/Make-H.pl ../../../pfe/core-mix.c */

#include <pfe/incl-mix.h>

/** 
 * -- miscellaneous useful extra words for CORE-EXT
 *
 *  Copyright (C) Tektronix, Inc. 1998 - 2001. All rights reserved.
 *
 *  @see     GNU LGPL
 *  @author  Tektronix CTE              @(#) %derived_by: guidod %
 *  @version %version:  1.11 %
 *    (%date_modified:  Mon Oct 08 17:29:31 2001 %)
 *
 *  @description
 *      Compatiblity with former standards, miscellaneous useful words.
 *      ... for CORE-EXT
 */

#ifdef __cplusplus
extern "C" {
#endif




/** 0<= ( a -- flag )
 simulate    : 0<= 0> 0= ;
 */
extern P4_CODE (p4_zero_less_equal);

/** 0>= ( a -- flag )
 simulate    : 0>= 0< 0= ;
 */
extern P4_CODE (p4_zero_greater_equal);

/** <= ( a b -- flag )
 simulate    : <= > 0= ;
 */
extern P4_CODE (p4_less_equal);

/** >= ( a b -- flag )
 simulate    : >= < 0= ;
 */
extern P4_CODE (p4_greater_equal);

/** U<= ( a b -- flag )
 simulate    : U<= U> 0= ;
 */
extern P4_CODE (p4_u_less_equal);

/** U>= ( a b -- flag )
 simulate    : U>= U< 0= ;
 */
extern P4_CODE (p4_u_greater_equal);

/** UMAX ( a b -- max )
 * see => MAX
 */
extern P4_CODE (p4_u_max);

/** UMIN ( a b -- min )
 * see => MIN , => MAX and => UMAX
 */
extern P4_CODE (p4_u_min);

/** LICENSE ( -- )
 * show a lisence info - the basic PFE system is licensed under the terms
 * of the LGPL (Lesser GNU Public License) - binary modules loaded into
 * the system and hooking into the system may carry another => LICENSE
 : LICENSE [ ENVIRONMENT ] FORTH-LICENSE TYPE ;
 */
extern P4_CODE (p4_license);

/** WARRANTY ( -- )
 * show a warranty info - the basic PFE system is licensed under the terms
 * of the LGPL (Lesser GNU Public License) - which exludes almost any 
 * liabilities whatsoever - however loadable binary modules may hook into
 * the system and their functionality may have different WARRANTY infos.
 */
extern P4_CODE (p4_warranty);

/** .VERSION ( -- )
 * show the version of the current PFE system
 : .VERSION [ ENVIRONMENT ] FORTH-NAME TYPE FORTH-VERSION TYPE ;
 */
extern P4_CODE (p4_dot_version);

/** .CVERSION ( -- )
 * show the compile date of the current PFE system
 : .CVERSION [ ENVIRONMENT ] FORTH-NAME TYPE FORTH-DATE TYPE ;
 */
extern P4_CODE (p4_dot_date);

/** STRING,               ( str len -- )
 *  Store a string in data space as a counted string.
 : STRING, HERE  OVER 1+  ALLOT  PLACE ;
 */
extern P4_CODE (p4_string_comma);

/** PARSE,                    ( "chars<">" -- )
 *  Store a char-delimited string in data space as a counted
 *  string. As seen in Bawd's
 : ," [CHAR] " PARSE  STRING, ; IMMEDIATE
 *
 * this implementation is much different from Bawd's
 : PARSE, PARSE STRING, ;
 */
extern P4_CODE (p4_parse_comma);

/** PARSE,"                   ( "chars<">" -- )
 *  Store a quote-delimited string in data space as a counted
 *  string.
 : ," [CHAR] " PARSE  STRING, ; IMMEDIATE
 *
 * implemented here as
 : PARSE," [CHAR] " PARSE, ; IMMEDIATE
 */
extern P4_CODE (p4_parse_comma_quote);

#ifdef __cplusplus
} /* extern "C" */
#endif


#endif
