/*
 * unsharp.h  -- This code is derived from the GIMP unsharp mask plug-in 
 * by Winston Chang
, September 2001
 *
 * Copyright (C) 2001 by Winston Chang
 <winston@stdout.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

typedef struct
{
  double radius;
  double amount;
  int    threshold;
} UnsharpMaskParams;

inline void blur_line     (double  *ctable,
 double  *cmatrix,
				  int     cmatrix_length,
  unsigned char *cur_col,
				  unsigned char  *dest_col,
 int y,
 long bytes);

int gen_convolve_matrix   (double  std_dev,
 double  **cmatrix);

double* gen_lookup_table  (double* cmatrix,
 int cmatrix_length);

void
 unsharp_mask(unsigned char   *src_region,  unsigned char   *dest_region,
		  int    width,
        int     height,
		  int    bytes,        UnsharpMaskParams unsharp_params)
;

